/*------------------------------------*/
/* init.c (last modified: 12/06/2013) */
/* initialize all the sheets          */
/*------------------------------------*/

#include "define.h"
#include "variables.h"
#include "string.h"
#include <stdio.h>
#include <stdlib.h>

// LOGICAL EXPRESSION FOR MINIMUM AND MAXIMUM VALUES
double Min (double a, double b)
{
    if(a<b)
        return(a);
    else
        return(b);
}
double Max (double a, double b)
{
    if(a>b)
		return(a);
	else
		return(b);
}

// INITIALIZE MODEL ARRAYS AND BOUNDARY CONDITION SETUP
void Init()
{
    int i,t;
	double N, K, D0, beta, d;

    // INCLUDE DEPTH FORMULATION (see ReadMe.doc for further details)
    include_constantDEPTH=0;

    // CONVERGENCE LENGTH [m]
    LC=1.0/-(1.0/(double)EL*log((double)B_ub/(double)B_lb));

    // VAN DER BURGH'S COEFFICIENT [-]
    K=4.38*pow(DEPTH_lb,0.36)*pow(B_lb,-0.21)*pow(LC,-0.14);

    // DISPERSION COEFFICIENT [m2 s-1]
    for (i=0; i<=M; i++)
	{
        N=-PI*(Qr)/(DEPTH_lb*B_lb);
        D0=26*sqrt(N*G)*pow(DEPTH_lb,1.5);
	    beta=-(K*LC*Qr)/(D0*B_lb*DEPTH_lb);
		d=D0*(1.- beta*( exp(((i+1)-1.)*DELXI/LC) -1.));
		disp[i]=(d>0.) ? d : 0.0;
    }

    for (i=0; i<=M; i++)
    {
        // HYDRODYNAMICS: INITIALIZE ARRAYS
        E[i]=0.0;
        Y[i]=-5.0;
        Chezy[i]= (i>=distance) ? Chezy_lb-(Chezy_lb-Chezy_ub)*(i-50)*1/(M-50) : Chezy_lb;

        U[i]=0.0;
        TU[i]=0.0;

        B[i]= (i==0) ? B_lb : B_lb*(exp(-(((i+1)-1)*((double)DELXI))/((double)LC)));
        ZZ[i]=B[i]* (DEPTH_lb-(DEPTH_lb-DEPTH_ub)/(double)EL*(i*(double)DELXI));
        Z[i]=0.0;

        if (include_constantDEPTH==1)
        {
            ZZ[i]=B[i]* DEPTH_lb;
            Chezy[i]= (i>=distance) ? Chezy_ub : Chezy_lb;
        }

        for (t=0; t<=4; t++) C[i][t]=0.0;

        H[i] = B[i]*0.;
        TH[i]= B[i]*0.;
        D[i] =H[i]+ZZ[i];
        Dold[i] =H[i]+ZZ[i];
        DEPTH[i]=D[i]/B[i];

        // TRANSPORT: INITIALIZE ARRAYS
        fl[i]=0.0;
        disp[i]=0.0;

        // BIOGEOCHEMISTRY: INITIALIZE ARRAYS
        GPP[i]=0.0;
        NPP[i]=0.0;
        NPP_NO3[i]=0.0;
        NPP_NH4[i]=0.0;
        phy_death[i]=0.0;
        aer_deg[i]=0.0;
        denit[i]=0.0;
        nit[i]=0.0;
        O2_ex[i]=0.0;
    }

    // BIOGEOCHEMISTRY: BOUNDARY CONDITIONS

    //Salinity
    strcpy(v[S].name,"S.dat");
    v[S].env =1;
    v[S].clb =30.3;
    v[S].cub =0.0;
    for (i=0; i<=M; i++)
    {
        v[S].c[i]       =v[S].clb+(v[S].cub-v[S].clb)/((double)M)*(i);
        v[S].avg[i]     =0.0;
        v[S].concflux[i]=0.0;
        v[S].advflux[i] =0.0;
        v[S].disflux[i] =0.0;
    }

    //Diatoms [mmol C m-3]
    strcpy(v[DIA].name,"DIA.dat");
    v[DIA].env =1;
    v[DIA].clb =10.0;
    v[DIA].cub =50.0;
    for (i=1; i<=M; i++)
    {
        v[DIA].c[i]       =v[DIA].clb+(v[DIA].cub-v[DIA].clb)/((double)M)*i;
        v[DIA].avg[i]     =0.0;
        v[DIA].concflux[i]=0.0;
        v[DIA].advflux[i] =0.0;
        v[DIA].disflux[i] =0.0;
    }

    //Silica [mmol Si m-3]
    strcpy(v[dSi].name,"dSi.dat");
    v[dSi].env =1;
    v[dSi].clb =10.0;
    v[dSi].cub =250.0;
    for (i=1; i<=M; i++)
    {
        v[dSi].c[i]       =v[dSi].clb+(v[dSi].cub-v[dSi].clb)/((double)M)*i;
        v[dSi].avg[i]     =0.0;
        v[dSi].concflux[i]=0.0;
        v[dSi].advflux[i] =0.0;
        v[dSi].disflux[i] =0.0;
    }

    //Nitrate [mmol N m-3]
    strcpy(v[NO3].name,"NO3.dat");
    v[NO3].env =1;
    v[NO3].clb =50.0;
    v[NO3].cub =198.0;
    for (i=1; i<=M; i++)
    {
        v[NO3].c[i]       =v[NO3].clb+(v[NO3].cub-v[NO3].clb)/((double)M)*i;
        v[NO3].avg[i]     =0.0;
        v[NO3].concflux[i]=0.0;
        v[NO3].advflux[i] =0.0;
        v[NO3].disflux[i] =0.0;
    }

    //Ammonium [mmol N m-3]
    strcpy(v[NH4].name,"NH4.dat");
    v[NH4].env =1;
    v[NH4].clb =0.1;
    v[NH4].cub =520.0;
    for (i=1; i<=M; i++)
    {
        v[NH4].c[i]       =v[NH4].clb+(v[NH4].cub-v[NH4].clb)/((double)M)*i;
        v[NH4].avg[i]     =0.0;
        v[NH4].concflux[i]=0.0;
        v[NH4].advflux[i] =0.0;
        v[NH4].disflux[i] =0.0;
    }

    //Phosphate [mmol P m-3]
    strcpy(v[PO4].name,"PO4.dat");
    v[PO4].env =1;
    v[PO4].clb =0.1;
    v[PO4].cub =17.0;
    for (i=1; i<=M; i++)
    {
        v[PO4].c[i]       =v[PO4].clb+(v[PO4].cub-v[PO4].clb)/((double)M)*i;
        v[PO4].avg[i]     =0.0;
        v[PO4].concflux[i]=0.0;
        v[PO4].advflux[i] =0.0;
        v[PO4].disflux[i] =0.0;
    }

    //Oxygen [mmol O2 m-3]
    strcpy(v[O2].name,"O2.dat");
    v[O2].env =1;
    v[O2].clb =250.0;
    v[O2].cub =106.0;
    for (i=1; i<=M; i++)
    {
        v[O2].c[i]       =v[O2].clb+(v[O2].cub-v[O2].clb)/((double)M)*i;
        v[O2].avg[i]     =0.0;
        v[O2].concflux[i]=0.0;
        v[O2].advflux[i] =0.0;
        v[O2].disflux[i] =0.0;
    }

    //Total organic carbon [mmol C m-3]
    strcpy(v[TOC].name,"TOC.dat");
    v[TOC].env =1;
    v[TOC].clb =0.1;
    v[TOC].cub =393.0;
    for (i=1; i<=M; i++)
    {
        v[TOC].c[i]       =v[TOC].clb+(v[TOC].cub-v[TOC].clb)/((double)M)*i;
        v[TOC].avg[i]     =0.0;
        v[TOC].concflux[i]=0.0;
        v[TOC].advflux[i] =0.0;
        v[TOC].disflux[i] =0.0;
    }

    //Suspended matter [g l-1]
    strcpy(v[SPM].name,"SPM.dat");
    v[SPM].env =1;
    v[SPM].clb =0.03;
    v[SPM].cub =0.07;
    for (i=0; i<=M; i++)
    {
        v[SPM].c[i]       =v[SPM].clb+(v[SPM].cub-v[SPM].clb)/((double)M)*i;
        v[SPM].avg[i]     =0.0;
        v[SPM].concflux[i]=0.0;
        v[SPM].advflux[i] =0.0;
        v[SPM].disflux[i] =0.0;
    }
}
