/*-----------------------------------------*/
/* define.h (last modified: 12/06/2013)    */
/* define global variables and parameters  */
/*-----------------------------------------*/

#ifndef DEFINE_H
#define DEFINE_H

// GEOMETRICAL AND PHYSICAL PARAMETERS
#define EL         158000                     //Estuarine length [m] (NOTE: the number of the grid points must be an odd number)
#define DEPTH_lb     11.5                     //Depth at downstream boundary (x=0) [m]
#define DEPTH_ub     1.0                      //Depth at upstream boundary (x=0) [m]
#define B_lb         6952.0                   //Width at the downstream boudary [m]
#define B_ub       30.0                       //Width at the upstream boundary [m]
#define RS         1.0		                  //Storage width ratio
#define rho_w	   1000.0                     //Density of pure water [Kg m-3]
#define G          9.81                       //Gravity acceleration [m s-2]
#define distance   50                         //Number of grid points corresponding to the saline estuarine zone (e.g. 10 corresponds to 20 km, 50 corresponds to 100 km)

// HYDRODYNAMIC AND SEDIMENT PARAMETERS
#define Chezy_lb     70                       //Chezy coefficient at the dowstream boundary [m-1/2 s-1]
#define Chezy_ub    40                        //Chezy coefficient at the upstream boundary [m-1/2 s-1]
#define ws		   1.e-3                      //Settling velocity for sediment [m s-1]
#define tau_ero_lb   0.4                      //Critical shear stress for erosion at the downstream boundary [N m-2]
#define tau_dep_lb   0.4                      //Critical shear stress for deposition at the downstream boundary [N m-2]
#define tau_ero_ub   1.0                      //Critical shear stress for erosion at the upstream boundary [N m-2]
#define tau_dep_ub   1.0                      //Critical shear stress for deposition at the upstream boundary [N m-2]
#define Mero_lb     3.5e-6                    //Erosion coefficient at the downstream boundary [mg m-2 s-1]
#define Mero_ub     6.0e-8                    //Erosion coefficient at the upstream boundary [mg m-2 s-1]

// BIOGEOCHEMICAL PARAMETERS
#define Pbmax      1.157e-4                   //Maximum specific photosynthetic rate [s-1]
#define alpha      5.8e-7                     //Photosynthetic efficiency [m2 s muE-1 s-1]
#define KdSi        20.0                      //Michaelis-Menten constant for silica [muM Si]
#define KPO4       0.5                        //Michaelis-Menten constant for phosphate [muM P]
#define KNH4       100.0                      //Michaelis-Menten constant for ammonium [muM N]
#define KNO3	   45.0                       //Michaelis-Menten constant for nitrate [muM N]
#define KTOC       60.0                       //Michaelis-Menten constant for organic matter [muM C]
#define KO2		   15.0                       //Michaelis-Menten constant for oxygen [muM O2]
#define KN         5.0                        //Michaelis-Menten constant for dissolved nitrogen [muM N]
#define KinO2      50.0                       //Inhibition term for denitrification [muM O2]
#define redsi	   16./80.                    //Redfield ratio for silica [mol Si/mol C]
#define redn	   16./106.                   //Redfield ratio for nitrogen [mol N/mol C]
#define redp       1./106.                    //Redfield ratio for phosphorous [mol P/mol C]
#define kmaint     9.2593e-7                  //Maintenance rate constant [s-1]
#define kmort      7.1e-7                     //Phytoplankton mortality [s-1]
#define kexcr      0.03                       //Excretion constant [-]
#define kgrowth    0.3                        //Growth constant [-]
#define KD1		   1.3                        //Background extinction coefficient [m-1]
#define KD2        0.06                       //Specific attenuation of suspended matter [mg-1 m-1]
#define kox		   2.0e-4                     //Aerobic degradation rate constant [muM C s-1]
#define kdenit	   1.0e-4                     //Denitrification rate constant [muM C s-1]
#define knit	   1.5e-4                     //Nitrification rate constant [muM C s-1]

// EXTERNAL FORCINGS
#define Qr          -32.0                     //River Discharge [m3 s-1]
#define AMPL       3.7                        //Tidal amplitude at the mouth [m]
#define pfun       0.080536912751677847       //Tidal frequency (M2 tidal component) [cycle hr-1]
#define Uw_sal     4.0                        //Windspeed for wind component in piston velocity in the saline estuary (0-100 km) [m s-1]
#define Uw_tid     1.0                        //Windspeed for wind component in piston velocity in the tidal river (100-150 km) [m s-1]
#define water_temp 17                         //Water temperature [C]

// OTHER PARAMETERS
#define Euler      0.5772156649               //Euler constant [-]
#define PI	       acos(-1.)                  //Number pi [-]

// NUMERICAL INTEGRATION
#define MAXT       90*24*60*60                //Max time [sec] + add hydrodynamic & transport warmup days
#define WARMUP     3*24*60*60                 //Warm up period; switch on biogeochemistry if t>WARMUP
#define DELTI      150                        //Delta t [sec]
#define TS         12                         //Save every TS timesteps (i.e. 1--> save every 150 seconds; 4--> save every 10 minuts; 8--> save every 20 minuts; 12--> save every 30 minuts)
#define DELXI      2000                       //Delta x [m]
#define TOL        1e-10                      //Convergence criterium
#define M	       EL/DELXI+1                 //Max even grid points [-]
#define M1	       M-1	                      //Max odd grid points [-]
#define M2	       M-2	                      //Last even grid point [-]
#define M3	       M-3	                      //Last odd grid point [-]
#define MAXV       10                         //Max number of species in chemical array [-]

// LIBRARIES
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#endif
