  ! constants
  real, parameter :: epsilon = 0.96          !surface emissivity [1]
  real, parameter :: a_v_min = 0.3           !albedo of vegetation [1]
  real, parameter :: a_v_max = 0.5           !albedo of vegetation [1]
  real, parameter :: a_b     = 0.5           !albedo of bare soil [1]
  real, parameter :: sigma   = 5.676e-8      !Stefan-Boltzmann constant [w.m-2.K-4]
  real, parameter :: k_1     = 0.41          !Von Karman constant [-]
  real, parameter :: tau_l   =  1*3.1536e7   !residence time of leaf
                                              !biomass [s]
  real, parameter :: tau_r   = 10*3.1536e7   !residence time of root
                                              !biomass [s]
  real, parameter :: tau_s   = 10*3.1536e7   !residence time of root
                                              !biomass [s]
  real, parameter :: c_d     = 1013          !specific head capacity of dry air [J.kg-1.K-1]
  real, parameter :: c_v     = 2080          !specific head capacity of water vapor [J.kg-1.K-1]
  real, parameter :: e       = 0.622         !ratio of molecular weight of water1 to dry air [1]
  real, parameter :: l       = 2.45e6        !latent heat of vaporization [J.kg-1]
  real, parameter :: SLA     = 30.0          !Specific leaf area [m2/kgC]
  real, parameter :: zn      = 2.0           !height of wind measurments [m]
  real, parameter :: z0m     = 0.02          !roughness length for momentum [m]
  real, parameter :: z0h     = 0.002         !roughness length for heat [m]
  real, parameter :: z0q     = 0.002         !roughness length for moisture [m]
  real, parameter :: R       = 287           !specific gas constant [J.kg-1.k-1]
  real, parameter :: rho_w   = 1e3           !water density [kg.m-3]
  real, parameter :: g_soilmax = 0.02        !minimum soil evaporation conductance [s/m]
  real, parameter :: c_a     = 380           !ambient CO2 concentration [ppmv]
  real, parameter :: con_soil = 0.2          !soil heat conductivity [w.m-1.k-1]
  real, parameter :: rsCs    = 2e6           !heat capacity of soil [J.m-3.k-1]
  real, parameter :: rwCw    = 4.2e6         !heat capacity of water [J.m-3.k-1]
  real, parameter :: LAIref  = 6.0           !reference LAI [m2/m2]
  real, dimension(2), parameter :: z = (/0.02, 0.48/) !depth of first layer [m] z(1): first soil layer; z(2) second soil layer
  real, parameter :: k       = 0.5           !parameter for fc calculation [-]
  real, parameter :: CAref   = 15.0          !reference crown area
                                                ![m2]
  real, parameter :: ac      = 2.381         !parameter in Dmax-gm theme [-]
  real, parameter :: bc      = 0.6103        !parameter in Dmax-gm theme [-]
  real, parameter :: cc      = 2.8           !parameter in Dmax-gm theme [-]
  real, parameter :: dc      = 4.7           !parameter in Dmax-gm theme [-]
  real, parameter :: ec      = 7.0           !parameter in Dmax-gm theme [-]
  real, parameter :: Q10     = 2
  real, parameter :: T1_g    = 5             ![oC]
  real, parameter :: T2_g    = 36            ![oC]
  real, parameter :: T1_A    = 8             ![oC]
  real, parameter :: T2_A    = 38            ![oC]
  real, parameter :: Ma      = 18            !mocular of H2O []
  real, parameter :: Mv      = 29            !mocular of air []
  real, parameter :: b2      = 0.944         !foliage scattering coefficient []
  real, parameter :: Gr      = 0.5           !distribution of leaves
  real, parameter :: gv      = 9.81          !acceleration due to gravity [m/s2]
!  real, parameter :: pi      = acos(0.0)    !pi
  real, parameter :: fu      = 0.2           !radiation parameter [1]

  real :: w(3) = (/0.88889,0.55556,0.55556/) !weights used in three-point gaussian quadrature
  real :: x(3) = (/0.0,0.7746,-0.7746/)      !points used in three-point gaussian quadrature


  ! parameters changed with specific issues
  real, dimension(:), allocatable :: G_sat           !saturated conductivity [m.s-1]
  real, dimension(:), allocatable :: a_s             !soil texture parameter [m-1]
  real, dimension(:), allocatable :: l_s             !soil texture parameter [-]
  real, dimension(:), allocatable :: n_s             !soil texture parameter [-]
  real, dimension(:), allocatable :: sm_r            !residual soil moisture [m3.m-3]
  real, dimension(:), allocatable :: sm_sat          !saturated soil moisture [m3.m-3]
  real, dimension(:), allocatable :: f0_s            !unstressed factor [-]
  real, dimension(:), allocatable :: Am_max
  real, dimension(:), allocatable :: Dmax_x
  real, dimension(:), allocatable :: Dmax_n
  real, dimension(:), allocatable :: Dmax_s
  real, dimension(:), allocatable :: f2c
  real, dimension(:), allocatable :: gm_s
  real, dimension(:), allocatable :: Eps0
  real, dimension(:), allocatable :: c_rm            !maximum root biomass[kgC/m2]  
  real, dimension(:), allocatable :: al
  real, dimension(:), allocatable :: G_x             !CO2 compensation concentration [ppm]
  real, dimension(:), allocatable :: sm_cap          !volumetric water content at field capacity (medium) [m3.m-3]
  real, dimension(:), allocatable :: sm_pwp          !volumetric water content at wilting point (medium) [m3.m-3]
  integer, parameter :: numS    = 6                     !number of soil texture types
  integer, parameter :: numV    = 4                     !number of vegetation types

  allocate(sm_sat(numS))
  allocate(sm_r(numS))
  allocate(G_sat(numS))
  allocate(a_s(numS))
  allocate(sm_cap(numS))
  allocate(sm_pwp(numS))
  allocate(l_s(numS))
  allocate(n_s(numS))
  allocate(f0_s(numV))
  allocate(Am_max(numV))
  allocate(Dmax_n(numV))
  allocate(Dmax_x(numV))
  allocate(Dmax_s(numV))
  allocate(f2c(numV))
  allocate(gm_s(numV))
  allocate(Eps0(numV))
  allocate(c_rm(numV))
  allocate(al(numV))
  allocate(G_x(numV))

  ! settings soil texture parameters
  !            1Coarse,   2Medium, 3Medium fine, 4Fine,  5Very fine, 6Organic
  sm_sat  = (/0.403,   0.439,   0.430,   0.52,    0.614,     0.766  /)
  sm_r    = (/0.011,   0.011,   0.011,   0.011,   0.011,     0.011  /)
  sm_cap  = (/0.242,   0.346,    0.382,   0.448,   0.541,     0.662 /)
  sm_pwp  = (/0.059,   0.151,   0.133,   0.279,   0.335,     0.267  /)
  G_sat   = (/6.94e-6, 1.16e-6, 0.26e-6, 2.87e-6, 1.74e-6,   0.93e-6/)
  a_s     = (/3.83,    3.14,    0.83,    3.67,    2.65,      1.3    /)
  l_s     = (/1.25,   -2.342,  -0.588,  -1.977,   2.5,       0.4    /)
  n_s     = (/1.38,    1.28,     1.25,   1.1,     1.1,       1.2    /)

            !  1.Def grass, 2.Off grass 3.Def woody 4.Off woody
  f0_s      = (/0.95,      0.95,       0.606,       0.46/)
  Am_max    = (/6e-7,      6e-7,       4.9e-7,     4.9e-7/)
  Dmax_n    = (/0.055,     0.055,      0.0,        0.0/)
  Dmax_x    = (/0.3,       0.3,        0.0,        0.0/)
  f2c       = (/0.5,       0.5,        0.1,        0.6/)
  gm_s      = (/0.5e-3,    0.5e-3,     1.6e-3,     4.4e-3/)
  G_x       = (/42.,       42.,        42.,        42./)
  Eps0      = (/4.64e-9,   4.64e-9,    4.64e-9,    4.64e-9/)
  c_rm      = (/1.0,       1.0,        10.0,       10.0/)
  al        = (/0.0,       0.0,        0.65,       0.65/)
