"""
Plotting script for convergence rates based on precomputed values
"""

# Copyright (C) 2013 Marie E. Rognes

import os
import sys
import pylab
import numpy

resultsdir = "results"
resultspath = os.path.join(os.getcwd(), resultsdir)
print "Treating data from %s" % resultspath
sys.path.insert(0, resultspath)

# Increase fonts
myfontsize=22
pylab.rc('lines', linewidth=2)
pylab.rc('legend', fontsize=myfontsize)
pylab.rc("lines", markeredgewidth=2.0)

pylab.figure(figsize=(10, 8))

h_max = [2.27961e6, 1.14449e6, 5.71186e5, 2.85431e5]

RT1 = [0.0143865320677, 0.00839212378869, 0.00325941293291, 0.00154528168033]
BDM1 = [0.0096623697368, 0.00469103006137, 0.00245860435818, 0.00116701406969]

Xa = [2.5e6, 2.5e5]
Yfirst = 9e-9*numpy.power(Xa,1)
Ysecond = 3e-9*numpy.power(Xa,1)

pylab.loglog(h_max, RT1, '^-', color="black", label="RT$_1$")

pylab.loglog(h_max, BDM1, '^-', color="blue", label="BDM$_1$")

pylab.loglog(Xa, Yfirst, color="grey", label=r'$\propto $h$^1$')
pylab.loglog(Xa, Ysecond, color="grey")

pylab.legend(loc='best')
pylab.xlabel("$h$ (m)", fontsize=22)
pylab.ylabel("Normalised $L_2$ error", fontsize=22)
pylab.grid(True)
pylab.savefig("%s/plot1.pdf" % resultsdir)
pylab.show()
