"""
Plotting script for convergence rates based on precomputed values
"""

# Copyright (C) 2013 Marie E. Rognes

import os
import sys
import pylab
import numpy

resultsdir = "results"
resultspath = os.path.join(os.getcwd(), resultsdir)
print "Treating data from %s" % resultspath
sys.path.insert(0, resultspath)

# Increase fonts
myfontsize=22
pylab.rc('lines', linewidth=2)
pylab.rc('legend', fontsize=myfontsize)
pylab.rc("lines", markeredgewidth=2.0)

pylab.figure(figsize=(10, 8))

# Import each of the cases here
from errors_w2 import h_max, uRT1, uBDM1, uBDFM2, uBDM2, DRT1, DBDM1, DBDFM2, DBDM2

# old data
#h_max = [2.27961e6, 1.14449e6, 5.71186e5, 2.85431e5]
#uRT1 = [0.0152055895716, 0.00368358443971, 0.00134659451777, 0.000514252101679]
#uBDM1 = [0.0125780274894, 0.00243161761236, 0.000618440793228, 0.000168809931627]
#uBDM2 = [0.0131137520703, 0.00244182204333, 0.000617089811375, 0.000151869597378]
#DRT1 = [0.00134644823818, 0.00056405488197, 0.000189663460153, 6.96966603422e-05]
#DBDM1 = [0.00111898685017, 0.00026099584734, 7.60772772072e-05, 2.15746691221e-05]
#DBDM2 = [0.00326666987514, 0.000700245210174, 0.000150978956305, 4.30954770179e-05]

Xa = [3e6, 2.6e5]
Yfirst = 9e-9*numpy.power(Xa,1)
Ysecond = 1.6e-16*numpy.power(Xa,2)

pylab.loglog(h_max, uRT1, 'o-', color="black", label="RT$_1$ velocity")
pylab.loglog(h_max, DRT1, '^-', color="black", label="RT$_1$ depth")

pylab.loglog(h_max, uBDM1, 'o-', color="blue", label="BDM$_1$ velocity")
pylab.loglog(h_max, DBDM1, '^-', color="blue", label="BDM$_1$ depth")

pylab.loglog(h_max, uBDFM2, 'o-', color="red", label="BDFM$_2$ velocity")
pylab.loglog(h_max, DBDFM2, '^-', color="red", label="BDFM$_2$ depth")

pylab.loglog(h_max, uBDM2, 'o-', color="orange", label="BDM$_2$ velocity")
pylab.loglog(h_max, DBDM2, '^-', color="orange", label="BDM$_2$ depth")

pylab.loglog(Xa, Yfirst, color="grey", label=r'$\propto $h$^1$')
pylab.loglog(Xa, Ysecond, color="grey", label=r'$\propto $h$^2$')

pylab.xlim([1e5,1e8])
pylab.xlabel("$h$ (m)", fontsize=22)
pylab.ylabel("Normalised $L_2$ error", fontsize=22)
pylab.legend(loc='best')
pylab.grid(True)
pylab.savefig("%s/plot1.pdf" % resultsdir)
pylab.show()
