set terminal postscript eps enhanced color solid "Helvetica" 12
#
# least-squares linear regression
# (this is done before setting ranges otherwise an "no data to fit"
# error message appears)
#
!rm fit-scale.log
set fit logfile "fit-scale.log"
f(x) = (af)*(x) + bf
#
# convergence rate for l2
#
fit f(x) "data.dat" using (log($1)):(log($2)) via af,bf

set out "conv.eps"
set grid
set xrange [4.5:0.375-(0.375/4.0)]
set yrange [1.0E-7:1.0E1]
set logscale x 2
set logscale y

set format y "10^{%L}" #set format y '%2.0g'
set xtics ("3{/Symbol \260}" 3,"1.5{/Symbol \260}" 1.5, "0.75{/Symbol \260}" 0.75, "0.375{/Symbol \260}" 0.375,"0.1875{/Symbol \260}" 0.1875)


#
# plot 1
#

set size 1.0, 0.5
set origin 0.0, 0.0
set multiplot
set size 0.5,0.5
set origin 0.0,0.0
set grid
set key spacing 1.2
set title "l_2, Gaussian hills" font "Helvetica,16"
#set ylabel "l1 error"
set yrange [1.0E-5:1.0E1]
second(x)=0.05*x**(2.0)
third(x)=0.00015*x**(3.0)
plot (x>=0.375)&&(x<=3.0)? second(x):1/0 w l lw 4 lt 9 notitle,(x>=0.375)&&(x<=3.0)? third(x):1/0 w l lw 4 lt 9 notitle,'data.dat' using 1:2 title 'CSLAM, CFL5.5' w lp
#
# plot 2
#
set nokey
set size 0.5,0.5
set origin 0.5,0.0
set title "l_{/Symbol \245}, Gaussian hills" font "Helvetica,16"
set yrange [1.0E-5:1.0E1]
second(x)=0.3*x**(2.0)
third(x)=0.0004*x**(3.0)
plot (x>=0.375)&&(x<=3.0)? second(x):1/0 w l lw 4 lt 9 notitle,(x>=0.375)&&(x<=3.0)? third(x):1/0 w l lw 4 lt 9 notitle,'data.dat' using 1:3 title 'CSLAM,CFL5.5' w lp

