load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
begin
  ;
  ; PLEASE EDIT BELOW
  ;
  ; This script assumes that the data is in ASCII format on a regular 
  ; latitude-longitude grid
  ;
  ; Please edit the dimension data below to fit your setup
  ;
  m = 240 ; number of latitudes
  n = 480 ; number of longitudes
  rot = 45; offset in longitude 
  ;
  ; the location of grid cells and data bounds below might have to be edited
  ;
  ; below it is assumed that the data for longitude i=0 is duplicated in longitude n
  ; we assume that the data is for cell center with cell walls at 
  ;
  ; 	x=i*dx+dx/2 and y=j*dy+dy/2
  ;
  dx  = 360./n
  lon  = ispan(0,n,1)*dx+0.5*dx
  dy  = (180./(m-1))
  lat  = -90.0+ispan(0,m-2,1)*dy+0.5*dy
  ;
  ; provide file names for data files
  ;
  fdat = (/"1.dat","2.dat","3.dat","4.dat"/)
  ;
  ; read in files
  ;
  num_files = dimsizes(fdat)
  print(num_files)  
  print("read in field")
  data = new((/m-1,n+1,num_files/),"float")
  do i=0,num_files-1
    data(:,:,i) = asciiread(fdat(i),(/m-1,n+1/),"float")
  end do
  ;
  ; text for title of each plot
  ; 
  ftxt = (/"(a) ~F33~f ~F21~(t=T/2), Gaussian hills","(b) ~F33~f ~F21~(t=T/2), cosine bells",\
           "(c) ~F33~f ~F21~(t=T/2), slotted cylinders","(d) ~F33~f ~F21~(t=T/2), `correlated' cosine bells"/)
  ;
  ; set contour levels
  ;
  mnlvl = 0.1                 ; Minimum contour level.
  mxlvl = 1.1               ; Maximum contour level.
  spcng = 0.05                  ; Contour level spacing.
  ncn   = (mxlvl-mnlvl)/spcng + 1  ; Number of contour levels.
  ;
  ;=========================================================================================
  ;
  ; it should not be necessary to edit beyond this point
  ;
  lon!0          = "lon"
  lon@long_name  = "lon"
  lon@units      = "degrees-east"
  lon&lon        = lon

  lat!0          = "lat"
  lat@long_name  = "lat"
  lat@units      = "degrees_north"
  lat&lat        = lat

  ;
  ; Create a workstation.
  ;
  wks = gsn_open_wks("eps","ncl-plot")
  ;
  ;  Define a color map.
  ;
  gsn_define_colormap(wks,"wh-bl-gr-ye-re")
  ;
  ; To make background color to white
  ;
  setvalues wks
  "wkBackgroundColor" : (/ 1.0,1.0,1.0 /)
  end setvalues
  ;
  ;  Define some resources and draw a globe as a background for 
  ;  the plot. 
  ;
  map_resources = True
  map_resources@gsnFrame = False
  map_resources@gsnMaximize = False     ;;Full Frame
  map_resources@mpGridAndLimbOn = True
  map_resources@mpGridSpacingF = 90.0
  map_resources@mpGridLineDashPattern = 2
  map_resources@mpLimbLineColor = 1
  map_resources@mpGridLineColor = 0
  map_resources@mpGreatCircleLinesOn = True
  map_resources@mpPerimLineThicknessF   = 1.

  map_resources@mpCenterLonF =  0.0           ; Rotate the projection.
  map_resources@mpOutlineOn     = False       ; No continents

  map_resources@vpXF      = 0.1    ; Change the size and location of the
  map_resources@vpYF      = 0.92   ; plot on the viewport.
  map_resources@vpWidthF  = 0.8
  map_resources@vpHeightF = 0.8


;
; Contour line features
;

  map_resources@cnLevelSelectionMode = "ManualLevels" ; Define your own
  map_resources@cnMinLevelValF       = mnlvl          ; contour levels.
  map_resources@cnMaxLevelValF       = mxlvl
  map_resources@cnLevelSpacingF      = spcng

  map_resources@cnInfoLabelOn        = False    ;No c-label box at the bottom 
  map_resources@cnLineLabelsOn       = False    ;No cotour labels 
  map_resources@cnInfoLabelPerimOn   = False

  map_resources@cnFillOn        = True               ; color plot desired
  map_resources@gsnSpreadColors = True               ; use full color table
  map_resources@gsnSpreadColorStart = 10
  map_resources@gsnSpreadColorEnd   = -4

  map_resources@lbLabelBarOn     = False

  map_resources@lbLabelStride       = 2       ;
  map_resources@lbTitleFontThicknessF   = .08
  map_resources@lbAutoManage = False
  map_resources@lbLabelFontHeightF    = .0175

  map_resources@pmTickMarkDisplayMode = "Always"

  map_resources@cnLinesOn         = False
  map_resources@cnLineDashPattern    = 0     ; Solid line contours     
  map_resources@cnLineThicknessF     = 1.0   ; Double the line thickness.
  map_resources@cnMonoLineColor      = True
  map_resources@cnLineColors         = 1 

  map_resources@cnLevelFlag       = True
  map_resources@cnFillOn          = True
  ;
  ; Sticking the contour plots on the map
  ;
   map_resources@sfXCStartV = -180.0         ; Define where contour plot
   map_resources@sfXCEndV   = 180.0         ; should lie on the map plot.
   map_resources@sfYCStartV = -90.0
   map_resources@sfYCEndV   =  90.0

 ; ==============================   DJS changes ================================
   map_resources@mpFillOn   = False         ; not needed

   if (isatt(map_resources,"pmTickMarkDisplayMode")) then
       delete(map_resources@pmTickMarkDisplayMode) 
   end if

   map_resources@tmXBMode   = "Explicit"
   map_resources@tmXBValues = (/ -180, -90, 0, 90, 180/)
   map_resources@tmXBLabels = (/"0", "~F8~p"+"/2", "~F8~p","3"+"~F8~p"+"/2", "2"+"~F8~p"/)

   map_resources@tmYLMode   = "Explicit"
   map_resources@tmYLValues = (/          -90,   0,           90/)
   map_resources@tmYLLabels = (/"-"+"~F8~p"+"/2", "0", "~F8~p"+"/2"/)

   map_resources@mpCenterLonF = 0                 ; make 0 be the center
   map_resources@pmLabelBarOrthogonalPosF = .10   ; move whole thing down

   map_resources@gsnDraw  = False
   map_resources@gsnFrame = False

   fontheight = .027

   map = new(num_files,graphic)

   do i=0,num_files-1
    map_resources@txFont = "helvetica"
    map_resources@gsnCenterString   = ftxt(i)
    map_resources@gsnStringFontHeightF = fontheight

    map(i) = gsn_csm_contour_map_ce(wks,data(:,:,i),map_resources) ; Draw contours over a map.
   end do
   pres = True

   pres@gsnPanelBottom   = 0.05
   pres@gsnPanelLabelBar  = True
   pres@lbLabelAutoStride = True
   pres@gsnPanelDebug     = True     ; To get information from panel

   pres@gsnPanelXWhiteSpacePercent =3 
   pres@gsnPanelYWhiteSpacePercent = 5

   pres@gsnPanelLabelBar  = True
   gsn_panel(wks,map,(/num_files/1,2/),pres)
end



