! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Reaction Rates File
! 
! Generated by KPP-2.2.1_rs5 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : messy_mecca_kpp_Rates.f90
! Time                 : Mon Dec 20 17:34:19 2010
! Working directory    : /home/sander/e2/messy_d2.40f_rs/messy/mbm/caaba/mecca
! Equation file        : messy_mecca_kpp.kpp
! Output root filename : messy_mecca_kpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE messy_mecca_kpp_Rates

  USE messy_mecca_kpp_Parameters
  USE messy_mecca_kpp_Global
  IMPLICIT NONE

CONTAINS



! Begin Rate Law Functions from KPP_HOME/util/UserRateLaws

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  User-defined Rate Law functions
!  Note: the default argument type for rate laws, as read from the equations file, is single precision
!        but all the internal calculations are performed in double precision
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!~~~>  Arrhenius
   REAL(kind=dp) FUNCTION ARR( A0,B0,C0 )
      REAL A0,B0,C0      
      ARR =  DBLE(A0) * EXP(-DBLE(B0)/TEMP) * (TEMP/300.0_dp)**DBLE(C0)
   END FUNCTION ARR        

!~~~> Simplified Arrhenius, with two arguments
!~~~> Note: The argument B0 has a changed sign when compared to ARR
   REAL(kind=dp) FUNCTION ARR2( A0,B0 )
      REAL A0,B0           
      ARR2 =  DBLE(A0) * EXP( DBLE(B0)/TEMP )              
   END FUNCTION ARR2          

   REAL(kind=dp) FUNCTION EP2(A0,C0,A2,C2,A3,C3)
      REAL A0,C0,A2,C2,A3,C3
      REAL(kind=dp) K0,K2,K3            
      K0 = DBLE(A0) * EXP(-DBLE(C0)/TEMP)
      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
      K3 = DBLE(A3) * EXP(-DBLE(C3)/TEMP)
      K3 = K3*CFACTOR*1.0E6_dp
      EP2 = K0 + K3/(1.0_dp+K3/K2 )
   END FUNCTION EP2

   REAL(kind=dp) FUNCTION EP3(A1,C1,A2,C2) 
      REAL A1, C1, A2, C2
      REAL(kind=dp) K1, K2      
      K1 = DBLE(A1) * EXP(-DBLE(C1)/TEMP)
      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
      EP3 = K1 + K2*(1.0E6_dp*CFACTOR)
   END FUNCTION EP3 

   REAL(kind=dp) FUNCTION FALL ( A0,B0,C0,A1,B1,C1,CF)
      REAL A0,B0,C0,A1,B1,C1,CF
      REAL(kind=dp) K0, K1     
      K0 = DBLE(A0) * EXP(-DBLE(B0)/TEMP)* (TEMP/300.0_dp)**DBLE(C0)
      K1 = DBLE(A1) * EXP(-DBLE(B1)/TEMP)* (TEMP/300.0_dp)**DBLE(C1)
      K0 = K0*CFACTOR*1.0E6_dp
      K1 = K0/K1
      FALL = (K0/(1.0_dp+K1))*   &
           DBLE(CF)**(1.0_dp/(1.0_dp+(LOG10(K1))**2))
   END FUNCTION FALL

  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_3rd(temp,cair,k0_300K,n,kinf_300K,m,fc)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL, INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL, INTENT(IN) :: n         ! exponent for low pressure limit
    REAL, INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL, INTENT(IN) :: m         ! exponent for high pressure limit
    REAL, INTENT(IN) :: fc        ! broadening factor (usually fc=0.6)
    REAL(kind=dp) :: zt_help, k0_T, kinf_T, k_ratio

    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    k_3rd   = k0_T/(1._dp+k_ratio)*fc**(1._dp/(1._dp+LOG10(k_ratio)**2))

  END FUNCTION k_3rd

  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_arr (k_298,tdep,temp)
    ! Arrhenius function

    REAL,     INTENT(IN) :: k_298 ! k at T = 298.15K
    REAL,     INTENT(IN) :: tdep  ! temperature dependence
    REAL(kind=dp), INTENT(IN) :: temp  ! temperature

    INTRINSIC EXP

    k_arr = k_298 * EXP(tdep*(1._dp/temp-3.3540E-3_dp)) ! 1/298.15=3.3540e-3

  END FUNCTION k_arr

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  End of User-defined Rate Law functions
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! End Rate Law Functions from KPP_HOME/util/UserRateLaws


! Begin INLINED Rate Law Functions


  ELEMENTAL REAL(dp) FUNCTION k_SIV_H2O2 (k_298,tdep,cHp,temp)
    ! special rate function for S(IV) + H2O2
    REAL,     INTENT(IN) :: k_298 ! k at T = 298.15K
    REAL,     INTENT(IN) :: tdep  ! temperature dependence
    REAL(dp), INTENT(IN) :: cHp   ! c(H+)
    REAL(dp), INTENT(IN) :: temp  ! temperature
    INTRINSIC :: EXP
    k_SIV_H2O2 = k_298 * EXP(tdep*(1._dp/temp-3.3540E-3_dp)) &
      * cHp / (cHp+0.1_dp)
  END FUNCTION k_SIV_H2O2
  ELEMENTAL REAL(dp) FUNCTION k_3rd_iupac(temp,cair,k0_300K,n,kinf_300K,m,fc)
    ! IUPAC three body reaction formula (www.iupac-kinetic.ch.cam.ac.uk)
    INTRINSIC :: LOG10
    REAL(dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL,     INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL,     INTENT(IN) :: n         ! exponent for low pressure limit
    REAL,     INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL,     INTENT(IN) :: m         ! exponent for high pressure limit
    REAL,     INTENT(IN) :: fc        ! broadening factor (e.g. 0.45 or 0.6...)
    REAL                 :: nu        ! N
    REAL                 :: zt_help, k0_T, kinf_T, k_ratio
    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    nu      = 0.75-1.27*LOG10(fc)
    k_3rd_iupac = k0_T/(1._dp+k_ratio)* &
      fc**(1._dp/(1._dp+(LOG10(k_ratio)/nu)**2))
  END FUNCTION k_3rd_iupac
  ELEMENTAL REAL(dp) FUNCTION k_limited (k3rd,cHp)
    ! diffusion limitation caps 3rd order rate coefficients
    REAL(dp), INTENT(IN) :: k3rd  ! 3rd order rate coefficient
    REAL(dp), INTENT(IN) :: cHp   ! c(H+)
    REAL(dp), PARAMETER  :: DiffLimit = 1E10 ! diffusion limitation [M-1s-1]
    INTRINSIC :: EXP
    k_limited = 1._dp / ( 1._dp/k3rd + cHp/DiffLimit)
  END FUNCTION k_limited

! End INLINED Rate Law Functions

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_SUN - update SUN light using TIME
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  SUBROUTINE Update_SUN()
      !USE messy_mecca_kpp_Parameters
      !USE messy_mecca_kpp_Global

    IMPLICIT NONE

    REAL(kind=dp) :: SunRise, SunSet
    REAL(kind=dp) :: Thour, Tlocal, Ttmp 
    ! PI - Value of pi
    REAL(kind=dp), PARAMETER :: PI = 3.14159265358979d0
    
    SunRise = 4.5_dp 
    SunSet  = 19.5_dp 
    Thour = TIME/3600.0_dp 
    Tlocal = Thour - (INT(Thour)/24)*24

    IF ((Tlocal>=SunRise).AND.(Tlocal<=SunSet)) THEN
       Ttmp = (2.0*Tlocal-SunRise-SunSet)/(SunSet-SunRise)
       IF (Ttmp.GT.0) THEN
          Ttmp =  Ttmp*Ttmp
       ELSE
          Ttmp = -Ttmp*Ttmp
       END IF
       SUN = ( 1.0_dp + COS(PI*Ttmp) )/2.0_dp 
    ELSE
       SUN = 0.0_dp 
    END IF

 END SUBROUTINE Update_SUN

! End of Update_SUN function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_RCONST - function to update rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_RCONST ( )




! Begin INLINED RCONST


  USE messy_main_constants_mem ! atm2Pa, N_A, R_gas
  USE messy_cmn_photol_mem     ! IP_MAX, ip_*, jname
  ! end of USE statements
  !
  ! start of executable statements
  ! define some rate constants here if the expressions are too long
  ! for kpp or if they are used more than once
  k_HO2_HO2    = (1.5E-12*EXP(19./temp)+1.7E-33*EXP(1000./temp)*cair)* & ! {1.5+-0.2}
                 (1.+1.4E-21*EXP(2200./temp)*C(ind_H2O))
  k_NO3_NO2    = k_3rd(temp,cair,2.0E-30,4.4,1.4E-12,0.7,0.6)
  k_NO2_HO2    = k_3rd(temp,cair,2.0E-31,3.4,2.9E-12,1.1,0.6)
  k_HNO3_OH    = 2.4E-14*EXP(460./temp) + 1./ &
                 ( 1./(6.5E-34*EXP(1335./temp)*cair) + &
                 1./(2.7E-17*EXP(2199./temp)) )
  k_CH3OOH_OH  = 3.8E-12*EXP(200./temp)
  k_CH3CO3_NO2 = k_3rd(temp,cair,9.7E-29,5.6,9.3E-12,1.5,0.6)
  k_PAN_M      = k_CH3CO3_NO2/9.0E-29*EXP(-14000./temp)
  k_ClO_ClO    = k_3rd_iupac(temp,cair,2.0E-32, &
                 4.0,1.0E-11,0.0,0.45)
  ! JPL: k_ClO_ClO   = k_3rd(temp,cair,1.6E-32,4.5,2.0E-12,2.4,0.6)
  k_BrO_NO2    = k_3rd_iupac(temp,cair,4.7E-31,3.1,1.8E-11,0.0,0.4)
  ! JPL: k_BrO_NO2   = k_3rd(temp,cair,5.2E-31,3.2,6.9E-12,2.9,0.6)
  k_I_NO2      = k_3rd_iupac(temp,cair,3.0E-31,1.0,6.6E-11,0.0,0.63)
  ! for numerical reasons, the expression is multiplied by 1e30/1e30
  k_DMS_OH     = 1.E-9*EXP(5820./temp)*C(ind_O2)/ &
                 (1.E30+5.*EXP(6280./temp)*C(ind_O2))
  G7402a_yield = 0.8/1.1 ! 0.8+-0.2
  ! mz_pj_20080812+
  k_O3s = (1.7E-12*EXP(-940./temp)) * C(ind_OH) &  ! <G2104>
        + (1.E-14*EXP(-490./temp)) * C(ind_HO2) &  ! <G2107>
        + jx(ip_O1D) * 2.2E-10 * C(ind_H2O) &      !
        / ( 3.2E-11*EXP(70./temp)*C(ind_O2)   &
           + 1.8E-11*EXP(110./temp)*C(ind_N2) &
           + 2.2E-10*C(ind_H2O) )
  ! mz_pj_20080812-
  KRO2NO  = 2.54E-12*EXP(360./temp)
  KRO2HO2 = 2.91E-13*EXP(1300./temp)
  KAPHO2  = 4.30E-13*EXP(1040./temp) ! CH3CO3 + HO2
  KAPNO   = 8.10E-12*EXP(270./temp)  ! CH3CO3 + NO
  KRO2NO3 = 2.50E-12
  KNO3AL  = 1.4E-12*EXP(-1900./temp)
  J_IC3H7NO3 = 3.7*jx(ip_PAN)
  J_ACETOL   = 0.65*0.11*jx(ip_CHOH)
  RO2 = 0.
  IF (ind_LISOPACO2>0)  RO2 = RO2 + C(ind_LISOPACO2)
  IF (ind_ISOPBO2>0)    RO2 = RO2 + C(ind_ISOPBO2)
  IF (ind_ISOPDO2>0)    RO2 = RO2 + C(ind_ISOPDO2)
  IF (ind_NISOPO2>0)    RO2 = RO2 + C(ind_NISOPO2)
  IF (ind_LHC4ACCO3>0)  RO2 = RO2 + C(ind_LHC4ACCO3)
  IF (ind_LC578O2>0)    RO2 = RO2 + C(ind_LC578O2)
  IF (ind_C59O2>0)      RO2 = RO2 + C(ind_C59O2)
  IF (ind_LNISO3>0)     RO2 = RO2 + C(ind_LNISO3)
  IF (ind_CH3O2>0)      RO2 = RO2 + C(ind_CH3O2)
  IF (ind_CH3CO3>0)     RO2 = RO2 + C(ind_CH3CO3)
  IF (ind_C2H5O2>0)     RO2 = RO2 + C(ind_C2H5O2)
  IF (ind_HOCH2CO3>0)   RO2 = RO2 + C(ind_HOCH2CO3)
  IF (ind_HYPROPO2>0)   RO2 = RO2 + C(ind_HYPROPO2)
  IF (ind_HCOCO3>0)     RO2 = RO2 + C(ind_HCOCO3)
  IF (ind_CO2H3CO3>0)   RO2 = RO2 + C(ind_CO2H3CO3)
  IF (ind_LHMVKABO2>0)  RO2 = RO2 + C(ind_LHMVKABO2)
  IF (ind_MACO3>0)      RO2 = RO2 + C(ind_MACO3)
  IF (ind_MACRO2>0)     RO2 = RO2 + C(ind_MACRO2)
  IF (ind_LMVKOHABO2>0) RO2 = RO2 + C(ind_LMVKOHABO2)
  IF (ind_PRONO3BO2>0)  RO2 = RO2 + C(ind_PRONO3BO2)
  IF (ind_HOCH2CH2O2>0) RO2 = RO2 + C(ind_HOCH2CH2O2)
  IF (ind_CH3COCH2O2>0) RO2 = RO2 + C(ind_CH3COCH2O2)
  IF (ind_IC3H7O2>0)    RO2 = RO2 + C(ind_IC3H7O2)
  IF (ind_LC4H9O2>0)    RO2 = RO2 + C(ind_LC4H9O2)
  IF (ind_LMEKO2>0)     RO2 = RO2 + C(ind_LMEKO2)

! End INLINED RCONST

  RCONST(1) = (3.3E-11*EXP(55./temp))
  RCONST(2) = (6.E-34*((temp/300.)**(-2.4))*cair)
  RCONST(3) = (k_3rd(temp,cair,4.4E-32,1.3,4.7E-11,0.2,0.6))
  RCONST(4) = (1.7E-12*EXP(-940./temp))
  RCONST(5) = (2.8E-12*EXP(-1800./temp))
  RCONST(6) = (1.E-14*EXP(-490./temp))
  RCONST(7) = (4.8E-11*EXP(250./temp))
  RCONST(8) = (k_HO2_HO2)
  RCONST(9) = (1.63E-10*EXP(60./temp))
! RCONST(10) = constant rate coefficient
  RCONST(11) = (2.15E-11*EXP(110./temp))
  RCONST(12) = (3.E-12*EXP(-1500./temp))
  RCONST(13) = (1.2E-13*EXP(-2450./temp))
  RCONST(14) = (1.5E-11*EXP(170./temp))
  RCONST(15) = (k_NO3_NO2)
  RCONST(16) = (k_NO3_NO2/(2.7E-27*EXP(11000./temp)))
  RCONST(17) = (k_3rd(temp,cair,7.0E-31,2.6,3.6E-11,0.1,0.6))
  RCONST(18) = (3.5E-12*EXP(250./temp))
  RCONST(19) = (k_3rd(temp,cair,1.8E-30,3.0,2.8E-11,0.,0.6))
  RCONST(20) = (k_NO2_HO2)
! RCONST(21) = constant rate coefficient
  RCONST(22) = (1.8E-11*EXP(-390./temp))
  RCONST(23) = (k_HNO3_OH)
  RCONST(24) = (k_NO2_HO2/(2.1E-27*EXP(10900./temp)))
  RCONST(25) = (1.3E-12*EXP(380./temp))
  RCONST(26) = (1.7E-12*EXP(-710./temp))
  RCONST(27) = (4.3E-12*EXP(-930./temp))
  RCONST(28) = (4.8E-07*EXP(-628./temp)*temp**(-1.32))
  RCONST(29) = (9.4E-09*EXP(-356./temp)*temp**(-1.12))
  RCONST(30) = (1.92E-12*((temp/298.)**(-1.5)))
  RCONST(31) = (1.41E-11*((temp/298.)**(-1.5)))
  RCONST(32) = (1.2E-11*((temp/298.)**(-2.0)))
  RCONST(33) = (0.8E-11*((temp/298.)**(-2.0)))
! RCONST(34) = constant rate coefficient
! RCONST(35) = constant rate coefficient
  RCONST(36) = (8.0E-11*EXP(-500./temp))
  RCONST(37) = (1.66E-12*EXP(-1500./temp))
  RCONST(38) = (1.0E-12*EXP(-1000./temp))
! RCONST(39) = constant rate coefficient
  RCONST(40) = (4.13E-11*EXP(-2138./temp))
  RCONST(41) = (3.65E-14*EXP(-4600./temp))
  RCONST(42) = (1.85E-20*EXP(2.82*log(temp)-987./temp))
  RCONST(43) = (2.9E-12*EXP(-345./temp))
  RCONST(44) = (4.1E-13*EXP(750./temp))
  RCONST(45) = (2.8E-12*EXP(300./temp))
! RCONST(46) = constant rate coefficient
  RCONST(47) = (2.*RO2*9.5E-14*EXP(390./temp)/(1.+1./26.2*EXP(1130./temp)))
  RCONST(48) = (2.*RO2*9.5E-14*EXP(390./temp)/(1.+26.2*EXP(-1130./temp)))
  RCONST(49) = (k_CH3OOH_OH)
  RCONST(50) = (9.52E-18*EXP(2.03*log(temp)+636./temp))
  RCONST(51) = (3.4E-13*EXP(-1900./temp))
  RCONST(52) = ((1.57E-13+cair*3.54E-33))
! RCONST(53) = constant rate coefficient
  RCONST(54) = (jx(ip_O2))
  RCONST(55) = (jx(ip_O1D))
  RCONST(56) = (jx(ip_O3P))
  RCONST(57) = (jx(ip_H2O2))
  RCONST(58) = (jx(ip_NO2))
  RCONST(59) = (jx(ip_NO2O))
  RCONST(60) = (jx(ip_NOO2))
  RCONST(61) = (jx(ip_N2O5))
  RCONST(62) = (jx(ip_HONO))
  RCONST(63) = (jx(ip_HNO3))
  RCONST(64) = (jx(ip_HNO4))
  RCONST(65) = (jx(ip_CH3OOH))
  RCONST(66) = (jx(ip_COH2))
  RCONST(67) = (jx(ip_CHOH))
      
END SUBROUTINE Update_RCONST

! End of Update_RCONST function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_PHOTO - function to update photolytical rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_PHOTO ( )


   USE messy_mecca_kpp_Global

  RCONST(54) = (jx(ip_O2))
  RCONST(55) = (jx(ip_O1D))
  RCONST(56) = (jx(ip_O3P))
  RCONST(57) = (jx(ip_H2O2))
  RCONST(58) = (jx(ip_NO2))
  RCONST(59) = (jx(ip_NO2O))
  RCONST(60) = (jx(ip_NOO2))
  RCONST(61) = (jx(ip_N2O5))
  RCONST(62) = (jx(ip_HONO))
  RCONST(63) = (jx(ip_HNO3))
  RCONST(64) = (jx(ip_HNO4))
  RCONST(65) = (jx(ip_CH3OOH))
  RCONST(66) = (jx(ip_COH2))
  RCONST(67) = (jx(ip_CHOH))
      
END SUBROUTINE Update_PHOTO

! End of Update_PHOTO function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE messy_mecca_kpp_Rates

