! ==============================================================================
! {%CMODEL}_dbl_box
! generated: {%TIMEDATE}
!
! this module is generated by imdouble utility
!
! inter-configuration driver module
! level: smil boxmodel
!
! {$DBL_INFO} ! this is a template for isotopes configuration
!
! [Gromov, MPI-C, 2007-2008]
! ==============================================================================

! - general doubling parameters (as conditional defines) -----------------------

#include "{%CMODEL}_dbl_parameters.inc"

! -----------------------------------------------------------------------------

MODULE {%CMODEL}_dbl_box

  USE messy_mecca_kpp ! dp, ...
  USE caaba_mem, ONLY: C, timesteplen  ! interfaced box (caaba)
  USE {%CMODEL}_dbl_common   ! inter-configuration module: common utils, consts

! configurations linked
! {$CONF_LIST} [%  USE {%CMODEL}_@%]
! {$CONF_LIST} [%  USE {%CMODEL}_@_box%]

  IMPLICIT NONE

  PUBLIC mecca_dbl_postprocess      ! substitutes calc totals/deltas/fractions
  PUBLIC mecca_dbl_emis             ! proc. for emission in all configurations
  PUBLIC mecca_dbl_depos            !           removal
  PUBLIC mecca_dbl_init
  PUBLIC mecca_dbl_result
  PUBLIC mecca_dbl_finish

! =============================================================================

CONTAINS

! -----------------------------------------------------------------------------

  SUBROUTINE mecca_dbl_x0
  
    IMPLICIT NONE

! {$CONF_LIST} [%    CALL @_x0%]

#ifdef DEBUG
    print *,'dbl_x0: passed'
#endif 

  END SUBROUTINE mecca_dbl_x0



! -----------------------------------------------------------------------------

  SUBROUTINE mecca_dbl_postprocess

    IMPLICIT NONE

! {$CONF_LIST} [%    CALL @_postprocess%]

  ! by default, to remove deviation due to KIEs, correcting
! {$CONF_LIST} [%    CALL @_correct(C)%]

  ! converting PTs values (integral) into average reaction rates
    CALL mecca_dbl_intPTs2arr(C, timesteplen)

#ifdef DEBUG
    print *,'dbl_postprocess: passed'
#endif 

  END SUBROUTINE mecca_dbl_postprocess



! -----------------------------------------------------------------------------

  SUBROUTINE mecca_dbl_emis(ind_r, amount, deltas)

    IMPLICIT NONE

    INTEGER,  INTENT(IN)    :: ind_r
    REAL(dp), INTENT(IN)    :: amount
    REAL(dp), INTENT(IN)    :: deltas(:)

! {$CONF_LIST} [%    CALL @_emis(ind_r, amount, deltas)%]

#ifdef DEBUG
    print *,'dbl_emis(',TRIM(SPC_NAMES(ind_r)),', ',amount,', ',deltas,'): passed'
#endif 

  END SUBROUTINE mecca_dbl_emis



! -----------------------------------------------------------------------------

  SUBROUTINE mecca_dbl_depos(ind_r, factor)

    IMPLICIT NONE

    INTEGER,  INTENT(IN)    :: ind_r
    REAL(dp), INTENT(IN)    :: factor

! {$CONF_LIST} [%    CALL @_depos(ind_r, factor)%]

#ifdef DEBUG
    print *,'dbl_depos(',TRIM(SPC_NAMES(ind_r)),', ',factor,'): passed'
#endif 

  END SUBROUTINE mecca_dbl_depos



! -----------------------------------------------------------------------------

  SUBROUTINE mecca_dbl_init

    IMPLICIT NONE

    CHARACTER(len=1024) :: info

  ! scan PTs if there are any
    CALL mecca_dbl_scanPTs(info)
    print *,info

    CALL mecca_dbl_x0

! {$CONF_LIST} [%    CALL @_init%]
  
#ifdef DEBUG
    print *,'dbl_init: passed'
#endif 

  END SUBROUTINE mecca_dbl_init



! -----------------------------------------------------------------------------

  SUBROUTINE mecca_dbl_result(model_time)

    IMPLICIT NONE
    
    REAL(dp), INTENT(IN) :: model_time
    
! {$CONF_LIST} [%    CALL @_result(model_time)%]

  ! resetting PTs after flushing of the output
    CALL mecca_dbl_resetPTs(C)

#ifdef DEBUG
    print *,'dbl_result: passed'
#endif 

  END SUBROUTINE mecca_dbl_result



! ---------------------------------------------------------------------------

  SUBROUTINE mecca_dbl_finish

    IMPLICIT NONE

! {$CONF_LIST} [%    CALL @_finish%]

#ifdef DEBUG
    print *,'dbl_finish: passed'
#endif 

  END SUBROUTINE mecca_dbl_finish



! ---------------------------------------------------------------------------

END MODULE {%CMODEL}_dbl_box

! ***************************************************************************

