! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Jacobian of Chemical Model File
! 
! Generated by KPP-2.2.1_rs5 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : messy_mecca_kpp_Jacobian.f90
! Time                 : Mon Dec 20 17:34:19 2010
! Working directory    : /home/sander/e2/messy_d2.40f_rs/messy/mbm/caaba/mecca
! Equation file        : messy_mecca_kpp.kpp
! Output root filename : messy_mecca_kpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE messy_mecca_kpp_Jacobian

  USE messy_mecca_kpp_Parameters
  USE messy_mecca_kpp_JacobianSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Jac_SP - the Jacobian of Variables in sparse matrix representation
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      JVS       - sparse Jacobian of variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Jac_SP ( V, F, RCT, JVS )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)


! Local variables
! B - Temporary array
  REAL(kind=dp) :: B(114)

! B(1) = dA(1)/dV(12)
  B(1) = RCT(1)*F(1)
! B(3) = dA(2)/dV(5)
  B(3) = RCT(2)*F(1)
! B(5) = dA(3)/dV(7)
  B(5) = RCT(3)*F(1)
! B(7) = dA(4)/dV(26)
  B(7) = RCT(4)*V(28)
! B(8) = dA(4)/dV(28)
  B(8) = RCT(4)*V(26)
! B(9) = dA(5)/dV(9)
  B(9) = RCT(5)*V(28)
! B(10) = dA(5)/dV(28)
  B(10) = RCT(5)*V(9)
! B(11) = dA(6)/dV(26)
  B(11) = RCT(6)*V(29)
! B(12) = dA(6)/dV(29)
  B(12) = RCT(6)*V(26)
! B(13) = dA(7)/dV(28)
  B(13) = RCT(7)*V(29)
! B(14) = dA(7)/dV(29)
  B(14) = RCT(7)*V(28)
! B(15) = dA(8)/dV(29)
  B(15) = RCT(8)*2*V(29)
! B(16) = dA(9)/dV(12)
  B(16) = RCT(9)*V(19)
! B(17) = dA(9)/dV(19)
  B(17) = RCT(9)*V(12)
! B(18) = dA(10)/dV(8)
  B(18) = 1.8e-12*V(28)
! B(19) = dA(10)/dV(28)
  B(19) = 1.8e-12*V(8)
! B(20) = dA(11)/dV(12)
  B(20) = RCT(11)*F(2)
! B(22) = dA(12)/dV(26)
  B(22) = RCT(12)*V(27)
! B(23) = dA(12)/dV(27)
  B(23) = RCT(12)*V(26)
! B(24) = dA(13)/dV(26)
  B(24) = RCT(13)*V(30)
! B(25) = dA(13)/dV(30)
  B(25) = RCT(13)*V(26)
! B(26) = dA(14)/dV(25)
  B(26) = RCT(14)*V(27)
! B(27) = dA(14)/dV(27)
  B(27) = RCT(14)*V(25)
! B(28) = dA(15)/dV(25)
  B(28) = RCT(15)*V(30)
! B(29) = dA(15)/dV(30)
  B(29) = RCT(15)*V(25)
! B(30) = dA(16)/dV(6)
  B(30) = RCT(16)
! B(31) = dA(17)/dV(27)
  B(31) = RCT(17)*V(28)
! B(32) = dA(17)/dV(28)
  B(32) = RCT(17)*V(27)
! B(33) = dA(18)/dV(27)
  B(33) = RCT(18)*V(29)
! B(34) = dA(18)/dV(29)
  B(34) = RCT(18)*V(27)
! B(35) = dA(19)/dV(28)
  B(35) = RCT(19)*V(30)
! B(36) = dA(19)/dV(30)
  B(36) = RCT(19)*V(28)
! B(37) = dA(20)/dV(29)
  B(37) = RCT(20)*V(30)
! B(38) = dA(20)/dV(30)
  B(38) = RCT(20)*V(29)
! B(39) = dA(21)/dV(25)
  B(39) = 3.5e-12*V(29)
! B(40) = dA(21)/dV(29)
  B(40) = 3.5e-12*V(25)
! B(41) = dA(22)/dV(17)
  B(41) = RCT(22)*V(28)
! B(42) = dA(22)/dV(28)
  B(42) = RCT(22)*V(17)
! B(43) = dA(23)/dV(18)
  B(43) = RCT(23)*V(28)
! B(44) = dA(23)/dV(28)
  B(44) = RCT(23)*V(18)
! B(45) = dA(24)/dV(15)
  B(45) = RCT(24)
! B(46) = dA(25)/dV(15)
  B(46) = RCT(25)*V(28)
! B(47) = dA(25)/dV(28)
  B(47) = RCT(25)*V(15)
! B(48) = dA(26)/dV(2)
  B(48) = RCT(26)*V(28)
! B(49) = dA(26)/dV(28)
  B(49) = RCT(26)*V(2)
! B(50) = dA(27)/dV(22)
  B(50) = RCT(27)*V(26)
! B(51) = dA(27)/dV(26)
  B(51) = RCT(27)*V(22)
! B(52) = dA(28)/dV(22)
  B(52) = RCT(28)*V(29)
! B(53) = dA(28)/dV(29)
  B(53) = RCT(28)*V(22)
! B(54) = dA(29)/dV(22)
  B(54) = RCT(29)*V(29)
! B(55) = dA(29)/dV(29)
  B(55) = RCT(29)*V(22)
! B(56) = dA(30)/dV(22)
  B(56) = RCT(30)*V(27)
! B(57) = dA(30)/dV(27)
  B(57) = RCT(30)*V(22)
! B(58) = dA(31)/dV(22)
  B(58) = RCT(31)*V(27)
! B(59) = dA(31)/dV(27)
  B(59) = RCT(31)*V(22)
! B(60) = dA(32)/dV(22)
  B(60) = RCT(32)*V(30)
! B(61) = dA(32)/dV(30)
  B(61) = RCT(32)*V(22)
! B(62) = dA(33)/dV(22)
  B(62) = RCT(33)*V(30)
! B(63) = dA(33)/dV(30)
  B(63) = RCT(33)*V(22)
! B(64) = dA(34)/dV(20)
  B(64) = 1.2e-14*V(26)
! B(65) = dA(34)/dV(26)
  B(65) = 1.2e-14*V(20)
! B(66) = dA(35)/dV(20)
  B(66) = 1300
! B(67) = dA(36)/dV(21)
  B(67) = RCT(36)*V(28)
! B(68) = dA(36)/dV(28)
  B(68) = RCT(36)*V(21)
! B(69) = dA(37)/dV(14)
  B(69) = RCT(37)*V(21)
! B(70) = dA(37)/dV(21)
  B(70) = RCT(37)*V(14)
! B(71) = dA(38)/dV(21)
  B(71) = RCT(38)*V(30)
! B(72) = dA(38)/dV(30)
  B(72) = RCT(38)*V(21)
! B(73) = dA(39)/dV(14)
  B(73) = 1.66e-12*V(28)
! B(74) = dA(39)/dV(28)
  B(74) = 1.66e-12*V(14)
! B(75) = dA(40)/dV(13)
  B(75) = RCT(40)*V(28)
! B(76) = dA(40)/dV(28)
  B(76) = RCT(40)*V(13)
! B(77) = dA(41)/dV(21)
  B(77) = RCT(41)*F(1)
! B(79) = dA(42)/dV(3)
  B(79) = RCT(42)*V(28)
! B(80) = dA(42)/dV(28)
  B(80) = RCT(42)*V(3)
! B(81) = dA(43)/dV(10)
  B(81) = RCT(43)*V(28)
! B(82) = dA(43)/dV(28)
  B(82) = RCT(43)*V(10)
! B(83) = dA(44)/dV(24)
  B(83) = RCT(44)*V(29)
! B(84) = dA(44)/dV(29)
  B(84) = RCT(44)*V(24)
! B(85) = dA(45)/dV(24)
  B(85) = RCT(45)*V(27)
! B(86) = dA(45)/dV(27)
  B(86) = RCT(45)*V(24)
! B(87) = dA(46)/dV(24)
  B(87) = 1.3e-12*V(25)
! B(88) = dA(46)/dV(25)
  B(88) = 1.3e-12*V(24)
! B(89) = dA(47)/dV(24)
  B(89) = RCT(47)
! B(90) = dA(48)/dV(24)
  B(90) = RCT(48)
! B(91) = dA(49)/dV(16)
  B(91) = RCT(49)*V(28)
! B(92) = dA(49)/dV(28)
  B(92) = RCT(49)*V(16)
! B(93) = dA(50)/dV(23)
  B(93) = RCT(50)*V(28)
! B(94) = dA(50)/dV(28)
  B(94) = RCT(50)*V(23)
! B(95) = dA(51)/dV(23)
  B(95) = RCT(51)*V(25)
! B(96) = dA(51)/dV(25)
  B(96) = RCT(51)*V(23)
! B(97) = dA(52)/dV(11)
  B(97) = RCT(52)*V(28)
! B(98) = dA(52)/dV(28)
  B(98) = RCT(52)*V(11)
! B(99) = dA(53)/dV(4)
  B(99) = 4e-13*V(28)
! B(100) = dA(53)/dV(28)
  B(100) = 4e-13*V(4)
! B(102) = dA(55)/dV(26)
  B(102) = RCT(55)
! B(103) = dA(56)/dV(26)
  B(103) = RCT(56)
! B(104) = dA(57)/dV(8)
  B(104) = RCT(57)
! B(105) = dA(58)/dV(30)
  B(105) = RCT(58)
! B(106) = dA(59)/dV(25)
  B(106) = RCT(59)
! B(107) = dA(60)/dV(25)
  B(107) = RCT(60)
! B(108) = dA(61)/dV(6)
  B(108) = RCT(61)
! B(109) = dA(62)/dV(17)
  B(109) = RCT(62)
! B(110) = dA(63)/dV(18)
  B(110) = RCT(63)
! B(111) = dA(64)/dV(15)
  B(111) = RCT(64)
! B(112) = dA(65)/dV(16)
  B(112) = RCT(65)
! B(113) = dA(66)/dV(23)
  B(113) = RCT(66)
! B(114) = dA(67)/dV(23)
  B(114) = RCT(67)

! Construct the Jacobian terms from B's
! JVS(1) = Jac_FULL(1,1)
  JVS(1) = 0
! JVS(2) = Jac_FULL(1,22)
  JVS(2) = B(60)
! JVS(3) = Jac_FULL(1,30)
  JVS(3) = B(61)
! JVS(4) = Jac_FULL(2,2)
  JVS(4) = -B(48)
! JVS(5) = Jac_FULL(2,28)
  JVS(5) = -B(49)
! JVS(6) = Jac_FULL(3,3)
  JVS(6) = -B(79)
! JVS(7) = Jac_FULL(3,28)
  JVS(7) = -B(80)
! JVS(8) = Jac_FULL(4,4)
  JVS(8) = -B(99)
! JVS(9) = Jac_FULL(4,28)
  JVS(9) = -B(100)
! JVS(10) = Jac_FULL(5,5)
  JVS(10) = -B(3)
! JVS(11) = Jac_FULL(5,12)
  JVS(11) = B(1)+B(20)
! JVS(12) = Jac_FULL(5,25)
  JVS(12) = B(106)
! JVS(13) = Jac_FULL(5,26)
  JVS(13) = B(103)
! JVS(14) = Jac_FULL(5,30)
  JVS(14) = B(105)
! JVS(15) = Jac_FULL(6,6)
  JVS(15) = -B(30)-B(108)
! JVS(16) = Jac_FULL(6,25)
  JVS(16) = B(28)
! JVS(17) = Jac_FULL(6,30)
  JVS(17) = B(29)
! JVS(18) = Jac_FULL(7,7)
  JVS(18) = -B(5)
! JVS(19) = Jac_FULL(7,9)
  JVS(19) = B(9)
! JVS(20) = Jac_FULL(7,11)
  JVS(20) = B(97)
! JVS(21) = Jac_FULL(7,23)
  JVS(21) = B(114)
! JVS(22) = Jac_FULL(7,28)
  JVS(22) = B(10)+B(98)
! JVS(23) = Jac_FULL(8,8)
  JVS(23) = -B(18)-B(104)
! JVS(24) = Jac_FULL(8,28)
  JVS(24) = -B(19)
! JVS(25) = Jac_FULL(8,29)
  JVS(25) = B(15)
! JVS(26) = Jac_FULL(9,9)
  JVS(26) = -B(9)
! JVS(27) = Jac_FULL(9,23)
  JVS(27) = B(113)
! JVS(28) = Jac_FULL(9,28)
  JVS(28) = -B(10)
! JVS(29) = Jac_FULL(10,10)
  JVS(29) = -B(81)
! JVS(30) = Jac_FULL(10,24)
  JVS(30) = 0.5*B(90)
! JVS(31) = Jac_FULL(10,28)
  JVS(31) = -B(82)
! JVS(32) = Jac_FULL(11,11)
  JVS(32) = -B(97)
! JVS(33) = Jac_FULL(11,23)
  JVS(33) = B(93)+B(95)+B(113)+B(114)
! JVS(34) = Jac_FULL(11,25)
  JVS(34) = B(96)
! JVS(35) = Jac_FULL(11,28)
  JVS(35) = B(94)-B(98)
! JVS(36) = Jac_FULL(12,12)
  JVS(36) = -B(1)-B(16)-B(20)
! JVS(37) = Jac_FULL(12,19)
  JVS(37) = -B(17)
! JVS(38) = Jac_FULL(12,26)
  JVS(38) = B(102)
! JVS(39) = Jac_FULL(13,13)
  JVS(39) = -B(75)
! JVS(40) = Jac_FULL(13,14)
  JVS(40) = B(69)
! JVS(41) = Jac_FULL(13,21)
  JVS(41) = B(70)
! JVS(42) = Jac_FULL(13,28)
  JVS(42) = -B(76)
! JVS(43) = Jac_FULL(14,13)
  JVS(43) = B(75)
! JVS(44) = Jac_FULL(14,14)
  JVS(44) = -B(69)-B(73)
! JVS(45) = Jac_FULL(14,20)
  JVS(45) = B(66)
! JVS(46) = Jac_FULL(14,21)
  JVS(46) = -B(70)
! JVS(47) = Jac_FULL(14,28)
  JVS(47) = -B(74)+B(76)
! JVS(48) = Jac_FULL(15,15)
  JVS(48) = -B(45)-B(46)-B(111)
! JVS(49) = Jac_FULL(15,28)
  JVS(49) = -B(47)
! JVS(50) = Jac_FULL(15,29)
  JVS(50) = B(37)
! JVS(51) = Jac_FULL(15,30)
  JVS(51) = B(38)
! JVS(52) = Jac_FULL(16,16)
  JVS(52) = -B(91)-B(112)
! JVS(53) = Jac_FULL(16,24)
  JVS(53) = B(83)
! JVS(54) = Jac_FULL(16,28)
  JVS(54) = -B(92)
! JVS(55) = Jac_FULL(16,29)
  JVS(55) = B(84)
! JVS(56) = Jac_FULL(17,17)
  JVS(56) = -B(41)-B(109)
! JVS(57) = Jac_FULL(17,21)
  JVS(57) = B(71)
! JVS(58) = Jac_FULL(17,27)
  JVS(58) = B(31)
! JVS(59) = Jac_FULL(17,28)
  JVS(59) = B(32)-B(42)
! JVS(60) = Jac_FULL(17,30)
  JVS(60) = B(72)
! JVS(61) = Jac_FULL(18,18)
  JVS(61) = -B(43)-B(110)
! JVS(62) = Jac_FULL(18,23)
  JVS(62) = B(95)
! JVS(63) = Jac_FULL(18,25)
  JVS(63) = B(96)
! JVS(64) = Jac_FULL(18,28)
  JVS(64) = B(35)-B(44)
! JVS(65) = Jac_FULL(18,30)
  JVS(65) = B(36)
! JVS(66) = Jac_FULL(19,2)
  JVS(66) = B(48)
! JVS(67) = Jac_FULL(19,3)
  JVS(67) = B(79)
! JVS(68) = Jac_FULL(19,4)
  JVS(68) = B(99)
! JVS(69) = Jac_FULL(19,8)
  JVS(69) = B(18)
! JVS(70) = Jac_FULL(19,9)
  JVS(70) = B(9)
! JVS(71) = Jac_FULL(19,12)
  JVS(71) = -B(16)
! JVS(72) = Jac_FULL(19,13)
  JVS(72) = B(75)
! JVS(73) = Jac_FULL(19,14)
  JVS(73) = B(73)
! JVS(74) = Jac_FULL(19,15)
  JVS(74) = B(46)
! JVS(75) = Jac_FULL(19,16)
  JVS(75) = B(91)
! JVS(76) = Jac_FULL(19,17)
  JVS(76) = B(41)
! JVS(77) = Jac_FULL(19,18)
  JVS(77) = B(43)
! JVS(78) = Jac_FULL(19,19)
  JVS(78) = -B(17)
! JVS(79) = Jac_FULL(19,20)
  JVS(79) = 0
! JVS(80) = Jac_FULL(19,21)
  JVS(80) = B(67)
! JVS(81) = Jac_FULL(19,22)
  JVS(81) = B(54)+B(58)+B(60)
! JVS(82) = Jac_FULL(19,23)
  JVS(82) = B(93)
! JVS(83) = Jac_FULL(19,24)
  JVS(83) = 0
! JVS(84) = Jac_FULL(19,25)
  JVS(84) = 0
! JVS(85) = Jac_FULL(19,26)
  JVS(85) = 0
! JVS(86) = Jac_FULL(19,27)
  JVS(86) = B(59)
! JVS(87) = Jac_FULL(19,28)
  JVS(87) = B(10)+B(13)+B(19)+B(42)+B(44)+B(47)+B(49)+B(68)+B(74)+B(76)+B(80)+B(92)+B(94)+B(100)
! JVS(88) = Jac_FULL(19,29)
  JVS(88) = B(14)+B(55)
! JVS(89) = Jac_FULL(19,30)
  JVS(89) = B(61)
! JVS(90) = Jac_FULL(20,20)
  JVS(90) = -B(64)-B(66)
! JVS(91) = Jac_FULL(20,22)
  JVS(91) = B(50)+B(52)+B(62)
! JVS(92) = Jac_FULL(20,26)
  JVS(92) = B(51)-B(65)
! JVS(93) = Jac_FULL(20,29)
  JVS(93) = B(53)
! JVS(94) = Jac_FULL(20,30)
  JVS(94) = B(63)
! JVS(95) = Jac_FULL(21,14)
  JVS(95) = -B(69)+B(73)
! JVS(96) = Jac_FULL(21,20)
  JVS(96) = 0
! JVS(97) = Jac_FULL(21,21)
  JVS(97) = -B(67)-B(70)-B(71)-B(77)
! JVS(98) = Jac_FULL(21,22)
  JVS(98) = B(54)
! JVS(99) = Jac_FULL(21,26)
  JVS(99) = 0
! JVS(100) = Jac_FULL(21,28)
  JVS(100) = -B(68)+B(74)
! JVS(101) = Jac_FULL(21,29)
  JVS(101) = B(55)
! JVS(102) = Jac_FULL(21,30)
  JVS(102) = -B(72)
! JVS(103) = Jac_FULL(22,2)
  JVS(103) = B(48)
! JVS(104) = Jac_FULL(22,20)
  JVS(104) = B(64)
! JVS(105) = Jac_FULL(22,22)
  JVS(105) = -B(50)-B(52)-B(54)-B(56)-B(58)-B(60)-B(62)
! JVS(106) = Jac_FULL(22,26)
  JVS(106) = -B(51)+B(65)
! JVS(107) = Jac_FULL(22,27)
  JVS(107) = -B(57)-B(59)
! JVS(108) = Jac_FULL(22,28)
  JVS(108) = B(49)
! JVS(109) = Jac_FULL(22,29)
  JVS(109) = -B(53)-B(55)
! JVS(110) = Jac_FULL(22,30)
  JVS(110) = -B(61)-B(63)
! JVS(111) = Jac_FULL(23,10)
  JVS(111) = B(81)
! JVS(112) = Jac_FULL(23,16)
  JVS(112) = 0.3*B(91)+B(112)
! JVS(113) = Jac_FULL(23,23)
  JVS(113) = -B(93)-B(95)-B(113)-B(114)
! JVS(114) = Jac_FULL(23,24)
  JVS(114) = B(85)+B(87)+B(89)+0.5*B(90)
! JVS(115) = Jac_FULL(23,25)
  JVS(115) = B(88)-B(96)
! JVS(116) = Jac_FULL(23,27)
  JVS(116) = B(86)
! JVS(117) = Jac_FULL(23,28)
  JVS(117) = B(82)+0.3*B(92)-B(94)
! JVS(118) = Jac_FULL(23,29)
  JVS(118) = 0
! JVS(119) = Jac_FULL(24,3)
  JVS(119) = B(79)
! JVS(120) = Jac_FULL(24,16)
  JVS(120) = 0.7*B(91)
! JVS(121) = Jac_FULL(24,24)
  JVS(121) = -B(83)-B(85)-B(87)-B(89)-B(90)
! JVS(122) = Jac_FULL(24,25)
  JVS(122) = -B(88)
! JVS(123) = Jac_FULL(24,27)
  JVS(123) = -B(86)
! JVS(124) = Jac_FULL(24,28)
  JVS(124) = B(80)+0.7*B(92)
! JVS(125) = Jac_FULL(24,29)
  JVS(125) = -B(84)
! JVS(126) = Jac_FULL(25,6)
  JVS(126) = B(30)+B(108)
! JVS(127) = Jac_FULL(25,15)
  JVS(127) = 0.333*B(111)
! JVS(128) = Jac_FULL(25,18)
  JVS(128) = B(43)
! JVS(129) = Jac_FULL(25,23)
  JVS(129) = -B(95)
! JVS(130) = Jac_FULL(25,24)
  JVS(130) = -B(87)
! JVS(131) = Jac_FULL(25,25)
  JVS(131) = -B(26)-B(28)-B(39)-B(88)-B(96)-B(106)-B(107)
! JVS(132) = Jac_FULL(25,26)
  JVS(132) = B(24)
! JVS(133) = Jac_FULL(25,27)
  JVS(133) = -B(27)
! JVS(134) = Jac_FULL(25,28)
  JVS(134) = B(44)
! JVS(135) = Jac_FULL(25,29)
  JVS(135) = -B(40)
! JVS(136) = Jac_FULL(25,30)
  JVS(136) = B(25)-B(29)
! JVS(137) = Jac_FULL(26,5)
  JVS(137) = B(3)
! JVS(138) = Jac_FULL(26,12)
  JVS(138) = 0
! JVS(139) = Jac_FULL(26,19)
  JVS(139) = 0
! JVS(140) = Jac_FULL(26,20)
  JVS(140) = -B(64)
! JVS(141) = Jac_FULL(26,21)
  JVS(141) = 0
! JVS(142) = Jac_FULL(26,22)
  JVS(142) = -B(50)
! JVS(143) = Jac_FULL(26,23)
  JVS(143) = 0
! JVS(144) = Jac_FULL(26,24)
  JVS(144) = 0
! JVS(145) = Jac_FULL(26,25)
  JVS(145) = 0
! JVS(146) = Jac_FULL(26,26)
  JVS(146) = -B(7)-B(11)-B(22)-B(24)-B(51)-B(65)-B(102)-B(103)
! JVS(147) = Jac_FULL(26,27)
  JVS(147) = -B(23)
! JVS(148) = Jac_FULL(26,28)
  JVS(148) = -B(8)
! JVS(149) = Jac_FULL(26,29)
  JVS(149) = -B(12)
! JVS(150) = Jac_FULL(26,30)
  JVS(150) = -B(25)
! JVS(151) = Jac_FULL(27,14)
  JVS(151) = B(69)
! JVS(152) = Jac_FULL(27,17)
  JVS(152) = B(109)
! JVS(153) = Jac_FULL(27,20)
  JVS(153) = 0
! JVS(154) = Jac_FULL(27,21)
  JVS(154) = B(67)+B(70)+B(71)+B(77)
! JVS(155) = Jac_FULL(27,22)
  JVS(155) = -B(56)-B(58)+B(62)
! JVS(156) = Jac_FULL(27,24)
  JVS(156) = -B(85)
! JVS(157) = Jac_FULL(27,25)
  JVS(157) = -B(26)+B(107)
! JVS(158) = Jac_FULL(27,26)
  JVS(158) = -B(22)
! JVS(159) = Jac_FULL(27,27)
  JVS(159) = -B(23)-B(27)-B(31)-B(33)-B(57)-B(59)-B(86)
! JVS(160) = Jac_FULL(27,28)
  JVS(160) = -B(32)+B(68)
! JVS(161) = Jac_FULL(27,29)
  JVS(161) = -B(34)
! JVS(162) = Jac_FULL(27,30)
  JVS(162) = B(63)+B(72)+B(105)
! JVS(163) = Jac_FULL(28,2)
  JVS(163) = -B(48)
! JVS(164) = Jac_FULL(28,3)
  JVS(164) = -B(79)
! JVS(165) = Jac_FULL(28,4)
  JVS(165) = -B(99)
! JVS(166) = Jac_FULL(28,8)
  JVS(166) = -B(18)+2*B(104)
! JVS(167) = Jac_FULL(28,9)
  JVS(167) = -B(9)
! JVS(168) = Jac_FULL(28,10)
  JVS(168) = -B(81)
! JVS(169) = Jac_FULL(28,11)
  JVS(169) = -B(97)
! JVS(170) = Jac_FULL(28,12)
  JVS(170) = 2*B(16)
! JVS(171) = Jac_FULL(28,13)
  JVS(171) = -B(75)
! JVS(172) = Jac_FULL(28,14)
  JVS(172) = -B(73)
! JVS(173) = Jac_FULL(28,15)
  JVS(173) = -B(46)+0.333*B(111)
! JVS(174) = Jac_FULL(28,16)
  JVS(174) = -0.7*B(91)+B(112)
! JVS(175) = Jac_FULL(28,17)
  JVS(175) = -B(41)+B(109)
! JVS(176) = Jac_FULL(28,18)
  JVS(176) = -B(43)+B(110)
! JVS(177) = Jac_FULL(28,19)
  JVS(177) = 2*B(17)
! JVS(178) = Jac_FULL(28,20)
  JVS(178) = 0
! JVS(179) = Jac_FULL(28,21)
  JVS(179) = -B(67)
! JVS(180) = Jac_FULL(28,22)
  JVS(180) = B(52)+B(56)
! JVS(181) = Jac_FULL(28,23)
  JVS(181) = -B(93)
! JVS(182) = Jac_FULL(28,24)
  JVS(182) = 0
! JVS(183) = Jac_FULL(28,25)
  JVS(183) = B(39)
! JVS(184) = Jac_FULL(28,26)
  JVS(184) = -B(7)+B(11)
! JVS(185) = Jac_FULL(28,27)
  JVS(185) = -B(31)+B(33)+B(57)
! JVS(186) = Jac_FULL(28,28)
  JVS(186) = -B(8)-B(10)-B(13)-B(19)-B(32)-B(35)-B(42)-B(44)-B(47)-B(49)-B(68)-B(74)-B(76)-B(80)-B(82)-0.7*B(92)-B(94)&
               &-B(98)-B(100)
! JVS(187) = Jac_FULL(28,29)
  JVS(187) = B(12)-B(14)+B(34)+B(40)+B(53)
! JVS(188) = Jac_FULL(28,30)
  JVS(188) = -B(36)
! JVS(189) = Jac_FULL(29,4)
  JVS(189) = B(99)
! JVS(190) = Jac_FULL(29,7)
  JVS(190) = B(5)
! JVS(191) = Jac_FULL(29,8)
  JVS(191) = B(18)
! JVS(192) = Jac_FULL(29,9)
  JVS(192) = 0
! JVS(193) = Jac_FULL(29,10)
  JVS(193) = B(81)
! JVS(194) = Jac_FULL(29,11)
  JVS(194) = 0
! JVS(195) = Jac_FULL(29,15)
  JVS(195) = B(45)+0.667*B(111)
! JVS(196) = Jac_FULL(29,16)
  JVS(196) = B(112)
! JVS(197) = Jac_FULL(29,21)
  JVS(197) = B(77)
! JVS(198) = Jac_FULL(29,22)
  JVS(198) = -B(52)-B(54)+B(56)
! JVS(199) = Jac_FULL(29,23)
  JVS(199) = B(93)+B(95)+B(114)
! JVS(200) = Jac_FULL(29,24)
  JVS(200) = -B(83)+B(85)+B(87)+B(89)
! JVS(201) = Jac_FULL(29,25)
  JVS(201) = -B(39)+B(88)+B(96)
! JVS(202) = Jac_FULL(29,26)
  JVS(202) = B(7)-B(11)
! JVS(203) = Jac_FULL(29,27)
  JVS(203) = -B(33)+B(57)+B(86)
! JVS(204) = Jac_FULL(29,28)
  JVS(204) = B(8)-B(13)+B(19)+B(82)+B(94)+B(100)
! JVS(205) = Jac_FULL(29,29)
  JVS(205) = -B(12)-B(14)-2*B(15)-B(34)-B(37)-B(40)-B(53)-B(55)-B(84)
! JVS(206) = Jac_FULL(29,30)
  JVS(206) = -B(38)
! JVS(207) = Jac_FULL(30,6)
  JVS(207) = B(30)+B(108)
! JVS(208) = Jac_FULL(30,15)
  JVS(208) = B(45)+B(46)+0.667*B(111)
! JVS(209) = Jac_FULL(30,17)
  JVS(209) = B(41)
! JVS(210) = Jac_FULL(30,18)
  JVS(210) = B(110)
! JVS(211) = Jac_FULL(30,21)
  JVS(211) = -B(71)
! JVS(212) = Jac_FULL(30,22)
  JVS(212) = -B(60)-B(62)
! JVS(213) = Jac_FULL(30,23)
  JVS(213) = 0
! JVS(214) = Jac_FULL(30,24)
  JVS(214) = B(85)+B(87)
! JVS(215) = Jac_FULL(30,25)
  JVS(215) = 2*B(26)-B(28)+B(39)+B(88)+B(106)
! JVS(216) = Jac_FULL(30,26)
  JVS(216) = B(22)-B(24)
! JVS(217) = Jac_FULL(30,27)
  JVS(217) = B(23)+2*B(27)+B(33)+B(86)
! JVS(218) = Jac_FULL(30,28)
  JVS(218) = -B(35)+B(42)+B(47)
! JVS(219) = Jac_FULL(30,29)
  JVS(219) = B(34)-B(37)+B(40)
! JVS(220) = Jac_FULL(30,30)
  JVS(220) = -B(25)-B(29)-B(36)-B(38)-B(61)-B(63)-B(72)-B(105)
      
END SUBROUTINE Jac_SP

! End of Jac_SP function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Jac_SP_Vec - function for sparse multiplication: sparse Jacobian times vector
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      UV        - User vector for variables
!      JUV       - Jacobian times user vector
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Jac_SP_Vec ( JVS, UV, JUV )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! UV - User vector for variables
  REAL(kind=dp) :: UV(NVAR)
! JUV - Jacobian times user vector
  REAL(kind=dp) :: JUV(NVAR)

  JUV(1) = JVS(1)*UV(1)+JVS(2)*UV(22)+JVS(3)*UV(30)
  JUV(2) = JVS(4)*UV(2)+JVS(5)*UV(28)
  JUV(3) = JVS(6)*UV(3)+JVS(7)*UV(28)
  JUV(4) = JVS(8)*UV(4)+JVS(9)*UV(28)
  JUV(5) = JVS(10)*UV(5)+JVS(11)*UV(12)+JVS(12)*UV(25)+JVS(13)*UV(26)+JVS(14)*UV(30)
  JUV(6) = JVS(15)*UV(6)+JVS(16)*UV(25)+JVS(17)*UV(30)
  JUV(7) = JVS(18)*UV(7)+JVS(19)*UV(9)+JVS(20)*UV(11)+JVS(21)*UV(23)+JVS(22)*UV(28)
  JUV(8) = JVS(23)*UV(8)+JVS(24)*UV(28)+JVS(25)*UV(29)
  JUV(9) = JVS(26)*UV(9)+JVS(27)*UV(23)+JVS(28)*UV(28)
  JUV(10) = JVS(29)*UV(10)+JVS(30)*UV(24)+JVS(31)*UV(28)
  JUV(11) = JVS(32)*UV(11)+JVS(33)*UV(23)+JVS(34)*UV(25)+JVS(35)*UV(28)
  JUV(12) = JVS(36)*UV(12)+JVS(37)*UV(19)+JVS(38)*UV(26)
  JUV(13) = JVS(39)*UV(13)+JVS(40)*UV(14)+JVS(41)*UV(21)+JVS(42)*UV(28)
  JUV(14) = JVS(43)*UV(13)+JVS(44)*UV(14)+JVS(45)*UV(20)+JVS(46)*UV(21)+JVS(47)*UV(28)
  JUV(15) = JVS(48)*UV(15)+JVS(49)*UV(28)+JVS(50)*UV(29)+JVS(51)*UV(30)
  JUV(16) = JVS(52)*UV(16)+JVS(53)*UV(24)+JVS(54)*UV(28)+JVS(55)*UV(29)
  JUV(17) = JVS(56)*UV(17)+JVS(57)*UV(21)+JVS(58)*UV(27)+JVS(59)*UV(28)+JVS(60)*UV(30)
  JUV(18) = JVS(61)*UV(18)+JVS(62)*UV(23)+JVS(63)*UV(25)+JVS(64)*UV(28)+JVS(65)*UV(30)
  JUV(19) = JVS(66)*UV(2)+JVS(67)*UV(3)+JVS(68)*UV(4)+JVS(69)*UV(8)+JVS(70)*UV(9)+JVS(71)*UV(12)+JVS(72)*UV(13)+JVS(73)&
              &*UV(14)+JVS(74)*UV(15)+JVS(75)*UV(16)+JVS(76)*UV(17)+JVS(77)*UV(18)+JVS(78)*UV(19)+JVS(80)*UV(21)+JVS(81)&
              &*UV(22)+JVS(82)*UV(23)+JVS(86)*UV(27)+JVS(87)*UV(28)+JVS(88)*UV(29)+JVS(89)*UV(30)
  JUV(20) = JVS(90)*UV(20)+JVS(91)*UV(22)+JVS(92)*UV(26)+JVS(93)*UV(29)+JVS(94)*UV(30)
  JUV(21) = JVS(95)*UV(14)+JVS(97)*UV(21)+JVS(98)*UV(22)+JVS(100)*UV(28)+JVS(101)*UV(29)+JVS(102)*UV(30)
  JUV(22) = JVS(103)*UV(2)+JVS(104)*UV(20)+JVS(105)*UV(22)+JVS(106)*UV(26)+JVS(107)*UV(27)+JVS(108)*UV(28)+JVS(109)&
              &*UV(29)+JVS(110)*UV(30)
  JUV(23) = JVS(111)*UV(10)+JVS(112)*UV(16)+JVS(113)*UV(23)+JVS(114)*UV(24)+JVS(115)*UV(25)+JVS(116)*UV(27)+JVS(117)&
              &*UV(28)
  JUV(24) = JVS(119)*UV(3)+JVS(120)*UV(16)+JVS(121)*UV(24)+JVS(122)*UV(25)+JVS(123)*UV(27)+JVS(124)*UV(28)+JVS(125)&
              &*UV(29)
  JUV(25) = JVS(126)*UV(6)+JVS(127)*UV(15)+JVS(128)*UV(18)+JVS(129)*UV(23)+JVS(130)*UV(24)+JVS(131)*UV(25)+JVS(132)&
              &*UV(26)+JVS(133)*UV(27)+JVS(134)*UV(28)+JVS(135)*UV(29)+JVS(136)*UV(30)
  JUV(26) = JVS(137)*UV(5)+JVS(140)*UV(20)+JVS(142)*UV(22)+JVS(146)*UV(26)+JVS(147)*UV(27)+JVS(148)*UV(28)+JVS(149)&
              &*UV(29)+JVS(150)*UV(30)
  JUV(27) = JVS(151)*UV(14)+JVS(152)*UV(17)+JVS(154)*UV(21)+JVS(155)*UV(22)+JVS(156)*UV(24)+JVS(157)*UV(25)+JVS(158)&
              &*UV(26)+JVS(159)*UV(27)+JVS(160)*UV(28)+JVS(161)*UV(29)+JVS(162)*UV(30)
  JUV(28) = JVS(163)*UV(2)+JVS(164)*UV(3)+JVS(165)*UV(4)+JVS(166)*UV(8)+JVS(167)*UV(9)+JVS(168)*UV(10)+JVS(169)*UV(11)&
              &+JVS(170)*UV(12)+JVS(171)*UV(13)+JVS(172)*UV(14)+JVS(173)*UV(15)+JVS(174)*UV(16)+JVS(175)*UV(17)+JVS(176)&
              &*UV(18)+JVS(177)*UV(19)+JVS(179)*UV(21)+JVS(180)*UV(22)+JVS(181)*UV(23)+JVS(183)*UV(25)+JVS(184)*UV(26)&
              &+JVS(185)*UV(27)+JVS(186)*UV(28)+JVS(187)*UV(29)+JVS(188)*UV(30)
  JUV(29) = JVS(189)*UV(4)+JVS(190)*UV(7)+JVS(191)*UV(8)+JVS(193)*UV(10)+JVS(195)*UV(15)+JVS(196)*UV(16)+JVS(197)*UV(21)&
              &+JVS(198)*UV(22)+JVS(199)*UV(23)+JVS(200)*UV(24)+JVS(201)*UV(25)+JVS(202)*UV(26)+JVS(203)*UV(27)+JVS(204)&
              &*UV(28)+JVS(205)*UV(29)+JVS(206)*UV(30)
  JUV(30) = JVS(207)*UV(6)+JVS(208)*UV(15)+JVS(209)*UV(17)+JVS(210)*UV(18)+JVS(211)*UV(21)+JVS(212)*UV(22)+JVS(214)&
              &*UV(24)+JVS(215)*UV(25)+JVS(216)*UV(26)+JVS(217)*UV(27)+JVS(218)*UV(28)+JVS(219)*UV(29)+JVS(220)*UV(30)
      
END SUBROUTINE Jac_SP_Vec

! End of Jac_SP_Vec function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! JacTR_SP_Vec - sparse multiplication: sparse Jacobian transposed times vector
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      UV        - User vector for variables
!      JTUV      - Jacobian transposed times user vector
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE JacTR_SP_Vec ( JVS, UV, JTUV )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! UV - User vector for variables
  REAL(kind=dp) :: UV(NVAR)
! JTUV - Jacobian transposed times user vector
  REAL(kind=dp) :: JTUV(NVAR)

  JTUV(1) = JVS(1)*UV(1)
  JTUV(2) = JVS(4)*UV(2)+JVS(66)*UV(19)+JVS(103)*UV(22)+JVS(163)*UV(28)
  JTUV(3) = JVS(6)*UV(3)+JVS(67)*UV(19)+JVS(119)*UV(24)+JVS(164)*UV(28)
  JTUV(4) = JVS(8)*UV(4)+JVS(68)*UV(19)+JVS(165)*UV(28)+JVS(189)*UV(29)
  JTUV(5) = JVS(10)*UV(5)+JVS(137)*UV(26)
  JTUV(6) = JVS(15)*UV(6)+JVS(126)*UV(25)+JVS(207)*UV(30)
  JTUV(7) = JVS(18)*UV(7)+JVS(190)*UV(29)
  JTUV(8) = JVS(23)*UV(8)+JVS(69)*UV(19)+JVS(166)*UV(28)+JVS(191)*UV(29)
  JTUV(9) = JVS(19)*UV(7)+JVS(26)*UV(9)+JVS(70)*UV(19)+JVS(167)*UV(28)
  JTUV(10) = JVS(29)*UV(10)+JVS(111)*UV(23)+JVS(168)*UV(28)+JVS(193)*UV(29)
  JTUV(11) = JVS(20)*UV(7)+JVS(32)*UV(11)+JVS(169)*UV(28)
  JTUV(12) = JVS(11)*UV(5)+JVS(36)*UV(12)+JVS(71)*UV(19)+JVS(170)*UV(28)
  JTUV(13) = JVS(39)*UV(13)+JVS(43)*UV(14)+JVS(72)*UV(19)+JVS(171)*UV(28)
  JTUV(14) = JVS(40)*UV(13)+JVS(44)*UV(14)+JVS(73)*UV(19)+JVS(95)*UV(21)+JVS(151)*UV(27)+JVS(172)*UV(28)
  JTUV(15) = JVS(48)*UV(15)+JVS(74)*UV(19)+JVS(127)*UV(25)+JVS(173)*UV(28)+JVS(195)*UV(29)+JVS(208)*UV(30)
  JTUV(16) = JVS(52)*UV(16)+JVS(75)*UV(19)+JVS(112)*UV(23)+JVS(120)*UV(24)+JVS(174)*UV(28)+JVS(196)*UV(29)
  JTUV(17) = JVS(56)*UV(17)+JVS(76)*UV(19)+JVS(152)*UV(27)+JVS(175)*UV(28)+JVS(209)*UV(30)
  JTUV(18) = JVS(61)*UV(18)+JVS(77)*UV(19)+JVS(128)*UV(25)+JVS(176)*UV(28)+JVS(210)*UV(30)
  JTUV(19) = JVS(37)*UV(12)+JVS(78)*UV(19)+JVS(177)*UV(28)
  JTUV(20) = JVS(45)*UV(14)+JVS(90)*UV(20)+JVS(104)*UV(22)+JVS(140)*UV(26)
  JTUV(21) = JVS(41)*UV(13)+JVS(46)*UV(14)+JVS(57)*UV(17)+JVS(80)*UV(19)+JVS(97)*UV(21)+JVS(154)*UV(27)+JVS(179)*UV(28)&
               &+JVS(197)*UV(29)+JVS(211)*UV(30)
  JTUV(22) = JVS(2)*UV(1)+JVS(81)*UV(19)+JVS(91)*UV(20)+JVS(98)*UV(21)+JVS(105)*UV(22)+JVS(142)*UV(26)+JVS(155)*UV(27)&
               &+JVS(180)*UV(28)+JVS(198)*UV(29)+JVS(212)*UV(30)
  JTUV(23) = JVS(21)*UV(7)+JVS(27)*UV(9)+JVS(33)*UV(11)+JVS(62)*UV(18)+JVS(82)*UV(19)+JVS(113)*UV(23)+JVS(129)*UV(25)&
               &+JVS(181)*UV(28)+JVS(199)*UV(29)
  JTUV(24) = JVS(30)*UV(10)+JVS(53)*UV(16)+JVS(114)*UV(23)+JVS(121)*UV(24)+JVS(130)*UV(25)+JVS(156)*UV(27)+JVS(200)&
               &*UV(29)+JVS(214)*UV(30)
  JTUV(25) = JVS(12)*UV(5)+JVS(16)*UV(6)+JVS(34)*UV(11)+JVS(63)*UV(18)+JVS(115)*UV(23)+JVS(122)*UV(24)+JVS(131)*UV(25)&
               &+JVS(157)*UV(27)+JVS(183)*UV(28)+JVS(201)*UV(29)+JVS(215)*UV(30)
  JTUV(26) = JVS(13)*UV(5)+JVS(38)*UV(12)+JVS(92)*UV(20)+JVS(106)*UV(22)+JVS(132)*UV(25)+JVS(146)*UV(26)+JVS(158)*UV(27)&
               &+JVS(184)*UV(28)+JVS(202)*UV(29)+JVS(216)*UV(30)
  JTUV(27) = JVS(58)*UV(17)+JVS(86)*UV(19)+JVS(107)*UV(22)+JVS(116)*UV(23)+JVS(123)*UV(24)+JVS(133)*UV(25)+JVS(147)&
               &*UV(26)+JVS(159)*UV(27)+JVS(185)*UV(28)+JVS(203)*UV(29)+JVS(217)*UV(30)
  JTUV(28) = JVS(5)*UV(2)+JVS(7)*UV(3)+JVS(9)*UV(4)+JVS(22)*UV(7)+JVS(24)*UV(8)+JVS(28)*UV(9)+JVS(31)*UV(10)+JVS(35)&
               &*UV(11)+JVS(42)*UV(13)+JVS(47)*UV(14)+JVS(49)*UV(15)+JVS(54)*UV(16)+JVS(59)*UV(17)+JVS(64)*UV(18)+JVS(87)&
               &*UV(19)+JVS(100)*UV(21)+JVS(108)*UV(22)+JVS(117)*UV(23)+JVS(124)*UV(24)+JVS(134)*UV(25)+JVS(148)*UV(26)&
               &+JVS(160)*UV(27)+JVS(186)*UV(28)+JVS(204)*UV(29)+JVS(218)*UV(30)
  JTUV(29) = JVS(25)*UV(8)+JVS(50)*UV(15)+JVS(55)*UV(16)+JVS(88)*UV(19)+JVS(93)*UV(20)+JVS(101)*UV(21)+JVS(109)*UV(22)&
               &+JVS(125)*UV(24)+JVS(135)*UV(25)+JVS(149)*UV(26)+JVS(161)*UV(27)+JVS(187)*UV(28)+JVS(205)*UV(29)+JVS(219)&
               &*UV(30)
  JTUV(30) = JVS(3)*UV(1)+JVS(14)*UV(5)+JVS(17)*UV(6)+JVS(51)*UV(15)+JVS(60)*UV(17)+JVS(65)*UV(18)+JVS(89)*UV(19)&
               &+JVS(94)*UV(20)+JVS(102)*UV(21)+JVS(110)*UV(22)+JVS(136)*UV(25)+JVS(150)*UV(26)+JVS(162)*UV(27)+JVS(188)&
               &*UV(28)+JVS(206)*UV(29)+JVS(220)*UV(30)
      
END SUBROUTINE JacTR_SP_Vec

! End of JacTR_SP_Vec function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE messy_mecca_kpp_Jacobian

