Module Qtcmpar
  !
  ! QTCM mode parameter, generated by par.F90
  !
  Integer, Parameter  ::  &
       &       nvmod  =   2  & !  no. v-modes
       &     , nTmod  =   1  & !  no. T-modes
       &     , nz     =  14!  V1z table size
  REAL, Parameter     ::  &
       &       a1hat    = 0.45934832      & ! hat{a_1}   [-] NZ (3.2)
       &     , a1phat   = 0.24527773      & ! hat{a_1^+} [-] NZ (2.16), (3.9)
       &     , a1s      = 0.30203983      & ! a_{1s})    [-] NZ (5.16)
       &     , V1s      = -.24527773      & ! V_{1s}     [-] NZ (4.13)
       &     , V1sqhat  = 0.39477620E-01  & ! hat{V_1^2} [-] NZ (4.13)
       &     , b1hat    = 0.31574178      & ! hat{b_1}   [-] NZ (5.17)
       &     , b1s      =  1.0000000      & ! b_{1s}     [-] NZ (4.32)
       &     , bb1hat   = 0.37340331      & ! hat{B_1}   [-] NZ (4.26)
       &     , GMsr     =  3.5999999      & ! M_{sr}     [K] NZ (4.17)
       &     , GMsp     = 0.42701162E-01  & ! M_{sp}     [-] NZ (4.18)
       &     , GMqr     =  3.0000000      & ! M_{qr}     [K] NZ (5.10)
       &     , GMqp     = 0.50709546E-01  & ! M_{qp}     [-] NZ (5.10)
       &     , eps_c    = 0.13888889E-03  & ! 1/tau_c [1/s] NZ (5.7)
       &     , eps_i1   = 0.89938197E-06  & ! Mode 1 z-diffusion time [1/s]=>  13.    [day]
       &     , Tsref    =  302.26001      & ! ref. Ts for radiation [K]
       &     , Cpg      =  8708163.0      & ! Cp*delp/gravity [J/K/m*2]
       &     , Trefs    =  302.00000      & ! surface Tref [K]
       &     , qrefs    =  51.955288      & ! surface qref [K]
       &     , Tcrefs   =  302.00000      & ! convect. surface Tref [K]
       &     , qcrefs   =  50.814919      & ! convect. surface qref [K]
       &     , Trefhat  =  267.77045      & ! mean ref. temperature [K]
       &     , qrefhat  =  16.404453      & ! mean ref. humidity [K]
       &     , Tcrefhat =  268.98318      & ! convect. mean ref. temp. [K]
       &     , qcrefhat =  16.159273        ! convect. mean ref. humidity [K]
  !
  ! advection coefficients
  !
  REAL, Parameter, Dimension(nvmod**3) ::  &
       &    Vijkt = (/   1.0000000    , 0.0000000       & ! Vijk(:,0,0)
       &              ,  0.0000000    ,0.39477620E-01   & ! Vijk(:,1,0)
       &              ,  0.0000000    , 1.0000000       & ! Vijk(:,0,1)
       &              ,  1.0000000    ,0.11037793    /) & ! Vijk(:,1,1)
       &  , Vwijkt = (/   0.0000000    , 0.0000000      & ! Vwijk(:,0,0)
       &             , 0.24527763    ,0.39408989E-01    & ! Vwijk(:,1,0)
       &             ,  0.0000000    , 0.0000000        & ! Vwijk(:,0,1)
       &             , -.26465219    ,0.54747105E-01/)    ! Vwijk(:,1,1)

  REAL, parameter, dimension(nvmod*nTmod**2) ::  &
       &    DTijkt = (/   1.0000000    ,0.68389595E-01  /)  & ! DTijk(:,1,1)
       &  , Dqijkt = (/   1.0000000    ,-.16060449      /)    ! Dqijk(:,1,1)
  !
  ! Table of V1(z) profile
  !
  REAL, Parameter, Dimension(2*nz) ::  V1z1d= &
       &(/&!    z [m]     ,     V1 [-]
       &     0.0000000    , -.24527773    ,   &
       &     200.00000    , -.23844716    ,   &
       &     400.00000    , -.23163342    ,   &
       &     600.00000    , -.22483708    ,   &
       &     800.00000    , -.21805863    ,   &
       &     1000.0000    , -.21128868    ,   &
       &     2000.0000    , -.17567538    ,   &
       &     3000.0000    , -.13634732    ,   &
       &     4000.0000    , -.92545077E-01,   &
       &     5000.0000    , -.43332372E-01,   &
       &     6000.0000    , 0.12398618E-01,   &
       &     7000.0000    , 0.76425947E-01,   &
       &     8000.0000    , 0.15042150    ,   &
       &     9000.0000    , 0.23544320        /)
#ifdef TOPO
  ! Old V1(z) profile array; still used for topographic lifting
  REAL, Parameter, Dimension(nz) ::  &
       & V1z = (/ -.24527773    , -.23844716    , -.23163342    , -.22483708     &
       & , -.21805863    , -.21128868    , -.17567538    , -.13634732       &
       & , -.92545077E-01, -.43332372E-01, 0.12398618E-01, 0.76425947E-01   &
       & , 0.15042150    , 0.23544320     /)
#endif
End Module Qtcmpar

Module T1cTableIn
  ! Profile for nonlinear T1c lookup table
  Integer, Parameter :: np=11
  REAL, Parameter, Dimension(4*np) ::  table= &
       &(/&!  p [HPa]     ,  alpha [-]    ,  Tsat [K]    ,  a1 [-] 
       &     1000.0000    , 0.85000002    , 302.00000    ,0.30203983    ,   &
       &     950.00000    , 0.83529413    , 297.64838    ,0.29764509    ,   &
       &     900.00000    , 0.82058823    , 293.08527    ,0.29308203    ,   &
       &     850.00000    , 0.80588239    , 291.01846    ,0.30323407    ,   &
       &     800.00000    , 0.79117650    , 288.79773    ,0.31495297    ,   &
       &     700.00000    , 0.76176476    , 283.78235    ,0.34451482    ,   &
       &     600.00000    , 0.73235297    , 277.72491    ,0.38630155    ,   &
       &     500.00000    , 0.70294118    , 270.06317    ,0.44864291    ,   &
       &     400.00000    , 0.67352945    , 259.69208    ,0.54513770    ,   &
       &     300.00000    , 0.64411765    , 244.30972    ,0.67801291    ,   &
       &     200.00000    , 0.61470592    , 219.90630    ,0.74564552        /)
End Module T1cTableIn
                                                      
            !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            !! Things useful but not used in the model !!
            !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!  a1phatb  = 0.15479809E-01 & ! ave. of {a_1^+} over subcloud layer
!!  GMs0r    =  44.398193     & ! include divergence due to topo. lifting [K] 
!!  GMq0r    = -51.881905     & ! include divergence due to topo. lifting [K] 
!!  CV0      = 0.14000000E-01  & !  ref. drag coeff*velocity [m/s]
!!  eps_0    = 0.19369413E-05 & ! [1/s]=>  6.0    [day]
!!  eps_10   = -.47508857E-06 & ! [1/s]=> -24.    [day]
!!  eps_01   = -.12034377E-04 & ! [1/s]=>-0.96    [day]
!!  eps_1    = 0.29517646E-05 & ! [1/s]=>  3.9    [day]
!!  a1p  at 1000, 950, 900, 850, 800 mb
!!  REAL, Parameter, Dimension(5) ::  & 
!!  & a1p = (/  0.0000000    , 0.15066436E-01, 0.31023277E-01   &
!!  &, 0.48029605E-01, 0.66726476E-01 /)
