﻿'Class and dll for interacting with the GOTM module via Python
'Interfaces are as follows'
'Construct class
'Initialise() - things to initialise after construction
'Load() - request to load external Model
'Edit() - request to edit external model
'Run() - request to run external model
'Reset() - request to reset external model
'CleanUp() - Cleanup and closedown external model
'TimeDate() - getTime date Information

'Callbacks
'Set status() - update status information
'Progress() - give progress information
'Message() - Send message to console
Imports Python.Runtime
Imports Microsoft.Win32
Imports Couplerlib


Public Class GOTMInterface
    Inherits PluginExtenderBase.PluginExtenderBase
    Dim dispform As GOTMserve.ERSEM1D2Way
    Public Pycallback As Python.Runtime.PyObject
    Private threadstate As IntPtr
    Private scenario, result, netcdfmodule As PyObject
    Public cp As CCouplerlib
    Dim cpool, npool, ppool, cflux, nflux, pflux, spool, sflux As Double
    Dim isthreed As Boolean
    Friend contform As ScientificInterface.FormGotmPluggin
    Dim alongitude, alatitude, azed As Double()
    Private slabsize As Integer
    Private biotext As String
    Private TestDataPath As String

    Public Sub New(ByVal icontform As ScientificInterface.FormGotmPluggin)
        contform = icontform
    End Sub


    Public Overrides Sub Load(ByVal regkey1 As RegistryKey, ByVal iTestDataPath As String, ByVal xmlfile As String, ByRef cci As CCouplerlib, ByVal itimebase As Double)
        Dim novars As Integer
        Dim gotmdir, gotmpydir As String
        Dim regkey2 As RegistryKey
        Dim datapath, py2path, svtemp As String
        Dim nototdataelements As Integer
        'Dim svnames As List(Of String)
        'Dim svvalues As List(Of String)
        Dim lock As System.IntPtr
        Dim rt As Integer
        TestDataPath = iTestDataPath
        cp = cci
        PythonEngine.Initialize()
        threadstate = PythonEngine.BeginAllowThreads()
        lock = PythonEngine.AcquireLock()

        Dim sysmodule As PyObject, pyresult As PyObject
        sysmodule = PythonEngine.ImportModule("sys")
        Try
            regkey2 = regkey1.OpenSubKey("GOTMSERVER", True)
            If (regkey2 Is Nothing) Then
                Throw New ApplicationException()
            End If
        Catch
            regkey1.CreateSubKey("GOTMSERVER")
            regkey2 = regkey1.OpenSubKey("GOTMSERVER", True)
        End Try
        Try
            gotmdir = regkey2.GetValue("GOTMDIR").ToString()
        Catch
            regkey2.SetValue("GOTMDIR", "E:/Ecopath6/OCEANCERTAIN")
            gotmdir = regkey2.GetValue("GOTMDIR").ToString()
        End Try
        Try
            gotmpydir = regkey2.GetValue("GOTMPYDIR").ToString()
        Catch
            regkey2.SetValue("GOTMPYDIR", "E:/GOTM")
            gotmpydir = regkey2.GetValue("GOTMPYDIR").ToString()
        End Try
        pyresult = sysmodule.GetAttr("path").InvokeMethod("append", New PyString(gotmpydir + "\gui.py"))
        'System.Environment.SetEnvironmentVariable("PATH", System.Environment.GetEnvironmentVariable("PATH") + ";" + System.Environment.GetEnvironmentVariable("GOTMDIR") + "\gui.py")
        System.Environment.SetEnvironmentVariable("PATH", System.Environment.GetEnvironmentVariable("PATH") + ";" + gotmpydir + "\gui.py")
        'System.Environment.SetEnvironmentVariable("PATH", System.Environment.GetEnvironmentVariable("PATH") + ";" + "C:\Python27\DLLs")
        System.Environment.SetEnvironmentVariable("PATH", System.Environment.GetEnvironmentVariable("PATH")) ' + ";" + gotmpydir + " C:\Python27\DLLs")
        svtemp = System.Environment.GetEnvironmentVariable("PATH")
        Dim corescenario As PyObject
        corescenario = PythonEngine.ImportModule("core.scenario")
        corescenario.SetAttr("schemadir", New PyString(gotmpydir + "\gui.py\Schemas\scenario"))
        Me.scenario = corescenario.GetAttr("Scenario").InvokeMethod("fromSchemaName", New PyString("gotmgui-0.5.0"))
        Me.scenario.InvokeMethod("loadAll", New PyString(TestDataPath + "\test.gotmscenario"))
        Dim scenariobuilder, newscenario As PyObject
        scenariobuilder = PythonEngine.ImportModule("scenariobuilder")
        newscenario = scenariobuilder.InvokeMethod("loadScenario")
        netcdfmodule = PythonEngine.ImportModule("NetCDF")
        REM If the user cancelled loading a new scenario, just keep the old one.
        If (newscenario.IsTrue()) Then
            scenario = newscenario
        End If
        corescenario.Dispose()
        PythonEngine.ReleaseLock(lock)


    End Sub

    Public Overrides Sub edit(ByVal carryoutedit As Boolean, ByVal timerratio As Integer, ByVal spinupdays As Integer, ByRef specification As Xml.XmlDocument, ByRef cpp As CCouplerlib)
        Dim lock As IntPtr
        Dim scenariobuilder As PyObject
        Dim dt As Double
        Dim dstart, dend As Double
        Dim pydt, pyst, pyend, pyastart, pyaend As PyObject
        Dim dsstart, dsend As String
        lock = PythonEngine.AcquireLock()
        If carryoutedit Then
            scenariobuilder = PythonEngine.ImportModule("scenariobuilder")
            scenariobuilder.InvokeMethod("editScenario", scenario)
        End If
        REM Determine the number of GOTM time steps in a month.
        pydt = scenario("timeintegration/dt").InvokeMethod("getValue").InvokeMethod("getAsSeconds")
        pyst = scenario("time/start").InvokeMethod("getValue").InvokeMethod("toordinal")
        pyend = scenario("time/stop").InvokeMethod("getValue").InvokeMethod("toordinal")
        pyastart = scenario("time/start").InvokeMethod("getValue").InvokeMethod("isoformat")
        pyaend = scenario("time/stop").InvokeMethod("getValue").InvokeMethod("isoformat")
        dt = Convert.ToDouble(pydt.AsManagedObject(Type.GetType("System.Double")))
        dstart = Convert.ToDouble(pyst.AsManagedObject(Type.GetType("System.Double")))
        dend = Convert.ToDouble(pyend.AsManagedObject(Type.GetType("System.Double")))
        dsstart = pyastart.ToString() 'Convert.ToString(pyastart.AsManagedObject(Type.GetType("System.String")))
        dsend = pyaend.ToString() 'Convert.ToString(pyaend.AsManagedObject(Type.GetType("System.String")))
        slabsize = contform.setstep(Int(dend - dstart), dt, timerratio, False, 0, "host")
        contform.TimeSpecify("GOTMtemplate.xml", dsstart, dsend, Int(dt))
        PythonEngine.ReleaseLock(lock)

    End Sub




    Public Overrides Sub simulate(ByVal extfilename As String, ByVal EwEGOTMTimeRatio As Integer, ByVal spinupdays As Integer, ByRef specification As Xml.XmlDocument, ByVal iusespatial As Boolean)
        Dim names, units, abbrev, names2, units2, abbrev2 As String()
        Dim isok As Boolean
        Dim interleave As Integer
        Dim eisended As Boolean
        Dim hasmore, canrun, usespatial As Boolean
        Dim realdays, extraday As Double
        Dim simulator, simulatorobject As PyObject
        Dim bioinfo As PyTuple
        Dim biocut As PyObject
        Dim lock As System.IntPtr
        Dim Pelflag, benflag As PyInt
        Dim bstart, bensplit As Integer
        Dim nobenthic, nopelagic As Integer
        Dim nodims, novars, olength As Integer
        Dim biovals, biovalsben As PyObject
        Dim nodataelements, nototdataelements, nospatialelements As Integer
        Dim vals, benvals, oldvals As Double()
        Dim avals, abenvals, aoldvals As Double()()
        Dim linkn, linkp, links, isc, isorg As Integer()
        Dim ncratio, pcratio, scratio, pextran, pextrap, pextras, adjn, adjp, adjs, cadj As Double
        Dim depth, dp, adjpool, adjmult, temperature, salinity As Double
        Dim adepth, adp, aadjpool, aadjmult, atemperature, asalinity As Double()
        Dim lmname As String
        Dim d As Integer()
        Dim curtime, timebase As Double
        Dim nprogress, novals As Integer
        usespatial = iusespatial
        lock = PythonEngine.AcquireLock()




        REM  Create the simulator in Python.
        'a = PythonEngine.RunSimpleString("import os")
        'a = PythonEngine.RunSimpleString("os.chdir(""c:\\ewecefas\\gotm\\gui.py"")")
        'a = PythonEngine.RunSimpleString("import simulator")
        simulatorobject = PythonEngine.ImportModule("core.simulator")
        simulator = simulatorobject.InvokeMethod("Simulator", scenario)

        REM At this point GOTM has initialized and everything is known, including the names, units etc.
        REM  of the biological
        REM String xml = scenario.InvokeMethod("describe")
        'itest = simulator.InvokeMethod("getBioVariableInfo").AsManagedObject(Type.GetType("System.Integer"))
        bioinfo = New PyTuple(simulator.InvokeMethod("getBioVariableInfo"))
        ReDim abbrev(bioinfo(0).Length())
        ReDim names(bioinfo(1).Length())
        ReDim units(bioinfo(2).Length())
        For i = 0 To bioinfo(0).Length() - 1
            abbrev(i) = bioinfo(0).Item(i).ToString
            names(i) = bioinfo(1).Item(i).ToString
            units(i) = bioinfo(2).Item(i).ToString
            If abbrev(i) = "Y1c" Then bstart = i
        Next
        'abbrev(0) = biocut.ToString()
        'abbrev = DirectCast(bioinfo(0).AsManagedObject(Type.GetType("System.String[]")), String())
        'names = DirectCast(bioinfo(1).AsManagedObject(Type.GetType("System.String[]")), String())
        'units = DirectCast(bioinfo(2).AsManagedObject(Type.GetType("System.String[]")), String())
        'For i = 0 To abbrev.Length - 1
        'If abbrev(i) = "Y1c" Then bstart = i
        'Next
        nototdataelements = 172

        adjpool = 1.0
        REM nodataelements = DirectCast(bioinfo(3).AsManagedObject(Type.GetType("System.Integer")), Int32)

        npool = 0.0
        cpool = 0.0

        ppool = 0.0
        spool = 0.0
        Pelflag = New PyInt(1)
        benflag = New PyInt(0)
        biovals = simulator.InvokeMethod("getBioValues", Pelflag)
        biovalsben = simulator.InvokeMethod("getBioValues", benflag)
        vals = biovals.AsManagedObject(Type.GetType("System.Double[]"))
        benvals = biovalsben.AsManagedObject(Type.GetType("System.Double[]"))
        For i = 0 To benvals.Length
            abbrev(i + vals.Length) = abbrev(bstart + i)
            names(i + vals.Length) = names(bstart + i)
            units(i + vals.Length) = units(bstart + i)
        Next
        nodataelements = vals.Length
        nototdataelements += benvals.Length + 3
        ReDim Preserve abbrev(nototdataelements)
        ReDim Preserve names(nototdataelements)
        ReDim Preserve units(nototdataelements)
        ReDim linkn(nototdataelements)
        ReDim linkp(nototdataelements)
        ReDim links(nototdataelements)
        ReDim isc(nototdataelements)
        ReDim isorg(nototdataelements)
        ReDim d(nototdataelements)
        abbrev(nodataelements - 3) = "ETW"
        names(nodataelements - 3) = "Temperature"
        units(nodataelements - 3) = "C"
        cp.GetIndex(0, nodataelements - 3, "SST")
        abbrev(nodataelements - 2) = "ESW"
        names(nodataelements - 2) = "Salinity"
        units(nodataelements - 2) = "psu"
        cp.GetIndex(0, nodataelements - 2, "SSS")
        abbrev(nodataelements - 1) = "SDD"
        names(nodataelements - 1) = "Depth"
        units(nodataelements - 1) = "m"
        cp.GetIndex(0, nodataelements - 1, "bathy")
        abbrev(nodataelements) = "NUL"
        names(nodataelements) = "NULL"
        units(nodataelements) = "0"
        REM this is strictly speaking a GOTM call and so goes in this file
        lmname = specifyGOTMXML(TestDataPath, specification, names, units, abbrev, linkn, linkp, links, isc, isorg, isthreed, iusespatial)
        Dim compnames() As String = {"z", "lon", "lat", "n_faces", "n_zfaces"}
        Dim comptypes() As Integer = {4, 3, 3, 2, 2}
        Dim comdims() As Integer = {2, 0, 1, -1, -1}
        contform.plugin.GOTMstat = 1 'Ready to go
        hasmore = True
        canrun = contform.Starting(lmname, False, curtime)
        If usespatial Then
            cp.SetCompressions(5, compnames, comptypes, comdims)
            ReDim avals(nodataelements)
            ReDim abenvals(nototdataelements - nodataelements)
        Else
            ReDim vals(nodataelements)
            ReDim benvals(nototdataelements - nodataelements)
        End If
        If (canrun) Then
            curtime = cp.GetStartTime(0)
            interleave = 0
            realdays = 0.0
            While hasmore
                hasmore = simulator.InvokeMethod("runSlab", New PyInt(slabsize)).IsTrue()
            If (hasmore = False) Then
                Dim ad As Integer = 1
            End If
            If (eisended And ((interleave Mod EwEGOTMTimeRatio) = 0)) Then
                hasmore = False
            End If
                nprogress = simulator.InvokeMethod("getProgress").AsManagedObject(Type.GetType("System.Single"))
                depth = simulator.InvokeMethod("getDepth").AsManagedObject(Type.GetType("System.Double"))
                temperature = simulator.InvokeMethod("getTemperature").AsManagedObject(Type.GetType("System.Double"))
                salinity = simulator.InvokeMethod("getSalinity").AsManagedObject(Type.GetType("System.Double"))
                REM Get a string describing the current depth-integrated bio values.
                biovals = simulator.InvokeMethod("getBioValues", Pelflag)
                biovalsben = simulator.InvokeMethod("getBioValues", benflag)
                vals = biovals.AsManagedObject(Type.GetType("System.Double[]"))
                bensplit = vals.Length
                benvals = biovalsben.AsManagedObject(Type.GetType("System.Double[]"))
                nodataelements = bensplit + benvals.Length
                If (usespatial) Then
                    ReDim Preserve avals(nodataelements + 2)
                    'ReDim Preserve aoldvals(nodataelements + 2)
                    avals(nodataelements - 3) = atemperature
                    avals(nodataelements - 2) = asalinity
                    avals(nodataelements - 1) = adepth
                    For i = bensplit To avals.Length - 4
                        avals(i) = abenvals(i - bensplit)
                    Next


                    '                    Next
                Else
                    ReDim Preserve vals(nodataelements + 2)
                    ReDim Preserve oldvals(nodataelements + 2)
                    For i = bensplit To vals.Length - 4
                        vals(i) = benvals(i - bensplit)
                    Next
                    vals(nodataelements - 3) = temperature
                    vals(nodataelements - 2) = salinity
                    vals(nodataelements - 1) = depth


                End If


                If (((interleave Mod EwEGOTMTimeRatio) = 0) And (interleave >= spinupdays) And (extraday < 1)) Or (Not hasmore) Then
                    If usespatial Then
                        contform.Postvaluesa(avals, nodataelements, nospatialelements)
                    Else
                        contform.postvalues(vals, nodataelements)
                    End If
                    biotext = ""
                    Dim vtot As Single
                    Dim vcount As Single
                    If (usespatial) Then
                        For i As Integer = 0 To avals.Length - 4
                            vtot = 0.0
                            vcount = 0.0
                            For j As Integer = 0 To nospatialelements - 1
                                If adepth(j) > 0 Then
                                    vtot += avals(i)(j)
                                    vcount += 1.0
                                End If
                            Next
                            biotext = biotext + names(i) + " = " + (vtot / vcount).ToString() + " " + units(i) + vbCrLf
                        Next

                    Else
                        For i As Integer = 0 To vals.Length - 3
                            biotext = biotext + names(i) + " = " + vals(i).ToString() + " " + units(i) + vbCrLf
                        Next

                    End If
                    Dim newvals As Double()
                    Dim anewvals As Double()()
                    Dim valarray As Double()
                    If usespatial Then
                        anewvals = avals
                    Else
                        newvals = vals
                    End If
                    If (usespatial) Then
                        ReDim aoldvals(avals.Length - 1)
                        For i = 0 To avals.Length - 4
                            ReDim aoldvals(i)(nospatialelements)
                            For n = 0 To nospatialelements - 1
                                aoldvals(i)(n) = avals(i)(n)
                            Next n
                        Next i


                    Else
                        For i = 0 To vals.Length - 1
                            oldvals(i) = vals(i)
                        Next i

                    End If

                    eisended = contform.plugin.runstep()
                    olength = contform.getvalues(newvals)
                    If extraday = 1 Then

                    End If

                    If (interleave >= spinupdays) Then
                        If extraday < 1 Then
                            realdays += 365.25 / 360.0
                        End If
                        If ((interleave Mod EwEGOTMTimeRatio) = 0) Then


                            d = contform.orgrefs(olength)
                            novals = oldvals.Length
                            For j = 0 To olength - 1


                                If isorg(d(j)) = 1 Then
                                    adjmult = adjpool
                                Else
                                    adjmult = 1.0
                                End If
                                If (newvals(j) < 0) Then
                                    'vals(d(j)) *=(1-newvals(j))
                                Else
                                    'vals(d(j)) *=(1-newvals(j))

                                End If
                                If (newvals(j) < 0.0) Then
                                    '  d(j) = -1
                                End If
                                REM newvals(j) = vals(j)

                            Next
                            cflux = nflux = pflux = 0.0
                            For j = 0 To -1 'oldvals.Length - 4
                                If j > bensplit Then
                                    dp = 1.0
                                Else
                                    dp = depth
                                End If
                                If (isc(j) = 1) Then
                                    cpool -= dp * (newvals(j) - oldvals(j))
                                    cflux += Math.Abs(dp * (newvals(j) - oldvals(j)))
                                    If (linkn(j) > -1) Then
                                        npool -= dp * (newvals(linkn(j)) - oldvals(linkn(j)))
                                        nflux += Math.Abs(dp * (newvals(linkn(j)) - oldvals(linkn(j))))
                                    End If
                                    If (linkp(j) > -1) Then
                                        ppool -= dp * (newvals(linkp(j)) - oldvals(linkp(j)))
                                        pflux += Math.Abs(dp * (newvals(linkp(j)) - oldvals(linkp(j))))
                                    End If
                                    If (links(j) > -1) Then
                                        spool -= dp * (newvals(links(j)) - oldvals(links(j)))
                                        sflux += Math.Abs(dp * (newvals(links(j)) - oldvals(links(j))))
                                    End If
                                End If
                            Next
                            ncratio = 0.015
                            pcratio = 0.00167
                            scratio = 0.00167
                            pextran = npool - cpool * ncratio
                            pextrap = ppool - cpool * pcratio
                            pextras = spool - cpool * scratio
                            Dim adjntot As Double = 0.0
                            For j = 0 To -1 'oldvals.Length - 4
                                If j > bensplit Then
                                    dp = 1.0
                                Else
                                    dp = depth
                                End If
                                If (isc(j) = 1) Then
                                    If (linkn(j) > -1) And (isorg(j) = 1) Then
                                        adjn = pextran * Math.Abs(dp * (newvals(linkn(j)) - oldvals(linkn(j)))) / nflux
                                        newvals(linkn(j)) += adjn / dp
                                        npool -= adjn
                                        adjntot += adjn
                                    End If
                                    If (linkp(j) > -1) And (isorg(j) = 1) Then
                                        adjp = pextrap * Math.Abs(dp * (newvals(linkp(j)) - oldvals(linkp(j)))) / pflux
                                        newvals(linkp(j)) += adjp / dp
                                        ppool -= adjp
                                    End If
                                    If (links(j) > -1) And (isorg(j) = 1) Then
                                        adjs = pextras * Math.Abs(dp * (newvals(links(j)) - oldvals(links(j)))) / sflux
                                        newvals(links(j)) += adjs / dp
                                        spool -= adjs
                                    End If
                                End If
                            Next
                            adjpool = 1 / (1 - cpool / 1000.0)

                            For j As Integer = 0 To newvals.Length - 1
                                If Single.IsNaN(newvals(j)) Or newvals(j) < 0 Then
                                    Dim g As Integer = 1
                                End If
                            Next

                            REM Hack to stop underflow problem when RE goes to zero with values ging via Python
                            If (newvals(7) < 0.01) Then
                                '    newvals(7) = 0.01
                            End If
                            Dim pynewvals As PyObject()
                            pynewvals = New PyObject(bensplit - 1) {}
                            For j As Integer = 0 To bensplit - 1
                                pynewvals(j) = New PyFloat(vals(j))
                            Next
                            Dim cv As PyObject
                            'simulator.InvokeMethod("setBioValues", New PyList(pynewvals))
                            ReDim pynewvals(vals.Length - bensplit - 4)
                            For j As Integer = bensplit To vals.Length - 4
                                pynewvals(j - bensplit) = New PyFloat(vals(j))
                            Next
                            'simulator.InvokeMethod("setBioValuesBenthic", New PyList(pynewvals))

                        End If
                    End If
                Else
                    realdays += 1.0
                    extraday = Convert.ToInt32(realdays - interleave)
                End If
            End While
            result = simulator.InvokeMethod("finalize")
            Dim errmsg As String
            errmsg = result.GetAttr("errormessage").AsManagedObject(Type.GetType("System.String"))
            Dim corescenario As PyObject
            corescenario = PythonEngine.ImportModule("core.scenario")
            REM corescenario.SetAttr("Scenario", corescenario)
            REM corescenario.GetAttr("Scenario").InvokeMethod("saveAll", scenario, New PyString("E:\\gotm\\gui.py\\tempx"))
            REM errmsg = result.GetAttr("errormessage").AsManagedObject(Type.GetType("System.String"))
            'fs.Close()

        End If
        PythonEngine.ReleaseLock(lock)
    End Sub

    Public Overrides Sub display()
        Dim lock As IntPtr
        Dim a As Integer
        Dim s As String
        Dim simulator, mpl As PyObject
        lock = PythonEngine.AcquireLock()
        a = PythonEngine.RunSimpleString("import PyQt4")
        simulator = PythonEngine.ImportModule("visualizer")
        mpl = PythonEngine.ImportModule("matplotlib")
        s = mpl.InvokeMethod("get_backend").AsManagedObject(Type.GetType("System.String"))
        simulator.InvokeMethod("visualizeResult", result)
        PythonEngine.ReleaseLock(lock)
    End Sub

    Public Sub Progresstext()
        dispform.TextBox5.Text = biotext
        If (biotext <> Nothing) Then
            'AddText(fs, biotext)
        End If
        dispform.TextBox7.Text = Convert.ToString(cpool)
        dispform.TextBox8.Text = Convert.ToString(npool)
        dispform.TextBox9.Text = Convert.ToString(ppool)
        dispform.TextBox10.Text = Convert.ToString(spool)
        contform.Update()
    End Sub

    Friend Function specifyGOTMXML(ByVal testdatapath As String, ByRef specification As Xml.XmlDocument, ByVal ivariables As String(), ByVal iunits As String(), ByVal iabbrev As String(), ByRef ilkn As Integer(), ByRef ilkp As Integer(), ByRef ilks As Integer(), ByRef isc As Integer(), ByRef iisorg As Integer(), ByVal isthreed As Boolean, ByVal isspatial As Boolean) As String
        Dim NL, clx, gclx As Xml.XmlNodeList
        Dim cl, cl2, m, nodims As Integer
        Dim NewNode, NewChild As Xml.XmlNode
        Dim dt, ftype, tabrev As String
        Dim lonstart, latstart, longint, latint As Double
        Dim longsz, latsz As Integer
        Dim NodeName As String() = {"Longitude", "Latitude", "Depth"}
        Dim FgType As String() = {"C", "N", "Si", "O", "P", "C"}
        Dim Fgstr As String() = {"c", "n", "s", "o", "p"}
        Dim GroupType As String() = {"Phytoplankton", "Zooplankton", "Detritus", "Bacteria", "Consumer", "Detritus", "Bacteria", "Nutrient", "Nutrient", "Nutrient", "StateVariables", "StateVariables", "Other"}
        Dim Abbrevtype As String() = {"P", "Z", "R", "B", "Y", "Q", "H", "K", "N", "O", "D", "E"}
        Dim Node, Child, GChild, GGChild, GGGChild As Xml.XmlNode
        cp.SetDimNames(NodeName)
        NL = specification.GetElementsByTagName("ModelName")
        Dim mname As String
        If NL.Count = 0 Then
            mname = Nothing
        Else
            mname = NL(0).InnerText
        End If
        NL = specification.GetElementsByTagName("Interface")
        For n = 0 To NL.Count - 1
            Node = NL(n).ChildNodes(4)  'Specification.GetElementsByTagName("GridData")
            clx = Node.ChildNodes
            If isspatial Then
                If ((clx(0).Name = "GridFormNone" And isthreed) Or (clx(0).Name = "GridFormRaster3D")) Then
                    Node.RemoveChild(clx(0))
                    NewNode = specification.CreateElement("GridFormRaster3D")
                    NewNode.InnerText = "3D"
                    Node.AppendChild(NewNode)
                End If
                If ((clx(0).Name = "GridFormNone" And Not isthreed) Or (clx(0).Name = "GridFormRaster2D")) Then
                    Node.RemoveChild(clx(0))
                    NewNode = specification.CreateElement("GridFormRaster2D")
                    NewNode.InnerText = "2D"
                    Node.AppendChild(NewNode)
                End If
            Else
                If ((clx(0).Name = "GridFormNone" And isthreed) Or (clx(0).Name = "GridFormRaster3D")) Then
                    Node.RemoveChild(clx(0))
                    NewNode = specification.CreateElement("GridFormRaster1D")
                    NewNode.InnerText = "1D"
                    Node.AppendChild(NewNode)
                End If
                If ((clx(0).Name = "GridFormNone" And Not isthreed) Or (clx(0).Name = "GridFormRaster2D")) Then
                    Node.RemoveChild(clx(0))
                    NewNode = specification.CreateElement("GridFormNone")
                    NewNode.InnerText = "none"
                    Node.AppendChild(NewNode)
                End If
            End If
            If isthreed Then
                If isspatial Then
                    nodims = 3
                Else
                    nodims = 1
                End If

            Else
                If isspatial Then
                    nodims = 2
                Else
                    nodims = 0
                End If

            End If
            For m = 1 To clx.Count - 1
                Node.RemoveChild(clx(m))
            Next
            For m = 1 To nodims
                NewNode = specification.CreateElement(NodeName(m - 1))
                NewChild = specification.CreateElement("Minimum")
                If m = 1 Then
                    NewChild.InnerText = Convert.ToString(alongitude(0))
                End If
                If m = 2 Then
                    NewChild.InnerText = Convert.ToString(alatitude(0))
                End If
                If m = 3 Then
                    NewChild.InnerText = Convert.ToString(azed(0) / azed.Length())
                End If
                NewNode.AppendChild(NewChild)
                NewChild = specification.CreateElement("Interval")
                If m = 1 Then
                    NewChild.InnerText = Convert.ToString(alongitude(1) - alongitude(0))
                End If
                If m = 2 Then
                    NewChild.InnerText = Convert.ToString(alatitude(1) - alatitude(0))
                End If
                If m = 3 Then
                    NewChild.InnerText = Convert.ToString((azed(1) - azed(0)) / azed.Length())
                End If
                NewNode.AppendChild(NewChild)
                NewChild = specification.CreateElement("Length")
                If m = 1 Then
                    NewChild.InnerText = Convert.ToString(alongitude.Length - 1)
                End If
                If m = 2 Then
                    NewChild.InnerText = Convert.ToString(alatitude.Length - 1)
                End If
                If m = 3 Then
                    NewChild.InnerText = Convert.ToString(azed.Length)
                End If
                NewNode.AppendChild(NewChild)
                Node.AppendChild(NewNode)
            Next

        Next
        NL = specification.GetElementsByTagName("DataCollection")
        For n = 0 To NL.Count - 1
            Node = NL(n)
            For m = 0 To ivariables.Length - 1
                ilkn(m) = -1
                ilkp(m) = -1
            Next

            For m = 0 To ivariables.Length - 1
                cl = 12
                For k = 0 To Abbrevtype.Length - 1
                    If iabbrev(m).StartsWith(Abbrevtype(k)) Then
                        cl = k
                    End If
                Next
                Child = specification.CreateElement("Data")
                GChild = specification.CreateElement("Name")
                If (cl < 7) Then
                    If iabbrev(m).Substring(iabbrev(m).Length - 1, 1) = "D" Then
                        tabrev = iabbrev(m).Substring(0, iabbrev(m).Length - 2)
                    Else
                        tabrev = iabbrev(m).Substring(0, iabbrev(m).Length - 1)
                    End If
                    GChild.InnerText = tabrev
                Else
                    GChild.InnerText = iabbrev(m)
                End If
                Child.AppendChild(GChild)
                GChild = specification.CreateElement("DataItem")
                GChild.InnerText = ""
                GGChild = specification.CreateElement(GroupType(cl))
                GGGChild = specification.CreateElement("Name")
                GGGChild.InnerText = ivariables(m)
                GGChild.AppendChild(GGGChild)
                REM If ivariables(m).Length > 3 Then
                REM .InnerText = ivariables(m).Substring(0, 3)
                REM Else
                REM GGGChild.InnerText = ivariables(m)
                REM End If
                If (cl < 7) Then
                    If iabbrev(m).Substring(iabbrev(m).Length - 1, 1) = "D" Then
                        ftype = iabbrev(m).Substring(iabbrev(m).Length - 2, 1)
                    Else
                        ftype = iabbrev(m).Substring(iabbrev(m).Length - 1, 1)
                    End If
                    cl2 = 5
                    For k = 0 To Fgstr.Length - 1
                        If Fgstr(k) = ftype Then
                            cl2 = k
                        End If
                    Next
                    GGGChild = specification.CreateElement("Constituent")
                    GGGChild.InnerText = FgType(cl2)
                    GGChild.AppendChild(GGGChild)
                    If (cl2 = 0) Then
                        isc(m) = 1
                    Else
                        isc(m) = 0
                    End If
                    If (cl = 1) Then
                        iisorg(m) = 2
                    Else
                        If (cl = 2 Or cl = 5) Then
                            iisorg(m) = 1
                        Else
                            iisorg(m) = 0
                        End If
                    End If
                    If (cl2 = 1) Then
                        For k = 0 To ivariables.Length - 1
                            If ((iabbrev(k).Substring(0, iabbrev(k).Length - 1) = tabrev) And (iabbrev(k).Substring(iabbrev(k).Length - 1, 1) = "c")) Then
                                ilkn(k) = m
                            End If
                        Next
                    End If
                    If (cl2 = 4) Then
                        For k = 0 To ivariables.Length - 1
                            If ((iabbrev(k).Substring(0, iabbrev(k).Length - 1) = tabrev) And (iabbrev(k).Substring(iabbrev(k).Length - 1, 1) = "c")) Then
                                ilkp(k) = m
                            End If
                        Next
                    End If
                    If (cl2 = 2) Then
                        For k = 0 To ivariables.Length - 1
                            If ((iabbrev(k).Substring(0, iabbrev(k).Length - 1) = tabrev) And (iabbrev(k).Substring(iabbrev(k).Length - 1, 1) = "c")) Then
                                ilks(k) = m
                            End If
                        Next
                    End If
                Else
                    GGGChild = specification.CreateElement("Constituent")
                    GGGChild.InnerText = "U"
                    GGChild.AppendChild(GGGChild)
                    tabrev = iabbrev(m)
                End If

                GGGChild = specification.CreateElement("Symbol")
                GGGChild.InnerText = tabrev
                GGChild.AppendChild(GGGChild)
                GGGChild = specification.CreateElement("Description")
                GGGChild.InnerText = ivariables(m) + " ERSEM Group"
                GGChild.AppendChild(GGGChild)
                GChild.AppendChild(GGChild)
                Child.AppendChild(GChild)
                GChild = specification.CreateElement("Flux")
                If n = 0 Then
                    GChild.InnerText = "State"
                Else
                    GChild.InnerText = "Predation"
                End If
                Child.AppendChild(GChild)
                GChild = specification.CreateElement("Units")
                If n = 0 Then
                    GChild.InnerText = iunits(m)
                Else
                    GChild.InnerText = iunits(m) + "/Interval"
                End If
                Child.AppendChild(GChild)
                Node.AppendChild(Child)
            Next
        Next
        REM Specification.Save("c:\ewecefas\gotm\gui.py\gotm.xml")
        specification.Save(testdatapath + "\GOTM.xml")
        Return (mname)
    End Function

    Public Overrides Function UsesNetCDF() As Boolean
        Return (False)
    End Function
End Class
