%---------------------------------------------------
% function initialize
%creates matrices for heat capacity and conductivity

function [cT_frozen, cT_thawed, K_frozen, K_thawed, conductivity, capacity] = initialize(cT_water, cT_mineral, cT_organic, cT_soilType, K_water, K_mineral, K_organic, K_soilType, arraySize, cT_grid, kh_bedrock)

c_w= 4.2*10^6; %[J/m�K]
c_o= 2.5*10^6; %[J/m�K]
c_m= 2*10^6; %[J/m�K]
c_a= 0.00125*10^6;%[J/m�K]
c_i= 1.9*10^6;%[J/m�K]

%density of water
rho_w=1000; %[kg/m�]
rho_i=900;
%latent heat of freezing
L_si=334000; % [J/kg]
deltaT=0.001*ones(size(cT_grid,1),1);

%------- capacity part ----------------------------------------------------
waterMin=0;
water=cT_water;
mineral=cT_mineral;
organic=cT_organic;
a=cT_soilType;


cT_thawed=zeros(size(a,1),1);
%cT_frozen=-15*ones(size(a,1),1);

ch=mineral*c_m+organic*c_o+waterMin.*c_w+(water-waterMin)*c_i;

%preallocate variable
c_h2o=ones(length(a),length(-30:0.01:-1));
j=1;
for i= -30:0.01:-1
    c_h2o(:,j)=L_si*rho_w*(freezeC(water, 1-mineral-organic, a, i+deltaT/2)-freezeC(water, 1-mineral-organic, a, i-deltaT/2))/deltaT(1,1) < 0.05.*ch;
    j=j+1;
end

%preallocate variables
cT_frozen=-30+((sum(c_h2o')')-1).*0.01;

c_h2o=ones(length(a),length(1:arraySize-2)+1); 
water_c=c_h2o;
ch=c_h2o;

water_c(:,1) = freezeC(water,1-mineral-organic, a, cT_frozen);
ch(:,1)      = mineral * c_m + organic * c_o +  water_c(:,1) * (c_w-c_i) + water * c_i;
c_h2o(:,1)   = L_si*rho_w* (freezeC(water, 1-mineral-organic, a, cT_frozen+deltaT/2)-freezeC(water, 1-mineral-organic, a, cT_frozen-deltaT/2))/deltaT(1,1);
for i=1:arraySize-2
    water_c(:,i+1) = freezeC(water, 1-mineral-organic, a, cT_thawed+(cT_frozen-cT_thawed)*(arraySize-2-i)/(arraySize-2));
    ch(:,i+1)      = mineral*c_m+organic*c_o+freezeC(water, 1-mineral-organic, a, cT_thawed+(cT_frozen-cT_thawed)*(arraySize-2-i)/(arraySize-2))*(c_w-c_i)+water*c_i;
    c_h2o(:,i+1)   = L_si*rho_w*(freezeC(water, 1-mineral-organic, a, cT_thawed+(cT_frozen-cT_thawed)*(arraySize-2-i)/(arraySize-2)+deltaT/2)-freezeC(water, 1-mineral-organic, a, cT_thawed+(cT_frozen-cT_thawed)*(arraySize-2-i)/(arraySize-2)-deltaT/2))/deltaT(1,1);
end

capacity=ch+c_h2o;
capacity =[capacity mineral*c_m+organic*c_o+water*c_w];  %capacity matrix for unfrozen soil

% lastSnowCell=find(cT_grid(:,1)<0);
% lastSnowCell=lastSnowCell(end);
% 
% capacity(1:lastSnowCell,:) = repmat(rho_snow/rho_i*c_i, lastSnowCell, size(capacity,2));


%---------- conductivity part ---------------------------------------------
% water=K_water;
% mineral=K_mineral;
% organic=K_organic;
% a=K_soilType;
%%K_frozen=-15*ones(size(a,1),1);
%K_frozen=[cT_frozen(1,1); 0.5.*(cT_frozen(1:end-1,1)+cT_frozen(2:end,1)) ; cT_frozen(end,1)];
%K_thawed=zeros(size(a,1),1);

% changed to cT-grid since K- interpolation is done external now
water=cT_water;
mineral=cT_mineral;
organic=cT_organic;
a=cT_soilType;

K_frozen=cT_frozen;
K_thawed=cT_thawed;

%preallocate variables
water_c=ones(length(a),length(1:arraySize-2)+1);
water_c(:,1)=freezeC(water, 1-mineral-organic, a, K_frozen);
conductivity=water_c;

for i=1:arraySize-2
    water_c(:,i+1)=freezeC(water, 1-mineral-organic, a, K_thawed+(K_frozen-K_thawed)*(arraySize-2-i)/(arraySize-2));
end
for i=1:size(a,1)
    ice_c=water(i,1)*ones(1,arraySize-1)-water_c(i,:);
    %plot(water_c(i,:)')
    conductivity(i,:)=conductivity2(water_c(i,:), ice_c, mineral(i,1), organic(i,1), kh_bedrock);
    %plot(heatcond(water_c(i,:)', ice_c, mineral(i,1), organic(i,1), 0, 0.15, 2))
end

conductivity=[conductivity conductivity(:,size(conductivity,2))]; %conductivity matrix for soil filled

% lastSnowCell=find((:,1)<0);
% lastSnowCell=lastSnowCell(end);
% conductivity(1:lastSnowCell,:) = repmat(kh_snow, lastSnowCell, size(conductivity,2)); 

conductivity=real(conductivity);
capacity=real(capacity);


%---------------------------------------------------
% function freezeC
%part of the freezeCurve for T<T_th - for T>T_th, the value for water
%content is 'water' by default
function waterC =  freezeC(thetaTot, thetaSat,soilType, T)
thetaTot=min(thetaSat,thetaTot);

T=T+273.15;
% thetaTot=0.3;
% thetaSat=0.4;
thetaRes=zeros(size(soilType));
alpha=zeros(size(soilType));
n=zeros(size(soilType));

for i=1:size(soilType,1)
if soilType(i,1)==1 % sand

thetaRes(i,1)=0;
alpha(i,1)=4; %units meter
n(i,1)=2;
end

if soilType(i,1)==2 %silt

thetaRes(i,1)=0.05;
alpha(i,1)=0.65; %units meter
n(i,1)=1.7;
end
end

% thetaTot=0.2;
% thetaSat=0.5;
% thetaRes=0.05;
% alpha=0.15; %units meter
% n=1.25;
 m=1-1./n;
waterPotZero=-1./alpha .*( ((thetaTot-thetaRes)./(thetaSat-thetaRes) ).^(-1./m) -1 ).^(1./n);
Tstar=273.15+9.81.*273.15./3.34e5.*waterPotZero;
waterC=zeros(size(T));

for i=1:size(soilType,1)
if T(i)>=273.15
    waterC(i,1)=thetaTot(i,1);
else
  
      if T(i,1)>273.1
       
            
           waterPot=waterPotZero(i,1)+(3.34e5./9.81./Tstar(i,1).*(273.1-Tstar(i,1))).*(273.1<Tstar(i,1));
           waterC(i,1)=thetaRes(i,1)+(thetaSat(i,1)-thetaRes(i,1)).*(1+(-alpha(i,1).*waterPot).^n(i,1)).^(-m(i,1));
            
            waterC(i,1) =waterC(i,1)+ (thetaTot(i,1)-waterC(i,1))./0.05.*(T(i,1)-273.1);
        
      else
            waterPot=waterPotZero(i,1)+(3.34e5./9.81./Tstar(i,1).*(T(i,1)-Tstar(i,1))).*(T(i,1)<Tstar(i,1));
           waterC(i,1)=thetaRes(i,1)+(thetaSat(i,1)-thetaRes(i,1)).*(1+(-alpha(i,1).*waterPot).^n(i,1)).^(-m(i,1));
          
      end
end
end

    


