function [L_star u_star] = L_star(uz, z, z0, Tz, Qh, Qe, Lstar)

rho=1.293;
cp=1005;
L=3.34*10^5;
kappa=0.4;
g=9.81;
p=1005*100;
sigma=5.67e-8;


Tz=Tz+273.15;

u_star = real(uz.*kappa./(log(z./z0)- psi_M(z./Lstar, z0./Lstar)));
L_star = real(-rho.*cp.*Tz./kappa./g.*u_star.^3./(Qh + 0.61.*cp./L.*Tz.*Qe));
L_star=(abs(L_star)<1e-7).*L_star./abs(L_star).*1e-7 + (abs(L_star)>=1e-7).*L_star;



