function H = ShowMap(M,Hi_1km)

Wf = 1800;
Wa = Wf - 150;
Ha=  Wa * 121/181;
Hf = Ha + 200;

H.Figure = figure(...
  'units',          'pixels',...
  'position',       [50 50 Wf Hf],...
  'color',          [1 1 1]);

H.Axes   = axes(...
  'parent',         H.Figure,...
  'units',          'pixels',...
  'position',       [100 75 Wa Ha],...
  'xtick',          [-3600 -3000 -2400 -1800 -1200 -600 0 600 1200 1800 2400 3000 3600],...
  'ytick',          [-2400 -1800 -1200 -600 0 600 1200 1800 2400],...
  'xlim',           [-3600 3600],...
  'ylim',           [-2400 2400],...
  'box',            'on',...
  'fontsize',       30,...
  'xgrid',          'on',...
  'ygrid',          'on',...
  'layer',          'top');

H.Xlabel = xlabel(H.Axes,'kilometers','fontsize',28);
H.Ylabel = ylabel(H.Axes,'kilometers','fontsize',28);

colormap(...
 [0.1 0.4 0.1;...
  0.4 1 0.4;...
  0.6 0.7 1;...
  1   1   1]);

H.Image = image(...
  'parent',         H.Axes,...
  'cdata',          M'+1,...
  'xdata',          [-3600 3600],...
  'ydata',          [-2400 2400]);

H.ImageIce = image(...
  'parent',           H.Axes,...
  'cdata',            zeros(size(Hi_1km,2),size(Hi_1km,1))+4,...
  'xdata',            get(H.Axes,'xlim'),...
  'ydata',            get(H.Axes,'ylim'),...
  'alphadata',        Hi_1km'.^0.25,...
  'alphadatamapping', 'scaled');

if sum(sum(Hi_1km)) == 0
  set(H.ImageIce,'visible','off')
end

set(H.Ylabel,'position',get(H.Ylabel,'position')+[120 0 0])

end