% Tijn Berends, 11-02-2016
%
% This routine converts a low-resolution Map and Stack to their
% high-resolution equivalents, conserving filled elements.

function [Map_1km, Stack_1km, StackN_1km] = Map_Stack_40km_to_1km(C, Map_40km, Stack_40km, StackN_40km, Map_1km, Stack_1km, StackN_1km)

% First the filled Map elements.
for i = 1: C.NX40
for j = 1: C.NY40
  if (Map_40km(i,j) == 2)
    Map_1km((i-1)*40+1:i*40, (j-1)*40+1:j*40) = 2;
  end
end
end

for i = 1:StackN_40km-1

  % For every edge element Map_**km(i), check which of the 8 neighbours are Filled.
  % If, for example, the element west of Map_**km(i) is Filled then the whole western border
  % of the corresponding high-resolution block is shoreline.

  W   = false;
  if (Stack_40km(i,1) > 1)
    if (Map_40km(Stack_40km(i,1)-1, Stack_40km(i,2)) == 2)
      W = true;
    end
  end

  NW  = false;
  if (Stack_40km(i,1) > 1 && Stack_40km(i,2) < C.NY40)
    if (Map_40km(Stack_40km(i,1)-1, Stack_40km(i,2)+1) == 2)
      NW = true;
    end
  end

  N   = false;
  if (Stack_40km(i,2) < C.NY40)
    if (Map_40km(Stack_40km(i,1), Stack_40km(i,2)+1) == 2)
      N = true;
    end
  end

  NE  = false;
  if (Stack_40km(i,1) < C.NX40 && Stack_40km(i,2) < C.NY40)
    if (Map_40km(Stack_40km(i,1)+1, Stack_40km(i,2)+1) == 2)
      NE = true;
    end
  end

  E   = false;
  if (Stack_40km(i,1) < C.NX40)
    if (Map_40km(Stack_40km(i,1)+1, Stack_40km(i,2)) == 2)
      E = true;
    end
  end

  SE  = false;
  if (Stack_40km(i,1) < C.NX40 && Stack_40km(i,2) > 1)
    if (Map_40km(Stack_40km(i,1)+1, Stack_40km(i,2)-1) == 2)
      SE = true;
    end
  end

  S   = false;
  if (Stack_40km(i,2) > 1)
    if (Map_40km(Stack_40km(i,1), Stack_40km(i,2)-1) == 2)
      S = true;
    end
  end

  SW  = false;
  if (Stack_40km(i,1) > 1 && Stack_40km(i,2) > 1)
    if (Map_40km(Stack_40km(i,1)-1, Stack_40km(i,2)-1) == 2)
      SW = true;
    end
  end

  % The indices of the western, eastern, northern and southern border elements of the
  % corresponding high-resolution block.

  pw = (Stack_40km(i,1)-1)*40+1;
  pe = Stack_40km(i,1)*40;
  ps = (Stack_40km(i,2)-1)*40+1;
  pn = Stack_40km(i,2)*40;

  % First the four corners
  if (W || NW || N)
    Map_1km(pw,pn) = 1;
    Stack_1km(StackN_1km,:) = [pw, pn, 1];
    StackN_1km = StackN_1km+1;
  end
  if (E || NE || N)
    Map_1km(pe,pn) = 1;
    Stack_1km(StackN_1km,:) = [pe, pn, 1];
    StackN_1km = StackN_1km+1;
  end
  if (E || SE || S)
    Map_1km(pe,ps) = 1;
    Stack_1km(StackN_1km,:) = [pe, ps, 1];
    StackN_1km = StackN_1km+1;
  end
  if (W || SW || S)
    Map_1km(pw,ps) = 1;
    Stack_1km(StackN_1km,:) = [pw, ps, 1];
    StackN_1km = StackN_1km+1;
  end

  % Then the sides in between
  if (W)
    Map_1km(pw,ps+1:pn-1) = 1;
    for j = ps+1: pn-1
      Stack_1km(StackN_1km,:) = [pw, j, 1];
      StackN_1km = StackN_1km+1;
    end
  end
  if (N)
    Map_1km(pw+1:pe-1,pn) = 1;
    for j = pw+1: pe-1
      Stack_1km(StackN_1km,:) = [j, pn, 1];
      StackN_1km = StackN_1km+1;
    end
  end
  if (E)
    Map_1km(pe,ps+1:pn-1) = 1;
    for j = ps+1: pn-1
      Stack_1km(StackN_1km,:) = [pe, j, 1];
      StackN_1km = StackN_1km+1;
    end
  end
  if (S)
    Map_1km(pw+1:pe-1,ps) = 1;
    for j = pw+1: pe-1
      Stack_1km(StackN_1km,:) = [j, ps, 1];
      StackN_1km = StackN_1km+1;
    end
  end

end

end