clc
clear all
close all

Hb_1km      = ncread('Data_30Ky.nc','Hb_1km');
Hb_5km      = ncread('Data_30Ky.nc','Hb_5km');
Hb_40km     = ncread('Data_30Ky.nc','Hb_40km');
Hi_40km     = ncread('Data_30Ky.nc','Hi_40km');
SL_40km     = ncread('Data_30Ky.nc','SL_40km');

% Sizes of the different arrays
C.NX40 = 181;         % Number of elements in the X (east-west)   direction on 40km resolution.
C.NY40 = 121;         % Number of elements in the Y (north-south) direction on 40km resolution.
C.NX5  = C.NX40 * 8;  % Same on 8km resolution.
C.NY5  = C.NY40 * 8;
C.NX1  = C.NX40 * 40; % Same on 1km resolution.
C.NY1  = C.NY40 * 40;

SL_5km      = zeros(C.NX5,C.NY5);
SL_1km      = zeros(C.NX1,C.NY1);
Hi_5km      = zeros(C.NX5,C.NY5);
Hi_1km      = zeros(C.NX1,C.NY1);
Hbmax_40km  = zeros(C.NX40,C.NY40);
Hbmax_5km   = zeros(C.NX5,C.NY5);


% Nearest-neighbour interpolation for ice thickness to preserve blockiness
for i=1:C.NX40
  for j=1:C.NY40
    Hi_5km((i-1)*8 +1:i*8 ,(j-1)*8 +1:j*8 ) = Hi_40km(i,j);
    Hi_1km((i-1)*40+1:i*40,(j-1)*40+1:j*40) = Hi_40km(i,j);
  end
end

% Bi-linear interpolation for SL to preserve smoothiness
% ==========
% Smoothly interpolate geoid from 40km to 5km grid.
for i = 5: C.NX5-4
for j = 5: C.NY5-4
  ib = (i + 3.6) / 8;
  jb = (j + 3.6) / 8;
  SL_5km(i,j)           = (SL_40km(         floor(ib)  , floor(jb)   ) * ((ceil(ib)  - ib) * (ceil(jb)  - jb))) + ...
                          (SL_40km(         floor(ib)  , ceil(jb) ) * ((ceil(ib)  - ib) * (jb - floor(jb)  ))) + ...
                          (SL_40km(         ceil(ib), floor(jb)   ) * ((ib - floor(ib)) * (ceil(jb)  - jb))) + ...
                          (SL_40km(         ceil(ib), ceil(jb) ) * ((ib - floor(ib)) * (jb - floor(jb)  )));
end  
end

for j = 5:C.NY5-4
for i = 1:4
  jb = (j + 3.6) / 8  ;
  SL_5km(i,j)          = (SL_40km(         1,floor(jb)  ) * (ceil(jb)-jb)) + (SL_40km( 1,ceil(jb)) * (jb-floor(jb)  ));
end
for i = C.NX5-3:C.NX5
  jb = (j + 3.6) / 8;
  SL_5km(i,j)          = (SL_40km(         C.NX40,floor(jb)  ) * (ceil(jb)-jb)) + (SL_40km( C.NX40,ceil(jb)) * (jb-floor(jb)  ));
end
end
for i = 5:C.NX5-4
for j = 1:4
  ib = (i + 3.6) / 8;
  SL_5km(i,j)          = (SL_40km(         floor(ib)  ,1) * (ceil(ib)-ib)) + (SL_40km( ceil(ib),1) * (ib-floor(ib)  ));
end
for j = C.NY5-3:C.NY5
  ib = (i + 3.6) / 8;
  SL_5km(i,j)          = (SL_40km(         floor(ib)  ,C.NY40) * (ceil(ib)-ib)) + (SL_40km( ceil(ib),C.NY40) * (ib-floor(ib)  ));
end
end

SL_5km( 1:4,                      1:4                     )           = SL_40km(          1,          1       );
SL_5km( 1:4,                      C.NY5-3:C.NY5 )           = SL_40km(          1,          C.NY40);
SL_5km( C.NX5-3:C.NX5,  1:4                     )           = SL_40km(          C.NX40,   1       );
SL_5km( C.NX5-3:C.NX5,  C.NY5-3:C.NY5 )           = SL_40km(          C.NX40,   C.NY40);
% Smoothly interpolate geoid from 40km to 5km grid.  
% ==========

% ==========
% Smoothly interpolate geoid, bedrock deformation and ETOPO offset from initial restart file from 40km to 1km grid. 
for i = 21: C.NX1-20
for j = 21: C.NY1-20
  ib = (i + 19.5) / 40;
  jb = (j + 19.5) / 40 ; 
  SL_1km(i,j)          = (SL_40km(         floor(ib)  , floor(jb)   ) * ((ceil(ib)  - ib) * (ceil(jb)  - jb))) + ...
                         (SL_40km(         floor(ib)  , ceil(jb) ) * ((ceil(ib)  - ib) * (jb - floor(jb)   ))) + ...
                         (SL_40km(         ceil(ib), floor(jb)   ) * ((ib - floor(ib)   ) * (ceil(jb)  - jb))) + ...
                         (SL_40km(         ceil(ib), ceil(jb) ) * ((ib - floor(ib)   ) * (jb - floor(jb)   )));
end
end

for j = 21: C.NY1-20
for i = 1: 20
  jb = (j + 19.5) / 40    ;
  SL_1km(i,j)          = (SL_40km(         1,floor(jb)  ) * (ceil(jb)-jb)) + (SL_40km( 1,ceil(jb)) * (jb-floor(jb)  ));
end
for i = C.NX1-19: C.NX1
  jb = (j + 19.5) / 40    ;
  SL_1km(i,j)          = (SL_40km(         C.NX40,floor(jb)  ) * (ceil(jb)-jb)) + (SL_40km( C.NX40,ceil(jb)) * (jb-floor(jb)  ));
end
end
for i = 21: C.NX1-20
for j = 1: 20
  ib = (i + 19.5) / 40    ;
  SL_1km(i,j)          = (SL_40km(         floor(ib)  ,1) * (ceil(ib)-ib)) + (SL_40km( ceil(ib),1) * (ib-floor(ib)  ));
end
for j = C.NY1-19: C.NY1
  ib = (i + 19.5) / 40    ;
  SL_1km(i,j)          = (SL_40km(         floor(ib)  ,C.NY40) * (ceil(ib)-ib)) + (SL_40km( ceil(ib),C.NY40) * (ib-floor(ib)  ));
end
end

SL_1km(          1:20,                        1:20      )                 = SL_40km(          1,    1);
SL_1km(          1:20,                        C.NY1-19:C.NY1) = SL_40km(          1,    C.NY40);
SL_1km(          C.NX1-19:C.NX1,  1:20      )                 = SL_40km(          C.NX40, 1);
SL_1km(          C.NX1-19:C.NX1,  C.NY1-19:C.NY1) = SL_40km(          C.NX40, C.NY40);
% Smoothly interpolate geoid, bedrock deformation and ETOPO offset from initial restart file from 40km to 1km grid.  
% ==========

% Get Hbmax fields
ice_density      = 960;
seawater_density = 1018;

Hrel_1km = Hb_1km - SL_1km + Hi_1km*ice_density/seawater_density;
Hrel_5km = Hb_5km - SL_5km + Hi_5km*ice_density/seawater_density;

tic

for i=1:C.NX5
  for j=1:C.NY5
    Hbmax_5km(i,j) = max(max(Hrel_1km((i-1)*5+1:i*5,(j-1)*5+1:j*5)));
  end
end
for i=1:C.NX40
  for j=1:C.NY40
    Hbmax_40km(i,j) = max(max(Hrel_1km((i-1)*40+1:i*40,(j-1)*40+1:j*40)));
  end
end

toc