;**********************************
; VFE diagram script modified from taylor_4.ncl
;**********************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"   
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"   
load "./VFE_diagram.ncl"
;**********************************
begin
;**********************************
; Assume the following have already been computed:
;   _ratio are the ratio:  Case_Variance/Reference_Variance
;   _cc    are the cross correlation coef of Case to Reference
; In this example, these are derived for annual mean climatologies.
;**********************************

; Cases [Model]
  case      = (/ "CMIP5 Models"/)
  nCase     = dimsizes(case )                 ; # of Cases [Cases]

; variables compared
  var      = (/ "", "", "", "", "", "","","",\
                 "","","","","","",\
                 "","","","","" /) 
  nVar      = dimsizes(var)                   ; # of Variables

; more info to be added [all are bogus]
  source    = (/ "", "","","", "", "", "", "","","" \
               , "", "","","", "", "", "", "",""  /)

; "Case A"                        
  CA_ratio   = (/1.036, 1.068, 1.019, 0.976, 0.966, 1.071, 1.059, 0.991, 1.010, 1.065 \
                ,0.945, 0.777, 0.817, 1.081, 0.888, 1.038, 0.993, 0.980, 0.821 /)
  CA_cc      = (/0.956, 0.933, 0.916, 0.948, 0.949, 0.884, 0.952, 0.918, 0.907, 0.915 \
                ,0.946, 0.858, 0.887, 0.935, 0.923, 0.934, 0.953, 0.892, 0.847 /)

; arrays to be passed to taylor_diagram. It will calculate the x xnd y coordinates.
  ratio      = new ((/nCase, nVar/),typeof(CA_cc) )  
  cc         = new ((/nCase, nVar/),typeof(CA_cc) ) 

  ratio(0,:) = CA_ratio 
;  ratio(1,:) = CB_ratio

  cc(0,:)    = CA_cc 
;  cc(1,:)    = CB_cc

;**********************************
; create plot
;**********************************
  varSource = var + source              ; add extra info [*not* required]

  ty_opt   = True                           ; taylor diagram with options
        
  ty_opt@Markers       = (/20/)         ; make all solid fill
  ty_opt@Colors        = (/"red"/)          
  ty_opt@varLabels     = varSource
  ty_opt@caseLabels    = case

  ty_opt@varLabelsYloc = -0.20                ; Move location of variable labels [default 0.45]
  ty_opt@caseLabelsFontHeightF = 0.14       ; make slight larger   [default=0.12 ]
  ty_opt@varLabelsFontHeightF  = 0.011      ; make slight smaller  [default=0.013]
 
  ty_opt@tiMainString  = "Asian-Australian Monsoon region in Summer"           ; title
  ty_opt@stnRad        = (/ 0.5,1.5 /)      ; additional standard radii
  ty_opt@ccRays        = (/ 0.7,0.95 /)     ; correllation rays
  ty_opt@centerDiffRMS = True               ; RMS 'circles'
  ty_opt@centerDiffRMS_color = "LightGray"  ; default is "black"
;  ty_opt@ccRays_color    = "LightGray"       ; default is "black"

  wks   = gsn_open_wks("ps","VFE.MAsia.summer")
  plot  = taylor_diagram(wks,ratio,cc,ty_opt)

;**************************************************
; fill an array for a "taylor metrics table"
;**************************************************

  season    = (/ "ANN" /)
  nSeason   = dimsizes(season)

  table     = new ( (/nCase,nSeason,nVar/), typeof(ratio) )
  table(0,0,:) = CA_ratio
;  table(1,0,:) = CB_ratio

  tt_opt        = True
  tt_opt@pltType= "ps"                  ; "eps" [default], "pdf", "ps"
                                         ; "png", "gif" [if you have ImageMajik 'convert']

end 
