function [hat_x,info] = alg_optimReg(y,M,regular,tlacitko)

if nargin < 4
    tlacitko = 1e-4;
end

options.alpha          = tlacitko;
options.regularization = regular;

switch regular
    case 'OLS'
        hat_x = SolveProblem(M, y, options);
    case 'LASSO' % L1 norm
        [hat_x, valueLASSO, dataLASSO] = SolveProblem(M, y, options);
    case 'Tikhonov' %L2 norm
        [hat_x, valueTihkonov, dataTikhonov] = SolveProblem(M, y, options);
end

info = options;


end
