function [x, lambda, i, residual]  = SolveSemismooth(A, b, lowerBound, upperBound, xOld, lambdaOld)
    %SolveSemismooth solves quadratic problem using semismooth Newton method
    %  minimize     0.5*x'Ax + b'x
    %  subject to   lowerBound <= x <= upperBound
    % This file has been written by Lukas Adam, for further information, contact me at adam@utia.cas.cz
    % The method has NOT been developed by myself
    
    % Fill the missing data 1
    m = size(A,1);
    n = size(A,2);
    if nargin < 6 || isempty(lambdaOld)
        lambdaOld = zeros(m,1);
    end
    if nargin < 5 || isempty(xOld)
        xOld = zeros(m,1);
    end
    if nargin < 4 || isempty(upperBound)
        upperBound = Inf(n,1);
    end
    if nargin < 3 || isempty(lowerBound)
        lowerBound = -Inf(n,1);
    end
    % Check for errors
    if any(lowerBound > upperBound)
        error('Upper bound must not be smaller than the lower bound.');
    end
    ASym = 0.5*(A+A');
    if ~isequal(A, ASym)
        warning('Matrix A is not symmetric. Setting A = 0.5*(A+transpose(A)).');
        A = ASym;
    end
    % Remove any indices with the same lower and upper bound
    fixedX      = find(lowerBound == upperBound);
    nonfixedX   = setdiff(1:n, fixedX);
    b           = b(nonfixedX) + 2*A(nonfixedX,fixedX)*lowerBound(fixedX);
    A           = A(nonfixedX,nonfixedX);
    lambdaOld   = lambdaOld(nonfixedX);
    xOld        = xOld(nonfixedX);
    lowerBound  = lowerBound(nonfixedX);
    upperBound  = upperBound(nonfixedX);
    fixedValues = lowerBound;    
    % Start the optimization    
    c = 100;
    for i=1:200
        I = find(lambdaOld + c*(xOld-lowerBound) < 0);
        K = find(lambdaOld + c*(xOld-upperBound) > 0);
        IK = sort([I; K]);
        J = setdiff(1:m, IK);
        
        xNew = zeros(m, 1);
        xNew(I) = lowerBound(I);
        xNew(K) = upperBound(K);
        
        xNew(J) = -A(J,J) \ (b(J) + A(J,IK)*xNew(IK));
        lambdaNew = zeros(m, 1);
        lambdaNew(IK) = -b(IK) - A(IK,:)*xNew;
        
        xOld = xNew;
        lambdaOld = lambdaNew;
        
        projection = min(max(xNew+100000*lambdaNew,lowerBound),upperBound);
        residual1  = norm(A*xNew + b + lambdaNew);
        residual2  = norm(xNew - projection);
        residual   = max(residual1, residual2);
        if residual <= 1e-12
            break;
        end
    end
    % Set the removed indices
    x = fixedValues;
    x(nonfixedX) = xNew;
    lambda = zeros(length(fixedValues), 1);
    lambda(nonfixedX) = lambdaNew;
end