c Pick data from weather files with date limits and specified site numbers

	implicit none

	integer i, j, k, Year, ThisYear, CO2effect, scenario

	integer SiteNo, idate, ilat, ilon, Glob, vdate, vlat, vlon, tdate
	integer lon, lat, lon_t(4000), lat_t(4000)
      real fsum(10,4000,100), gsum(10,4000,100), fgsum(10,4000,100)
      real ffs(10,4000),ggs(10,4000), ffss(10,4000), ggss(10,4000)
      real fgs(10,4000), fgss(10,4000), fgs_store(10,4000)
	Real MeanT, MaxT, MinT, Prec, VPD, VPD_old, pH2O, pSAT, MeanTRh
	real RH, theta(2), REW_tot, ET_tot, fDET
	integer a1, a2, vuosi, v1, v2, v3, v4
	integer REW_frequency(101), REW_index
	character*4 vuosistr
c      real Tsum(4000,100), WTsum(4000,100)

c ROmul soil water model parameters
      real roo_M, roo_H, cW
      real SW, SFC, SWP, ST(2), ET_C, W_H, W_M, REW
      real P1, P2, P_H, P_M
      real ST_M, ST_H, theta1, theta2
      real stm(2)

      real LKP_decomp
      real f_1, f_2, f_3, f_4, f_5, f_6
      real g_1, g_2, g_3, g_4, g_5, g_6

      double precision litter(11),litter_N(11),Navail(4000)
      double precision in_litter(11,4000), in_litter_N(11,4000)
      double precision in_SW(2,4000)
      
      real SWmax(2)

	Real kappa, fD, fD2
	real x0, xk, Smax, tau, Sk, fS
	real gamma, PAR, fL, xDC, kDC

	real beta, fAPAR, P0(4000), P0_sum(4000), P0_table(4000,50)
	real P0_reduced(4000, 50), SoilWaterReducer
	real SWReducer(4000, 50)
	real p0sum, ddsum
	integer count

	real LS(4000), LsThreshold, PhenoMulti
	integer StartDate, LsDates(4000), td

	character*160 InFile, Infile2, OutFile1, Outfile2, outfile3
	character*160 outfile4
	character*40 inputstring
	character*3 precstring, soilstring, CO2string
	character*1 tempstring


c	Variables for simple soilwater module
	real SoilWater(4000,2), soilw(2), SoilwaterMax, DroughtDays(4000,50,2)
	real x, ET, EvapoTranspiration, tempincr, precincr
	real CO2ppm, CO2multi, CO2_VPDmulti

	CO2effect = 1

      do 11 i = 1, 10
          do 12 j = 1, 4000
              do 13 k = 1, 100
                  fsum(i,j,k) = 0
                  gsum(i,j,k) = 0
                  fgsum(i,j,k) = 0
c          Tsum(j,k) = 0
c          WTsum(j,k) = 0

13            continue
12        continue
11    continue
      
	Infile2 = "input.txt"
	open(22, file = infile2, status = 'old')

666	read(22,*, end = 667) inputstring
	write(*,*) inputstring

	soilstring = inputstring(12:14)
	precstring = inputstring(5:7)
	tempstring = inputstring(2:2)
	if (CO2effect .GT. 0 ) then
		CO2string = inputstring(19:21)
		CO2ppm = 100*(ichar(CO2string(1:1)) - 48) +
     +	10*(ichar(CO2string(2:2)) - 48) + 
     +	(ichar(CO2string(3:3)) - 48)
	endif

	soilwatermax = 100*(ichar(soilstring(1:1)) - 48) +
     +  10*(ichar(soilstring(2:2)) - 48) + (ichar(soilstring(3:3)) - 48)

	tempincr = ichar(tempstring) - 48
	precincr = 10*(ichar(precstring(2:2)) - 48) + 
     +(ichar(precstring(3:3)) - 48)

c	store the "logical" value of variable, as it will be used for calcualation later...
	scenario = precincr
      write(*,*) "scenario", scenario
	if(precstring(1:1) .eq. '-') then
	  precincr = -1 * precincr
	endif


c **************************************************************************
c	define parameters, init values...

	beta = 0.541
	fAPAR = 0.80

	kappa = -0.403

	gamma = 0.0223

	xDC = 0.5
	kDC = kappa

	x0 = -3.9
	Smax = 17.1 
	tau = 17.04
      
c     ROMUL SWM
c     Mineral soil and humus dencities from Raisa via Annikki      
      roo_M = 1.6
      roo_H = 0.167
      
c     cW coefficient from Chertov et al. 2001  
      cW = 5.0
        

c	StartDate = MMDD, i.e. 408 = 0408 = Apr 8th 
	StartDate = 408
	LsThreshold = 167.0

c	init...
	Year = 0
	i = 0
c      Navail = 0

c	Soilwater parameters
	do 320 i = 1, 4000
		SoilWater(i,1) = 10
          Soilwater(i,2) = 120
          Navail(i) = 0
320	continue

c **************************************************************************
c	litter & SW

c      open (20, file = "litter_2014_08_C.txt", status = 'old', err=150)      
      open (20, file = "litter.txt", status = 'old', err=150)      
      open (21, file = "soil_water_aleksi.txt", status = 'old', err=150)      
c      open (21, file = "soil_water_constant.txt", status = 'old',
c     c            err=150)      
      do 330 i = 1, 3829
          read(20,*) k, (in_litter(j,i), j = 1, 5), in_litter(11,i),
     +   (in_litter_N(j,i), j = 1, 5), in_litter_N(11,i)
          in_litter(6,i) = 0
          in_litter(7,i) = 0
          in_litter(8,i) = 0
          in_litter(9,i) = 0
          in_litter(10,i) = 0
          in_litter_N(6,i) = 0
          in_litter_N(7,i) = 0
          in_litter_N(8,i) = 0
          in_litter_N(9,i) = 0
          in_litter_N(10,i) = 0
          
c Foliage and fine root N re-uptake; only 50% and 10% released to ground!          
c These coefficients in the input data! 
          
          
c          in_litter_N(1,i) = in_litter_N(1,i) / 2
c          in_litter_N(4,i) = in_litter_N(4,i) / 10
          
          read(21,*) k, in_SW(1,i), in_SW(2,i)
          
 330  continue
      
      close(20)
      close(21)
c **************************************************************************


	InFile = "files.txt"
	open(20, file = InFile, status = 'old', err=150)
	goto 155
150	Write(*,*) 'Error! No file "files.txt" for input files!'
	stop
155	read(20,*) InFile, a1, a2
c	read(20,*) OutFile1
	close(20)

c Init ROMUL storages
      call ROMUL_AN(litter,litter_N,ST,SoilW,Navail, 3829, 1, 1)



c **************************************************************************
c **************************************************************************
c	Main program loop starts here; loop jump to label 110!
c	First read a new line from the meteo file

c	do 100 vuosi = 1961, 1962
      do 100 vuosi = 1961, 2012
		write(*,*) 'Reading ',vuosi,'...'

		v1 = int(vuosi/1000)
		v2 = int(mod(vuosi,1000)/100)
		v3 = int(mod(vuosi,100)/10)
		v4 = int(mod(vuosi,10)/1)

		vuosistr(1:1) = char(v1+48)
		vuosistr(2:2) = char(v2+48)
		vuosistr(3:3) = char(v3+48)
		vuosistr(4:4) = char(v4+48)

c open input files, year by year

		InFile(a1:a2) = vuosistr
		open(20, file = InFile, status = 'old')




110       read(20,*, end=120) SiteNo, tdate, lat, lon, MeanT, MaxT, 
     +		MinT, Prec, Glob, pH2O

c select only Hyde          
c          if (siteno .ne. 975) then 
c              goto 110
c          endif
		if (MeanT .LT. -50) then
			MeanT = -50
		endif

		if (Glob .LT. 0) then
			Glob = 0
		endif

		lat_t(SiteNo) = lat
		lon_t(SiteNo) = lon

c **************************************************************************
c	Check for ACCLIM climate scenario, adjust "tempincr" accordingly

		if (scenario .GT. 90) then
		  if (scenario .EQ. 91) then
			if(td .LE. 229 .OR. td .GE. 1201) then
				tempincr = 2.2
				Precincr = 7
			endif
			if(td .GE. 301 .AND. td .LE. 531) then
				tempincr = 1.4
				Precincr = 6
			endif
			if(td .GE. 601 .AND. td .LE. 831) then
				tempincr = 1.1
				Precincr = 4
			endif
			if(td .GE. 901 .AND. td .LE. 1131) then
				tempincr = 1.4
				Precincr = 5
			endif
		  endif
		  if (scenario .EQ. 92) then
			if((td .LE. 229) .OR. (td .GE. 1201)) then
				tempincr = 4.3
				Precincr = 15
			endif
			if((td .GE. 301) .AND. (td .LE. 531)) then
				tempincr = 2.8
				Precincr = 10
			endif
			if((td .GE. 601) .AND. (td .LE. 831)) then
				tempincr = 2.0
				Precincr = 8
			endif
			if((td .GE. 901) .AND. (td .LE. 1131)) then
				tempincr = 2.7
				Precincr = 10
			endif
		  endif
		  if (scenario .EQ. 93) then
			if(td .LE. 229 .OR. td .GE. 1201) then
				tempincr = 6.1
				Precincr = 23
			endif
			if(td .GE. 301 .AND. td .LE. 531) then
				tempincr = 4.0
				Precincr = 16
			endif
			if(td .GE. 601 .AND. td .LE. 831) then
				tempincr = 2.8
				Precincr = 11
			endif
			if(td .GE. 901 .AND. td .LE. 1131) then
				tempincr = 3.8
				Precincr = 15
			endif
		  endif
		endif

c **************************************************************************
c	Crude A2 -scenatio modification: increase T by 3C and Prec by 10% !!!
c	Note that T increase over 90 == ACCLIM scenarios; different values for
c	different seasons (see code within the year loop)

		meanTRh = MeanT
		MeanT = MeanT + tempincr
		Prec =  (1+(precincr/100)) * Prec


c	init the Year calculator
c	Check for a new year!
		ThisYear = int(tdate/10000)

		if (Year .EQ. 0) then
			Year = ThisYear
		endif
		if (ThisYear .NE. Year) then
			Year = ThisYear
		endif

c **************************************************************************
c	Phenology dept.

		td = mod(tdate, 10000)
		if (td .GE. StartDate) then
			LS(SiteNo) = LS(SiteNo) + max(MeanT-1.5,0.0)
		endif

		if(LS(SiteNo) .GE. LsThreshold) then
			PhenoMulti = 1.0
		else
			PhenoMulti = 0.0
			LsDates(siteNo) = tdate
          endif

c          if (td .gt. 400 .and. td .lt. 1000) then
c              tsum(siteno, year-1960) = 
c     +            tsum(siteno, year-1960) + max(MeanT-5.0,0.0)
c          else
c              wtsum(siteno, year-1960) = 
c     +            wtsum(siteno, year-1960) + max(MeanT,0.0)
c          endif

c **************************************************************************
c	Calculate VPD and fD

		pSAT = -999
		VPD  = -999

c	omit calculation if pH2O == "missing value"
		if (pH2O .GE. 0) then 
c	Tm on alkuperinen VPD:n laskenta, olettaa ett VPD pysyy ennallaan
			pSAT = exp (77.34 - 7235/(MeanTRh+273.15) - 
     -			8.2*log(MeanTRh+273.15) +  0.005711*(MeanTRh+273.15))
			VPD_old = pSAT - (100*pH2O)
c
c	... ja uudessa versiossa oletetaan RH:n pysyvn muuttumattomana!
			pSAT = exp (77.34 - 7235/(MeanTRh+273.15) - 
     -			8.2*log(MeanTRh+273.15) +  0.005711*(MeanTRh+273.15))

			RH = (pH2O * 100) / pSAT  !Nykyilmaston RH

			pSAT = exp (77.34 - 7235/(MeanT+273.15) - 
     -			8.2*log(MeanT+273.15) +  0.005711*(MeanT+273.15))

			pH2O = RH * pSAT

			VPD = pSAT - pH2O

		endif



c **************************************************************************
c	Calculate PAR and fL
c	Glob in kJ m-2 (per day), PAR in umol m-2 s-1
c	conversion W m-2 -> umol m-2 s-1 derived by Duursma (publ. in Hrknen et al. manus.)

		PAR = -0.894 + 1.8 * Glob * 1000 / (60*60*24)
c		fL = 1 / (gamma * PAR + 1)



c **************************************************************************
c	Calculate EvapoTranspiration for the day

c		REW_tot = Soilwater(SiteNo,2)/(0.55*350*0.7)
		REW_tot = (Soilwater(SiteNo,1)+Soilwater(SiteNo,2))/
     +            (SWmax(1)+SWmax(2))

		ET_tot = EvapoTranspiration (MeanT, PAR, VPD, x, CO2effect, 
     +		CO2ppm, REW_tot, fDET)
          
          soilw(1) = soilwater(siteno,1)
          soilw(2) = soilwater(siteno,2)
          
          SWmax(1) = in_SW(1,siteno)
          SWmax(2) = in_SW(2,siteno)
          
          theta(1) = soilw(1) / (SWmax(1) / 0.65)
          theta(2) = soilw(2) / (SWmax(2) / 0.65)
          
          call two_layer_soil_water(SoilW, SWmax, theta, prec, ET_tot)

          soilwater(siteno,1) = soilw(1)
          soilwater(siteno,2) = soilw(2)
          
c Soil Temperature
          call SoilTemperature(ST, MeanT)
          ST_H = ST(1)
          ST_M = ST(2)
           

c     Volumetric SW and Pumpanen decomp. functions
          soilw(1) = theta(1)
          soilw(2) = theta(2)
          P_H = LKP_decomp(theta(1), 0.7)
          P_M = LKP_decomp(theta(2), 0.55)
          
          do 400 j = 1, 11
c     Litter input as annual, but calculation here is daily!              
              litter(j) = in_litter(j,siteno) / 365
              litter_N(j) = in_litter_N(j, siteno) / 365
400       continue

          call ROMUL_AN(litter,litter_N,ST,SoilW,Navail,
     +            siteno, vuosi, 0)
                    
          
c          write(98,*) vuosi, siteno, navail(siteno)

          if (1 .eq. 0) then
          
         
          fsum(1,siteno,Year-1960) = fsum(1,siteno,Year-1960) + 
     +        f_1(ST_H)
          fsum(2,siteno,Year-1960) = fsum(2,siteno,Year-1960) + 
     +        f_2(ST_H)
          fsum(3,siteno,Year-1960) = fsum(3,siteno,Year-1960) + 
     +       f_3(ST_H)
          fsum(4,siteno,Year-1960) = fsum(4,siteno,Year-1960) +
     +        f_1(ST_M)
          fsum(5,siteno,Year-1960) = fsum(5,siteno,Year-1960) + 
     +        f_2(ST_M)
          fsum(6,siteno,Year-1960) = fsum(6,siteno,Year-1960) + 
     +        f_3(ST_M)
          fsum(7,siteno,Year-1960) = fsum(7,siteno,Year-1960) + 
     +        f_4(ST_M)
          fsum(8,siteno,Year-1960) = fsum(8,siteno,Year-1960) + 
     +        f_5(ST_M)
          fsum(9,siteno,Year-1960) = fsum(9,siteno,Year-1960) + 
     +        f_6(ST_M)

          gsum(1,siteno,Year-1960) = gsum(1,siteno,Year-1960) + 
     +            P_H
c     +        g_1(W_H)
          gsum(2,siteno,Year-1960) = gsum(2,siteno,Year-1960) + 
     +            P_H
c     +        g_2(W_H)
          gsum(3,siteno,Year-1960) = gsum(3,siteno,Year-1960) + 
     +            P_H
c     +        g_3(W_H)
          gsum(4,siteno,Year-1960) = gsum(4,siteno,Year-1960) + 
     +            P_M
c     +        g_1(W_M * Cw)
          gsum(5,siteno,Year-1960) = gsum(5,siteno,Year-1960) + 
     +            P_M
c     +        g_2(W_M * Cw)
          gsum(6,siteno,Year-1960) = gsum(6,siteno,Year-1960) + 
     +            P_M
c     +        g_3(W_M * Cw)
c          if (W_M * Cw .ge. 4.0) then
c                gsum(7,siteno,Year-1960) = gsum(7,siteno,Year-1960) + 1
c          else                                
              gsum(7,siteno,Year-1960) = gsum(7,siteno,Year-1960) + 
     +            P_M
c     +        g_4(W_M * Cw)
c          endif
          gsum(8,siteno,Year-1960) = gsum(8,siteno,Year-1960) + 
     +            P_M
c     +        g_5(W_M)
          gsum(9,siteno,Year-1960) = gsum(9,siteno,Year-1960) + 
     +            P_M
c     +        g_6(W_M)
   
          fgsum(1,siteno,Year-1960) = fgsum(1,siteno,Year-1960) + 
     +        f_1(ST_H)*P_H
c     +        f_1(ST_H)*g_1(W_H)
          fgsum(2,siteno,Year-1960) = fgsum(2,siteno,Year-1960) + 
     +        f_2(ST_H)*P_H
c     +        f_2(ST_H)*g_2(W_H)
          fgsum(3,siteno,Year-1960) = fgsum(3,siteno,Year-1960) + 
     +        f_3(ST_H)*P_H
c     +        f_3(ST_H)*g_3(W_H)
          fgsum(4,siteno,Year-1960) = fgsum(4,siteno,Year-1960) + 
     +        f_1(ST_M)*P_M
c     +        f_1(ST_M)*g_1(W_M * Cw)
          fgsum(5,siteno,Year-1960) = fgsum(5,siteno,Year-1960) + 
     +        f_2(ST_M)*P_M
c     +        f_2(ST_M)*g_2(W_M * Cw)
          fgsum(6,siteno,Year-1960) = fgsum(6,siteno,Year-1960) + 
     +        f_3(ST_M)*P_M
c     +        f_3(ST_M)*g_3(W_M * Cw)
c          if (W_M * Cw .ge. 4.0) then
                fgsum(7,siteno,Year-1960) = fgsum(7,siteno,Year-1960) + 
     +            f_4(ST_M)*P_M
c     +        f_4(ST_M)*g_4(W_M * Cw)
c          else                                
c              fgsum(7,siteno,Year-1960) = fgsum(7,siteno,Year-1960) + 
c     +        f_4(ST_M)*g_4(W_M * Cw)
c          endif
          fgsum(8,siteno,Year-1960) = fgsum(8,siteno,Year-1960) + 
     +        f_5(ST_M)*P_M
c     +        f_5(ST_M)*g_5(W_M)
          fgsum(9,siteno,Year-1960) = fgsum(9,siteno,Year-1960) + 
     +        f_6(ST_M)*P_M
c     +        f_6(ST_M)*g_6(W_M)
 
          
          endif
          

c     loop over sites
	goto 110



120   continue

c     loop over years
100   continue

c write soil storages to file 
      call ROMUL_AN(litter,litter_N,ST,SoilW,Navail, 3829,
     +       1, 2)


c close all files
		close(20)

         
      do 402 i = 1, 3829
c      do 402 i = 975, 975
          do 403 j = 1, 52
c              write(50,405) i, j+1960, lat_t(i), lon_t(i), 
c     +            tsum(i,j), wtsum(i,j)
c     +            (fgsum(k,i,j),k = 1, 9)
c     +            (fsum(k,i,j),k = 1, 9), (gsum(k,i,j),k = 1, 9)
c              write(51,406) i, j+1960, (gsum(k,i,j),k = 1, 9)
403       continue
402   continue
405   format (2i5,2i10, 18f13.6)      
c406   format (9f13.3)      

401   Format (I5, 2I10, 50F8.1)

      do 500 i = 1, 3829
          do 501 k = 1, 9
              ffs(k,i) = 0
              ggs(k,i) = 0
              fgs(k,i) = 0
              fgs_store(k,i) = 0
              ffss(k,i) = 0
              ggss(k,i) = 0
              fgss(k,i) = 0
501       continue
500   continue
          
      do 502 i = 1, 3829
          do 503 j = 1, 52
              do 504 k = 1, 9
              ffs(k,i) = ffs(k,i) + fsum(k,i,j)
              ggs(k,i) = ggs(k,i) + gsum(k,i,j)              
              fgs(k,i) = fgs(k,i) + fgsum(k,i,j)
              fgs_store(k,i) = fgs(k,i)
504           continue              
503       continue
502   continue
      
      do 514 i = 1, 3828
          write (52,515) i, lat_t(i), lon_t(i),
     +    (ffs(k,i)/(52*365), k = 1, 9), 
     +    (ggs(k,i)/(52*365), k = 1, 9)
514   continue
515   format (3i10, 18f13.6)

      do 505 i = 1, 3829
          do 506 k = 1, 9
              ffs(k,i) = ffs(k,i)**2 / 52.0
              ggs(k,i) = ggs(k,i)**2 / 52.0
              fgs(k,i) = fgs(k,i)**2 / 52.0
506       continue
505   continue

      do 507 i = 1, 3829
          do 508 j = 1, 52
              do 509 k = 1, 9
              ffss(k,i) = ffss(k,i) + fsum(k,i,j)**2 
              ggss(k,i) = ggss(k,i) + gsum(k,i,j)**2
              fgss(k,i) = fgss(k,i) + fgsum(k,i,j)**2
509           continue    
508       continue
507   continue
      
      do 510 i = 1, 3829
          do 511 k = 1, 9
              ffss(k,i) = ((ffss(k,i) - ffs(k,i))/ 47) ** 0.5
              ggss(k,i) = ((ggss(k,i) - ggs(k,i))/ 47) ** 0.5
              fgss(k,i) = ((fgss(k,i) - fgs(k,i))/ 47) ** 0.5
511       continue
510   continue
       
      do 512 i = 1, 3828
          write(51,515) i, lat_t(i), lon_t(i), 
     +        (fgs_store(k,i)/(52*365), k = 1, 9), 
     +        (fgss(k,i)/52, k = 1, 9)
          write (53,515) i, lat_t(i), lon_t(i), 
     +        (ffss(k,i)/(52*365), k = 1, 9), 
     +        (ggss(k,i)/(52*365), k = 1, 9)
512   continue
      
	P0sum = 0
	ddsum = 0
	count = 0

	do 410 i = 1, 3829
	do 420 j = 11, 40

	P0sum = P0sum + P0_reduced(i,j)
	ddsum = ddsum + DroughtDays(i,j,1)
	count = count + 1

420	continue
410	continue

	P0sum = P0sum / count
	ddsum = ddsum / count

	write(40,*) P0sum, ddsum

c	close (24)
	close (25)
	close (26)

	goto 666

667	continue

	do 20 i = 1, 101
	  write(42,*) i-1, REW_frequency(i)
20    continue

      
	end

c---------------------------------------------------------------------------
c
c	ET-function copied from program remko.f. Function based loosely on paper 
c	Duursma et al. Tree Physiology 2008, but the dependency of ET on irradiation
c	modified by T. Linkosalo and fitted to Hyytil data in spring 2009
c
c---------------------------------------------------------------------------
	real function EvapoTranspiration (Temp, PAR, VPD, x, CO2effect,
     +		 CO2ppm, REW, fDET)

c  
	real ET
	real Temp, PAR, VPD, x, REW, fDET
     	real beta, tau, x0, kappa, a_1, a_2, CO2ppm
	integer CO2effect

c	parameters hard-coded...
	
	beta = 0.016752	
	tau = 14.39305	
	x0 = -6.94684
	kappa = -0.000263	
	a_1 = 0.0007	
	a_2 = 0.0837	


c	calculate S and D functions
		x = x + (Temp - x)/tau
		fS = max(0.0, x - x0)
		fD = exp(kappa * VPD)
		
c	calculate ET
		ET = beta * PAR * fS * fD + a_1*PAR + a_2

c Convert ET from mol/m2/d to g/m2/d
		ET = ET * 18

c Convert ET from g/m2/d to mm/d  (ET/rho and m -> mm)
		ET = ET / 1000

		fDET = 1

		if (REW .LT. 0.4) then
			fDET = REW/0.4
			ET = ET * fDET
		endif

		EvapoTranspiration = ET
		return
      end
    

      subroutine SoilTemperature(ST, T)

      implicit none
      
      real ST(2), T, adj_T(2)

c parameters for soil temperature model
      real minimum_temp(2), tau(2)
      minimum_temp(1) = -0.13
      minimum_temp(2) = 0.24
	tau(1) = 14.9
	tau(2) = 10.5
      
      adj_T(1) = max(T, minimum_temp(1))
      adj_T(2) = max(T, minimum_temp(2))

      ST(1) = ST(1) + (adj_T(1) - ST(1)) / tau(1)
      ST(2) = ST(2) + (adj_T(2) - ST(2)) / tau(2)
      
c      SoilTemperature = ST

      return
      end
      
      subroutine fgk(f, g, k)
      
      real f(10), g(10), k(10)
      
      integer i
      
c loop over fluxes      
      do 100 i = 1, 6
          
          
          
100   continue
      
      
      
      return
      end
     
      
c	-----------------------------------------------------------------------------
c
c     Decomposition rate function for volumetric soil water content (theta) (where
c     theta = 0 == wilting point and theta = 1 == saturation), based on paper
c     Linkosalo, Kolari & Pumpanen 2013.
c
c	-----------------------------------------------------------------------------      
      real function LKP_decomp(theta, porosity)
      
          real  theta, porosity, P1, P2
      
          P1 = 3.83 * theta ** 1.25
c          P2 = 4.43 * (porosity-theta)**0.8854
          P2 = 4.43 * (1-theta)**0.8854
          LKP_decomp = min(P1,P2,1.)

          return
          end
      
c	-----------------------------------------------------------------------------
c	The functions for rate of decomposition modifiers depending on temperature and 
c	moisture of the corresponding cohort. These new functions are from "Romul 
c	updated equations".
c
c	Tapio Linkosalo October 2008
c	-----------------------------------------------------------------------------
	real function f_1(T)

		real T

		if (T .LE. -5.0 .OR. T .GT. 60.0) then
			f_1 = 0
		endif
		if (T .GT. -5.0 .AND. T .LE. 1.0) then
			f_1 = 0.1595 + 0.0319 * T
		endif
		if (T . GT. 1.0 .AND. T .LE. 35.0) then
			f_1 = 0.1754 * exp(0.0871 * T)
		endif
		if (T . GT. 35.0 .AND. T .LE. 60.0) then
			f_1 = 8.791 - 0.1465 * T
		endif

		return
	end
c	-----------------------------------------------------------------------------
	real function g_1(W)

		real W, W_local, power

		W_local = W*100
	
		if(W_local .LE. 7) then
			g_1 = 0
		endif
		if(W_local .GT. 7 .AND. W_local .LE. 125) then
			g_1 = 0.00000453 * power(W_local, 2.5492)
		endif
		if(W_local .GT. 125 .AND. W_local .LT. 400) then
			g_1 = 1
		endif
		if(W_local .GE. 400) then
			g_1 = 1.0027 * power(0.99157,W_local-400)
		endif

		return
	end
c	-----------------------------------------------------------------------------
	real function f_2(T)

		real T

		if (T .LE. -5.0 .OR. T .GT. 60.0) then
			f_2 = 0
		endif
		if (T .GT. -5.0 .AND. T .LE. 1.0) then
			f_2 = 0.1595 + 0.0319 * T
		endif
		if (T . GT. 1.0 .AND. T .LE. 35.0) then
			f_2 = 0.1754 * exp(0.0871 * T)
		endif
		if (T . GT. 35.0 .AND. T .LE. 60.0) then
			f_2 = 3.690 - 0.0615 * T
		endif

		return
	end
c	-----------------------------------------------------------------------------
	real function g_2(W)

		real W, g_1

		g_2 = g_1 (W)

		return
	end
c	-----------------------------------------------------------------------------
	real function f_3(T)

		real T

		if (T .LE. -3.0) then
			f_3 = 0
		endif
		if (T .GT. -3.0 .AND. T .LE. 7.0) then
			f_3 = 1.3
		endif
		if (T .GT. 7.0 .AND. T .LE. 60.0) then
			f_3 = 1.472 - T * 0.0245
		endif
		if (T. GT. 60.0) then
			f_3 = 0
		endif 

		return
	end
c	-----------------------------------------------------------------------------
	real function g_3(W)

		real W, g_1

		g_3 = g_1(W)

		return
	end
c	-----------------------------------------------------------------------------
	real function f_4(T)

		real T

		if (T .LE. -5.0) then
			f_4 = 0
		endif
		if (T .GT. -5.0 .AND. T .LE. 1.0) then
			f_4 = 0.1595 + 0.0319 * T
		endif
		if (T .GT. 1.0 .AND. T .LE. 20.0) then
			f_4 = 0.1754 * exp(0.0871 * T)
		endif
		if (T .GT. 20.0 .AND. T .LE. 40.0) then
			f_4 = 1
		endif
		if (T .GT. 40.0 .AND. T .LE. 80.0) then
			f_4 = 2.0 - 0.025 * T 
		endif
		if (T. GT. 80.0) then
			f_4 = 0
		endif 

		return
	end
c	-----------------------------------------------------------------------------
	real function g_4(W)

		real W

		if (W .LE. 0.4) then
			g_4  = 2.5 * W
		endif
		if (W .GT. 0.4 .AND. W .LE. 4.0) then
			g_4 = 1
		endif
		if (W .GT. 4.0 .AND. W .LE. 7.0) then
			g_4 = (7 - W)/3
		endif
		if (W .GT. 7.0) then
			g_4 = 0
		endif

		return
	end
c	-----------------------------------------------------------------------------
	real function f_5(T)

		real T

		if (T .LE. -5.0) then
			f_5 = 0
		endif
		if (T .GT. -5.0 .AND. T .LE. 1.0) then
			f_5 = 0.078 + 0.0156 * T
		endif
		if (T .GT. 1.0 .AND. T .LE. 13.0) then
			f_5 = 0.0675 * exp(0.2088 * T)
		endif
		if (T .GT. 13.0 .AND. T .LE. 25.0) then
			f_5 = 1
		endif
		if (T .GT. 25.0 .AND. T .LE. 50.0) then
			f_5 = 2.0 - 0.04 * T 
		endif
		if (T. GT. 50.0) then
			f_5 = 0
		endif 

		return
	end
c	-----------------------------------------------------------------------------
	real function g_5(W)

		real W

		if(W .LE. 0.02 .OR. W .GE. 1.2) then
			g_5 = 0
		endif
		if(W .GT. 0.02 .AND. W .LE. 0.15) then
			g_5 = 7.69 * W - 0.1538
		endif
		if(W .GT. 0.15 .AND. W .LE. 0.7) then
			g_5 = 1
		endif
		if(W .GT. 0.7 .AND. W .LT. 1.2) then
			g_5 = 2.4 - 2 * W 
		endif


		return
	end
c	-----------------------------------------------------------------------------
	real function f_6(T)

		real T

		if (T .LE. -5.0) then
			f_6 = 0
		endif
		if (T .GT. -5.0 .AND. T .LE. 1.0) then
			f_6 = 0.1595 + 0.0319 * T
		endif
		if (T .GT. 1.0 .AND. T .LE. 27.5) then
			f_6 = 0.1754 * exp(0.0871 * T)
		endif
		if (T .GT. 27.5 .AND. T .LE. 35.0) then
			f_6 = 1.95
		endif
		if (T .GT. 35.0 .AND. T .LE. 60.0) then
			f_6 = 4.68 - 0.078 * T 
		endif
		if (T. GT. 60.0) then
			f_6 = 0
		endif 

		return
	end
c	-----------------------------------------------------------------------------
	real function g_6(W)

		real W

		if (W .LE. 0.4) then
			g_6 = 2.5 * W
		else
			g_6 = 1
		endif

		return
	end

c	-----------------------------------------------------------------------------
	real function power (a, x)

	real a, x

		power = exp(x*log(a))

		return
      end
c	-----------------------------------------------------------------------------          

c	-----------------------------------------------------------------------------
c	The following are the k coefficients for the decomposition rate, depending on
c	litter ash and N content. The two values are given as parameters (absolute 
c	values g/g, NOT percentage as in Romul equations!) so that the same functions
c	can be used whether the parameter values are for a spesific cohort or litter
c	in general. These are the "new" functions as in the "Romul updated equations".
c
c	TL October 2008. 
c	-----------------------------------------------------------------------------
	double precision function k_1L_rma(ash, N)

		double precision ash, N

		k_1L_rma = 0.0005 + 0.54 * N

		return
	end
c	-----------------------------------------------------------------------------
	double precision function k_1S_rma(ash, N)

		double precision ash, N

		k_1S_rma = 0.0136 + 0.06 * ash

		return
	end
c	-----------------------------------------------------------------------------
	double precision function k_2L_rma(ash, N)

		double precision ash, N

		k_2L_rma = 0.00060

		return
	end
c	-----------------------------------------------------------------------------
	double precision function k_2S_rma(ash, N)

		double precision ash, N

		k_2S_rma = 0.00126

		return
	end
c	-----------------------------------------------------------------------------
	double precision function k_3L_rma(ash, N)

		double precision ash, N


		k_3L_rma = 0.0089 + 0.78 * N

		return
	end
c	-----------------------------------------------------------------------------
	double precision function k_3S_rma(ash, N)

		double precision ash, N


		if (ash .LT. 0.18) then
              k_3s_rma = 0.0394 - 0.21 * ash
		else
              k_3S_rma = 0.0394 - 0.21 * 0.18
		endif

		return
	end
c	-----------------------------------------------------------------------------
	double precision function k_4_rma(ash, N)

		double precision ash, N

		if (N .LE. 0.02) then
			k_4_rma = 0.05 * N
		else
			k_4_rma = 0.001
		endif

	return
	end
c	-----------------------------------------------------------------------------
	double precision function k_5_rma(ash, N)

		double precision ash, N

		if (N .LE. 0.005) then
			k_5_rma = 0
		else
			if (N .GE. 0.02) then
				k_5_rma = 0.007
			else
				k_5_rma = 0.007 * (100*(2*N - 0.01)/3)
			endif
		endif
	return
	end
c	-----------------------------------------------------------------------------
	double precision function k_6_rma()
      
  		k_6_rma = 0.00006
c  		k_6_rma = 0.00015

	return
	end
c	-----------------------------------------------------------------------------
      
c ****************************************************************
c
c Subroutine simulates the soil water content in two layers,
c organic layer on top and mineral soil layer in bottom.
c
c Input/output parameters: SW (SoilWater, absolute, in mm)
c			   theta (output for calc, 0 = WP and 1 = sat)
c			   prec (precipitation, in mm)
c			   ET_tot (total evapotranspiration in mm)
c
c Local parameters per layer: saturation (mm), FC (mm), WP (mm), tau (days)
c			      ET_ratio (split of ET between layers)
c
c ****************************************************************

      Subroutine two_layer_soil_water(SoilW, SWmax, theta, prec, ET_tot) 

c local variables
      	integer i
      	real theta(2), SoilW(2), ET_tot, prec
          real FC(2), WP(2), saturation(2), ET(2)
      	real tau_soil(2), ET_ratio, overflow
      	real P1, P2, P_H, P_M
          real SWmax(2)
          
c     Soil water submodel parameters
	ET_ratio = 0.256107371  
	tau_soil(1) = 0.894587365
	tau_soil(2) = 9.418136372
	saturation(1) = SWmax(1)/0.65
	saturation(2) = SWmax(2)/0.65
c	WP(1) = 2.09
c	WP(2) = 13.1264
      wp(1) = 0
      wp(2) = 0
      FC(1) = WP(1) + SWmax(1)
      FC(2) = WP(2) + SWmax(2)
c	FC(1) = 14.375
c	FC(2) = 128
      
c Split evapotranspiration for the two layers         
	ET(1) = ET_ratio * ET_tot
	if(ET(1) .gt. SoilW(1)) then
		ET(1) = SoilW(1)
	endif
	ET(2) = ET_tot - ET(1)
        
  
c Soilwater of organic layer from previous day over field capacity? -> overflow          
	if (SoilW(1) .gt. FC(1)) then
		overflow = (SoilW(1) - FC(1)) / tau_soil(1)
 		SoilW(1) = FC(1)
	else
		overflow = 0
	endif
          
	SoilW(1) = SoilW(1) + prec - ET(1)

c New soil water of organic layer over saturation -> immediately drainage
	if (SoilW(1) .gt. saturation(1)) then
		overflow = overflow + (SoilW(1) - saturation(1))
		SoilW(1) = saturation(1)
	endif

c          SoilW(2) = max(SoilW(2), SoilWP(2))
          
c Mineral soil over FC -> overflow
	if (soilW(2) .gt. FC(2)) then
		soilW(2) = soilW(2) - (soilW(2) - FC(2)) / tau_soil(2)
	endif
          
c Now add new water and subtract ET
	SoilW(2) = SoilW(2) + overflow - ET(2)
          
	if (soilW(2) .gt. saturation(2)) then
		soilW(2) = saturation(2)
c		overflow = saturation(2) - SoilW(2)
	endif
          
	if (SoilW(2) .lt. WP(2)) then
		ET(2) = ET(2) - (WP(2) - SoilW(2))
 		soilW(2) = WP(2)
	endif
          
	ET_tot = ET(1) + ET(2)

	theta(1) = (soilW(1) - WP(1)) / (Saturation(1) - WP(1))
	theta(2) = (soilW(2) - WP(2)) / (Saturation(2) - WP(2))
          

	return
      end    
      
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c This is an annual version of ROMUL as reported by Chertov et al. 2001
c
c AM August 2012
c
c Modified by TL October 2013
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc      

      	subroutine ROMUL_AN(litter,litter_N,T,SW,Navail,
     +                site, year, init)

	implicit none

c litterfall by cohort, soil temperature and water content for organic (==1)  and mineral soil layer (==2)  
      double precision litter(11), litter_N(11)
      real T(2), SW(2)
      
c mass storages are save-variables, values persist from one call to another
c First dimension of pools is for the SOM cohort, the second for spatial locations
c (except only one pool per geographic location for humus)
      double precision Lpool(11,4000), Fpool(11,4000)
      double precision LNpool(11,4000), FNpool(11,4000)
      double precision Hpool(4000), HNpool(4000)
      save Lpool, Fpool, Hpool, LNpool, FNpool, HNpool
      
      double precision Navail(4000)
	real time, Nup, fnf, gnf, fnwb, Ndemand, qctot
	integer site, year, init
      
      integer local_year
      static local_year

      real f_1, f_2, f_3, f_4, f_5, f_6
      real g_1, g_2, g_3, g_4, g_5, g_6
c
c * N pools etc
c
c  litter in 11 separate pools
c  all have L and F fractions, one H fraction
c  all fractions have SOM and N
c  cohorts are order thus:
c     1   foliage
c     2   branches
c     3   stems
c     4   fine roots
c     5   coarse roots
c     6   foliage of felling residue
c     7   branches of felling residue
c     8   stems of felling residue
c     9   fine roots of felling residue
c     10  coarse roots of felling residue
c     11  ground vegetation
c

c parameters - following ROMUL 
c
c	kL		specific rate of leaching (yr-1)	1.0
c	kDL(i)  specific rate of litter decomposition (yr-1)	0.3
c	kDF(i)	specific rate of SOM decomposition (yr-1)	0.3
c 	kTL(i)	specific rate of transfer from litter to SOM  (yr-1)
c	kTF(i)	specific rate of transfer from SOM to humus, comp. 1  (yr-1)	0.3
c	kTF2(i)	specific rate of transfer from SOM to humus, comp. 2  (yr-1)	0.3
c	kDH		specific rate of humus decomposition (yr-1)	1/6000
c	kUG		maximum specific N uptake rate of ground vegetation (yr-1)	100
c	DeposN  N deposition (free input) (kg yr-1)	1
c
c     ash_cont(i) ash content of cohorts
c     fnf     foliar N concentration in live foliage
c	gnf		retention of foliar N when shedding foliage 0.45
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

c Declare internal variables

      double precision DeposN, LeachN
	double precision d_Lpool(11),d_Fpool(11),d_HumusPool
      double precision d_LNpool(11),d_FNpool(11),d_HumusNPool
	double precision d_Navail
c	real N_coeff_GV1,N_coeff_GV2,N_Coeff_TR
c	real fnw, fnr
      double precision fn(11)
	real kL, kM, DM
      double precision kDL(11), kDH
      double precision kDF(11)
      double precision kTL(11)
      double precision kTF(11),kTF2(11)
c      double precision fg(3), fgs(6)
      real LKP_decomp
      double precision K_1S_rma, K_2S_rma,K_3S_rma, k_1L_rma,K_2L_rma
      double precision k_3L_rma, k_4_rma,k_5_rma,k_6_rma
      double precision ML, MF(11), MFres(11), MH, gamma, GVN1, GVN2
	double precision N_release, FH_FluxB, FH_fluxL, FHN_FluxB, FHN_fluxL
      double precision MF_flux, MF_min
      double precision H_miner, H_C, C_C, DeltaB, DeltaL, dL
      double precision x1, x2, ash_cont(11)
      integer inttime, i, j, k, inttimetot
      double precision Lpoolsum(5),Fpoolsum(5),LNpoolsum(5),FNpoolsum(5)
      double precision littersum(5), Fpooltot(2), FNpooltot(2), H_CN
      double precision Lpooltot(2), LNpooltot(2)
      double precision NFconc(2), NLconc(2)
      double precision Lflux(11,4000), Fflux(11,4000), Hflux(4000)
      double precision C_sum(4000), N_sum(4000)
      static lflux, fflux, hflux, C_sum, N_sum
c      N_in_litter
c      double precision LNpooltot
	double precision step
     
      
c assign parameter values      
	data kL
     1 /0.12/
c     1 /0.05/

      data (ash_cont(i) , i=1,11)
     1 /0.02,  0.02,  0.01,  0.02,  0.02, 0.02, 0.02, 0.01, 
     1 0.02, 0.01, 0.04/
      
      data fnf, gnf  /0.02, 0.45/
      
      data DeposN, kM, DM /2., 2., 0.3/
      data ML, gamma, C_C / 0.1, 0.8, 0.5/
      data deltaB, deltaL /24., 12.8/

      
c      dL = 1. - (site-200.) / 2800.
c      dL = min(dL, 1.0)
c      dL = max(dL, 0.01)
      
      dL = 1
      
c      if (site .le. 200) then
c          dL = 1
c      endif
c      if (site .ge. 3000) then
c          dL = 0
c      endif
      
      
       
      
      
      
c read inputs when coming to this subroutine for the first time (init = 1)
      if (init.eq.1) then
	   open(unit=25,file='soil.dat',status = 'old', err = 999)
         do 100 i = 1, site
      	   read(25,*) j, (Lpool(j,i),j=1,5),Lpool(11,i),
     +                     (Fpool(j,i),j=1,5),Fpool(11,i),
     +                        Hpool(i),
     +            (LNpool(j,i),j=1,5),LNpool(11,i),
     +            (FNpool(j,i),j=1,5),FNpool(11,i),
     +            HNpool(i)
             
         do 98 k = 1, 11 
            lflux(k,site) = 0
            fflux(k,site) = 0
            C_sum(site) = 0
            N_sum(site) = 0
98       continue
         hflux(site) = 0
         
100      continue
	   close(25) 
         goto 998
999      write(*,*) "failed to open soil.dat"
         
         
         local_year = 0
         
998         return
      endif

      
c write storages to file when coming to this subroutine for the last time (init = 2)
      if (init.eq.2) then
	   open(unit=25,file='soil.dat',status = 'old')

         write(*,*) "writing soil.dat..."
         do 101 i = 1, site
              write(25,997) i,(Lpool(j,i),j=1,5),Lpool(11,i),
     +                        (Fpool(j,i),j=1,5),Fpool(11,i),
     +         Hpool(i),
     +        (LNpool(j,i),j=1,5),LNpool(11,i),
     +        (FNpool(j,i),j=1,5),FNpool(11,i),
     +            HNpool(i)
997   format(i5,12f12.2,f14.2,12f12.5,f14.3)
101      continue
	   close(25) 
         return
      endif

c      return
      
 
      if (year .ne. local_year) then
c          write(*,*) year, local_year
           local_year = year
           do 696 j = 1, 4000
              if (year .gt. 1961) then 
c                  write(99,*) year, j, C_sum(j), N_sum(j)
c              endif
              write(99,676) year, j, (Lflux(k,j), k = 1, 5) ,
     +            Lflux(11,j),(Fflux(k,j), k = 1, 5),
     +            Fflux(11,j),Hflux(j)
              endif
              do 686 k = 1, 11
                  lflux(k,j) = 0
                  fflux(k,j) = 0
                  hflux(j) = 0
                  C_sum(j) = 0
                  N_sum(j) = 0
686           continue
696       continue
      endif
676   format(2i6, 13f12.6)
      
 






c Daily calculation starts here!      

c Typpipitoisuudet Raisan kokopuunkorjuu-jutusta, Ukonmaanaho et al.
         fnf = 0.0123
         fnwb = 0.0058

c  N concentration in litter
         fn(1) = fnf * (1.-gnf)
	   fn(2) = fnwb
         fn(3) = fnwb
         fn(4) = fnf / (1.3) * (1.-gnf)
         fn(5) = fnwb
         fn(11) = 0.0042
c  N concentration in felling residues         
         fn(6) = fnf 
	   fn(7) = fnwb
         fn(8) = fnwb
         fn(9) = fnf / (1.3) 
         fn(10) = fnwb
         
c N concentration from Komarov book!         
         fn(1) = 0.004
         fn(2) = 0.004
         fn(3) = 0.0015
c         fn(4) = 0.004
         fn(4) = 0.0005
         fn(5) = 0.0025
         fn(6) = 0.008
         fn(7) = 0.0045
         fn(8) = 0.0017
         fn(9) = 0.006
         fn(10) = 0.003
         fn(11) = 0.0042
         
         do 65 i = 1, 11
             fn(i) = litter_N(i)/litter(i)
65       continue
         
c     1   foliage
c     2   branches
c     3   stems
c     4   fine roots
c     5   coarse roots
c     6   foliage of felling residue
c     7   branches of felling residue
c     8   stems of felling residue
c     9   fine roots of felling residue
c     10  coarse roots of felling residue
c     11  ground vegetation
c keep step coefficient for time being, but for daily version it equals unity!         
            step = 1
c
c         
c         inttimetot = idint(1./step)
         
c compute specific rate parameters as functions of ash content and N content
c compute total N in litter

c      N_in_litter = 0.

c first the N concentration for the F-pools:
c index 1 = organic layer, and 2 = mineral soil

      Lpooltot(1) = Lpool(1,site) + Lpool(2,site) + Lpool(3,site) + 
     +                Lpool(11,site)
      LNpooltot(1) = LNpool(1,site) + LNpool(2,site) + LNpool(3,site) +
     +                LNpool(11,site)
      Fpooltot(1) = Fpool(1,site) + Fpool(2,site) + Fpool(3,site) + 
     +                Fpool(11,site)
      FNpooltot(1) = FNpool(1,site) + FNpool(2,site) + FNpool(3,site) +
     +                FNpool(11,site)
      Fpooltot(2) = Fpool(4,site) + Fpool(5,site)
      FNpooltot(2) = FNpool(4,site) + FNpool(5,site) 


      NFconc(1) = FNpooltot(1) / Fpooltot(1)
      NFconc(2) = FNpooltot(2) / Fpooltot(2)
      NLconc(1) = LNpooltot(1) / Lpooltot(1)
      NLconc(2) = LNpooltot(2) / Lpooltot(2)
      
      
      do 25 i = 1,5
                    
          if(i.ge.4) then
              kDL(i) = k_1S_rma(ash_cont(i), fn(i)) * 
     *            f_1(T(2)) * LKP_decomp(SW(2), 0.55)
             kDF(i) = k_2S_rma(ash_cont(i), NFconc(2)) * 
     *            f_2(T(2)) * LKP_decomp(SW(2), 0.55)
              kTL(i) = k_3S_rma(ash_cont(i), fn(i)) * 
c     *            f_1(T(2)) *LKP_decomp(SW(2), 0.55)
     *            f_3(T(2)) *LKP_decomp(SW(2), 0.55)
          else
              kDL(i) = k_1L_rma(ash_cont(i), fn(i)) * 
     *            f_1(T(1)) * LKP_decomp(SW(1), 0.7)
              kDF(i) = k_2L_rma(ash_cont(i), NFconc(1)) * 
     *            f_2(T(1)) * LKP_decomp(SW(1), 0.7)
              kTL(i) = k_3L_rma(ash_cont(i), fn(i)) * 
c     *            f_1(T(1)) * LKP_decomp(SW(1), 0.7)
     *            f_3(T(1)) * LKP_decomp(SW(1), 0.7)
          endif
          
          kTF(i) = k_4_rma(ash_cont(i), NFconc(2)) * 
     *            f_4(T(2)) * LKP_decomp(SW(2), 0.55)
          kTF2(i) = k_5_rma(ash_cont(i), NFconc(2)) *
     *            f_5(T(2)) * LKP_decomp(SW(2), 0.55)
          
25    continue
     
          kDL(11) = k_1L_rma(ash_cont(11), fn(11)) * 
     *            f_1(T(1)) * LKP_decomp(SW(1), 0.7)
          kDF(11) = k_2L_rma(ash_cont(11), NFconc(1)) * 
     *            f_2(T(1)) * LKP_decomp(SW(1), 0.7)
          kTL(11) = k_3L_rma(ash_cont(11), fn(11)) * 
c     *            f_1(T(1)) * LKP_decomp(SW(1), 0.7)
     *            f_3(T(1)) * LKP_decomp(SW(1), 0.7)
          
          kTF(11) = k_4_rma(ash_cont(11), NFconc(2)) * 
     *            f_4(T(1)) * LKP_decomp(SW(1), 0.55)
          kTF2(11) = k_5_rma(ash_cont(11), NFconc(1)) *
     *            f_5(T(1)) * LKP_decomp(SW(1), 0.55)
                
      
      kDH = k_6_rma() * f_6(T(2)) * LKP_decomp(SW(2), 0.55)
          
      
      

c	update N pools

	Nup = 0.

c      do 100 inttime = 1, inttimetot
          


      LeachN = kL * Navail(site)
      LeachN = max(LeachN, 0.)

c      N_coeff_GV1 = min(0.5*Navail,1.)
c      N_coeff_GV2 = min(0.8*Navail,1.)
c	N_coeff_TR = min(1.0*Navail,1.)
      
c C pools: derivatives

      FH_fluxB = 0.
      FH_fluxL = 0.
      FHN_fluxB = 0.
      FHN_fluxL = 0.

      do 10 i = 1,5
          
          d_Lpool(i) = litter(i) + litter(i+5) - 
     -        (kDL(i) + kTL(i)) * Lpool(i,site)
          
          d_Fpool(i) = kTL(i) * Lpool(i,site) 
     1                 -(kDF(i) + kTF(i) + kTF2(i)) * Fpool(i,site) 
          
          FHN_fluxB = FHN_fluxB + kTF(i) * FNpool(i,site) 
          FHN_fluxL = FHN_fluxL + kTF2(i) * FNpool(i,site) 
          FH_fluxB = FH_fluxB + kTF(i) * Fpool(i,site)
          FH_fluxL = FH_fluxL + kTF2(i) * Fpool(i,site) 
          
c          Lflux(i,site) = Lflux(i,site) + kDL(i) * Lpool(i,site)
c          Fflux(i,site) = Fflux(i,site) + kDF(i) * Fpool(i,site) 

10    continue
          
c          Hflux(site) = Hflux(site) + kDH* Hpool(site)
          


          d_Lpool(11) = litter(11)  - 
     -        (kDL(11) + kTL(11)) * Lpool(11,site)
          
          d_Fpool(11) = kTL(11) * Lpool(11,site) 
     1                 -(kDF(11) + kTF(11) + kTF2(11)) * Fpool(11,site) 
          
          FHN_fluxB = FHN_fluxB + kTF(11) * FNpool(11,site) 
          FHN_fluxL = FHN_fluxL + kTF2(11) * FNpool(11,site)  
          FH_fluxB = FH_fluxB + kTF(11) * Fpool(11,site)
          FH_fluxL = FH_fluxL + kTF2(11) * Fpool(11,site) 
      
      
c          Lflux(11,site) = Lflux(11,site) + kDL(11) * Lpool(11,site)  
c          Fflux(11,site) = Fflux(11,site) + kDF(11) * Fpool(11,site) 

      
      
      
      
           d_HumusPool = DeltaB * FHN_fluxB + DeltaL * FHN_fluxL 
     +                 - kDH * Hpool(site)
 
c calculate MF(i) 

      do 11 i = 1,5
          
          if((100.*NFconc(2) - 1.16 * 100.*NFconc(1)) . le. 0.44) then
              MF(i) = 0.1
          else 
              if((100.*NFconc(2) - 1.16*100.*NFconc(1)) . le. 1.50) then
                  MF(i) = 0.5
              else
                  MF(i) = 1.0
              endif
          endif
          
         
11    continue

          if((100.*NFconc(2) - 1.16 * 100.*NFconc(1)) . le. 0.44) then
              MF(11) = 0.1
          else 
              if((100.*NFconc(2) - 1.16*100.*NFconc(1)) . le. 1.50) then
                  MF(11) = 0.5
              else
                  MF(11) = 1.0
              endif
          endif
          
      
      
      
c MF_flux is transferred from F to H, MF_min is released
      
      MF_flux = 0.
      MF_min = 0.
      
      do 20 i = 1,5
          

          d_LNpool(i) = litter_N(i) + litter_N(i+5) 
     1                 - (ML*kDL(i) + kTL(i)) * LNpool(i,site)
          
           
          d_FNpool(i) = (kTL(i)) * LNpool(i,site) 
     1                  - MF(i) * kDF(i) * FNpool(i,site)
     1                  -(kTF(i) + kTF2(i)) * FNpool(i,site) 

          MF_flux = MF_flux + (1-MF(i)) * kDF(i) * FNpool(i,site)
          MF_min = MF_min + MF(i) * kDF(i) * FNpool(i,site)
          
          Lflux(i,site) = Lflux(i,site) + ML*kDL(i) * LNpool(i,site)
          Fflux(i,site) = Fflux(i,site) + MF(i)*kDF(i) * FNpool(i,site)

          
          
20    continue

      
      
          d_LNpool(11) = fn(11) * litter(11) 
     1                 - (ML*kDL(11) + kTL(11)) * LNpool(11,site)
          
           
          d_FNpool(11) = (kTL(11)) * LNpool(11,site) 
     1                  - MF(11) * kDF(11) * FNpool(11,site)
     1                  -(kTF(11) + kTF2(11)) * FNpool(11,site) 

          MF_flux = MF_flux + (1-MF(11)) * kDF(11) * FNpool(11,site)
          MF_min = MF_min + MF(11) * kDF(11) * FNpool(11,site)
 
          Lflux(11,site) = Lflux(11,site) + ML*kDL(11) * LNpool(11,site)
          Fflux(11,site) = Fflux(11,site) + MF(11)*kDF(11) * 
     *              FNpool(11,site)

          
          
      
       if(HNpool(site) .gt. 0.) then
          H_CN = Hpool(site) / HNPool(site) / 2.
      else
          H_CN = 100.
      endif
      
      if(H_CN .gt. 8.) then
          MH = 0.8
      else
          MH = 1.
      endif
      
          
          d_HumusNPool = 
     +                   - kDH * MH * HNpool(site)
     1                   + gamma * (FHN_fluxB + FHN_fluxL)
          

      
C  Calculate mineralised carbon
      
      H_miner = kDH * Hpool(site) + FH_fluxB + FH_fluxL
     1                 - DeltaB * FHN_fluxB - DeltaL * FHN_fluxL
     1                 - DeltaB * kM * Navail(site)
      
      do 15 i = 1,5
          H_miner = H_miner + kDL(i) * Lpool(i,site)
     +              + kDF(i) * Fpool(i,site)
15    continue
      
          H_miner = H_miner + kDL(11) * Lpool(11,site)
     +              + kDF(11) * Fpool(11,site)

      
      H_C = C_C * H_miner
      C_sum(site) = C_sum(site) + H_C
      
c calculate N release

      N_release =    kDH * MH * HNpool(site) 
     1              + (1. - gamma) *(FHN_fluxB + FHN_fluxL)     
     1                 + DeposN
c     1                - kM * Navail(site) + DeposN

      Hflux(site) = Hflux(site) + kDH* MH * HNpool(site)
      
      
      do 16 i = 1,5
          N_release = N_release + ML * kDL(i) * LNpool(i,site) 
     1                + MF(i) * kDF(i) * FNpool(i,site)


16    continue
      
          N_release = N_release + ML * kDL(11) * LNpool(11,site) 
     1                + MF(11) * kDF(11) * FNpool(11,site)


  	d_Navail = N_release  - LeachN 
c     1             - N_coeff_TR * Ndemand  
c     1             - N_coeff_GV1 * Gr_GVegN1 - N_coeff_GV2 *  Gr_GVegN2


c Update pools - use simple Euler

      do 17 i = 1, 5
c daily version -> step equals one!         
          Lpool(i,site) = Lpool(i,site) + d_Lpool(i) * step
          Fpool(i,site) = Fpool(i,site) + d_Fpool(i) * step
          LNpool(i,site) = LNpool(i,site) + d_LNpool(i) * step
          FNpool(i,site) = FNpool(i,site) + d_FNpool(i) * step
17    continue
      
          Lpool(11,site) = Lpool(11,site) + d_Lpool(11) * step
          Fpool(11,site) = Fpool(11,site) + d_Fpool(11) * step
          LNpool(11,site) = LNpool(11,site) + d_LNpool(11) * step
          FNpool(11,site) = FNpool(11,site) + d_FNpool(11) * step

      
      HPool(site) = HPool(site) + d_HumusPool * step
	HNPool(site) = HNPool(site) + d_HumusNPool * step
	Navail(site) = Navail(site) + d_Navail * step
      
      N_sum(site) = N_sum(site) + d_Navail * step
      
c      Navail(site) = max(Navail(site), 0.)


    
      
      return
      end subroutine ROMUL_AN
