import os
from string import Template

import scipy.constants as co

import cases

INPATH = '.'

def main():
    with open(os.path.join(INPATH, 'electrons_tmpl.yaml')) as ftmpl:
        tmpl = Template(ftmpl.read())

        
    for eng in cases.Primary_Energies:
        for n in cases.NParticles:
            dist = cases.List_Distances(n, eng)
            if n >= 1e5 and eng >= 1e4:
                for i in range(10):
                    filled = tmpl.safe_substitute(
                        end_time=1e-6,
                        init_particle_energy= eng * co.kilo * co.eV,
                        init_particles=int(n / 10),
                        random_seed=i + 1,
                        z_wall=[x * co.centi for x in dist])
                    fname = os.path.join(INPATH,
                                         ("grrr_electrons_N%.0e_E%.0e_%.2d_f.yaml"
                                          % (n, eng * co.kilo, i)))
                    with open(fname, "w") as fout:
                        fout.write(filled)
            else:
                filled = tmpl.safe_substitute(
                    end_time=1e-6,
                    init_particle_energy= eng * co.kilo * co.eV,
                    init_particles=int(n),
                    random_seed=1,
                    z_wall=[x * co.centi for x in dist])
                fname = os.path.join(INPATH, ("grrr_electrons_N%.0e_E%.0e_f.yaml"
                                             % (n, eng * co.kilo)))
                with open(fname, "w") as fout:
                    fout.write(filled)
            

            print(fname, n, eng, dist)
                    

            
if __name__ == '__main__':
    main()


