import itertools

Primary_Energies = [0.1e3, 0.4e3, 1.0e3, 10.0e3, 40.0e3]  # keV
NParticles       = [1e4, 1e6]


def main():
    for eng in Primary_Energies:
        for N in NParticles:
            print(N, eng, List_Distances(N, eng))


def List_Distances_10k(Primary_Energy):
    if Primary_Energy==0.1e3:
        return range(1,20,1)
    if Primary_Energy==0.4e3:
        return range(10,250,10)
    if Primary_Energy==1.0e3:
        return range(25,400,25)
    if Primary_Energy==10.0e3:
        return range(500,5500,500)
    if Primary_Energy==40.0e3:
        return range(1000,25000,1000)
    

def List_Distances_1M(Primary_Energy):
    if Primary_Energy==0.1e3:
        return [6.27]
    if Primary_Energy==0.4e3:
        return [56.5]
    if Primary_Energy==1.0e3:
        return [190]
    if Primary_Energy==10.0e3:
        return [2010]
    if Primary_Energy==40.0e3:
        return [6380]
        
def List_Distances(N, Primary_Energy):
    return list({1e4: List_Distances_10k,
                 1e6: List_Distances_1M}[N](Primary_Energy))


if __name__ == '__main__':
    main()


