!-----------------------------------------------------------------------
! Step 1: Initialization
!-----------------------------------------------------------------------

      implicit none

!     ------------
!     EGS5 COMMONs
!     ------------
      include 'include/egs5_h.f'                

      include 'include/egs5_bounds.f'
      include 'include/egs5_media.f'
      include 'include/egs5_misc.f'
      include 'include/egs5_thresh.f'
      include 'include/egs5_useful.f'
      include 'include/egs5_usersc.f'
      include 'include/randomm.f'


      common/geom/zbound
      real*8 zbound


      real*8 ein,xin,yin,zin,                        ! Arguments
     *       uin,vin,win,wtin,ti
      integer iqin,irin, ncase

      integer i,j                                    ! Local variables
      character*24 medarr(1)

!     ----------
!     Open files
!     ----------
      open(UNIT= 6,FILE='~/',
     &STATUS='unknown')
!-----------------------------------------------------------------------
!     ====================
      call counters_out(0)
!     ====================

!-----------------------------------------------------------------------
! Step 2: pegs5-call
!-----------------------------------------------------------------------
!     ==============
      call block_set                 ! Initialize some general variables
!     ==============

      nmed=1
      medarr(1)='AIR AT NTP              '

      do j=1,nmed
        do i=1,24
          media(i,j)=medarr(j)(i:i)
        end do
      end do  



      chard(1) = 0.1d0 

!     ---------------------------------------------
!     Run KEK version of PEGS5 before calling HATCH
!     (method was developed by Y. Namito - 010306)
!     ---------------------------------------------

      write(6,100)
100   FORMAT(' PEGS5-call comes next'/)

!     ==========
      call pegs5
!     ==========

!-----------------------------------------------------------------------
! Step 3: Pre-hatch-call-initialization
!-----------------------------------------------------------------------
      nreg=3
      med(1)=0
      med(3)=0
      med(2)=1
! Vacuum in regions 1 and 3, air in region 2
      ecut(2)=50e-3

      pcut(2)=50e-3

      luxlev = 1
      inseed= 5
      write(6,120) inseed
120   FORMAT(/,' inseed=',I12,5X,
     *         ' (seed for generating unique sequences of Ranlux)')

!     =============
      call rluxinit  
!     =============

!-----------------------------------------------------------------------
! Step 4:  Determination-of-incident-particle-parameters
!-----------------------------------------------------------------------
      iqin=Q  ! Particle charge = {-1,0,1}
      ein= Et  ! Particle total energy; Et = E_k + E_r
      xin=0.0
      yin=0.0
      zin=0.0
      uin=0.0
      vin=0.0
      win=1.0
      irin=2
      wtin=1.0

!-----------------------------------------------------------------------
! Step 5:   hatch-call
!-----------------------------------------------------------------------
      emaxe = ein ! Maximum energy equals to the initial

      open(UNIT=KMPI,FILE='pgs5job.pegs5dat',STATUS='old')
      open(UNIT=KMPO,FILE='egs5job.dummy',STATUS='unknown')

      write(6,140)
140   FORMAT(/,' HATCH-call comes next',/)

!     ==========
      call hatch
!     ==========

      close(UNIT=KMPI)
      close(UNIT=KMPO)

      write(6,150) ae(1)-RM, ap(1)
150   format(/' Knock-on electrons can be created and any electron ',
     *'followed down to' /T40,F8.3,' MeV kinetic energy'/
     *' Brem photons can be created and any photon followed down to',
     */T40,F8.3,' MeV')
!-----------------------------------------------------------------------
! Step 6:  Initialization-for-howfar
!-----------------------------------------------------------------------
      zbound= z
!z = Detector plane
!-----------------------------------------------------------------------
! Step 7:  Initialization-for-ausgab
!-----------------------------------------------------------------------
! Print header for output - which is all ausgab does in this case
      write(6,160)
160   format(/T19,'Charge',T27,'Kinetic energy(keV)',T48, 
     *'Position x,y,z',T65,'time')
     
!-----------------------------------------------------------------------
! Step 8:  Shower-call
!-----------------------------------------------------------------------
! Do a shower call for k different detection planes
! and for n particles
      
       do j = 1,k 
       do i = 1,n
        call shower(iqin,ein,xin,yin,zin,uin,vin,win,irin,wtin)
       end do 
      
       zbound = zbound + 10
       end do 
  
!-----------------------------------------------------------------------
! Step 9:  Output-of-results
!-----------------------------------------------------------------------
		call counters_out(1)
      stop
      end
!-------------------------last line of main code------------------------

!-------------------------------ausgab.f--------------------------------
      subroutine ausgab(iarg)

      implicit none

      include 'include/egs5_h.f'                ! Main EGS "header" file

      include 'include/egs5_stack.f'     ! COMMONs required by EGS5 code
      include 'include/egs5_useful.f'

      integer iarg                                          ! Arguments
      
      real*8 ekine , timens! Local variables

      timens = time(np)*10**9
      if (iarg.eq.3.and.ir(np).eq.3) then
         if (iq(np).eq.0) then
         ekine=e(np)*10**3
       else
        ekine=(e(np)-RM)*10**3
         end if
         write(6,'(I2,5E15.7)') iq(np),ekine,x(np),y(np),z(np),timens
       end if
      return
      end

!--------------------------last line of ausgab.f------------------------

!-------------------------------howfar.f--------------------------------
      subroutine howfar

      implicit none

      include 'include/egs5_h.f'                ! Main EGS "header" file

      include 'include/egs5_epcont.f'    ! COMMONs required by EGS5 code
      include 'include/egs5_stack.f'

      common/geom/zbound
      real*8 zbound
      real*8 tval                              ! Local variable

      if (ir(np).eq.3) then
        idisc=1
        return
      else if (ir(np).eq.2) then
        if (w(np).gt.0.0) then
          tval=(zbound-z(np))/w(np)
          if (tval.gt.ustep) then
            return
          else
            ustep=tval
            irnew=3
            return
          end if
        else if (w(np).lt.0.0) then
          tval=-z(np)/w(np)
          if (tval.gt.ustep) then
            return
          else
            ustep=tval
            irnew=1
            return
          end if
        else if (w(np).eq.0.0) then
          return
        end if
      else if (ir(np).eq.1) then
        if (w(np).gt.0.0) then
          ustep=0.0
          irnew=2 
          return 
        else
          idisc=1
          return
        end if
      end if
      end

!--------------------------last line of howfar.f------------------------
