
//

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

#include "BasePrimaryGeneratorAction.hh"

#include "BaseDetectorConstruction.hh"

#include "G4SystemOfUnits.hh"
#include "G4UnitsTable.hh"
#include "G4Event.hh"
#include "G4ParticleGun.hh"
#include "G4ParticleTable.hh"
#include "G4ParticleDefinition.hh"
#include "Randomize.hh"

//Print position of primaries.
#define POSITION 0

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

extern int type;
extern double energy;

BasePrimaryGeneratorAction::BasePrimaryGeneratorAction()
  :rndmVertex(false)
{
  //default kinematic
  G4int n_particle = 1;
  particleGun  = new G4ParticleGun(n_particle);
  
  G4ParticleDefinition* particle;
  
  if (type==0)
  { particle = G4ParticleTable::GetParticleTable()->FindParticle("gamma");}
  else if (type==-1)
  { particle = G4ParticleTable::GetParticleTable()->FindParticle("e-");}
  else if (type==1)
  { particle = G4ParticleTable::GetParticleTable()->FindParticle("e+");}
  else
  {G4cout << "ERROR : NOT A VALID PARTICLE TYPE (not O, -1 or 1)" << G4endl ;}  
  //G4ParticleDefinition* particle = G4ParticleTable::GetParticleTable()->FindParticle("gamma");
  //G4ParticleDefinition* particle = G4ParticleTable::GetParticleTable()->FindParticle("e-");

  particleGun->SetParticleDefinition(particle);
  particleGun->SetParticleEnergy(energy*MeV);

  //Momentum Direction
  particleGun->SetParticleMomentumDirection(G4ThreeVector(0.0,0.0,1.0));
  //particleGun->SetParticleMomentumDirection(G4ThreeVector(0.4,0.4,0.67));
    G4double x0 = 0.0*cm;
  G4double y0 = 0.0*cm;
  G4double z0 = 0.0*cm;
  
  particleGun->SetParticlePosition(G4ThreeVector(x0,y0,z0));
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

BasePrimaryGeneratorAction::~BasePrimaryGeneratorAction()
{
  delete particleGun;
  }

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

void BasePrimaryGeneratorAction::GeneratePrimaries(G4Event* anEvent)
{
  
  
  
  particleGun->GeneratePrimaryVertex(anEvent);
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....


