
//
#include "BaseAnalysisManager.hh"
#include <fstream>
#include <iomanip>
#include "globals.hh"
#include "G4SystemOfUnits.hh"
#include "G4Track.hh"
#include "G4ios.hh"
#include "G4SteppingManager.hh"
#include "G4ThreeVector.hh"
#include "G4PhysicalConstants.hh"

extern G4String filename111;
extern int type;
extern double energy;

BaseAnalysisManager* BaseAnalysisManager::instance = 0;

bool wroteHeader=false;


//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

BaseAnalysisManager::BaseAnalysisManager()
{
  
  asciiFileName1=filename111;
  std::ofstream asciiFile1(asciiFileName1);
  
  
}


//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

BaseAnalysisManager::~BaseAnalysisManager()
{;}


//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

BaseAnalysisManager* BaseAnalysisManager::getInstance()
{
    if (instance == 0) instance = new BaseAnalysisManager;
    return instance;
}


//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

void BaseAnalysisManager::analyseStepping(const G4Track& aTrack)
{
  
    G4String name = aTrack.GetParticleDefinition()->GetParticleName();
    G4double xpos=aTrack.GetPosition().x()/cm;          //X-position
    G4double ypos=aTrack.GetPosition().y()/cm;          //Y-position
    G4double zpos=aTrack.GetPosition().z()/cm;          //Z-position
    G4double kenergy=aTrack.GetKineticEnergy()/keV;        //Kinetic Energy
    G4double time=aTrack.GetGlobalTime()/nanosecond;       //Time

     //G4cout << kenergy << G4endl;
    


    std::ofstream asciiFile1(asciiFileName1, std::ios::app);

    if (!wroteHeader) {

      G4String partname;
      if (type==-1) {partname="ELECTRONS";}
    if (type==0) {partname="PHOTONS";}
      if (type==1) {partname="POSITRONS";}

      G4String text = "# GEANT4D 1000k "
      + std::to_string(int(energy/keV)) + " keV " + partname
      + ": ID  E (keV)  x (cm)  y (cm)  z (cm)  t (ns)";


      asciiFile1 << text << G4endl;
      wroteHeader=true;
    }


    asciiFile1 <<  std::scientific << std::setprecision(8);

    if(name=="gamma" && kenergy>=50){
        asciiFile1 << "0 " << kenergy << " " << xpos << " " << ypos << " " << zpos  << " " << time << G4endl;}
    if(name=="e-" && kenergy>=50){
        asciiFile1 << "-1 " << kenergy << " " << xpos << " " << ypos << " " << zpos  << " " << time << G4endl;}
    if(name=="e+" && kenergy>=50){    
        asciiFile1 << "+1 " << kenergy << " " << xpos << " " << ypos << " " << zpos  << " " << time << G4endl;}

} 




//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....
void BaseAnalysisManager::finish() 
{  

}


