
//

#ifndef BaseTrackingAction_h
#define BaseTrackingAction_h 1

#include "G4UserTrackingAction.hh"
#include "BaseDetectorConstruction.hh"
#include "BasePrimaryGeneratorAction.hh"
#include "globals.hh"
#include <fstream>

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

class BaseTrackingAction : public G4UserTrackingAction {

  public:  
    BaseTrackingAction(G4String filename1);
    virtual ~BaseTrackingAction();
    void PostUserTrackingAction(const G4Track*);
    void PreUserTrackingAction(const G4Track*);

    G4int getAvCtr(){return firstAvCtr;};
    G4double getAvCtr2(){return secondAvCtr;};
    
private:
    G4int firstAvCtr;
    G4double secondAvCtr;
    std::ofstream file1;
};

#endif
