
//

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

#ifndef BaseDetectorConstruction_h
#define BaseDetectorConstruction_h 1

#include "G4VUserDetectorConstruction.hh"
#include "globals.hh"
#include "G4ThreeVector.hh"
#include "G4RotationMatrix.hh"


class G4Box;
class G4Trd;
class G4LogicalVolume;
class G4VPhysicalVolume;
class G4Material;
class G4UniformMagField;

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

class BaseDetectorConstruction : public G4VUserDetectorConstruction
{
public:
  BaseDetectorConstruction();
  ~BaseDetectorConstruction();

public:  
     
  G4VPhysicalVolume* Construct();
     
public:

  void PrintDetectorParameters();
                    
  G4double GetWorldSizeXY()          {return WorldSizeXY;};
  G4double GetWorldSizeZ()           {return WorldSizeZ;};

  G4double GetMeasureVolumeSizeXY()  {return MeasureVolumeSizeXY;}; 
  G4double GetMeasureVolumeSizeZ()   {return MeasureVolumeSizeZ;};

  G4Material* GetWorldMaterial()           {return WorldMaterial;};
  G4Material* GetMeasureMaterial()         {return MeasureMaterial;};
    
  const G4VPhysicalVolume* GetWorld()           {return physiWorld;};           
  const G4VPhysicalVolume* GetMeasureVolume()   {return physiMeasureVolume;};
  const G4VPhysicalVolume* GetDetector1()       {return physDetector1;};
  const G4VPhysicalVolume* GetDetector2()       {return physDetector2;};

    
private:

  G4double           WorldSizeXY;
  G4double           WorldSizeZ;

  G4double           MeasureVolumeSizeXY;
  G4double           MeasureVolumeSizeZ;
  G4double           MeasureVolumePosition;


  G4VPhysicalVolume* physiWorld;
  G4LogicalVolume*   logicWorld;  
  G4Box*             solidWorld;

  G4VPhysicalVolume* physiMeasureVolume;
  G4LogicalVolume*   logicMeasureVolume;
  G4Box*             solidMeasureBox;
    
  G4VPhysicalVolume* physDetector1;
  G4LogicalVolume*   logicDetector1;
  G4Box*             detectorBox1;
    
  G4VPhysicalVolume* physDetector2;
  G4LogicalVolume*   logicDetector2;
  G4Box*             detectorBox2;
    
  G4Material*        WorldMaterial;
  G4Material*        MeasureMaterial;
    
private:
    
  void DefineMaterials();
  G4VPhysicalVolume* ConstructCalorimeter();     
};


#endif


