

#include "G4RunManager.hh"
#include "G4UImanager.hh"
#include "Randomize.hh"

#ifdef G4VIS_USE
#include "G4VisExecutive.hh"
#endif

#ifdef G4UI_USE
#include "G4UIExecutive.hh"
#endif

#include "LBE.hh"
//#include "G4EmPenelopePhysics.hh"
#include "FTFP_BERT_HP.hh"
#include <G4PhysListFactory.hh>

#include "BaseDetectorConstruction.hh"
#include "BasePrimaryGeneratorAction.hh"
#include "BaseRunAction.hh"
#include "BaseEventAction.hh"
#include "BaseTrackingAction.hh"
#include "BaseSteppingAction.hh"
#include "BaseSteppingVerbose.hh"

#include <time.h>
#include <iostream>
#include <fstream>

 int type;
 double energy;
 double detect_dis;
 G4String number;
 int Rand_seed;
 G4String filename;
 G4String filename111;

 
int main(int argc,char** argv) {

  std::cout << "Argument list" << std::endl;
    for (int i = 0; i < argc; ++i) {
        std::cout << argv[i] << std::endl;
    }
    
  type = std::stoi(argv[1]);
  energy= std::stod(argv[2]);
  detect_dis=std::stod(argv[3]);
  number=argv[4];
  Rand_seed=std::stoi(argv[5]);
  filename=argv[6];
    
  
  //choose the Random engine
 G4int seed = Rand_seed;
 G4Random::setTheEngine(new CLHEP::MTwistEngine);
 G4Random::setTheSeed(seed);
  
  //Base Verbose output class
  G4VSteppingVerbose::SetInstance(new BaseSteppingVerbose);
  
  // Construct the default run manager
  G4RunManager * runManager = new G4RunManager;

  // set mandatory initialization classes
  BaseDetectorConstruction* detector = new BaseDetectorConstruction;
  runManager->SetUserInitialization(detector);
  //runManager->SetUserInitialization(new BasePhysicsList);
  runManager->SetUserInitialization(new LBE());
  
  // G4PhysListFactory* physListFactory= new G4PhysListFactory();
  // G4VUserPhysicsList* physicsList=physListFactory->GetReferencePhysList("LBE_LIV");
 //  runManager->SetUserInitialization(physicsList);
  
  runManager->SetUserAction(new BasePrimaryGeneratorAction());
    
#ifdef G4VIS_USE
  // visualization manager
  G4VisManager* visManager = new G4VisExecutive;
  visManager->Initialize();
#endif

// output environment variables:
#ifdef G4ANALYSIS_USE
   G4cout << G4endl << G4endl << G4endl 
	  << " User Environment " << G4endl
	  << " Using AIDA 3.0 analysis " << G4endl;
# else
   G4cout << G4endl << G4endl << G4endl 
	  << " User Environment " << G4endl
	  << " G4ANALYSIS_USE environment variable not set, NO ANALYSIS " 
	  << G4endl;
#endif   

  // set user action classes
//   BaseRunAction* RunAct = new BaseRunAction();
//   runManager->SetUserAction(RunAct);
  runManager->SetUserAction(new BaseEventAction());

  //Tracking Action
  filename111=filename;
  
  // G4cout << filename1 << G4endl;
  
//   BaseTrackingAction* trackAction = new BaseTrackingAction(filename1);
//   runManager->SetUserAction(trackAction);



  //SteppingAction
  runManager->SetUserAction(new BaseSteppingAction(detector));

  
  //Initialize G4 kernel
  runManager->Initialize();
    
  // get the pointer to the User Interface manager 
    G4UImanager* UImanager = G4UImanager::GetUIpointer();
    // G4String command = "/control/execute heprepout.mac";

     UImanager->ApplyCommand("/process/eLoss/fluct 0"); // remove stochastic fluctuations in the continuous energy loss
    UImanager->ApplyCommand("/run/beamOn " + number);


    /*
  if (argc==1)   // Define UI session for interactive mode.
    {
#ifdef G4UI_USE
      G4UIExecutive* ui = new G4UIExecutive(argc, argv);
#ifdef G4VIS_USE
      UImanager->ApplyCommand("/control/execute vis.mac");     
#endif
      ui->SessionStart();
      delete ui;
#endif
    }
  else           // Batch mode
    { 
      G4String command = "/control/execute ";
      G4String fileName = argv[1];
      UImanager->ApplyCommand(command+fileName);
    }

*/
  // For bg jobs with 100000 events.
  /*
   int numberOfEvent = 100000;
   runManager->BeamOn(numberOfEvent);
  */


  // job termination
#ifdef G4VIS_USE
  delete visManager;
#endif
  delete runManager;

  return 0;
}

