#!/usr/bin/env python3.4

import subprocess
import os

number_of_parallel_jobs=4
    
nr_particles = 10000
list_energies = [0.1, 0.4, 1.0, 10.0, 40.0]
list_ID = [-1,0,1]

def List_Distances(Primary_ID,Primary_Energy):
    if Primary_ID==0:
        return range(5000,150000,5000)
    else:
        if Primary_Energy==0.1:
            return range(1,20,1)
        if Primary_Energy==0.4:
            return range(10,250,10)
        if Primary_Energy==1.0:
            return range(25,400,25)
        if Primary_Energy==10.0:
            return range(500,5500,500)
        if Primary_Energy==40.0:
            return range(1000,25000,1000)
                 

# define the commands to be run in parallel, run them
# example : # EGS5 10k 1 MeV PHOTONS: ID \t E (keV) \t x (cm) \t y (cm) \t z (cm) \t t (ns)
code_name='GEANT4L'
nb_file='010K'
nb_header='10k'

for E in list_energies:
    for ID in list_ID:
                D=List_Distances(ID,E)

                if ID == 0:
                    ID_header='PHOTONS'
                    ID_file='PHO'
                elif ID == -1:
                    ID_header='ELECTRONS'
                    ID_file='ELE'
                elif ID == 1:
                    ID_header='POSITRONS'
                    ID_file='POS'

                if E == 0.1:
                    ener_file='100keV'
                    ener_header='100 keV'
                elif E == 0.4:
                    ener_file='400keV'
                    ener_header='400 keV'
                elif E == 1.0:
                    ener_file='1MeV'
                    ener_header='1 MeV'
                elif E == 10.0:
                    ener_file='10MeV'
                    ener_header='10 MeV'
                elif E == 40.0:
                    ener_file='40MeV'
                    ener_header='40 MeV'
                
                filename=code_name + '_' + nb_file + '_' + ener_file + '_' + ID_file + '.TXT'
                header = '"#' + ' ' + code_name + ' ' + nb_header + ' ' + ener_header + ' ' + ID_header + ': ID \t E (keV) \t x (cm) \t y (cm) \t z (cm) \t t (ns)"'
                command='echo ' + header + ' > ' + filename
                process = os.system(command)

                command='cat'+' '+ code_name +'_' + str(ID) + '_' + str(E) + '_' + '*'+' '+'>>'+' '+ filename
                process = os.system(command)
                

              #  command='rm'+' '+'GEANT4_' + str(ID) + '_' + str(E) + '_' + '*'
             #   process = os.system(command)



