#!/usr/bin/env python3.4

from subprocess import call
from functools import partial
from multiprocessing.dummy import Pool


    
nr_particles = 1000000
list_energies = [0.1, 0.4, 1.0, 10.0, 40.0]
list_ID = [-1,0,1]

def List_Distances(Primary_ID,Primary_Energy):
    if Primary_ID==0:
        if Primary_Energy==0.1:
            return 1e4
        if Primary_Energy==0.4:
            return 1.62e4
        if Primary_Energy==1.0:
            return 2.43e4
        if Primary_Energy==10.0:
            return 7.56e4
        if Primary_Energy==40.0:
            return 9.07e4
    else:
        if Primary_Energy==0.1:
            return 6.27
        if Primary_Energy==0.4:
            return 56.5
        if Primary_Energy==1.0:
            return 1.9e2
        if Primary_Energy==10.0:
            return 2.01e3
        if Primary_Energy==40.0:
            return 6.38e3
                 
# 51,4
# define the commands to be run in parallel

commands=[]

excecutable = './Base'
seed = 1
for E in list_energies:
	for ID in list_ID:
                D=List_Distances(ID,E)

                if ID == 0:
                    ID_header='PHOTONS'
                    ID_file='PHO'
                elif ID == -1:
                    ID_header='ELECTRONS'
                    ID_file='ELE'
                elif ID == 1:
                    ID_header='POSITRONS'
                    ID_file='POS'

                if E == 0.1:
                    ener_file='100keV'
                    ener_header='100 keV'
                elif E == 0.4:
                    ener_file='400keV'
                    ener_header='400 keV'
                elif E == 1.0:
                    ener_file='1MeV'
                    ener_header='1 MeV'
                elif E == 10.0:
                    ener_file='10MeV'
                    ener_header='10 MeV'
                elif E == 40.0:
                    ener_file='40MeV'
                    ener_header='40 MeV'


                commands.append(excecutable+' '+str(ID)+' '+str(E)+' '+str(D)+' '+str(nr_particles)+' '+str(seed)+' '+'./bigfiles/GEANT4L_'+'1000K'+'_'+str(ener_file)+'_'+str(ID_file)+'.txt')



pool = Pool(2) # x concurrent commands at a time
for i, returncode in enumerate(pool.imap(partial(call, shell=True), commands)):
    if returncode != 0:
       print("%d command failed: %d" % (i, returncode))

