

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

#include "BaseSteppingAction.hh"
#include "BaseRunAction.hh"
#include "BaseDetectorConstruction.hh"

#include "G4SteppingManager.hh"
#include "G4VTouchable.hh"
#include "G4VPhysicalVolume.hh"

#include "BaseAnalysisManager.hh"
#include "G4SystemOfUnits.hh"
#include <iomanip>
#include <iostream>
#include <fstream>


//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

BaseSteppingAction::BaseSteppingAction(BaseDetectorConstruction* det)
:Detector(det)
{ }

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

BaseSteppingAction::~BaseSteppingAction()
{ }

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

void BaseSteppingAction::UserSteppingAction(const G4Step* aStep)

{
    G4Track* aTrack = aStep->GetTrack();
                   //Particle ID
      G4String name = aTrack->GetDefinition()->GetParticleName();
       // GetTrack()->SetTrackStatus(fStopAndKill);

//       if (!(name=="e+" || name=="gamma" || name=="e-")) {
//       aTrack->SetTrackStatus(fStopAndKill);
//       }
       
  G4String volName; 
  G4String nextVolName;
  
 if (aTrack->GetVolume()) volName =  aTrack->GetVolume()->GetName();
 if (aTrack->GetNextVolume()) nextVolName =  aTrack->GetNextVolume()->GetName();
 
   G4ThreeVector pos = aTrack->GetPosition()/m;
   G4double x = pos.x();
   G4double y = pos.y();
   G4double z = pos.z();
 
 if (z<0. && name=="gamma") {
      aTrack->SetTrackStatus(fStopAndKill);
 }
 
    if( nextVolName!="DetectorP1_p" && volName=="DetectorP1_p"){
      
      BaseAnalysisManager* analysis = BaseAnalysisManager::getInstance();
    
      
        analysis->analyseStepping(*aTrack);
	
        aTrack->SetTrackStatus(fStopAndKill);
        }
}
//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....
