//

#include "BaseDetectorConstruction.hh"
#include "globals.hh"
#include "G4PhysicalConstants.hh"
#include "G4SystemOfUnits.hh"
#include "G4ThreeVector.hh"
#include "G4Material.hh"
#include "G4Box.hh"
#include "G4Trd.hh"
#include "G4LogicalVolume.hh"
#include "G4PVPlacement.hh"
#include "G4PVReplica.hh"
#include "G4PVParameterised.hh"
#include "G4Mag_UsualEqRhs.hh"
#include "G4FieldManager.hh"
#include "G4UniformElectricField.hh"
#include "G4TransportationManager.hh"
#include "G4EqMagElectricField.hh"
#include "G4ElectroMagneticField.hh"

#include "G4ChordFinder.hh"
#include "G4UniformMagField.hh"
#include "G4ExplicitEuler.hh"
#include "G4ImplicitEuler.hh"
#include "G4SimpleRunge.hh"
#include "G4SimpleHeum.hh"
#include "G4ClassicalRK4.hh"
#include "G4HelixExplicitEuler.hh"
#include "G4HelixImplicitEuler.hh"
#include "G4HelixSimpleRunge.hh"
#include "G4CashKarpRKF45.hh"
#include "G4RKG3_Stepper.hh"

#include "G4VisAttributes.hh"
#include "G4Colour.hh"
#include "G4UnitsTable.hh"
#include "G4ios.hh"

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....
// Possibility to turn off (0) magnetic field and measurement volume.
//#define Layer 1          // Magnet geometric volume
#define MAG 1          // Magnetic field grid
#define MEASUREVOL 1   // Volume for measurement
//#define DETECTORVOL 1  // Volume for detectors

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

extern double detect_dis;

BaseDetectorConstruction::BaseDetectorConstruction()
:physiWorld(NULL), logicWorld(NULL), solidWorld(NULL),
physiMeasureVolume(NULL), logicMeasureVolume(NULL), solidMeasureBox(NULL),
physDetector1(NULL), logicDetector1(NULL),detectorBox1(NULL),
physDetector2(NULL), logicDetector2(NULL),detectorBox2(NULL),
WorldMaterial(NULL),
MeasureMaterial(NULL)

{
    WorldSizeXY=WorldSizeZ=0;
    MeasureVolumeSizeXY=MeasureVolumeSizeZ=0;
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

BaseDetectorConstruction::~BaseDetectorConstruction()
{}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

G4VPhysicalVolume* BaseDetectorConstruction::Construct()

{
    DefineMaterials();
    return ConstructCalorimeter();
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

void BaseDetectorConstruction::DefineMaterials()
{
    //This function illustrates the possible ways to define materials.
    //Density and mass per mole taken from Physics Handbook for Science
    //and engineering, sixth edition. This is a general material list
    //with extra materials for other examples.
    
    G4String name, symbol;
    G4double density;
    
    G4int ncomponents;
    G4double fractionmass;
    
    // Define Elements
    // Example: G4Element* Notation  = new G4Element ("Element", "Notation", z, a);
    G4Element*   N  = new G4Element ("Nitrogen", "N",  7., 14.01* g/mole);
    G4Element*   O  = new G4Element ("Oxygen"  , "O",  8., 16.00* g/mole);
    G4Element*   Ar = new G4Element ("Argon" , "Ar",  18., 39.948*g/mole);
    G4Element*   Si = new G4Element ("Silicon", "Si", 14., 28.085*g/mole);
    
    
    // Define Material from elements.
    // Example: G4Material* Notation = new G4Material("Material", atomic number z, mass of mole a, density);
    
    G4double temperature = 2.73*kelvin;
    G4double pressure = 3.e-18*pascal;
    
    //Material 1: Vacuum
    G4Material* Vacuum = new G4Material("interGalactic", 1., 1.008*g/mole, 1.e-25*g/cm3, kStateGas, temperature, pressure);
    
    //Material 2: Air
    G4double conversion = (0.78084*14.01*2 + 0.209476*16.00*2 + 0.00934*39.984)/6.02e23;
    density = 2.688e25*conversion*g/m3;
    G4Material* Air = new G4Material(name="Air", density, ncomponents=3);
    Air->AddElement(N,fractionmass=0.78085);
    Air->AddElement(O,fractionmass=0.2095);
    Air->AddElement(Ar,fractionmass=0.00965);
    
    //Material 3: Silicon
    G4Material* Silicon = new G4Material(name="Silicon",2.329*g/cm3,ncomponents=1);
    Silicon->AddElement(Si,fractionmass=1.0);
    
    // Default materials in setup.
    WorldMaterial = Vacuum;
    MeasureMaterial = Air;
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

G4VPhysicalVolume* BaseDetectorConstruction::ConstructCalorimeter()
{
    // Complete the parameters definition
    
    //The World
    WorldSizeZ   =  400000.0*m;
    WorldSizeXY  =  10.*WorldSizeZ;  // Cube

    
    //Measurement volume
    MeasureVolumeSizeXY = 1900*m;  // Inner Cubic volume
    
    
    

    
    //....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....
    //
    // World
    //
    
   // G4ElectricField* pEMfield           = new G4UniformElectricField(G4ThreeVector(0.0,0.0,0.0*kilovolt/cm));
//     G4EqMagElectricField* pEquation     = new G4EqMagElectricField(pEMfield);
//     G4int nvar                          = 8; // Need to integrate 8 variables: x,y,z, p[xyz], E, t
//     G4double pMinStep                   = 0.010*mm;
//     G4MagIntegratorStepper* pStepper    = new G4ClassicalRK4(pEquation,nvar);
//     G4MagInt_Driver* pIntgrDriver       = new G4MagInt_Driver(pMinStep, pStepper,pStepper->GetNumberOfVariables());
//     G4ChordFinder* pChordFinder         = new G4ChordFinder(pIntgrDriver);
//     G4FieldManager* pFieldMgr           = new G4FieldManager(pEMfield,pChordFinder);
//     pFieldMgr->SetChordFinder( pChordFinder );
    
    solidWorld = new G4Box("World",				    //its name
                           WorldSizeXY,WorldSizeXY,WorldSizeZ); //its size
    
    
    logicWorld = new G4LogicalVolume(solidWorld,	    //its solid
                                     MeasureMaterial,   //its material
                                     "World",         //its name
                                     0,0,0);  //Uniform Field.
    
    //logicWorld->SetFieldManager(pFieldMgr,true);
    
    physiWorld = new G4PVPlacement(0,                 //no rotation
                                   G4ThreeVector(0.,0.,0.),	//at (0,0,0)
                                   "World",           //its name
                                   logicWorld,		//its logical volume
                                   NULL,              //its mother  volume
                                   false,             //no boolean operation
                                   0);                //copy number
    
    //
    // DETECTOR 1
    //
    G4double thickness=0.000001*cm;
    detectorBox1 = new G4Box("DetectorP1_s",                         //its name
                             WorldSizeXY,WorldSizeXY,thickness);     //size
    
    logicDetector1 = new G4LogicalVolume(detectorBox1,             //its solid
                                         MeasureMaterial,          //its material
                                         "DetectorP1_l");            //its name
    
    
    physDetector1 = new G4PVPlacement(0,G4ThreeVector(0.,0.,detect_dis*cm), //no rotatio, placed at (0,0,Z)
                                      "DetectorP1_p",                //its name
                                      logicDetector1,              //its logical volume
                                      physiWorld,                  //its mother volume
                                      false,                       //no boolean volume
                                      0);                          //copy number

    
    
    // Visualization attributes
    G4VisAttributes* simpleWorldVisAtt= new G4VisAttributes(G4Colour(1.0,0.0,0.0)); //Blue
    simpleWorldVisAtt->SetVisibility(true);
    logicWorld->SetVisAttributes(simpleWorldVisAtt);
    // VISUALIZATION DETECTOR 1
    G4VisAttributes* simpleDetector1VisAtt= new G4VisAttributes(G4Colour(0.0,1.0,0.0)); //green
    simpleDetector1VisAtt->SetVisibility(true);                                         //set color on edges
    simpleDetector1VisAtt->SetForceSolid(true);                                         //set color in volume
    logicDetector1->SetVisAttributes(simpleDetector1VisAtt);
    
    
    return physiWorld;
}
//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....


