//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// Code developed by:
//  S.Larsson
//
//    **********************************
//    *                                *
//    *    BaseTrackingAction.hh    *
//    *                                *
//    **********************************
//
// $Id: BaseTrackingAction.hh 72967 2013-08-14 14:57:48Z gcosmo $
//

#ifndef BaseTrackingAction_h
#define BaseTrackingAction_h 1

#include "G4UserTrackingAction.hh"
#include "BaseDetectorConstruction.hh"
#include "BasePrimaryGeneratorAction.hh"
#include "globals.hh"
#include <fstream>

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

class BaseTrackingAction : public G4UserTrackingAction {

  public:  
    BaseTrackingAction(G4String filename1);
    virtual ~BaseTrackingAction();
    void PostUserTrackingAction(const G4Track*);
    void PreUserTrackingAction(const G4Track*);

    G4int getAvCtr(){return firstAvCtr;};
    G4double getAvCtr2(){return secondAvCtr;};
    
private:
    G4int firstAvCtr;
    G4double secondAvCtr;
    std::ofstream file1;
};

#endif
