    Info<< "Reading field p_rgh\n" << endl;
    volScalarField p_rgh
    (
        IOobject
        (
            "p_rgh",
            runTime.timeName(),
            mesh,
            IOobject::MUST_READ,
            IOobject::AUTO_WRITE
        ),
        mesh
    );

    Info<< "Reading field alpha1\n" << endl;
    volScalarField alpha1
    (
        IOobject
        (
            "alpha1",
            runTime.timeName(),
            mesh,
            IOobject::MUST_READ,
            IOobject::AUTO_WRITE
        ),
        mesh
    );


    Info<< "Reading field alpha2\n" << endl;
    volScalarField alpha2
    (
        IOobject
        (
            "alpha2",
            runTime.timeName(),
            mesh,
            IOobject::MUST_READ,
            IOobject::AUTO_WRITE
        ),
        mesh
    );


    Info<< "Reading field alpha3\n" << endl;
    volScalarField alpha3
    (
        IOobject
        (
            "alpha3",
            runTime.timeName(),
            mesh,
            IOobject::MUST_READ,
            IOobject::AUTO_WRITE
        ),
        mesh
    );

    alpha1 == 1.0 - alpha2 - alpha3;


    Info<< "Reading field U\n" << endl;
    volVectorField U
    (
        IOobject
        (
            "U",
            runTime.timeName(),
            mesh,
            IOobject::MUST_READ,
            IOobject::AUTO_WRITE
        ),
        mesh
    );

    #include "createPhi.H"

    threePhaseMixture threePhaseProperties(U, phi);

    const dimensionedScalar& rho1 = threePhaseProperties.rho1();
    const dimensionedScalar& rho2 = threePhaseProperties.rho2();
    const dimensionedScalar& rho3 = threePhaseProperties.rho3();
    const dimensionedScalar& rhoS_ = threePhaseProperties.lookup("rhoS");
    const dimensionedScalar& dS_ = threePhaseProperties.lookup("dS");
    dimensionedScalar D23(threePhaseProperties.lookup("D23"));

    // Read the reciprocal of the turbulent Schmidt number
    dimensionedScalar alphatab(threePhaseProperties.lookup("alphatab"));
    // Read a constant in analogy to the von Karman constant, to gain mixing length in dependency to cell-distance to wall
    dimensionedScalar mixingLengthFactor(threePhaseProperties.lookup("mixingLengthFactor"));
    /* Read a factor [1/s] that turns Bagnold numbers higher than 450 (Bagnolds number - 450 = intensity of grain-inertia flow) into a diffusion constant 
       of alpha3 towards the free surface. It is multiplied with the cellDiameter and wallDistance same as the eddy difusion*/
    dimensionedScalar grainInertiaDiffusivity(threePhaseProperties.lookup("grainInertiaDiffusivity"));
    // calculate an average cell size used to gain a mixing velocity in each cell from cell-vorticity, applied for eddy diffsuion
    volScalarField cellDiameter(pow(0.1666*fvc::surfaceSum(mesh.magSf()), 0.5));

    // get cell distances to walls
    volScalarField wallDistance(cellDiameter);
	const polyBoundaryMesh& patches = mesh.boundaryMesh();
    if(mixingLengthFactor.value() >= 10e-20)//Avoid long loop at startup if big mesh without eddy diffusion
    {
        Info<< "Calculating distances from cell centers to closest boundary, might take a while..." << endl;
	forAll(wallDistance, cellI)
	{
	    // get the position for the particle                                                                                                                                            
	    const vector& position = mesh.C()[cellI];

	    scalar distance = GREAT;
	    // loop over all patches                                                                                                                                                        
	    forAll(patches, patchI)
	    {
		//if (isA<wallPolyPatch>(patches[patchI])) // not working
		{
		    const polyPatch& patch = patches[patchI];
		    const vectorField& n = patch.faceNormals();
		    const vectorField& C = patch.faceCentres();
		    forAll(C, i)
		    {
		        vector normal = n[i]/mag(n[i]);
		        //scalar di = mag(position - C[i]); // distance to face centre
		        scalar di = mag( normal & ( position - C[i] ) );
		        distance = min(distance, di);
		    }
		}
	    }
	    wallDistance[cellI] = distance;
	   // Info << "distance to wall is " << distance << endl;
	}
    }

    // Need to store rho for ddt(rho, U)
    volScalarField rho
    (
        IOobject
        (
            "rho",
            runTime.timeName(),
            mesh,
            IOobject::READ_IF_PRESENT
        ),
        alpha1*rho1 + alpha2*rho2 + alpha3*rho3,
        alpha1.boundaryField().types()
    );
    rho.oldTime();


    // Mass flux
    // Initialisation does not matter because rhoPhi is reset after the
    // alpha solution before it is used in the U equation.
    surfaceScalarField rhoPhi
    (
        IOobject
        (
            "rho*phi",
            runTime.timeName(),
            mesh,
            IOobject::NO_READ,
            IOobject::NO_WRITE
        ),
        rho1*phi
    );


    // Construct interface from alpha distribution
    threePhaseInterfaceProperties interface(threePhaseProperties);


    // Construct incompressible turbulence model
    autoPtr<incompressible::turbulenceModel> turbulence
    (
        incompressible::turbulenceModel::New(U, phi, threePhaseProperties)
    );


    Info<< "Calculating field g.h\n" << endl;
    volScalarField gh("gh", g & mesh.C());
    surfaceScalarField ghf("ghf", g & mesh.Cf());

    volScalarField p
    (
        IOobject
        (
            "p",
            runTime.timeName(),
            mesh,
            IOobject::NO_READ,
            IOobject::AUTO_WRITE
        ),
        p_rgh + rho*gh
    );

    label pRefCell = 0;
    scalar pRefValue = 0.0;
    setRefCell
    (
        p,
        p_rgh,
        mesh.solutionDict().subDict("PIMPLE"),
        pRefCell,
        pRefValue
    );

    if (p_rgh.needReference())
    {
        p += dimensionedScalar
        (
            "p",
            p.dimensions(),
            pRefValue - getRefCellValue(p, pRefCell)
        );
        p_rgh = p - rho*gh;
    }

    fv::IOoptionList fvOptions(mesh);

