/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 2011 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Application
    debrisInterMixingFoam

Description
    Solver for 3 incompressible fluids, two of which are miscible,
    using a VOF method to capture the interface.
for compiling call:
 source $HOME/.OpenFOAM-vonBoett_rc
wmake debrisInterMixingFoam
 or wmake libso debrisInterMixingFoam but then parts are not updated
in the interFoam directory

\*---------------------------------------------------------------------------*/

#include "fvCFD.H"
#include "CMULES.H"
#include "subCycle.H"
#include "threePhaseMixture.H"
#include "threePhaseInterfaceProperties.H"
#include "turbulenceModel.H"
#include "pimpleControl.H"
#include "fvIOoptionList.H"
#include "fixedFluxPressureFvPatchScalarField.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

int main(int argc, char *argv[])
{
    #include "setRootCase.H"
    #include "createTime.H"
    #include "createMesh.H"
    #include "readGravitationalAcceleration.H"
    #include "initContinuityErrs.H"
    #include "createFields.H"
    #include "readTimeControls.H"
    #include "CourantNo.H"
    #include "setInitialDeltaT.H"

    pimpleControl pimple(mesh);

    #include "createPrghCorrTypes.H"
    #include "correctPhi.H"

    // * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

    Info<< "\nStarting time loop\n" << endl;

    while (runTime.run())
    {
        #include "readTimeControls.H"
        #include "CourantNo.H"
        #include "alphaCourantNo.H"
        #include "setDeltaT.H"

        runTime++;

        Info<< "Time = " << runTime.timeName() << nl << endl;

        threePhaseProperties.correct();

        #include "alphaEqnsSubCycle.H"
	interface.correct();

        #define twoPhaseProperties threePhaseProperties
	/* --- strong shear and pressure dependency of viscosity:
	   correct initial viscosity */

	volScalarField initVisc(turbulence->nu());
	Info<< "average initVisc00 = " << average(threePhaseProperties.nu()) << nl << endl;
	volScalarField initialP(p);
	volScalarField initialP_rgh(p_rgh);
	volVectorField initialVel(U);
	

	/* --- Pressure-velocity PIMPLE corrector loop which reduces to a viscosity iteration step activated if nOuterCorrectors > 1.
		if pressure and velocity are not set back to the timestep beginning, material "melts" or "freezes" due to the self-
		amplifying coupling of viscosity, velocity and pressure.*/
	while (pimple.loop())
	{
	    
		/* average velocity and pressure over the timestep length to calculate an average viscosity*/
		U = 0.5*(U + initialVel);
		p = 0.5*(initialP + p);
		p_rgh = 0.5*(initialP_rgh + p_rgh);
		/* update viscosity with "the average between initial and actual velocity" */
		threePhaseProperties.correct(); 
		Info<< "average initVisc0 = " << average(threePhaseProperties.nu()) << nl << endl;
		/* reset velocity and pressure to the beginning of timestep and perform PISO loop with viscosity according to average timestep velocity and pressure*/
		U = initialVel;
		p_rgh = initialP_rgh;
		p = initialP;
		#include "UEqn.H"		
		// --- Pressure corrector loop
		while (pimple.correct())
		{
			#include "pEqn.H"
		}
		if (pimple.turbCorr())
		{
			turbulence->correct();
		}
	}

        #include "continuityErrs.H"

        runTime.write();

        Info<< "ExecutionTime = " << runTime.elapsedCpuTime() << " s"
            << "  ClockTime = " << runTime.elapsedClockTime() << " s"
            << nl << endl;
    }

    Info<< "\n end \n";

    return(0);
}


// ************************************************************************* //

