C        Generated by TAPENADE     (INRIA, Tropics team)
C  Tapenade 3.5 (r3931) - 24 May 2011 16:28
C
C  Differentiation of sulfate in reverse (adjoint) mode:
C   gradient     of useful results: condnu delt xrow totnu pcond
C                rtdms rtcond acoefc rth totcdn rtso2 rth2s rgrid
C                rtnucl totcd
C   with respect to varying inputs: no3row ohrow t aerosize condnu
C                delt aeronum xrow rh pvol totnu pcond rtdms rtcond
C                shj rhop0 acoefc rth rhsize totcdn rtso2 rth2s
C                tcszrow rgrid rtnucl totcd cszrow pressg roarow
C                cldcv
C   RW status of diff variables: no3row:out ohrow:out t:out aerosize:out
C                condnu:incr delt:incr aeronum:out xrow:in-out
C                rh:out pvol:out totnu:in-out pcond:in-out rtdms:in-out
C                rtcond:in-out shj:out rhop0:out acoefc:in-out
C                rth:in-out rhsize:out totcdn:in-out rtso2:in-out
C                rth2s:in-out tcszrow:out rgrid:in-out rtnucl:in-out
C                totcd:in-out cszrow:out pressg:out roarow:out
C                cldcv:out
      SUBROUTINE SULFATE_B(lev,     ilev,    ilg,   il1,    il2, 
     +                     ih2s,    idms,   iso2,  iso4,  rgrid, 
     +                  aeronum,    xrow,    ntr, icomp, roarow,
     +                   pressg,       t,     rh,   shj,  totnu,
     +                    ohrow,  no3row,     nn, kount,  totcd,
     +                   rhsize,aerosize,tcszrow,cszrow,   jlat,
     +                    isize,    delt, rtnucl, rhop0,    lon,
     +                   rtcond,   rtso2,  rtdms, rth2s, totcdn,
     +                    cldcv,  acoefc, totmas,   rth,   iae1,
     +                     pvol,    tmin,  pcond,   cam,    mae,
     +                   condnu,
cccccccccccc  for ad model  cccccccccccc 
     +                  rgridb, aeronumb,  xrowb,  roarowb, pressgb,
     +                      tb,      rhb,   shjb,  totnub,   ohrowb,
     +                 no3rowb,   totcdb,rhsizeb,aerosizeb,tcszrowb,
     +                 cszrowb,    deltb,rtnuclb,   rhop0b, rtcondb,
     +                  rtso2b,   rtdmsb, rth2sb,  totcdnb,  cldcvb,
     +                 acoefcb,     rthb,  pvolb,   pcondb, condnub)


      IMPLICIT NONE
C
C     STATEMENT FUNCTION FOR ATOMIC DIFFUSION VOLUME [CM3]
C     MAKAR ET AL, 1998
C
C
C     STATEMENT FUNCTION OT COMPUTE SO4 CONCENTRATION DUE TO COMBINED
C     NUCLEATION AND CONDENSATION PROCESSES AS A FUNCTION OF TIME.
C      
      REAL y4pid3, so4mw, akb, ara, omega, expp, so4, adv
      REAL apard, apare, aconcr, apaarc, adelta, apara, aparb
      REAL apardb, aconcrb, adeltab, aparab, aparbb
      REAL aexp, frp, fn, an, dfso4, atuner, avesize, tclr
      REAL aexpb, frpb, fnb, anb, dfso4b, avesizeb, tclrb
      INTEGER n, inew, i
      REAL rk1, qoh, rkinf, rocon, rk, rk3, rh01, atempe, anw
      REAL rk1b, qohb, roconb, rkb, rk3b, rh01b, atempeb, anwb
      REAL so2pro, qno3, rto, rk4, so4t12, so4t13, so4t14, so4t11
      REAL so2prob, qno3b, rtob, rk4b, so4t12b, so4t13b, so4t14b, 
     +     so4t11b
      REAL so4t8, so4t9, so4t10, so4t15, totpar, a, w
      REAL so4t8b, so4t9b, so4t10b, so4t15b, totparb, ab
      INTEGER l, mae, iae1, isize, lon
      REAL dich, zc, adt2, cub, rk2, aparc, o2, adich, rk0, rvord
      REAL dichb, adt2b, rk2b, aparcb, o2b, adichb, rk0b
      REAL tfrez, pai, rcg0, p, ace, xiao, daylnt, hs, hv, so4t6
      REAL so4t6b
      REAL so4t7, so4t5, so4t3, so4t4, blg, condso4, totso4
      REAL so4t7b, so4t5b, so4t3b, so4t4b, blgb, condso4b, totso4b
      REAL xso2, xso4, so4t0, so2t0, d2, cond, dt, so4t1, so4t2
      REAL xso2b, xso4b, so4t0b, so2t0b, condb, so4t1b, so4t2b
      REAL pp, c, avo, cpresv, rgasv, boltzk, airmw, rgasi
      REAL ppb
      REAL cpres, g, asq, rayon, rgoasq, rgocp, rgas, t0
      REAL tmin, cam, delt, a0, rsn0, rcut0, ar, ww, tw, pi
      REAL deltb
      INTEGER il2, il1, ih2s, idms, lev, ilev, ilg, nn, kount
      INTEGER jlat, icomp, iso2, iso4, ntr
      COMMON /params/ ww, tw, rayon, asq, g, rgas, rgocp, rgoasq, cpres
     +, rgasv, cpresv
      COMMON /narcm/ avo, rgasi, airmw, boltzk, pi, ar, a0, rsn0, rcut0
     +, rcg0, p
C
      COMMON /param1/ pai, rvord, tfrez, hs, hv, daylnt
C
C     FOR FLOATING-1 MACHINE.
C
C      REAL*8 EFACT, AFAK, B, D, EXPPP
      DOUBLE PRECISION efact, afak, b, d, exppp
      DOUBLE PRECISION efactb, afakb, bb, db, expppb
      REAL*8 acoefc(ilg, ilev, 2)
      REAL*8 acoefcb(ilg, ilev, 2)
C
C      REAL ACOEFC(ILG,ILEV,2)
C
      REAL tcszrow(ilg), cszrow(ilg), totnu(ilg), totcd(ilg, ilev)
      REAL tcszrowb(ilg), cszrowb(ilg), totnub(ilg), totcdb(ilg, ilev)
      REAL rh(ilg, lev), totcdn(ilg, ilev), pcond(ilg, ilev, isize)
      REAL rhb(ilg, lev), totcdnb(ilg, ilev), pcondb(ilg, ilev, isize)
      REAL t(ilg, lev), shj(ilg, ilev), pressg(ilg)
      REAL tb(ilg, lev), shjb(ilg, ilev), pressgb(ilg)
      REAL ohrow(ilg, ilev), no3row(ilg, ilev), roarow(ilg, ilev)
      REAL ohrowb(ilg, ilev), no3rowb(ilg, ilev), roarowb(ilg, ilev)
CSLG
      REAL rgrid(ilg, ilev, ntr), cldcv(ilg, ilev, 2)
      REAL rgridb(ilg, ilev, ntr), cldcvb(ilg, ilev, 2)
      REAL rtso2(ilg, ilev, 2), rtdms(ilg, ilev), rth(ilg, ilev, isize)
      REAL rtso2b(ilg, ilev, 2), rtdmsb(ilg, ilev), rthb(ilg, ilev, 
     +     isize)
      REAL rth2s(ilg, ilev), rtnucl(ilg, ilev), condnu(15)
      REAL rth2sb(ilg, ilev), rtnuclb(ilg, ilev), condnub(15)
      REAL xrow(ilg, lev, ntr)
      REAL xrowb(ilg, lev, ntr)
      REAL rhsize(ilg, ilev, isize), aerosize(2, isize)
      REAL rhsizeb(ilg, ilev, isize), aerosizeb(2, isize)
      REAL kn, rtcond(ilg, ilev, isize), totmas(ilg, ilev, isize)
      REAL knb, rtcondb(ilg, ilev, isize)
      REAL aeronum(ilg, ilev, isize), rhop0(icomp), pvol(isize)
      REAL aeronumb(ilg, ilev, isize), rhop0b(icomp), pvolb(isize)
      PARAMETER (y4pid3=4.18879)
      PARAMETER (so4mw=98.1e-03)
      PARAMETER (akb=1.380662e-23)
      PARAMETER (ara=1.)
      EXTERNAL PUTZERO
      EXTERNAL PUTZERO_B
      EXTERNAL INTRSEC
      EXTERNAL INTRSEC_B
      INTEGER arg1
      INTEGER branch
      INTEGER ad_from
      INTEGER ad_to
      INTEGER ad_from0
      INTEGER ad_to0
      INTEGER ad_from1
      INTEGER ad_to1
      INTEGER ad_from2
      INTEGER ad_to2
      INTEGER ad_to3
      INTEGER ad_from3
      INTEGER ad_to4
      INTEGER ad_from4
      INTEGER ad_to5
      INTEGER ad_to6
      INTEGER ad_from5
      INTEGER ad_to7
      INTEGER ad_from6
      INTEGER ad_to8
      INTEGER ad_from7
      INTEGER ad_to9
      INTEGER ad_from8
      INTEGER ad_to10
      INTEGER ad_to11
      REAL temp3
      REAL temp29
      REAL x3b
      DOUBLE PRECISION temp153b
      REAL y1b
      REAL temp2
      DOUBLE PRECISION temp28
      REAL temp161b
      DOUBLE PRECISION temp198b
      REAL temp1
      REAL temp27
      DOUBLE PRECISION temp42b1
      REAL temp0
      REAL temp26
      DOUBLE PRECISION temp42b0
      REAL temp7b
      REAL temp25
      REAL temp24
      DOUBLE PRECISION temp66b
      INTRINSIC EXP
      INTRINSIC DEXP
      REAL temp23
      REAL temp74b
      DOUBLE PRECISION temp111b
      DOUBLE PRECISION temp119
      REAL temp22
      DOUBLE PRECISION temp59
      REAL temp118
      REAL temp21
      DOUBLE PRECISION temp58
      REAL temp117
      DOUBLE PRECISION temp164b
      REAL amin10b
      REAL temp20
      DOUBLE PRECISION temp57
      DOUBLE PRECISION temp116
      REAL temp172b
      DOUBLE PRECISION temp56
      DOUBLE PRECISION temp115
      REAL temp24b
      REAL temp35b0
      DOUBLE PRECISION temp55
      DOUBLE PRECISION temp114
      DOUBLE PRECISION temp109b0
      DOUBLE PRECISION temp54
      DOUBLE PRECISION temp113
      REAL temp106b
      REAL temp40b
      DOUBLE PRECISION temp53
      DOUBLE PRECISION temp77b
      DOUBLE PRECISION y10b
      DOUBLE PRECISION temp112
      DOUBLE PRECISION temp149
      REAL temp52
      DOUBLE PRECISION temp89
      REAL temp85b
      DOUBLE PRECISION temp111
      DOUBLE PRECISION temp122b
      DOUBLE PRECISION temp148
      DOUBLE PRECISION temp197b0
      DOUBLE PRECISION temp229
      REAL max2b
      REAL temp51
      DOUBLE PRECISION y7b
      DOUBLE PRECISION temp88
      DOUBLE PRECISION temp110
      DOUBLE PRECISION temp130b
      DOUBLE PRECISION temp147
      REAL temp228
      REAL temp30b0
      DOUBLE PRECISION temp50
      DOUBLE PRECISION temp87
      DOUBLE PRECISION temp146
      DOUBLE PRECISION temp175b
      DOUBLE PRECISION temp227
      REAL temp19b
      DOUBLE PRECISION temp86
      DOUBLE PRECISION temp145
      REAL temp183b
      REAL temp226
      REAL temp28b1
      REAL temp27b
      REAL temp85
      DOUBLE PRECISION temp144
      DOUBLE PRECISION temp175b0
      DOUBLE PRECISION temp225
      REAL tempb2
      DOUBLE PRECISION temp28b0
      REAL temp35b
      REAL temp84
      DOUBLE PRECISION temp109b
      DOUBLE PRECISION temp119b1
      DOUBLE PRECISION temp143
      REAL temp224
      REAL tempb1
      DOUBLE PRECISION temp43b
      DOUBLE PRECISION temp83
      DOUBLE PRECISION temp119b0
      REAL temp117b
      DOUBLE PRECISION y13b
      DOUBLE PRECISION temp142
      DOUBLE PRECISION temp179
      DOUBLE PRECISION temp223
      REAL tempb0
      REAL temp51b
      DOUBLE PRECISION temp82
      DOUBLE PRECISION temp88b
      DOUBLE PRECISION temp141
      DOUBLE PRECISION temp178
      REAL temp222
      DOUBLE PRECISION temp81
      REAL temp96b
      DOUBLE PRECISION temp133b
      REAL temp140
      DOUBLE PRECISION temp153b0
      DOUBLE PRECISION temp177
      DOUBLE PRECISION temp221
      INTRINSIC MAX
      DOUBLE PRECISION temp80
      DOUBLE PRECISION temp141b
      DOUBLE PRECISION temp176
      REAL temp220
      DOUBLE PRECISION temp175
      DOUBLE PRECISION temp186b
      DOUBLE PRECISION temp174
      REAL temp194b
      DOUBLE PRECISION temp205b9
      REAL x5
      REAL amin11
      DOUBLE PRECISION temp131b0
      REAL temp173
      DOUBLE PRECISION temp185b1
      DOUBLE PRECISION temp205b8
      REAL x4
      REAL amin10
      DOUBLE PRECISION y16b
      REAL temp172
      DOUBLE PRECISION temp185b0
      DOUBLE PRECISION temp205b7
      REAL x3
      DOUBLE PRECISION temp54b
      REAL temp128b
      DOUBLE PRECISION temp171
      DOUBLE PRECISION temp205b6
      REAL x2
      REAL temp62b
      DOUBLE PRECISION temp99b
      DOUBLE PRECISION temp170
      DOUBLE PRECISION temp205b5
      REAL x1
      DOUBLE PRECISION temp144b
      DOUBLE PRECISION temp163b1
      DOUBLE PRECISION temp205b4
      REAL temp19
      REAL x2b
      DOUBLE PRECISION temp152b
      DOUBLE PRECISION temp163b0
      DOUBLE PRECISION temp205b3
      REAL temp18
      DOUBLE PRECISION temp197b
      DOUBLE PRECISION temp205b2
      REAL temp17
      DOUBLE PRECISION temp205b1
      REAL temp16
      DOUBLE PRECISION temp87b0
      DOUBLE PRECISION temp141b1
      DOUBLE PRECISION y19b
      DOUBLE PRECISION temp205b0
      REAL temp15
      REAL temp20b
      DOUBLE PRECISION temp141b0
      REAL temp14
      DOUBLE PRECISION temp65b
      REAL temp139b
      REAL temp13
      REAL temp73b
      DOUBLE PRECISION temp109
      DOUBLE PRECISION temp110b
      REAL temp12
      DOUBLE PRECISION temp49
      DOUBLE PRECISION temp65b0
      DOUBLE PRECISION temp108
      DOUBLE PRECISION temp155b
      REAL x5b
      REAL temp11
      REAL y3b
      DOUBLE PRECISION temp48
      REAL temp107
      DOUBLE PRECISION temp163b
      INTRINSIC ALOG
      REAL temp10
      DOUBLE PRECISION temp47
      REAL temp106
      DOUBLE PRECISION temp46
      DOUBLE PRECISION temp105
      DOUBLE PRECISION y19
      REAL temp23b
      DOUBLE PRECISION temp45
      DOUBLE PRECISION temp43b0
      DOUBLE PRECISION temp104
      DOUBLE PRECISION temp97b1
      DOUBLE PRECISION y18
      DOUBLE PRECISION temp44
      DOUBLE PRECISION temp103
      DOUBLE PRECISION temp97b0
      DOUBLE PRECISION y17
      DOUBLE PRECISION temp43
      DOUBLE PRECISION temp76b
      DOUBLE PRECISION temp102
      REAL temp139
      DOUBLE PRECISION temp205b15
      DOUBLE PRECISION y16
      DOUBLE PRECISION temp42
      DOUBLE PRECISION temp79
      REAL temp84b
      DOUBLE PRECISION temp101
      DOUBLE PRECISION temp121b
      DOUBLE PRECISION temp138
      DOUBLE PRECISION temp219
      DOUBLE PRECISION temp205b14
      DOUBLE PRECISION y15
      REAL max1b
      REAL temp41
      DOUBLE PRECISION y6b
      DOUBLE PRECISION temp78
      DOUBLE PRECISION temp75b1
      DOUBLE PRECISION temp100
      DOUBLE PRECISION temp137
      DOUBLE PRECISION temp166b
      REAL temp218
      DOUBLE PRECISION temp205b13
      DOUBLE PRECISION y14
      REAL temp40
      DOUBLE PRECISION temp77
      DOUBLE PRECISION temp75b0
      DOUBLE PRECISION temp136
      DOUBLE PRECISION temp174b
      DOUBLE PRECISION temp217
      DOUBLE PRECISION temp205b12
      DOUBLE PRECISION y13
      REAL temp19b1
      DOUBLE PRECISION temp76
      DOUBLE PRECISION temp135
      REAL temp216
      DOUBLE PRECISION temp205b11
      DOUBLE PRECISION y12
      REAL temp19b0
      DOUBLE PRECISION temp75
      DOUBLE PRECISION temp134
      DOUBLE PRECISION temp215
      DOUBLE PRECISION temp205b10
      DOUBLE PRECISION y11
      DOUBLE PRECISION temp53b1
      REAL temp74
      DOUBLE PRECISION temp108b
      DOUBLE PRECISION temp133
      REAL temp214
      DOUBLE PRECISION y10
      DOUBLE PRECISION temp42b
      DOUBLE PRECISION temp53b0
      REAL temp73
      DOUBLE PRECISION y12b
      DOUBLE PRECISION temp132
      DOUBLE PRECISION temp169
      DOUBLE PRECISION temp213
      DOUBLE PRECISION temp72
      DOUBLE PRECISION temp87b
      DOUBLE PRECISION temp131
      DOUBLE PRECISION temp168
      REAL temp205b
      REAL temp212
      REAL tempb
      DOUBLE PRECISION temp71
      DOUBLE PRECISION y9b
      REAL temp95b
      DOUBLE PRECISION temp130
      DOUBLE PRECISION temp132b
      DOUBLE PRECISION temp167
      DOUBLE PRECISION temp211
      DOUBLE PRECISION temp70
      REAL temp140b
      DOUBLE PRECISION temp166
      DOUBLE PRECISION temp177b
      REAL temp210
      DOUBLE PRECISION temp165
      DOUBLE PRECISION temp185b
      DOUBLE PRECISION temp164
      INTRINSIC AMAX1
      REAL temp37b
      DOUBLE PRECISION temp163
      REAL temp235b4
      DOUBLE PRECISION temp45b
      DOUBLE PRECISION temp119b
      DOUBLE PRECISION y15b
      REAL temp162
      DOUBLE PRECISION temp199
      REAL temp235b3
      REAL temp2b
      DOUBLE PRECISION temp53b
      REAL temp161
      DOUBLE PRECISION temp198
      REAL temp235b2
      DOUBLE PRECISION temp98b
      DOUBLE PRECISION temp160
      DOUBLE PRECISION temp197
      REAL temp235b1
      DOUBLE PRECISION temp143b
      DOUBLE PRECISION temp196
      REAL temp235b0
      REAL x1b
      REAL temp24b1
      REAL temp151b
      DOUBLE PRECISION temp188b
      REAL temp195
      REAL temp24b0
      REAL temp194
      DOUBLE PRECISION temp196b
      DOUBLE PRECISION temp193
      DOUBLE PRECISION temp192
      DOUBLE PRECISION y18b
      DOUBLE PRECISION temp56b
      DOUBLE PRECISION temp191
      DOUBLE PRECISION temp186b0
      INTRINSIC LOG
      DOUBLE PRECISION temp64b
      DOUBLE PRECISION temp190
      REAL temp39
      REAL x4b
      DOUBLE PRECISION temp154b
      REAL temp235b
      REAL y2b
      REAL temp38
      DOUBLE PRECISION temp164b0
      REAL temp162b
      DOUBLE PRECISION temp199b
      REAL temp37
      DOUBLE PRECISION temp108b1
      REAL temp36
      DOUBLE PRECISION temp108b0
      REAL temp8b
      REAL temp22b
      REAL temp35
      REAL temp34
      REAL temp30b
      DOUBLE PRECISION temp67b
      DOUBLE PRECISION temp142b0
      DOUBLE PRECISION temp196b1
      REAL temp33
      DOUBLE PRECISION temp75b
      REAL temp129
      DOUBLE PRECISION temp196b0
      REAL temp32
      DOUBLE PRECISION temp69
      DOUBLE PRECISION temp120b
      REAL temp128
      DOUBLE PRECISION temp209
      REAL temp31
      DOUBLE PRECISION y5b
      DOUBLE PRECISION temp68
      DOUBLE PRECISION temp127
      DOUBLE PRECISION temp165b
      REAL temp208
      REAL temp30
      DOUBLE PRECISION temp67
      DOUBLE PRECISION temp126
      DOUBLE PRECISION temp120b0
      DOUBLE PRECISION temp174b1
      REAL temp173b
      DOUBLE PRECISION temp207
      INTRINSIC AMIN1
      REAL temp27b1
      DOUBLE PRECISION temp66
      DOUBLE PRECISION temp125
      DOUBLE PRECISION temp174b0
      REAL temp206
      INTRINSIC LOG10
      REAL temp27b0
      REAL temp25b
      DOUBLE PRECISION temp65
      DOUBLE PRECISION temp124
      DOUBLE PRECISION temp205
      DOUBLE PRECISION temp64
      REAL temp107b
      DOUBLE PRECISION temp123
      DOUBLE PRECISION temp204
      REAL temp41b
      REAL temp63
      DOUBLE PRECISION temp78b
      DOUBLE PRECISION temp98b0
      DOUBLE PRECISION y11b
      DOUBLE PRECISION temp122
      DOUBLE PRECISION temp159
      DOUBLE PRECISION temp152b1
      DOUBLE PRECISION temp203
      REAL temp62
      DOUBLE PRECISION temp86b
      DOUBLE PRECISION temp99
      DOUBLE PRECISION temp121
      DOUBLE PRECISION temp158
      DOUBLE PRECISION temp152b0
      DOUBLE PRECISION temp202
      DOUBLE PRECISION temp61
      DOUBLE PRECISION y8b
      DOUBLE PRECISION temp98
      DOUBLE PRECISION temp120
      DOUBLE PRECISION temp131b
      DOUBLE PRECISION temp157
      DOUBLE PRECISION temp201
      REAL max3b
      INTRINSIC MIN
      DOUBLE PRECISION temp60
      DOUBLE PRECISION temp97
      DOUBLE PRECISION temp156
      DOUBLE PRECISION temp176b
      DOUBLE PRECISION temp200
      DOUBLE PRECISION temp76b0
      REAL temp96
      DOUBLE PRECISION temp130b1
      DOUBLE PRECISION temp155
      REAL temp184b
      DOUBLE PRECISION temp28b
      REAL temp95
      DOUBLE PRECISION temp130b0
      DOUBLE PRECISION temp154
      REAL temp37b1
      REAL temp36b
      DOUBLE PRECISION temp94
      DOUBLE PRECISION temp153
      REAL temp234
      INTEGER ii3
      REAL temp37b0
      DOUBLE PRECISION temp44b
      DOUBLE PRECISION temp93
      REAL temp118b
      DOUBLE PRECISION y14b
      DOUBLE PRECISION temp152
      DOUBLE PRECISION temp189
      DOUBLE PRECISION temp233
      INTEGER ii2
      DOUBLE PRECISION temp54b0
      REAL temp52b
      DOUBLE PRECISION temp92
      DOUBLE PRECISION temp89b
      REAL temp151
      DOUBLE PRECISION temp188
      REAL temp232
      INTEGER ii1
      INTRINSIC SQRT
      DOUBLE PRECISION y9
      REAL temp
      DOUBLE PRECISION temp91
      DOUBLE PRECISION temp97b
      REAL temp150
      DOUBLE PRECISION temp187
      DOUBLE PRECISION temp231
      DOUBLE PRECISION y8
      REAL max3
      DOUBLE PRECISION temp90
      DOUBLE PRECISION temp142b
      DOUBLE PRECISION temp186
      REAL temp230
      DOUBLE PRECISION y7
      REAL max2
      REAL temp150b
      DOUBLE PRECISION temp185
      DOUBLE PRECISION temp187b
      DOUBLE PRECISION y6
      REAL max1
      REAL temp9
      DOUBLE PRECISION temp86b1
      REAL temp184
      REAL temp195b
      DOUBLE PRECISION y5
      REAL temp8
      DOUBLE PRECISION temp86b0
      REAL temp183
      REAL y4
      REAL temp7
      REAL temp10b
      DOUBLE PRECISION temp182
      DOUBLE PRECISION y17b
      REAL y3
      REAL temp6
      DOUBLE PRECISION temp55b
      REAL temp129b
      DOUBLE PRECISION temp181
      REAL y2
      REAL temp5
      REAL temp10b0
      DOUBLE PRECISION temp64b1
      REAL temp63b
      DOUBLE PRECISION temp100b
      DOUBLE PRECISION temp180
      REAL y1
      REAL temp4
      DOUBLE PRECISION temp64b0
      DATA ace /0.02/
      DATA xiao /1.0e3/
      adt2 = 2.*delt
C
C     ZERO WORKING ARRAYS
C
      arg1 = ilg*ilev
      CALL PUSHINTEGER4(arg1)
      CALL PUSHREAL8ARRAY(totcd, ilg*ilev)
      CALL PUTZERO(totcd, arg1)
      arg1 = ilg*ilev
      CALL PUSHINTEGER4(arg1)
      CALL PUSHREAL8ARRAY(totcdn, ilg*ilev)
      CALL PUTZERO(totcdn, arg1)
      arg1 = ilg*ilev
      CALL PUSHINTEGER4(arg1)
      arg1 = ilg*ilev*isize
      CALL PUSHINTEGER4(arg1)
      arg1 = ilg*ilev*isize
      CALL PUSHINTEGER4(arg1)
      CALL PUSHREAL8ARRAY(rtcond, ilg*ilev*isize)
      CALL PUTZERO(rtcond, arg1)
      cub = 1./3.
      zc = 0.000
      ad_from0 = 1 + mae
      DO l=ad_from0,ilev
        ad_from = il1
        DO i=ad_from,il2
          IF (cam .LT. 10.0) THEN
            IF (cldcv(i, l, 1) .LT. cldcv(i, l, 2)) THEN
              y1 = cldcv(i, l, 2)
              CALL PUSHCONTROL1B(0)
            ELSE
              y1 = cldcv(i, l, 1)
              CALL PUSHCONTROL1B(1)
            END IF
            IF (1.0 .GT. y1) THEN
              amin10 = y1
              CALL PUSHCONTROL1B(0)
            ELSE
              amin10 = 1.0
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(tclr)
CFOR GCM OR RCM
C===============================================================
C
C       * CLEAR AIR CHEMISTRY
C
C          RK  - RATE FOR SO2+OH
C          RK1 - DMS+OH VIA H ABSTRACTION
C          RK2 - DMS+OH VIA OH ADDITION
C          RK3 - DMS+NO3
C          RK4 - H2S+OH
C
C===============================================================
C
C      TOTAL CLEAR SKY FRACTION
C
CSLG
            tclr = 1. - amin10
            IF (cszrow(i) .LT. zc) THEN
              CALL PUSHREAL8(max1)
              max1 = zc
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(max1)
              max1 = cszrow(i)
              CALL PUSHCONTROL1B(1)
            END IF
C
C     * A FACTOR TO CONVERT DAILY AVERAGE FILED TO DIUNAL CHANGED
C
            dich = max1/tcszrow(i)*daylnt/delt
            IF (cszrow(i) .LT. zc) THEN
              CALL PUSHREAL8(max2)
              max2 = zc
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(max2)
              max2 = cszrow(i)
              CALL PUSHCONTROL1B(1)
            END IF
            adich = (1.0-max2)/(daylnt/delt-tcszrow(i))*daylnt/delt
            CALL PUSHREAL8(rk0)
C
C     * FOR SO2. THE REACTION RATE CONSTANT DeMore et al. [1992]
C 
C       (1) SO2 + OH --->
C           dC[SO2]/dt = -k C[OH] C[SO2]
C           C[SO2,t] = C[SO2,0]*exp(-k C[OH] t) 
C
            rk0 = 3.0e-31*(300.0/t(i, l+1))**3.3
            rkinf = 1.5e-12
C AIR KG/M3 ->MOL/CM3
            rocon = avo/airmw*1.0e-3
            CALL PUSHREAL8(rk0)
            rk0 = rk0*roarow(i, l)*rocon
            CALL PUSHREAL8(rk)
            rk = rk0/(1.0+rk0/rkinf)*0.6**(1./(1.0+LOG10(rk0/rkinf)**2))
C
C     QOH SHOULD BE THE CONCENTRATION OF OH IN THE UNIT OF
C         MOLECULES/CM3
C
C         MOZART OH IS IN THE UNIT OF VOLUME MIXING RATIO [CM3/CM3]
C         TO CONVERT TO MOLEC CM-3
C
C            USE: 273.15/T* P/1.0133E5*1.E-3  / 22.4136 * AVO
C                 --------------+------------   ---+---   ---
C                   TO STD STATE VOL LIT       TO G-MOLE  TO MOLECULES
C    
            rocon = avo*273.15/t(i, l+1)*pressg(i)*shj(i, l)/1.0133e5*
     +        1.e-3/22.4136
C
            qoh = ohrow(i, l)*dich*rocon
C
C       SO2 OXIDATION RATE
C
            rtso2(i, l, 1) = rk*qoh
            CALL PUSHREAL8(rk1)
C
C     * FOR DMS. THE REACTION RATE CONSTANT
C 
C       [1] H ABSTRACTION      Atkinson et al. [1989]
C
C       [2] OH ADDITION   e.g. Pham et al [1995]
C
C       [3] NO3 NIGHT REACTION  Pham et al [1995]
C
C          k =  1.9e-13 exp(500/T) cm**3/(mol * s) 
C
C
            rk1 = 9.6e-12*EXP(-(234./t(i, l+1)))
C AIR KG/M3 ->MOL/CM3
            o2 = roarow(i, l)*avo/airmw*1.0e-3*0.21
            CALL PUSHREAL8(rk2)
            rk2 = 1.7e-42*EXP(7810./t(i, l+1))*o2/(1.+5.5e-31*EXP(7460./
     +        t(i, l+1))*o2)
            CALL PUSHREAL8(rk3)
            rk3 = 1.9e-13*EXP(500./t(i, l+1))
            qno3 = no3row(i, l)*adich*rocon
            CALL PUSHREAL8(rto)
            rto = (EXP(-(((rk1+rk2)*qoh+rk3*qno3)*adt2))-1.)/adt2
CSLG
            rtdms(i, l) = xrow(i, l+1, idms)*rto
            y2 = xrow(i, l+1, idms) + rtdms(i, l)*adt2*tclr
            IF (tmin .LT. y2) THEN
              CALL PUSHREAL8(xrow(i, l+1, idms))
              xrow(i, l+1, idms) = y2
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(xrow(i, l+1, idms))
              xrow(i, l+1, idms) = tmin
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(rk4)
C      
C     * FOR H2S. THE REACTION RATE CONSTANT
C
            rk4 = 6.3e-12*EXP(-(80./t(i, l+1)))
CSLG
CSLG
            rth2s(i, l) = xrow(i, l+1, ih2s)*(EXP(-(rk4*qoh*adt2))-1.0)/
     +        adt2
            y3 = xrow(i, l+1, ih2s) + rth2s(i, l)*adt2*tclr
            IF (tmin .LT. y3) THEN
              CALL PUSHREAL8(xrow(i, l+1, ih2s))
              xrow(i, l+1, ih2s) = y3
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(xrow(i, l+1, ih2s))
              xrow(i, l+1, ih2s) = tmin
              CALL PUSHCONTROL1B(1)
            END IF
C
            so2pro = -(64.6*(rth2s(i, l)/34.06+rtdms(i, l)/62.13)*tclr)
            IF (tmin .LT. xrow(i, l+1, iso2) + so2pro*adt2) THEN
              CALL PUSHREAL8(xrow(i, l+1, iso2))
              xrow(i, l+1, iso2) = xrow(i, l+1, iso2) + so2pro*adt2
              CALL PUSHCONTROL2B(2)
            ELSE
              CALL PUSHREAL8(xrow(i, l+1, iso2))
              xrow(i, l+1, iso2) = tmin
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(0)
          END IF
          IF (rh(i, l+1) .GT. 1.0) THEN
            CALL PUSHCONTROL1B(0)
            x1 = 1.0
          ELSE
            x1 = rh(i, l+1)
            CALL PUSHCONTROL1B(1)
          END IF
          IF (x1 .LT. 0.1) THEN
            CALL PUSHREAL8(rh01)
            rh01 = 0.1
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHREAL8(rh01)
            rh01 = x1
            CALL PUSHCONTROL1B(1)
          END IF
          IF (t(i, l+1) .GT. 298.) THEN
            CALL PUSHCONTROL1B(0)
            x2 = 298.
          ELSE
            x2 = t(i, l+1)
            CALL PUSHCONTROL1B(1)
          END IF
          IF (x2 .LT. 233.) THEN
            CALL PUSHREAL8(atempe)
            atempe = 233.
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHREAL8(atempe)
            atempe = x2
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHREAL8(anw)
C
C---        water vapour concentration in 1/cm^3
          anw = rh01*1.e-06*EXP(77.34491296-7235.42451/atempe-8.2*LOG(
     +      atempe)+5.7113e-03*atempe)/(akb*atempe)
C
          adelta = atempe/273.15
          apara = 25.1289 - 4890.8/atempe - 2.2479*adelta*rh01
          aparb = 7643.4/atempe - 1.9712*adelta/rh01
          aparc = -(1743.3/atempe)
          CALL PUSHREAL8(apard)
          apard = 1.2233 - 0.0154*ara/(ara+rh01) - 0.0415*LOG(anw) + 
     +      0.0016*atempe
          apare = 0.0102
          CALL PUSHREAL8(aconcr)
C
C---        calculation of threshold H2SO4 concentration
          aconcr = EXP(-14.5125 + 0.1335*atempe - 10.5462*rh01 + 1958.4*
     +      rh01/atempe)
C
          aexp = apara + aparb*apare
          atuner = 1.
          CALL PUSHREAL8(exppp)
C
C      H2SO4 in kg/kg in combined equation and J in per cm^3/s
C
          exppp = aexp*ALOG(avo*roarow(i, l)/so4mw*1.e-06) - apara*ALOG(
     +      aconcr)
          CALL PUSHREAL8(efact)
          efact = DEXP(exppp)
          afak = EXP(aparb*apard+aparc)*efact*atuner
C
          avesize = aerosize(1, 1)
          CALL PUSHREAL8(afak)
C      *  to kg/kg/s
CSLG
          afak = afak*y4pid3*rhop0(nn)*avesize*avesize*avesize*1.e+06/
     +      roarow(i, l)
C
C---        nucleation coefficients 
          acoefc(i, l, 1) = afak
          acoefc(i, l, 2) = aexp
        ENDDO
        CALL PUSHINTEGER4(i - 1)
        CALL PUSHINTEGER4(ad_from)
      ENDDO
      CALL PUSHINTEGER4(l - 1)
      CALL PUSHINTEGER4(ad_from0)
C===============================================================
C
C
C      * CONDENSATION OF H2SO4 [G] TO EXSITING PARTICLES.
C        LOOP FOR SIZE SPECTRUM 
C
      DO n=1,isize
        ad_from2 = 1 + mae
        DO l=ad_from2,ilev
          ad_from1 = il1
          DO i=ad_from1,il2
            IF (aeronum(i, l, n)*roarow(i, l) .GT. xiao) THEN
              CALL PUSHREAL8(dfso4)
C
C   DIFFUSION COEFFICIENT OF H2SO4 [GAS] [PERRY AND GREEN, 1984]
C   [M2 S-1]
C   WHERE 0.21145 = [(Ma+Mg)/MaMg]^1/2, Ma=28.97, Mg=98.1 [H2SO4]
C
              dfso4 = 1.e-7*t(i, l+1)**1.75*0.21145/(pressg(i)*shj(i, l)
     +          /1.01325e5*((0.369*airmw+6.29)**cub+(0.369*(so4mw*1.e3)+
     +          6.29)**cub)**2)
              CALL PUSHREAL8(frp)
C
C  THE MEAN FREE PATH OF VAPOUR SULPHURIC ACID
C   
              frp = 3.0*SQRT(pi*98.1/(8.e3*rgasi*t(i, l+1)))*dfso4
C
C            ACE --> ACCOMMODATION COEFFICIENT ~0.02
C
              kn = frp/rhsize(i, l, n)
              fn = (1.+kn)/(1.+1.71*kn+1.33*kn*kn)
              an = 1./(1.+1.33*kn*fn*(1./ace-1.))
C
C     * THE CONDENSATION COEFFICIENTS FOR COMBINED COMPUTATION NEXT.
C       THE AERONUM*ROAROW ACCOUNTS FOR ALL THE PARTICLES IN BIN N. 
C
              rtcond(i, l, n) = 4.*pi*rhsize(i, l, n)*dfso4*fn*an*
     +          aeronum(i, l, n)*roarow(i, l)
              totcdn(i, l) = totcdn(i, l) + rtcond(i, l, n)
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
          ENDDO
          CALL PUSHINTEGER4(i - 1)
          CALL PUSHINTEGER4(ad_from1)
        ENDDO
        CALL PUSHINTEGER4(l - 1)
        CALL PUSHINTEGER4(ad_from2)
      ENDDO
      CALL PUSHINTEGER4(n - 1)
C
C
C    FRACTIONAL CONDENSATION TO EACH BIN FOR USE IN SOA
C
      DO n=1,isize
        ad_from4 = 1 + mae
        DO l=ad_from4,ilev
          ad_from3 = il1
          DO i=ad_from3,il2
            cond = totcdn(i, l)
            IF (cond .GT. 0. .AND. aeronum(i, l, n)*roarow(i, l) .GT. 
     +          xiao) THEN
              IF (rtcond(i, l, n)/cond .GT. 1.) THEN
                x3 = 1.
                CALL PUSHCONTROL1B(0)
              ELSE
                x3 = rtcond(i, l, n)/cond
                CALL PUSHCONTROL1B(1)
              END IF
              IF (x3 .LT. 0.) THEN
                CALL PUSHCONTROL2B(1)
              ELSE
                CALL PUSHCONTROL2B(2)
              END IF
            ELSE
              CALL PUSHCONTROL2B(0)
            END IF
          ENDDO
          CALL PUSHINTEGER4(i - 1)
          CALL PUSHINTEGER4(ad_from3)
        ENDDO
        CALL PUSHINTEGER4(l - 1)
        CALL PUSHINTEGER4(ad_from4)
      ENDDO
      CALL PUSHINTEGER4(n - 1)
      ad_from6 = 1 + mae
      DO l=ad_from6,ilev
        ad_from5 = il1
        DO i=ad_from5,il2
          IF (1.e-18 .LT. xrow(i, l+1, iso4)) THEN
            CALL PUSHREAL8(so4t0)
            so4t0 = xrow(i, l+1, iso4)
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHREAL8(so4t0)
            so4t0 = 1.e-18
            CALL PUSHCONTROL1B(1)
          END IF
          IF (1.e-18 .LT. xrow(i, l+1, iso2)) THEN
            so2t0 = xrow(i, l+1, iso2)
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
            so2t0 = 1.e-18
          END IF
          IF (so4t0 .GE. 1.e-18 .AND. totcdn(i, l) .GT. 0. .AND. xrow(i
     +        , l+1, iso2) .GE. 1.e-18) THEN
C
C      TOTAL CLEAR SKY FRACTION
C
            IF (totcdn(i, l) .GT. 0.025) THEN
              CALL PUSHCONTROL1B(0)
              x4 = 0.025
            ELSE
              x4 = totcdn(i, l)
              CALL PUSHCONTROL1B(1)
            END IF
            IF (x4 .LT. 0.0) THEN
              CALL PUSHREAL8(a)
              a = 0.0
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(a)
              a = x4
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(b)
            b = acoefc(i, l, 1)
            CALL PUSHREAL8(d)
            d = acoefc(i, l, 2)
C
            w = -(98.1/64.6)
            CALL PUSHREAL8(pp)
C
C      PP IS THE HSO4(GAS) PRODUCTION RATE FROM SO2 OXIDATION
C      IN THE TIME INTERVAL CONDNU( I)
C      SO2 CONCENTRASTION SO2T0 IS UPDATED IN EVERY CONDNU( I)
C
C--------------
            pp = w*so2t0*(EXP(-(rtso2(i, l, 1)*condnu(1)))-1.0)/condnu(1
     +        )
            CALL PUSHREAL8(so2t0)
            so2t0 = so2t0 + pp*condnu(1)/w
            y5 = ((1.-EXP(-((a+b*so4t0**(d-1.))*condnu(1))))*pp+EXP(-((a
     +        +b*so4t0**(d-1.))*condnu(1)))*(a+b*so4t0**(d-1.))*so4t0)/(
     +        a+b*so4t0**(d-1.))
            IF (akb .LT. y5) THEN
              CALL PUSHREAL8(so4t1)
              so4t1 = y5
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(so4t1)
              so4t1 = akb
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(pp)
C--------------
            pp = w*so2t0*(EXP(-(rtso2(i, l, 1)*condnu(2)))-1.0)/condnu(2
     +        )
            CALL PUSHREAL8(so2t0)
            so2t0 = so2t0 + pp*condnu(2)/w
            y6 = ((1.-EXP(-((a+b*so4t1**(d-1.))*condnu(2))))*pp+EXP(-((a
     +        +b*so4t1**(d-1.))*condnu(2)))*(a+b*so4t1**(d-1.))*so4t1)/(
     +        a+b*so4t1**(d-1.))
            IF (akb .LT. y6) THEN
              CALL PUSHREAL8(so4t2)
              so4t2 = y6
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(so4t2)
              so4t2 = akb
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(pp)
C--------------
            pp = w*so2t0*(EXP(-(rtso2(i, l, 1)*condnu(3)))-1.0)/condnu(3
     +        )
            CALL PUSHREAL8(so2t0)
            so2t0 = so2t0 + pp*condnu(3)/w
            y7 = ((1.-EXP(-((a+b*so4t2**(d-1.))*condnu(3))))*pp+EXP(-((a
     +        +b*so4t2**(d-1.))*condnu(3)))*(a+b*so4t2**(d-1.))*so4t2)/(
     +        a+b*so4t2**(d-1.))
            IF (akb .LT. y7) THEN
              CALL PUSHREAL8(so4t3)
              so4t3 = y7
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(so4t3)
              so4t3 = akb
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(pp)
C--------------
            pp = w*so2t0*(EXP(-(rtso2(i, l, 1)*condnu(4)))-1.0)/condnu(4
     +        )
            CALL PUSHREAL8(so2t0)
            so2t0 = so2t0 + pp*condnu(4)/w
            y8 = ((1.-EXP(-((a+b*so4t3**(d-1.))*condnu(4))))*pp+EXP(-((a
     +        +b*so4t3**(d-1.))*condnu(4)))*(a+b*so4t3**(d-1.))*so4t3)/(
     +        a+b*so4t3**(d-1.))
            IF (akb .LT. y8) THEN
              CALL PUSHREAL8(so4t4)
              so4t4 = y8
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(so4t4)
              so4t4 = akb
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(pp)
C--------------
            pp = w*so2t0*(EXP(-(rtso2(i, l, 1)*condnu(5)))-1.0)/condnu(5
     +        )
            CALL PUSHREAL8(so2t0)
            so2t0 = so2t0 + pp*condnu(5)/w
            y9 = ((1.-EXP(-((a+b*so4t4**(d-1.))*condnu(5))))*pp+EXP(-((a
     +        +b*so4t4**(d-1.))*condnu(5)))*(a+b*so4t4**(d-1.))*so4t4)/(
     +        a+b*so4t4**(d-1.))
            IF (akb .LT. y9) THEN
              CALL PUSHREAL8(so4t5)
              so4t5 = y9
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(so4t5)
              so4t5 = akb
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(pp)
C--------------
            pp = w*so2t0*(EXP(-(rtso2(i, l, 1)*condnu(6)))-1.0)/condnu(6
     +        )
            CALL PUSHREAL8(so2t0)
            so2t0 = so2t0 + pp*condnu(6)/w
            y10 = ((1.-EXP(-((a+b*so4t5**(d-1.))*condnu(6))))*pp+EXP(-((
     +        a+b*so4t5**(d-1.))*condnu(6)))*(a+b*so4t5**(d-1.))*so4t5)/
     +        (a+b*so4t5**(d-1.))
            IF (akb .LT. y10) THEN
              CALL PUSHREAL8(so4t6)
              so4t6 = y10
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(so4t6)
              so4t6 = akb
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(pp)
C--------------
            pp = w*so2t0*(EXP(-(rtso2(i, l, 1)*condnu(7)))-1.0)/condnu(7
     +        )
            CALL PUSHREAL8(so2t0)
            so2t0 = so2t0 + pp*condnu(7)/w
            y11 = ((1.-EXP(-((a+b*so4t6**(d-1.))*condnu(7))))*pp+EXP(-((
     +        a+b*so4t6**(d-1.))*condnu(7)))*(a+b*so4t6**(d-1.))*so4t6)/
     +        (a+b*so4t6**(d-1.))
            IF (akb .LT. y11) THEN
              CALL PUSHREAL8(so4t7)
              so4t7 = y11
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(so4t7)
              so4t7 = akb
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(pp)
C--------------
            pp = w*so2t0*(EXP(-(rtso2(i, l, 1)*condnu(8)))-1.0)/condnu(8
     +        )
            CALL PUSHREAL8(so2t0)
            so2t0 = so2t0 + pp*condnu(8)/w
            y12 = ((1.-EXP(-((a+b*so4t7**(d-1.))*condnu(8))))*pp+EXP(-((
     +        a+b*so4t7**(d-1.))*condnu(8)))*(a+b*so4t7**(d-1.))*so4t7)/
     +        (a+b*so4t7**(d-1.))
            IF (akb .LT. y12) THEN
              CALL PUSHREAL8(so4t8)
              so4t8 = y12
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(so4t8)
              so4t8 = akb
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(pp)
C--------------
            pp = w*so2t0*(EXP(-(rtso2(i, l, 1)*condnu(9)))-1.0)/condnu(9
     +        )
            CALL PUSHREAL8(so2t0)
            so2t0 = so2t0 + pp*condnu(9)/w
            y13 = ((1.-EXP(-((a+b*so4t8**(d-1.))*condnu(9))))*pp+EXP(-((
     +        a+b*so4t8**(d-1.))*condnu(9)))*(a+b*so4t8**(d-1.))*so4t8)/
     +        (a+b*so4t8**(d-1.))
            IF (akb .LT. y13) THEN
              CALL PUSHREAL8(so4t9)
              so4t9 = y13
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(so4t9)
              so4t9 = akb
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(pp)
C--------------
            pp = w*so2t0*(EXP(-(rtso2(i, l, 1)*condnu(10)))-1.0)/condnu(
     +        10)
            CALL PUSHREAL8(so2t0)
            so2t0 = so2t0 + pp*condnu(10)/w
            y14 = ((1.-EXP(-((a+b*so4t9**(d-1.))*condnu(10))))*pp+EXP(-(
     +        (a+b*so4t9**(d-1.))*condnu(10)))*(a+b*so4t9**(d-1.))*so4t9
     +        )/(a+b*so4t9**(d-1.))
            IF (akb .LT. y14) THEN
              CALL PUSHREAL8(so4t10)
              so4t10 = y14
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(so4t10)
              so4t10 = akb
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(pp)
C--------------
            pp = w*so2t0*(EXP(-(rtso2(i, l, 1)*condnu(11)))-1.0)/condnu(
     +        11)
            CALL PUSHREAL8(so2t0)
            so2t0 = so2t0 + pp*condnu(11)/w
            y15 = ((1.-EXP(-((a+b*so4t10**(d-1.))*condnu(11))))*pp+EXP(-
     +        ((a+b*so4t10**(d-1.))*condnu(11)))*(a+b*so4t10**(d-1.))*
     +        so4t10)/(a+b*so4t10**(d-1.))
            IF (akb .LT. y15) THEN
              CALL PUSHREAL8(so4t11)
              so4t11 = y15
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(so4t11)
              so4t11 = akb
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(pp)
C--------------
            pp = w*so2t0*(EXP(-(rtso2(i, l, 1)*condnu(12)))-1.0)/condnu(
     +        12)
            CALL PUSHREAL8(so2t0)
            so2t0 = so2t0 + pp*condnu(12)/w
            y16 = ((1.-EXP(-((a+b*so4t11**(d-1.))*condnu(12))))*pp+EXP(-
     +        ((a+b*so4t11**(d-1.))*condnu(12)))*(a+b*so4t11**(d-1.))*
     +        so4t11)/(a+b*so4t11**(d-1.))
            IF (akb .LT. y16) THEN
              CALL PUSHREAL8(so4t12)
              so4t12 = y16
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(so4t12)
              so4t12 = akb
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(pp)
C--------------
            pp = w*so2t0*(EXP(-(rtso2(i, l, 1)*condnu(13)))-1.0)/condnu(
     +        13)
            CALL PUSHREAL8(so2t0)
            so2t0 = so2t0 + pp*condnu(13)/w
            y17 = ((1.-EXP(-((a+b*so4t12**(d-1.))*condnu(13))))*pp+EXP(-
     +        ((a+b*so4t12**(d-1.))*condnu(13)))*(a+b*so4t12**(d-1.))*
     +        so4t12)/(a+b*so4t12**(d-1.))
            IF (akb .LT. y17) THEN
              CALL PUSHREAL8(so4t13)
              so4t13 = y17
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(so4t13)
              so4t13 = akb
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(pp)
C--------------
            pp = w*so2t0*(EXP(-(rtso2(i, l, 1)*condnu(14)))-1.0)/condnu(
     +        14)
            CALL PUSHREAL8(so2t0)
            so2t0 = so2t0 + pp*condnu(14)/w
            y18 = ((1.-EXP(-((a+b*so4t13**(d-1.))*condnu(14))))*pp+EXP(-
     +        ((a+b*so4t13**(d-1.))*condnu(14)))*(a+b*so4t13**(d-1.))*
     +        so4t13)/(a+b*so4t13**(d-1.))
            IF (akb .LT. y18) THEN
              CALL PUSHREAL8(so4t14)
              so4t14 = y18
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(so4t14)
              so4t14 = akb
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(pp)
C--------------
            pp = w*so2t0*(EXP(-(rtso2(i, l, 1)*condnu(15)))-1.0)/condnu(
     +        15)
            CALL PUSHREAL8(so2t0)
            so2t0 = so2t0 + pp*condnu(15)/w
            y19 = ((1.-EXP(-((a+b*so4t14**(d-1.))*condnu(15))))*pp+EXP(-
     +        ((a+b*so4t14**(d-1.))*condnu(15)))*(a+b*so4t14**(d-1.))*
     +        so4t14)/(a+b*so4t14**(d-1.))
            IF (akb .LT. y19) THEN
              CALL PUSHREAL8(so4t15)
              so4t15 = y19
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(so4t15)
              so4t15 = akb
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(xso2)
C
C      TOTAL SO2 CONVERTED INTO SO4
C
            xso2 = xrow(i, l+1, iso2) - so2t0
            CALL PUSHREAL8(xrow(i, l+1, iso2))
COXIDATION RATE
            xrow(i, l+1, iso2) = so2t0
C
C      GASEOUS SO4 CHANGE
C
            xso4 = (so4t15-xrow(i, l+1, iso4))/adt2
            IF (0.0 .LT. -(xso4*adt2)) THEN
              max3 = -(xso4*adt2)
              CALL PUSHCONTROL1B(0)
            ELSE
              max3 = 0.0
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(totso4)
C
C      RESULTING SO4
C                               IF GASEOUS SO4 IS REDUCED.
            totso4 = -(xso2*w) + max3
C
            totnu(i) = 0.0
C
C        FOR NUCLEATION 
C              
            IF (b .GT. 0.0) THEN
              CALL PUSHREAL8(blg)
              blg = LOG(b)
              totnu(i) = 1.0/adt2*(condnu(1)*EXP(blg+d*LOG(so4t0))+
     +          condnu(2)*EXP(blg+d*LOG(so4t1))+condnu(3)*EXP(blg+d*LOG(
     +          so4t2))+condnu(4)*EXP(blg+d*LOG(so4t3))+condnu(5)*EXP(
     +          blg+d*LOG(so4t4))+condnu(6)*EXP(blg+d*LOG(so4t5))+condnu
     +          (7)*EXP(blg+d*LOG(so4t6))+condnu(8)*EXP(blg+d*LOG(so4t7)
     +          )+condnu(9)*EXP(blg+d*LOG(so4t8))+condnu(10)*EXP(blg+d*
     +          LOG(so4t9))+condnu(11)*EXP(blg+d*LOG(so4t10))+condnu(12)
     +          *EXP(blg+d*LOG(so4t11))+condnu(13)*EXP(blg+d*LOG(so4t12)
     +          )+condnu(14)*EXP(blg+d*LOG(so4t13))+condnu(15)*EXP(blg+d
     +          *LOG(so4t14)))
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
C
C
C     FOR CONDENSATION
C
            totcd(i, l) = a/adt2*(condnu(1)*so4t0+condnu(2)*so4t1+condnu
     +        (3)*so4t2+condnu(4)*so4t3+condnu(5)*so4t4+condnu(6)*so4t5+
     +        condnu(7)*so4t6+condnu(8)*so4t7+condnu(9)*so4t8+condnu(10)
     +        *so4t9+condnu(11)*so4t10+condnu(12)*so4t11+condnu(13)*
     +        so4t12+condnu(14)*so4t13+condnu(15)*so4t14)
            CALL PUSHREAL8(rtnucl(i, l))
            rtnucl(i, l) = totnu(i)
            CALL PUSHREAL8(totpar)
C
C      TOTAL SO4 PRODUCTION RATE FROM THE SIPLIFIED SCHEME. IT IS POSSIBLE
C      THAT THE MASS MAY NOT BE BALANCED COMPARED TO THE TOTAL SO2
C      OXIDATED. THEREFORE, THE BALANCED RATE WAS SCALED ACCORDING TO
C      THE INIVIDUAL RATE AND THE CONVERTED AMMOUNT OF SO4: TOTSO4
C
            totpar = totcd(i, l) + rtnucl(i, l)
            CALL PUSHREAL8(totcd(i, l))
C
            totcd(i, l) = totcd(i, l)/totpar*totso4/adt2
            CALL PUSHREAL8(rtnucl(i, l))
            rtnucl(i, l) = rtnucl(i, l)/totpar*totso4/adt2
            CALL PUSHREAL8(xrow(i, l+1, iso4))
C
            xrow(i, l+1, iso4) = so4t15
C
C       * PRODUCTION OF NEW PARTICLES BY NUCLEATION
C
            inew = isize*(nn-1) + 1 + (iae1-1)
            CALL PUSHREAL8(xrow(i, l+1, inew))
            xrow(i, l+1, inew) = xrow(i, l+1, inew) + rtnucl(i, l)*adt2
            CALL PUSHCONTROL1B(1)
          ELSE
            CALL PUSHCONTROL1B(0)
          END IF
        ENDDO
        CALL PUSHINTEGER4(i - 1)
        CALL PUSHINTEGER4(ad_from5)
      ENDDO
      CALL PUSHINTEGER4(l - 1)
      CALL PUSHINTEGER4(ad_from6)
C
C     FOR CONDENSATION
C
      DO n=1,isize
        ad_from8 = 1 + mae
        DO l=ad_from8,ilev
          ad_from7 = il1
          DO i=ad_from7,il2
            cond = totcdn(i, l)
            IF (cond .GT. 0. .AND. aeronum(i, l, n)*roarow(i, l) .GT. 
     +          xiao) THEN
              IF (rtcond(i, l, n)/cond .GT. 1.) THEN
                x5 = 1.
                CALL PUSHCONTROL1B(0)
              ELSE
                x5 = rtcond(i, l, n)/cond
                CALL PUSHCONTROL1B(1)
              END IF
              IF (x5 .LT. 0.) THEN
                CALL PUSHREAL8(condso4)
                condso4 = 0.
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHREAL8(condso4)
                condso4 = x5
                CALL PUSHCONTROL1B(1)
              END IF
              CALL PUSHREAL8(rtcond(i, l, n))
              rtcond(i, l, n) = condso4*totcd(i, l)
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHREAL8(rtcond(i, l, n))
              rtcond(i, l, n) = 0.0
              CALL PUSHCONTROL1B(0)
            END IF
          ENDDO
          CALL PUSHINTEGER4(i - 1)
          CALL PUSHINTEGER4(ad_from7)
        ENDDO
        CALL PUSHINTEGER4(l - 1)
        CALL PUSHINTEGER4(ad_from8)
      ENDDO
      CALL PUSHINTEGER4(n - 1)
      DO ii1=1,isize
        DO ii2=1,2
c          aerosizeb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
c      adt2b = 0.0
      DO ii1=1,icomp
c        rhop0b(ii1) = 0.0
      ENDDO
      DO ii1=1,isize
        DO ii2=1,ilev
          DO ii3=1,ilg
c            aeronumb(ii3, ii2, ii1) = 0.0
          ENDDO
        ENDDO
      ENDDO
      DO ii1=1,ilev
        DO ii2=1,ilg
c          roarowb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,isize
c        pvolb(ii1) = 0.0
      ENDDO
      CALL INTRSEC_B(lev, ilev, ilg, il1, il2, xrow, xrowb, rgrid, 
     +               rgridb, ntr, icomp, iae1, aerosize, rth
     +         , rthb, nn, adt2, adt2b, rhop0, rhop0b, xiao, isize
     +               , rtcond, rtcondb, aeronum, aeronumb, roarow, 
     +                pvol, pvolb, mae)
      CALL POPINTEGER4(ad_to11)
      DO n=ad_to11,1,-1
        CALL POPINTEGER4(ad_from8)
        CALL POPINTEGER4(ad_to10)
        DO l=ad_to10,ad_from8,-1
          CALL POPINTEGER4(ad_from7)
          CALL POPINTEGER4(ad_to9)
          DO i=ad_to9,ad_from7,-1
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(rtcond(i, l, n))
              rtcondb(i, l, n) = 0.0
              condb = 0.0
            ELSE
              CALL POPREAL8(rtcond(i, l, n))
              condso4b = totcd(i, l)*rtcondb(i, l, n)
              totcdb(i, l) = totcdb(i, l) + condso4*rtcondb(i, l, n)
              rtcondb(i, l, n) = 0.0
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                CALL POPREAL8(condso4)
                x5b = 0.0
              ELSE
                CALL POPREAL8(condso4)
                x5b = condso4b
              END IF
              cond = totcdn(i, l)
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                condb = 0.0
              ELSE
                rtcondb(i, l, n) = rtcondb(i, l, n) + x5b/cond
                condb = -(rtcond(i, l, n)*x5b/cond**2)
              END IF
            END IF
            totcdnb(i, l) = totcdnb(i, l) + condb
          ENDDO
        ENDDO
      ENDDO
      CALL POPINTEGER4(ad_from6)
      CALL POPINTEGER4(ad_to8)
      DO l=ad_to8,ad_from6,-1
        CALL POPINTEGER4(ad_from5)
        CALL POPINTEGER4(ad_to7)
        DO i=ad_to7,ad_from5,-1
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            so2t0b = 0.0
            so4t0b = 0.0
          ELSE
            temp235b1 = totcdb(i, l)/(totpar*adt2)
            inew = isize*(nn-1) + 1 + (iae1-1)
            CALL POPREAL8(xrow(i, l+1, inew))
            rtnuclb(i, l) = rtnuclb(i, l) + adt2*xrowb(i, l+1, inew)
            adt2b = adt2b + rtnucl(i, l)*xrowb(i, l+1, inew)
            CALL POPREAL8(xrow(i, l+1, iso4))
            so4t15b = xrowb(i, l+1, iso4)
            xrowb(i, l+1, iso4) = 0.0
            CALL POPREAL8(rtnucl(i, l))
            temp235b = rtnuclb(i, l)/(totpar*adt2)
            temp235b0 = -(rtnucl(i, l)*totso4*temp235b/(totpar*adt2))
            CALL POPREAL8(totcd(i, l))
            totso4b = totcd(i, l)*temp235b1 + rtnucl(i, l)*temp235b
            temp235b2 = -(totcd(i, l)*totso4*temp235b1/(totpar*adt2))
            totparb = adt2*temp235b2 + adt2*temp235b0
            rtnuclb(i, l) = totparb + totso4*temp235b
            totcdb(i, l) = totparb + totso4*temp235b1
            totnub(i) = totnub(i) + rtnuclb(i, l)
            rtnuclb(i, l) = 0.0
            temp235b4 = a*totcdb(i, l)/adt2
            temp235b3 = (condnu(1)*so4t0+condnu(2)*so4t1+condnu(3)*so4t2
     +        +condnu(4)*so4t3+condnu(5)*so4t4+condnu(6)*so4t5+condnu(7)
     +        *so4t6+condnu(8)*so4t7+condnu(9)*so4t8+condnu(10)*so4t9+
     +        condnu(11)*so4t10+condnu(12)*so4t11+condnu(13)*so4t12+
     +        condnu(14)*so4t13+condnu(15)*so4t14)*totcdb(i, l)/adt2
            adt2b = adt2b + totpar*temp235b2 - a*temp235b3/adt2 + totpar
     +        *temp235b0
            CALL POPREAL8(totpar)
            CALL POPREAL8(rtnucl(i, l))
            condnub(1) = condnub(1) + so4t0*temp235b4
            so4t0b = condnu(1)*temp235b4
            condnub(2) = condnub(2) + so4t1*temp235b4
            so4t1b = condnu(2)*temp235b4
            condnub(3) = condnub(3) + so4t2*temp235b4
            so4t2b = condnu(3)*temp235b4
            condnub(4) = condnub(4) + so4t3*temp235b4
            so4t3b = condnu(4)*temp235b4
            condnub(5) = condnub(5) + so4t4*temp235b4
            so4t4b = condnu(5)*temp235b4
            condnub(6) = condnub(6) + so4t5*temp235b4
            so4t5b = condnu(6)*temp235b4
            condnub(7) = condnub(7) + so4t6*temp235b4
            so4t6b = condnu(7)*temp235b4
            condnub(8) = condnub(8) + so4t7*temp235b4
            so4t7b = condnu(8)*temp235b4
            condnub(9) = condnub(9) + so4t8*temp235b4
            so4t8b = condnu(9)*temp235b4
            condnub(10) = condnub(10) + so4t9*temp235b4
            so4t9b = condnu(10)*temp235b4
            condnub(11) = condnub(11) + so4t10*temp235b4
            so4t10b = condnu(11)*temp235b4
            condnub(12) = condnub(12) + so4t11*temp235b4
            so4t11b = condnu(12)*temp235b4
            condnub(13) = condnub(13) + so4t12*temp235b4
            so4t12b = condnu(13)*temp235b4
            condnub(14) = condnub(14) + so4t13*temp235b4
            so4t13b = condnu(14)*temp235b4
            condnub(15) = condnub(15) + so4t14*temp235b4
            so4t14b = condnu(15)*temp235b4
            ab = temp235b3
            totcdb(i, l) = 0.0
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              d = acoefc(i, l, 2)
              temp205b0 = totnub(i)/adt2
              temp234 = LOG(so4t0)
              temp233 = EXP(blg + d*temp234)
              temp205b1 = condnu(1)*EXP(blg+d*temp234)*temp205b0
              temp232 = LOG(so4t1)
              temp231 = EXP(blg + d*temp232)
              temp205b2 = condnu(2)*EXP(blg+d*temp232)*temp205b0
              temp230 = LOG(so4t2)
              temp229 = EXP(blg + d*temp230)
              temp205b3 = condnu(3)*EXP(blg+d*temp230)*temp205b0
              temp228 = LOG(so4t3)
              temp227 = EXP(blg + d*temp228)
              temp205b4 = condnu(4)*EXP(blg+d*temp228)*temp205b0
              temp226 = LOG(so4t4)
              temp225 = EXP(blg + d*temp226)
              temp205b5 = condnu(5)*EXP(blg+d*temp226)*temp205b0
              temp224 = LOG(so4t5)
              temp223 = EXP(blg + d*temp224)
              temp205b6 = condnu(6)*EXP(blg+d*temp224)*temp205b0
              temp222 = LOG(so4t6)
              temp221 = EXP(blg + d*temp222)
              temp205b7 = condnu(7)*EXP(blg+d*temp222)*temp205b0
              temp220 = LOG(so4t7)
              temp219 = EXP(blg + d*temp220)
              temp205b8 = condnu(8)*EXP(blg+d*temp220)*temp205b0
              temp218 = LOG(so4t8)
              temp217 = EXP(blg + d*temp218)
              temp205b9 = condnu(9)*EXP(blg+d*temp218)*temp205b0
              temp216 = LOG(so4t9)
              temp215 = EXP(blg + d*temp216)
              temp205b10 = condnu(10)*EXP(blg+d*temp216)*temp205b0
              temp214 = LOG(so4t10)
              temp213 = EXP(blg + d*temp214)
              temp205b11 = condnu(11)*EXP(blg+d*temp214)*temp205b0
              temp212 = LOG(so4t11)
              temp211 = EXP(blg + d*temp212)
              temp205b12 = condnu(12)*EXP(blg+d*temp212)*temp205b0
              temp210 = LOG(so4t12)
              temp209 = EXP(blg + d*temp210)
              temp205b13 = condnu(13)*EXP(blg+d*temp210)*temp205b0
              temp208 = LOG(so4t13)
              temp207 = EXP(blg + d*temp208)
              temp205b14 = condnu(14)*EXP(blg+d*temp208)*temp205b0
              temp206 = LOG(so4t14)
              temp205 = EXP(blg + d*temp206)
              temp205b15 = condnu(15)*EXP(blg+d*temp206)*temp205b0
              condnub(1) = condnub(1) + temp233*temp205b0
              blgb = temp205b15 + temp205b14 + temp205b13 + temp205b12 +
     +          temp205b11 + temp205b10 + temp205b9 + temp205b8 + 
     +          temp205b7 + temp205b6 + temp205b5 + temp205b4 + 
     +          temp205b3 + temp205b2 + temp205b1
              db = temp206*temp205b15 + temp208*temp205b14 + temp210*
     +          temp205b13 + temp212*temp205b12 + temp214*temp205b11 + 
     +          temp216*temp205b10 + temp218*temp205b9 + temp220*
     +          temp205b8 + temp222*temp205b7 + temp224*temp205b6 + 
     +          temp226*temp205b5 + temp228*temp205b4 + temp230*
     +          temp205b3 + temp232*temp205b2 + temp234*temp205b1
              so4t0b = so4t0b + d*temp205b1/so4t0
              condnub(2) = condnub(2) + temp231*temp205b0
              so4t1b = so4t1b + d*temp205b2/so4t1
              condnub(3) = condnub(3) + temp229*temp205b0
              so4t2b = so4t2b + d*temp205b3/so4t2
              condnub(4) = condnub(4) + temp227*temp205b0
              so4t3b = so4t3b + d*temp205b4/so4t3
              condnub(5) = condnub(5) + temp225*temp205b0
              so4t4b = so4t4b + d*temp205b5/so4t4
              condnub(6) = condnub(6) + temp223*temp205b0
              so4t5b = so4t5b + d*temp205b6/so4t5
              condnub(7) = condnub(7) + temp221*temp205b0
              so4t6b = so4t6b + d*temp205b7/so4t6
              condnub(8) = condnub(8) + temp219*temp205b0
              so4t7b = so4t7b + d*temp205b8/so4t7
              condnub(9) = condnub(9) + temp217*temp205b0
              so4t8b = so4t8b + d*temp205b9/so4t8
              condnub(10) = condnub(10) + temp215*temp205b0
              so4t9b = so4t9b + d*temp205b10/so4t9
              condnub(11) = condnub(11) + temp213*temp205b0
              so4t10b = so4t10b + d*temp205b11/so4t10
              condnub(12) = condnub(12) + temp211*temp205b0
              so4t11b = so4t11b + d*temp205b12/so4t11
              condnub(13) = condnub(13) + temp209*temp205b0
              so4t12b = so4t12b + d*temp205b13/so4t12
              condnub(14) = condnub(14) + temp207*temp205b0
              so4t13b = so4t13b + d*temp205b14/so4t13
              condnub(15) = condnub(15) + temp205*temp205b0
              so4t14b = so4t14b + d*temp205b15/so4t14
              adt2b = adt2b - (condnu(1)*temp233+condnu(2)*temp231+
     +          condnu(3)*temp229+condnu(4)*temp227+condnu(5)*temp225+
     +          condnu(6)*temp223+condnu(7)*temp221+condnu(8)*temp219+
     +          condnu(9)*temp217+condnu(10)*temp215+condnu(11)*temp213+
     +          condnu(12)*temp211+condnu(13)*temp209+condnu(14)*temp207
     +          +condnu(15)*temp205)*temp205b0/adt2
              totnub(i) = 0.0
              b = acoefc(i, l, 1)
              CALL POPREAL8(blg)
              bb = blgb/b
            ELSE
              db = 0.D0
              bb = 0.D0
            END IF
            totnub(i) = 0.0
            w = -(98.1/64.6)
            CALL POPREAL8(totso4)
            max3b = totso4b
            xso2b = -(w*totso4b)
            xso4 = (so4t15-xrow(i, l+1, iso4))/adt2
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              xso4b = -(adt2*max3b)
              adt2b = adt2b - xso4*max3b
            ELSE
              xso4b = 0.0
            END IF
            xso2b = xso2b + rtso2b(i, l, 1)/adt2
            temp205b = xso4b/adt2
            so4t15b = so4t15b + temp205b
            xrowb(i, l+1, iso4) = xrowb(i, l+1, iso4) - temp205b
            adt2b = adt2b - xso2*rtso2b(i, l, 1)/adt2**2 - (so4t15-xrow(
     +        i, l+1, iso4))*temp205b/adt2
            CALL POPREAL8(xrow(i, l+1, iso2))
            so2t0b = xrowb(i, l+1, iso2) - xso2b
            xrowb(i, l+1, iso2) = xso2b
            rtso2b(i, l, 1) = 0.0
            CALL POPREAL8(xso2)
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(so4t15)
              y19b = so4t15b
            ELSE
              CALL POPREAL8(so4t15)
              y19b = 0.D0
            END IF
            temp204 = so4t14**(d-1.)
            temp196b = y19b/(a+b*temp204)
            temp203 = so4t14**(d-1.)
            temp196 = a + b*temp203
            temp196b0 = -(pp*EXP(-(temp196*condnu(15)))*temp196b)
            temp196b1 = -(condnu(15)*temp196b0)
            temp202 = -EXP(-(temp196*condnu(15))) + 1.
            temp201 = so4t14**(d-1.)
            temp198 = a + b*temp201
            temp200 = so4t14**(d-1.)
            temp197 = a + b*temp200
            temp199 = EXP(-(temp197*condnu(15)))
            temp197b = temp198*so4t14*EXP(-(temp197*condnu(15)))*
     +        temp196b
            temp197b0 = -(condnu(15)*temp197b)
            temp198b = temp199*so4t14*temp196b
            temp199b = -((temp202*pp+temp199*(temp198*so4t14))*temp196b/
     +        (a+b*temp204))
            ab = ab + temp199b + temp198b + temp197b0 + temp196b1
            bb = bb + temp204*temp199b + temp201*temp198b + temp200*
     +        temp197b0 + temp203*temp196b1
            IF (so4t14 .LE. 0.0 .AND. (d - 1. .EQ. 0.0 .OR. d - 1. .NE. 
     +          INT(d - 1.))) THEN
              so4t14b = so4t14b + temp199*temp198*temp196b
            ELSE
              so4t14b = so4t14b + b*(d-1.)*so4t14**(d-2.0)*temp199b + 
     +          temp199*temp198*temp196b + b*(d-1.)*so4t14**(d-2.0)*
     +          temp198b + b*(d-1.)*so4t14**(d-2.0)*temp197b0 + b*(d-1.)
     +          *so4t14**(d-2.0)*temp196b1
            END IF
            IF (.NOT.so4t14 .LE. 0.0) db = db + b*temp204*LOG(so4t14)*
     +          temp199b + b*temp201*LOG(so4t14)*temp198b + b*temp200*
     +          LOG(so4t14)*temp197b0 + b*temp203*LOG(so4t14)*temp196b1
            ppb = condnu(15)*so2t0b/w + temp202*temp196b
            CALL POPREAL8(so2t0)
            temp195 = so2t0/condnu(15)
            temp194 = -(rtso2(i, l, 1)*condnu(15))
            temp194b = temp195*w*EXP(temp194)*ppb
            temp195b = (EXP(temp194)-1.0)*w*ppb/condnu(15)
            condnub(15) = condnub(15) + pp*so2t0b/w - temp195*temp195b -
     +        rtso2(i, l, 1)*temp194b - temp197*temp197b - temp196*
     +        temp196b0
            CALL POPREAL8(pp)
            rtso2b(i, l, 1) = rtso2b(i, l, 1) - condnu(15)*temp194b
            so2t0b = so2t0b + temp195b
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(so4t14)
              y18b = so4t14b
            ELSE
              CALL POPREAL8(so4t14)
              y18b = 0.D0
            END IF
            temp193 = so4t13**(d-1.)
            temp185b = y18b/(a+b*temp193)
            temp192 = so4t13**(d-1.)
            temp185 = a + b*temp192
            temp185b0 = -(pp*EXP(-(temp185*condnu(14)))*temp185b)
            temp185b1 = -(condnu(14)*temp185b0)
            temp191 = -EXP(-(temp185*condnu(14))) + 1.
            temp190 = so4t13**(d-1.)
            temp187 = a + b*temp190
            temp189 = so4t13**(d-1.)
            temp186 = a + b*temp189
            temp188 = EXP(-(temp186*condnu(14)))
            temp186b = temp187*so4t13*EXP(-(temp186*condnu(14)))*
     +        temp185b
            temp186b0 = -(condnu(14)*temp186b)
            temp187b = temp188*so4t13*temp185b
            temp188b = -((temp191*pp+temp188*(temp187*so4t13))*temp185b/
     +        (a+b*temp193))
            ab = ab + temp188b + temp187b + temp186b0 + temp185b1
            bb = bb + temp193*temp188b + temp190*temp187b + temp189*
     +        temp186b0 + temp192*temp185b1
            IF (so4t13 .LE. 0.0 .AND. (d - 1. .EQ. 0.0 .OR. d - 1. .NE. 
     +          INT(d - 1.))) THEN
              so4t13b = so4t13b + temp188*temp187*temp185b
            ELSE
              so4t13b = so4t13b + b*(d-1.)*so4t13**(d-2.0)*temp188b + 
     +          temp188*temp187*temp185b + b*(d-1.)*so4t13**(d-2.0)*
     +          temp187b + b*(d-1.)*so4t13**(d-2.0)*temp186b0 + b*(d-1.)
     +          *so4t13**(d-2.0)*temp185b1
            END IF
            IF (.NOT.so4t13 .LE. 0.0) db = db + b*temp193*LOG(so4t13)*
     +          temp188b + b*temp190*LOG(so4t13)*temp187b + b*temp189*
     +          LOG(so4t13)*temp186b0 + b*temp192*LOG(so4t13)*temp185b1
            ppb = condnu(14)*so2t0b/w + temp191*temp185b
            CALL POPREAL8(so2t0)
            temp184 = so2t0/condnu(14)
            temp183 = -(rtso2(i, l, 1)*condnu(14))
            temp183b = temp184*w*EXP(temp183)*ppb
            temp184b = (EXP(temp183)-1.0)*w*ppb/condnu(14)
            condnub(14) = condnub(14) + pp*so2t0b/w - temp184*temp184b -
     +        rtso2(i, l, 1)*temp183b - temp186*temp186b - temp185*
     +        temp185b0
            CALL POPREAL8(pp)
            rtso2b(i, l, 1) = rtso2b(i, l, 1) - condnu(14)*temp183b
            so2t0b = so2t0b + temp184b
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(so4t13)
              y17b = so4t13b
            ELSE
              CALL POPREAL8(so4t13)
              y17b = 0.D0
            END IF
            temp182 = so4t12**(d-1.)
            temp174b = y17b/(a+b*temp182)
            temp181 = so4t12**(d-1.)
            temp174 = a + b*temp181
            temp174b0 = -(pp*EXP(-(temp174*condnu(13)))*temp174b)
            temp174b1 = -(condnu(13)*temp174b0)
            temp180 = -EXP(-(temp174*condnu(13))) + 1.
            temp179 = so4t12**(d-1.)
            temp176 = a + b*temp179
            temp178 = so4t12**(d-1.)
            temp175 = a + b*temp178
            temp177 = EXP(-(temp175*condnu(13)))
            temp175b = temp176*so4t12*EXP(-(temp175*condnu(13)))*
     +        temp174b
            temp175b0 = -(condnu(13)*temp175b)
            temp176b = temp177*so4t12*temp174b
            temp177b = -((temp180*pp+temp177*(temp176*so4t12))*temp174b/
     +        (a+b*temp182))
            ab = ab + temp177b + temp176b + temp175b0 + temp174b1
            bb = bb + temp182*temp177b + temp179*temp176b + temp178*
     +        temp175b0 + temp181*temp174b1
            IF (so4t12 .LE. 0.0 .AND. (d - 1. .EQ. 0.0 .OR. d - 1. .NE. 
     +          INT(d - 1.))) THEN
              so4t12b = so4t12b + temp177*temp176*temp174b
            ELSE
              so4t12b = so4t12b + b*(d-1.)*so4t12**(d-2.0)*temp177b + 
     +          temp177*temp176*temp174b + b*(d-1.)*so4t12**(d-2.0)*
     +          temp176b + b*(d-1.)*so4t12**(d-2.0)*temp175b0 + b*(d-1.)
     +          *so4t12**(d-2.0)*temp174b1
            END IF
            IF (.NOT.so4t12 .LE. 0.0) db = db + b*temp182*LOG(so4t12)*
     +          temp177b + b*temp179*LOG(so4t12)*temp176b + b*temp178*
     +          LOG(so4t12)*temp175b0 + b*temp181*LOG(so4t12)*temp174b1
            ppb = condnu(13)*so2t0b/w + temp180*temp174b
            CALL POPREAL8(so2t0)
            temp173 = so2t0/condnu(13)
            temp172 = -(rtso2(i, l, 1)*condnu(13))
            temp172b = temp173*w*EXP(temp172)*ppb
            temp173b = (EXP(temp172)-1.0)*w*ppb/condnu(13)
            condnub(13) = condnub(13) + pp*so2t0b/w - temp173*temp173b -
     +        rtso2(i, l, 1)*temp172b - temp175*temp175b - temp174*
     +        temp174b0
            CALL POPREAL8(pp)
            rtso2b(i, l, 1) = rtso2b(i, l, 1) - condnu(13)*temp172b
            so2t0b = so2t0b + temp173b
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(so4t12)
              y16b = so4t12b
            ELSE
              CALL POPREAL8(so4t12)
              y16b = 0.D0
            END IF
            temp171 = so4t11**(d-1.)
            temp163b = y16b/(a+b*temp171)
            temp170 = so4t11**(d-1.)
            temp163 = a + b*temp170
            temp163b0 = -(pp*EXP(-(temp163*condnu(12)))*temp163b)
            temp163b1 = -(condnu(12)*temp163b0)
            temp169 = -EXP(-(temp163*condnu(12))) + 1.
            temp168 = so4t11**(d-1.)
            temp165 = a + b*temp168
            temp167 = so4t11**(d-1.)
            temp164 = a + b*temp167
            temp166 = EXP(-(temp164*condnu(12)))
            temp164b = temp165*so4t11*EXP(-(temp164*condnu(12)))*
     +        temp163b
            temp164b0 = -(condnu(12)*temp164b)
            temp165b = temp166*so4t11*temp163b
            temp166b = -((temp169*pp+temp166*(temp165*so4t11))*temp163b/
     +        (a+b*temp171))
            ab = ab + temp166b + temp165b + temp164b0 + temp163b1
            bb = bb + temp171*temp166b + temp168*temp165b + temp167*
     +        temp164b0 + temp170*temp163b1
            IF (so4t11 .LE. 0.0 .AND. (d - 1. .EQ. 0.0 .OR. d - 1. .NE. 
     +          INT(d - 1.))) THEN
              so4t11b = so4t11b + temp166*temp165*temp163b
            ELSE
              so4t11b = so4t11b + b*(d-1.)*so4t11**(d-2.0)*temp166b + 
     +          temp166*temp165*temp163b + b*(d-1.)*so4t11**(d-2.0)*
     +          temp165b + b*(d-1.)*so4t11**(d-2.0)*temp164b0 + b*(d-1.)
     +          *so4t11**(d-2.0)*temp163b1
            END IF
            IF (.NOT.so4t11 .LE. 0.0) db = db + b*temp171*LOG(so4t11)*
     +          temp166b + b*temp168*LOG(so4t11)*temp165b + b*temp167*
     +          LOG(so4t11)*temp164b0 + b*temp170*LOG(so4t11)*temp163b1
            ppb = condnu(12)*so2t0b/w + temp169*temp163b
            CALL POPREAL8(so2t0)
            temp162 = so2t0/condnu(12)
            temp161 = -(rtso2(i, l, 1)*condnu(12))
            temp161b = temp162*w*EXP(temp161)*ppb
            temp162b = (EXP(temp161)-1.0)*w*ppb/condnu(12)
            condnub(12) = condnub(12) + pp*so2t0b/w - temp162*temp162b -
     +        rtso2(i, l, 1)*temp161b - temp164*temp164b - temp163*
     +        temp163b0
            CALL POPREAL8(pp)
            rtso2b(i, l, 1) = rtso2b(i, l, 1) - condnu(12)*temp161b
            so2t0b = so2t0b + temp162b
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(so4t11)
              y15b = so4t11b
            ELSE
              CALL POPREAL8(so4t11)
              y15b = 0.D0
            END IF
            temp160 = so4t10**(d-1.)
            temp152b = y15b/(a+b*temp160)
            temp159 = so4t10**(d-1.)
            temp152 = a + b*temp159
            temp152b0 = -(pp*EXP(-(temp152*condnu(11)))*temp152b)
            temp152b1 = -(condnu(11)*temp152b0)
            temp158 = -EXP(-(temp152*condnu(11))) + 1.
            temp157 = so4t10**(d-1.)
            temp154 = a + b*temp157
            temp156 = so4t10**(d-1.)
            temp153 = a + b*temp156
            temp155 = EXP(-(temp153*condnu(11)))
            temp153b = temp154*so4t10*EXP(-(temp153*condnu(11)))*
     +        temp152b
            temp153b0 = -(condnu(11)*temp153b)
            temp154b = temp155*so4t10*temp152b
            temp155b = -((temp158*pp+temp155*(temp154*so4t10))*temp152b/
     +        (a+b*temp160))
            ab = ab + temp155b + temp154b + temp153b0 + temp152b1
            bb = bb + temp160*temp155b + temp157*temp154b + temp156*
     +        temp153b0 + temp159*temp152b1
            IF (so4t10 .LE. 0.0 .AND. (d - 1. .EQ. 0.0 .OR. d - 1. .NE. 
     +          INT(d - 1.))) THEN
              so4t10b = so4t10b + temp155*temp154*temp152b
            ELSE
              so4t10b = so4t10b + b*(d-1.)*so4t10**(d-2.0)*temp155b + 
     +          temp155*temp154*temp152b + b*(d-1.)*so4t10**(d-2.0)*
     +          temp154b + b*(d-1.)*so4t10**(d-2.0)*temp153b0 + b*(d-1.)
     +          *so4t10**(d-2.0)*temp152b1
            END IF
            IF (.NOT.so4t10 .LE. 0.0) db = db + b*temp160*LOG(so4t10)*
     +          temp155b + b*temp157*LOG(so4t10)*temp154b + b*temp156*
     +          LOG(so4t10)*temp153b0 + b*temp159*LOG(so4t10)*temp152b1
            ppb = condnu(11)*so2t0b/w + temp158*temp152b
            CALL POPREAL8(so2t0)
            temp151 = so2t0/condnu(11)
            temp150 = -(rtso2(i, l, 1)*condnu(11))
            temp150b = temp151*w*EXP(temp150)*ppb
            temp151b = (EXP(temp150)-1.0)*w*ppb/condnu(11)
            condnub(11) = condnub(11) + pp*so2t0b/w - temp151*temp151b -
     +        rtso2(i, l, 1)*temp150b - temp153*temp153b - temp152*
     +        temp152b0
            CALL POPREAL8(pp)
            rtso2b(i, l, 1) = rtso2b(i, l, 1) - condnu(11)*temp150b
            so2t0b = so2t0b + temp151b
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(so4t10)
              y14b = so4t10b
            ELSE
              CALL POPREAL8(so4t10)
              y14b = 0.D0
            END IF
            temp149 = so4t9**(d-1.)
            temp141b = y14b/(a+b*temp149)
            temp148 = so4t9**(d-1.)
            temp141 = a + b*temp148
            temp141b0 = -(pp*EXP(-(temp141*condnu(10)))*temp141b)
            temp141b1 = -(condnu(10)*temp141b0)
            temp147 = -EXP(-(temp141*condnu(10))) + 1.
            temp146 = so4t9**(d-1.)
            temp143 = a + b*temp146
            temp145 = so4t9**(d-1.)
            temp142 = a + b*temp145
            temp144 = EXP(-(temp142*condnu(10)))
            temp142b = temp143*so4t9*EXP(-(temp142*condnu(10)))*temp141b
            temp142b0 = -(condnu(10)*temp142b)
            temp143b = temp144*so4t9*temp141b
            temp144b = -((temp147*pp+temp144*(temp143*so4t9))*temp141b/(
     +        a+b*temp149))
            ab = ab + temp144b + temp143b + temp142b0 + temp141b1
            bb = bb + temp149*temp144b + temp146*temp143b + temp145*
     +        temp142b0 + temp148*temp141b1
            IF (so4t9 .LE. 0.0 .AND. (d - 1. .EQ. 0.0 .OR. d - 1. .NE. 
     +          INT(d - 1.))) THEN
              so4t9b = so4t9b + temp144*temp143*temp141b
            ELSE
              so4t9b = so4t9b + b*(d-1.)*so4t9**(d-2.0)*temp144b + 
     +          temp144*temp143*temp141b + b*(d-1.)*so4t9**(d-2.0)*
     +          temp143b + b*(d-1.)*so4t9**(d-2.0)*temp142b0 + b*(d-1.)*
     +          so4t9**(d-2.0)*temp141b1
            END IF
            IF (.NOT.so4t9 .LE. 0.0) db = db + b*temp149*LOG(so4t9)*
     +          temp144b + b*temp146*LOG(so4t9)*temp143b + b*temp145*LOG
     +          (so4t9)*temp142b0 + b*temp148*LOG(so4t9)*temp141b1
            ppb = condnu(10)*so2t0b/w + temp147*temp141b
            CALL POPREAL8(so2t0)
            temp140 = so2t0/condnu(10)
            temp139 = -(rtso2(i, l, 1)*condnu(10))
            temp139b = temp140*w*EXP(temp139)*ppb
            temp140b = (EXP(temp139)-1.0)*w*ppb/condnu(10)
            condnub(10) = condnub(10) + pp*so2t0b/w - temp140*temp140b -
     +        rtso2(i, l, 1)*temp139b - temp142*temp142b - temp141*
     +        temp141b0
            CALL POPREAL8(pp)
            rtso2b(i, l, 1) = rtso2b(i, l, 1) - condnu(10)*temp139b
            so2t0b = so2t0b + temp140b
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(so4t9)
              y13b = so4t9b
            ELSE
              CALL POPREAL8(so4t9)
              y13b = 0.D0
            END IF
            temp138 = so4t8**(d-1.)
            temp130b = y13b/(a+b*temp138)
            temp137 = so4t8**(d-1.)
            temp130 = a + b*temp137
            temp130b0 = -(pp*EXP(-(temp130*condnu(9)))*temp130b)
            temp130b1 = -(condnu(9)*temp130b0)
            temp136 = -EXP(-(temp130*condnu(9))) + 1.
            temp135 = so4t8**(d-1.)
            temp132 = a + b*temp135
            temp134 = so4t8**(d-1.)
            temp131 = a + b*temp134
            temp133 = EXP(-(temp131*condnu(9)))
            temp131b = temp132*so4t8*EXP(-(temp131*condnu(9)))*temp130b
            temp131b0 = -(condnu(9)*temp131b)
            temp132b = temp133*so4t8*temp130b
            temp133b = -((temp136*pp+temp133*(temp132*so4t8))*temp130b/(
     +        a+b*temp138))
            ab = ab + temp133b + temp132b + temp131b0 + temp130b1
            bb = bb + temp138*temp133b + temp135*temp132b + temp134*
     +        temp131b0 + temp137*temp130b1
            IF (so4t8 .LE. 0.0 .AND. (d - 1. .EQ. 0.0 .OR. d - 1. .NE. 
     +          INT(d - 1.))) THEN
              so4t8b = so4t8b + temp133*temp132*temp130b
            ELSE
              so4t8b = so4t8b + b*(d-1.)*so4t8**(d-2.0)*temp133b + 
     +          temp133*temp132*temp130b + b*(d-1.)*so4t8**(d-2.0)*
     +          temp132b + b*(d-1.)*so4t8**(d-2.0)*temp131b0 + b*(d-1.)*
     +          so4t8**(d-2.0)*temp130b1
            END IF
            IF (.NOT.so4t8 .LE. 0.0) db = db + b*temp138*LOG(so4t8)*
     +          temp133b + b*temp135*LOG(so4t8)*temp132b + b*temp134*LOG
     +          (so4t8)*temp131b0 + b*temp137*LOG(so4t8)*temp130b1
            ppb = condnu(9)*so2t0b/w + temp136*temp130b
            CALL POPREAL8(so2t0)
            temp129 = so2t0/condnu(9)
            temp128 = -(rtso2(i, l, 1)*condnu(9))
            temp128b = temp129*w*EXP(temp128)*ppb
            temp129b = (EXP(temp128)-1.0)*w*ppb/condnu(9)
            condnub(9) = condnub(9) + pp*so2t0b/w - temp129*temp129b - 
     +        rtso2(i, l, 1)*temp128b - temp131*temp131b - temp130*
     +        temp130b0
            CALL POPREAL8(pp)
            rtso2b(i, l, 1) = rtso2b(i, l, 1) - condnu(9)*temp128b
            so2t0b = so2t0b + temp129b
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(so4t8)
              y12b = so4t8b
            ELSE
              CALL POPREAL8(so4t8)
              y12b = 0.D0
            END IF
            temp127 = so4t7**(d-1.)
            temp119b = y12b/(a+b*temp127)
            temp126 = so4t7**(d-1.)
            temp119 = a + b*temp126
            temp119b0 = -(pp*EXP(-(temp119*condnu(8)))*temp119b)
            temp119b1 = -(condnu(8)*temp119b0)
            temp125 = -EXP(-(temp119*condnu(8))) + 1.
            temp124 = so4t7**(d-1.)
            temp121 = a + b*temp124
            temp123 = so4t7**(d-1.)
            temp120 = a + b*temp123
            temp122 = EXP(-(temp120*condnu(8)))
            temp120b = temp121*so4t7*EXP(-(temp120*condnu(8)))*temp119b
            temp120b0 = -(condnu(8)*temp120b)
            temp121b = temp122*so4t7*temp119b
            temp122b = -((temp125*pp+temp122*(temp121*so4t7))*temp119b/(
     +        a+b*temp127))
            ab = ab + temp122b + temp121b + temp120b0 + temp119b1
            bb = bb + temp127*temp122b + temp124*temp121b + temp123*
     +        temp120b0 + temp126*temp119b1
            IF (so4t7 .LE. 0.0 .AND. (d - 1. .EQ. 0.0 .OR. d - 1. .NE. 
     +          INT(d - 1.))) THEN
              so4t7b = so4t7b + temp122*temp121*temp119b
            ELSE
              so4t7b = so4t7b + b*(d-1.)*so4t7**(d-2.0)*temp122b + 
     +          temp122*temp121*temp119b + b*(d-1.)*so4t7**(d-2.0)*
     +          temp121b + b*(d-1.)*so4t7**(d-2.0)*temp120b0 + b*(d-1.)*
     +          so4t7**(d-2.0)*temp119b1
            END IF
            IF (.NOT.so4t7 .LE. 0.0) db = db + b*temp127*LOG(so4t7)*
     +          temp122b + b*temp124*LOG(so4t7)*temp121b + b*temp123*LOG
     +          (so4t7)*temp120b0 + b*temp126*LOG(so4t7)*temp119b1
            ppb = condnu(8)*so2t0b/w + temp125*temp119b
            CALL POPREAL8(so2t0)
            temp118 = so2t0/condnu(8)
            temp117 = -(rtso2(i, l, 1)*condnu(8))
            temp117b = temp118*w*EXP(temp117)*ppb
            temp118b = (EXP(temp117)-1.0)*w*ppb/condnu(8)
            condnub(8) = condnub(8) + pp*so2t0b/w - temp118*temp118b - 
     +        rtso2(i, l, 1)*temp117b - temp120*temp120b - temp119*
     +        temp119b0
            CALL POPREAL8(pp)
            rtso2b(i, l, 1) = rtso2b(i, l, 1) - condnu(8)*temp117b
            so2t0b = so2t0b + temp118b
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(so4t7)
              y11b = so4t7b
            ELSE
              CALL POPREAL8(so4t7)
              y11b = 0.D0
            END IF
            temp116 = so4t6**(d-1.)
            temp108b = y11b/(a+b*temp116)
            temp115 = so4t6**(d-1.)
            temp108 = a + b*temp115
            temp108b0 = -(pp*EXP(-(temp108*condnu(7)))*temp108b)
            temp108b1 = -(condnu(7)*temp108b0)
            temp114 = -EXP(-(temp108*condnu(7))) + 1.
            temp113 = so4t6**(d-1.)
            temp110 = a + b*temp113
            temp112 = so4t6**(d-1.)
            temp109 = a + b*temp112
            temp111 = EXP(-(temp109*condnu(7)))
            temp109b = temp110*so4t6*EXP(-(temp109*condnu(7)))*temp108b
            temp109b0 = -(condnu(7)*temp109b)
            temp110b = temp111*so4t6*temp108b
            temp111b = -((temp114*pp+temp111*(temp110*so4t6))*temp108b/(
     +        a+b*temp116))
            ab = ab + temp111b + temp110b + temp109b0 + temp108b1
            bb = bb + temp116*temp111b + temp113*temp110b + temp112*
     +        temp109b0 + temp115*temp108b1
            IF (so4t6 .LE. 0.0 .AND. (d - 1. .EQ. 0.0 .OR. d - 1. .NE. 
     +          INT(d - 1.))) THEN
              so4t6b = so4t6b + temp111*temp110*temp108b
            ELSE
              so4t6b = so4t6b + b*(d-1.)*so4t6**(d-2.0)*temp111b + 
     +          temp111*temp110*temp108b + b*(d-1.)*so4t6**(d-2.0)*
     +          temp110b + b*(d-1.)*so4t6**(d-2.0)*temp109b0 + b*(d-1.)*
     +          so4t6**(d-2.0)*temp108b1
            END IF
            IF (.NOT.so4t6 .LE. 0.0) db = db + b*temp116*LOG(so4t6)*
     +          temp111b + b*temp113*LOG(so4t6)*temp110b + b*temp112*LOG
     +          (so4t6)*temp109b0 + b*temp115*LOG(so4t6)*temp108b1
            ppb = condnu(7)*so2t0b/w + temp114*temp108b
            CALL POPREAL8(so2t0)
            temp107 = so2t0/condnu(7)
            temp106 = -(rtso2(i, l, 1)*condnu(7))
            temp106b = temp107*w*EXP(temp106)*ppb
            temp107b = (EXP(temp106)-1.0)*w*ppb/condnu(7)
            condnub(7) = condnub(7) + pp*so2t0b/w - temp107*temp107b - 
     +        rtso2(i, l, 1)*temp106b - temp109*temp109b - temp108*
     +        temp108b0
            CALL POPREAL8(pp)
            rtso2b(i, l, 1) = rtso2b(i, l, 1) - condnu(7)*temp106b
            so2t0b = so2t0b + temp107b
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(so4t6)
              y10b = so4t6b
            ELSE
              CALL POPREAL8(so4t6)
              y10b = 0.D0
            END IF
            temp105 = so4t5**(d-1.)
            temp97b = y10b/(a+b*temp105)
            temp104 = so4t5**(d-1.)
            temp97 = a + b*temp104
            temp97b0 = -(pp*EXP(-(temp97*condnu(6)))*temp97b)
            temp97b1 = -(condnu(6)*temp97b0)
            temp103 = -EXP(-(temp97*condnu(6))) + 1.
            temp102 = so4t5**(d-1.)
            temp99 = a + b*temp102
            temp101 = so4t5**(d-1.)
            temp98 = a + b*temp101
            temp100 = EXP(-(temp98*condnu(6)))
            temp98b = temp99*so4t5*EXP(-(temp98*condnu(6)))*temp97b
            temp98b0 = -(condnu(6)*temp98b)
            temp99b = temp100*so4t5*temp97b
            temp100b = -((temp103*pp+temp100*(temp99*so4t5))*temp97b/(a+
     +        b*temp105))
            ab = ab + temp100b + temp99b + temp98b0 + temp97b1
            bb = bb + temp105*temp100b + temp102*temp99b + temp101*
     +        temp98b0 + temp104*temp97b1
            IF (so4t5 .LE. 0.0 .AND. (d - 1. .EQ. 0.0 .OR. d - 1. .NE. 
     +          INT(d - 1.))) THEN
              so4t5b = so4t5b + temp100*temp99*temp97b
            ELSE
              so4t5b = so4t5b + b*(d-1.)*so4t5**(d-2.0)*temp100b + 
     +          temp100*temp99*temp97b + b*(d-1.)*so4t5**(d-2.0)*temp99b
     +          + b*(d-1.)*so4t5**(d-2.0)*temp98b0 + b*(d-1.)*so4t5**(d-
     +          2.0)*temp97b1
            END IF
            IF (.NOT.so4t5 .LE. 0.0) db = db + b*temp105*LOG(so4t5)*
     +          temp100b + b*temp102*LOG(so4t5)*temp99b + b*temp101*LOG(
     +          so4t5)*temp98b0 + b*temp104*LOG(so4t5)*temp97b1
            ppb = condnu(6)*so2t0b/w + temp103*temp97b
            CALL POPREAL8(so2t0)
            temp96 = so2t0/condnu(6)
            temp95 = -(rtso2(i, l, 1)*condnu(6))
            temp95b = temp96*w*EXP(temp95)*ppb
            temp96b = (EXP(temp95)-1.0)*w*ppb/condnu(6)
            condnub(6) = condnub(6) + pp*so2t0b/w - temp96*temp96b - 
     +        rtso2(i, l, 1)*temp95b - temp98*temp98b - temp97*temp97b0
            CALL POPREAL8(pp)
            rtso2b(i, l, 1) = rtso2b(i, l, 1) - condnu(6)*temp95b
            so2t0b = so2t0b + temp96b
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(so4t5)
              y9b = so4t5b
            ELSE
              CALL POPREAL8(so4t5)
              y9b = 0.D0
            END IF
            temp94 = so4t4**(d-1.)
            temp86b = y9b/(a+b*temp94)
            temp93 = so4t4**(d-1.)
            temp86 = a + b*temp93
            temp86b0 = -(pp*EXP(-(temp86*condnu(5)))*temp86b)
            temp86b1 = -(condnu(5)*temp86b0)
            temp92 = -EXP(-(temp86*condnu(5))) + 1.
            temp91 = so4t4**(d-1.)
            temp88 = a + b*temp91
            temp90 = so4t4**(d-1.)
            temp87 = a + b*temp90
            temp89 = EXP(-(temp87*condnu(5)))
            temp87b = temp88*so4t4*EXP(-(temp87*condnu(5)))*temp86b
            temp87b0 = -(condnu(5)*temp87b)
            temp88b = temp89*so4t4*temp86b
            temp89b = -((temp92*pp+temp89*(temp88*so4t4))*temp86b/(a+b*
     +        temp94))
            ab = ab + temp89b + temp88b + temp87b0 + temp86b1
            bb = bb + temp94*temp89b + temp91*temp88b + temp90*temp87b0 
     +        + temp93*temp86b1
            IF (so4t4 .LE. 0.0 .AND. (d - 1. .EQ. 0.0 .OR. d - 1. .NE. 
     +          INT(d - 1.))) THEN
              so4t4b = so4t4b + temp89*temp88*temp86b
            ELSE
              so4t4b = so4t4b + b*(d-1.)*so4t4**(d-2.0)*temp89b + temp89
     +          *temp88*temp86b + b*(d-1.)*so4t4**(d-2.0)*temp88b + b*(d
     +          -1.)*so4t4**(d-2.0)*temp87b0 + b*(d-1.)*so4t4**(d-2.0)*
     +          temp86b1
            END IF
            IF (.NOT.so4t4 .LE. 0.0) db = db + b*temp94*LOG(so4t4)*
     +          temp89b + b*temp91*LOG(so4t4)*temp88b + b*temp90*LOG(
     +          so4t4)*temp87b0 + b*temp93*LOG(so4t4)*temp86b1
            ppb = condnu(5)*so2t0b/w + temp92*temp86b
            CALL POPREAL8(so2t0)
            temp85 = so2t0/condnu(5)
            temp84 = -(rtso2(i, l, 1)*condnu(5))
            temp84b = temp85*w*EXP(temp84)*ppb
            temp85b = (EXP(temp84)-1.0)*w*ppb/condnu(5)
            condnub(5) = condnub(5) + pp*so2t0b/w - temp85*temp85b - 
     +        rtso2(i, l, 1)*temp84b - temp87*temp87b - temp86*temp86b0
            CALL POPREAL8(pp)
            rtso2b(i, l, 1) = rtso2b(i, l, 1) - condnu(5)*temp84b
            so2t0b = so2t0b + temp85b
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(so4t4)
              y8b = so4t4b
            ELSE
              CALL POPREAL8(so4t4)
              y8b = 0.D0
            END IF
            temp83 = so4t3**(d-1.)
            temp75b = y8b/(a+b*temp83)
            temp82 = so4t3**(d-1.)
            temp75 = a + b*temp82
            temp75b0 = -(pp*EXP(-(temp75*condnu(4)))*temp75b)
            temp75b1 = -(condnu(4)*temp75b0)
            temp81 = -EXP(-(temp75*condnu(4))) + 1.
            temp80 = so4t3**(d-1.)
            temp77 = a + b*temp80
            temp79 = so4t3**(d-1.)
            temp76 = a + b*temp79
            temp78 = EXP(-(temp76*condnu(4)))
            temp76b = temp77*so4t3*EXP(-(temp76*condnu(4)))*temp75b
            temp76b0 = -(condnu(4)*temp76b)
            temp77b = temp78*so4t3*temp75b
            temp78b = -((temp81*pp+temp78*(temp77*so4t3))*temp75b/(a+b*
     +        temp83))
            ab = ab + temp78b + temp77b + temp76b0 + temp75b1
            bb = bb + temp83*temp78b + temp80*temp77b + temp79*temp76b0 
     +        + temp82*temp75b1
            IF (so4t3 .LE. 0.0 .AND. (d - 1. .EQ. 0.0 .OR. d - 1. .NE. 
     +          INT(d - 1.))) THEN
              so4t3b = so4t3b + temp78*temp77*temp75b
            ELSE
              so4t3b = so4t3b + b*(d-1.)*so4t3**(d-2.0)*temp78b + temp78
     +          *temp77*temp75b + b*(d-1.)*so4t3**(d-2.0)*temp77b + b*(d
     +          -1.)*so4t3**(d-2.0)*temp76b0 + b*(d-1.)*so4t3**(d-2.0)*
     +          temp75b1
            END IF
            IF (.NOT.so4t3 .LE. 0.0) db = db + b*temp83*LOG(so4t3)*
     +          temp78b + b*temp80*LOG(so4t3)*temp77b + b*temp79*LOG(
     +          so4t3)*temp76b0 + b*temp82*LOG(so4t3)*temp75b1
            ppb = condnu(4)*so2t0b/w + temp81*temp75b
            CALL POPREAL8(so2t0)
            temp74 = so2t0/condnu(4)
            temp73 = -(rtso2(i, l, 1)*condnu(4))
            temp73b = temp74*w*EXP(temp73)*ppb
            temp74b = (EXP(temp73)-1.0)*w*ppb/condnu(4)
            condnub(4) = condnub(4) + pp*so2t0b/w - temp74*temp74b - 
     +        rtso2(i, l, 1)*temp73b - temp76*temp76b - temp75*temp75b0
            CALL POPREAL8(pp)
            rtso2b(i, l, 1) = rtso2b(i, l, 1) - condnu(4)*temp73b
            so2t0b = so2t0b + temp74b
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(so4t3)
              y7b = so4t3b
            ELSE
              CALL POPREAL8(so4t3)
              y7b = 0.D0
            END IF
            temp72 = so4t2**(d-1.)
            temp64b = y7b/(a+b*temp72)
            temp71 = so4t2**(d-1.)
            temp64 = a + b*temp71
            temp64b0 = -(pp*EXP(-(temp64*condnu(3)))*temp64b)
            temp64b1 = -(condnu(3)*temp64b0)
            temp70 = -EXP(-(temp64*condnu(3))) + 1.
            temp69 = so4t2**(d-1.)
            temp66 = a + b*temp69
            temp68 = so4t2**(d-1.)
            temp65 = a + b*temp68
            temp67 = EXP(-(temp65*condnu(3)))
            temp65b = temp66*so4t2*EXP(-(temp65*condnu(3)))*temp64b
            temp65b0 = -(condnu(3)*temp65b)
            temp66b = temp67*so4t2*temp64b
            temp67b = -((temp70*pp+temp67*(temp66*so4t2))*temp64b/(a+b*
     +        temp72))
            ab = ab + temp67b + temp66b + temp65b0 + temp64b1
            bb = bb + temp72*temp67b + temp69*temp66b + temp68*temp65b0 
     +        + temp71*temp64b1
            IF (so4t2 .LE. 0.0 .AND. (d - 1. .EQ. 0.0 .OR. d - 1. .NE. 
     +          INT(d - 1.))) THEN
              so4t2b = so4t2b + temp67*temp66*temp64b
            ELSE
              so4t2b = so4t2b + b*(d-1.)*so4t2**(d-2.0)*temp67b + temp67
     +          *temp66*temp64b + b*(d-1.)*so4t2**(d-2.0)*temp66b + b*(d
     +          -1.)*so4t2**(d-2.0)*temp65b0 + b*(d-1.)*so4t2**(d-2.0)*
     +          temp64b1
            END IF
            IF (.NOT.so4t2 .LE. 0.0) db = db + b*temp72*LOG(so4t2)*
     +          temp67b + b*temp69*LOG(so4t2)*temp66b + b*temp68*LOG(
     +          so4t2)*temp65b0 + b*temp71*LOG(so4t2)*temp64b1
            ppb = condnu(3)*so2t0b/w + temp70*temp64b
            CALL POPREAL8(so2t0)
            temp63 = so2t0/condnu(3)
            temp62 = -(rtso2(i, l, 1)*condnu(3))
            temp62b = temp63*w*EXP(temp62)*ppb
            temp63b = (EXP(temp62)-1.0)*w*ppb/condnu(3)
            condnub(3) = condnub(3) + pp*so2t0b/w - temp63*temp63b - 
     +        rtso2(i, l, 1)*temp62b - temp65*temp65b - temp64*temp64b0
            CALL POPREAL8(pp)
            rtso2b(i, l, 1) = rtso2b(i, l, 1) - condnu(3)*temp62b
            so2t0b = so2t0b + temp63b
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(so4t2)
              y6b = so4t2b
            ELSE
              CALL POPREAL8(so4t2)
              y6b = 0.D0
            END IF
            temp61 = so4t1**(d-1.)
            temp53b = y6b/(a+b*temp61)
            temp60 = so4t1**(d-1.)
            temp53 = a + b*temp60
            temp53b0 = -(pp*EXP(-(temp53*condnu(2)))*temp53b)
            temp53b1 = -(condnu(2)*temp53b0)
            temp59 = -EXP(-(temp53*condnu(2))) + 1.
            temp58 = so4t1**(d-1.)
            temp55 = a + b*temp58
            temp57 = so4t1**(d-1.)
            temp54 = a + b*temp57
            temp56 = EXP(-(temp54*condnu(2)))
            temp54b = temp55*so4t1*EXP(-(temp54*condnu(2)))*temp53b
            temp54b0 = -(condnu(2)*temp54b)
            temp55b = temp56*so4t1*temp53b
            temp56b = -((temp59*pp+temp56*(temp55*so4t1))*temp53b/(a+b*
     +        temp61))
            ab = ab + temp56b + temp55b + temp54b0 + temp53b1
            bb = bb + temp61*temp56b + temp58*temp55b + temp57*temp54b0 
     +        + temp60*temp53b1
            IF (so4t1 .LE. 0.0 .AND. (d - 1. .EQ. 0.0 .OR. d - 1. .NE. 
     +          INT(d - 1.))) THEN
              so4t1b = so4t1b + temp56*temp55*temp53b
            ELSE
              so4t1b = so4t1b + b*(d-1.)*so4t1**(d-2.0)*temp56b + temp56
     +          *temp55*temp53b + b*(d-1.)*so4t1**(d-2.0)*temp55b + b*(d
     +          -1.)*so4t1**(d-2.0)*temp54b0 + b*(d-1.)*so4t1**(d-2.0)*
     +          temp53b1
            END IF
            IF (.NOT.so4t1 .LE. 0.0) db = db + b*temp61*LOG(so4t1)*
     +          temp56b + b*temp58*LOG(so4t1)*temp55b + b*temp57*LOG(
     +          so4t1)*temp54b0 + b*temp60*LOG(so4t1)*temp53b1
            ppb = condnu(2)*so2t0b/w + temp59*temp53b
            CALL POPREAL8(so2t0)
            temp52 = so2t0/condnu(2)
            temp51 = -(rtso2(i, l, 1)*condnu(2))
            temp51b = temp52*w*EXP(temp51)*ppb
            temp52b = (EXP(temp51)-1.0)*w*ppb/condnu(2)
            condnub(2) = condnub(2) + pp*so2t0b/w - temp52*temp52b - 
     +        rtso2(i, l, 1)*temp51b - temp54*temp54b - temp53*temp53b0
            CALL POPREAL8(pp)
            rtso2b(i, l, 1) = rtso2b(i, l, 1) - condnu(2)*temp51b
            so2t0b = so2t0b + temp52b
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(so4t1)
              y5b = so4t1b
            ELSE
              CALL POPREAL8(so4t1)
              y5b = 0.D0
            END IF
            temp50 = so4t0**(d-1.)
            temp42b = y5b/(a+b*temp50)
            temp49 = so4t0**(d-1.)
            temp42 = a + b*temp49
            temp42b0 = -(pp*EXP(-(temp42*condnu(1)))*temp42b)
            temp42b1 = -(condnu(1)*temp42b0)
            temp48 = -EXP(-(temp42*condnu(1))) + 1.
            temp47 = so4t0**(d-1.)
            temp44 = a + b*temp47
            temp46 = so4t0**(d-1.)
            temp43 = a + b*temp46
            temp45 = EXP(-(temp43*condnu(1)))
            temp43b = temp44*so4t0*EXP(-(temp43*condnu(1)))*temp42b
            temp43b0 = -(condnu(1)*temp43b)
            temp44b = temp45*so4t0*temp42b
            temp45b = -((temp48*pp+temp45*(temp44*so4t0))*temp42b/(a+b*
     +        temp50))
            ab = ab + temp45b + temp44b + temp43b0 + temp42b1
            bb = bb + temp50*temp45b + temp47*temp44b + temp46*temp43b0 
     +        + temp49*temp42b1
            IF (so4t0 .LE. 0.0 .AND. (d - 1. .EQ. 0.0 .OR. d - 1. .NE. 
     +          INT(d - 1.))) THEN
              so4t0b = so4t0b + temp45*temp44*temp42b
            ELSE
              so4t0b = so4t0b + b*(d-1.)*so4t0**(d-2.0)*temp45b + temp45
     +          *temp44*temp42b + b*(d-1.)*so4t0**(d-2.0)*temp44b + b*(d
     +          -1.)*so4t0**(d-2.0)*temp43b0 + b*(d-1.)*so4t0**(d-2.0)*
     +          temp42b1
            END IF
            IF (.NOT.so4t0 .LE. 0.0) db = db + b*temp50*LOG(so4t0)*
     +          temp45b + b*temp47*LOG(so4t0)*temp44b + b*temp46*LOG(
     +          so4t0)*temp43b0 + b*temp49*LOG(so4t0)*temp42b1
            ppb = condnu(1)*so2t0b/w + temp48*temp42b
            CALL POPREAL8(so2t0)
            temp41 = so2t0/condnu(1)
            temp40 = -(rtso2(i, l, 1)*condnu(1))
            temp40b = temp41*w*EXP(temp40)*ppb
            temp41b = (EXP(temp40)-1.0)*w*ppb/condnu(1)
            condnub(1) = condnub(1) + pp*so2t0b/w - temp41*temp41b - 
     +        rtso2(i, l, 1)*temp40b - temp43*temp43b - temp42*temp42b0
            CALL POPREAL8(pp)
            rtso2b(i, l, 1) = rtso2b(i, l, 1) - condnu(1)*temp40b
            so2t0b = so2t0b + temp41b
            CALL POPREAL8(d)
            acoefcb(i, l, 2) = acoefcb(i, l, 2) + db
            CALL POPREAL8(b)
            acoefcb(i, l, 1) = acoefcb(i, l, 1) + bb
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(a)
              x4b = 0.0
            ELSE
              CALL POPREAL8(a)
              x4b = ab
            END IF
            CALL POPCONTROL1B(branch)
            IF (branch .NE. 0) totcdnb(i, l) = totcdnb(i, l) + x4b
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) xrowb(i, l+1, iso2) = xrowb(i, l+1, iso2) +
     +        so2t0b
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPREAL8(so4t0)
            xrowb(i, l+1, iso4) = xrowb(i, l+1, iso4) + so4t0b
          ELSE
            CALL POPREAL8(so4t0)
          END IF
        ENDDO
      ENDDO
      CALL POPINTEGER4(ad_to6)
      DO n=ad_to6,1,-1
        CALL POPINTEGER4(ad_from4)
        CALL POPINTEGER4(ad_to5)
        DO l=ad_to5,ad_from4,-1
          CALL POPINTEGER4(ad_from3)
          CALL POPINTEGER4(ad_to4)
          DO i=ad_to4,ad_from3,-1
            CALL POPCONTROL2B(branch)
            IF (branch .EQ. 0) THEN
              condb = 0.0
            ELSE
              IF (branch .EQ. 1) THEN
                pcondb(i, l, n) = 0.0
                x3b = 0.0
              ELSE
                x3b = pcondb(i, l, n)
                pcondb(i, l, n) = 0.0
              END IF
              cond = totcdn(i, l)
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                condb = 0.0
              ELSE
                rtcondb(i, l, n) = rtcondb(i, l, n) + x3b/cond
                condb = -(rtcond(i, l, n)*x3b/cond**2)
              END IF
            END IF
            totcdnb(i, l) = totcdnb(i, l) + condb
          ENDDO
        ENDDO
      ENDDO
      DO ii1=1,lev
        DO ii2=1,ilg
c          tb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,ilev
        DO ii2=1,ilg
c          shjb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,isize
        DO ii2=1,ilev
          DO ii3=1,ilg
c            rhsizeb(ii3, ii2, ii1) = 0.0
          ENDDO
        ENDDO
      ENDDO
      DO ii1=1,ilg
c        pressgb(ii1) = 0.0
      ENDDO
      CALL POPINTEGER4(ad_to3)
      DO n=ad_to3,1,-1
        CALL POPINTEGER4(ad_from2)
        CALL POPINTEGER4(ad_to2)
        DO l=ad_to2,ad_from2,-1
          CALL POPINTEGER4(ad_from1)
          CALL POPINTEGER4(ad_to1)
          DO i=ad_to1,ad_from1,-1
            CALL POPCONTROL1B(branch)
            IF (branch .NE. 0) THEN
              temp34 = 8.e3*rgasi*t(i, l+1)
              temp33 = 98.1*pi/temp34
              temp32 = SQRT(temp33)
              rtcondb(i, l, n) = rtcondb(i, l, n) + totcdnb(i, l)
              kn = frp/rhsize(i, l, n)
              fn = (1.+kn)/(1.+1.71*kn+1.33*kn*kn)
              an = 1./(1.+1.33*kn*fn*(1./ace-1.))
              temp39 = an*roarow(i, l)
              temp38 = aeronum(i, l, n)
              temp37 = rhsize(i, l, n)
              temp37b = pi*4.*rtcondb(i, l, n)
              temp37b0 = temp38*temp39*temp37b
              temp37b1 = temp37*dfso4*fn*temp37b
              aeronumb(i, l, n) = aeronumb(i, l, n) + temp39*temp37b1
              anb = temp38*roarow(i, l)*temp37b1
              roarowb(i, l) = roarowb(i, l) + temp38*an*temp37b1
              rtcondb(i, l, n) = 0.0
              temp36 = 1.33*(1.0/ace-1.)*kn*fn + 1.
              temp36b = -((1.0/ace-1.)*1.33*anb/temp36**2)
              fnb = kn*temp36b + temp37*dfso4*temp37b0
              temp35 = 1.71*kn + 1.33*kn**2 + 1.
              temp35b0 = -((kn+1.)*fnb/temp35**2)
              knb = fnb/temp35 + (1.33*2*kn+1.71)*temp35b0 + fn*temp36b
              temp35b = knb/rhsize(i, l, n)
              rhsizeb(i, l, n) = rhsizeb(i, l, n) + dfso4*fn*temp37b0 - 
     +          frp*temp35b/rhsize(i, l, n)
              frpb = temp35b
              dfso4b = 3.0*temp32*frpb + temp37*fn*temp37b0
              CALL POPREAL8(frp)
              temp31 = ((0.369*airmw+6.29)**cub+(1.e3*so4mw*0.369+6.29)
     +          **cub)**2
              temp30 = temp31*pressg(i)*shj(i, l)
              temp30b = 0.21145*1.01325e5*1.e-7*dfso4b/temp30
              IF (temp33 .EQ. 0.0) THEN
                tb(i, l+1) = tb(i, l+1) + 1.75*t(i, l+1)**0.75*temp30b
              ELSE
                tb(i, l+1) = tb(i, l+1) + 1.75*t(i, l+1)**0.75*temp30b -
     +            temp33*dfso4*3.0*8.e3*rgasi*frpb/(temp34*2.0*temp32)
              END IF
              CALL POPREAL8(dfso4)
              temp30b0 = -(t(i, l+1)**1.75*temp31*temp30b/temp30)
              pressgb(i) = pressgb(i) + shj(i, l)*temp30b0
              shjb(i, l) = shjb(i, l) + pressg(i)*temp30b0
            END IF
          ENDDO
        ENDDO
      ENDDO
      DO ii1=1,ilev
        DO ii2=1,ilg
c          no3rowb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,ilev
        DO ii2=1,ilg
c          ohrowb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,lev
        DO ii2=1,ilg
c          rhb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,ilg
c        tcszrowb(ii1) = 0.0
      ENDDO
      DO ii1=1,ilg
c        cszrowb(ii1) = 0.0
      ENDDO
      DO ii1=1,2
        DO ii2=1,ilev
          DO ii3=1,ilg
c            cldcvb(ii3, ii2, ii1) = 0.0
          ENDDO
        ENDDO
      ENDDO
      CALL POPINTEGER4(ad_from0)
      CALL POPINTEGER4(ad_to0)
      DO l=ad_to0,ad_from0,-1
        CALL POPINTEGER4(ad_from)
        CALL POPINTEGER4(ad_to)
        DO i=ad_to,ad_from,-1
          temp27 = 1.e-06*avo*roarow(i, l)/so4mw
          adelta = atempe/273.15
          apara = 25.1289 - 4890.8/atempe - 2.2479*adelta*rh01
          aparb = 7643.4/atempe - 1.9712*adelta/rh01
          apare = 0.0102
          aexp = apara + aparb*apare
          aexpb = acoefcb(i, l, 2)
          acoefcb(i, l, 2) = 0.0
          afakb = acoefcb(i, l, 1)
          acoefcb(i, l, 1) = 0.0
          avesize = aerosize(1, 1)
          CALL POPREAL8(afak)
          temp29 = roarow(i, l)
          temp28 = afak*rhop0(nn)/temp29
          temp28b = y4pid3*1.e+06*afakb
          temp28b0 = avesize**3*temp28b/temp29
          rhop0b(nn) = rhop0b(nn) + afak*temp28b0
          avesizeb = temp28*3*avesize**2*temp28b
          afakb = rhop0(nn)*temp28b0
          aerosizeb(1, 1) = aerosizeb(1, 1) + avesizeb
          aparc = -(1743.3/atempe)
          atuner = 1.
          temp28b1 = efact*atuner*EXP(aparb*apard+aparc)*afakb
          apardb = aparb*temp28b1
          aparcb = temp28b1
          efactb = atuner*EXP(aparb*apard+aparc)*afakb
          CALL POPREAL8(efact)
          expppb = DEXP(exppp)*efactb
          roarowb(i, l) = roarowb(i, l) + avo*1.e-06*aexp*expppb/(temp27
     +      *so4mw) - temp28*temp28b0
          CALL POPREAL8(exppp)
          aexpb = aexpb + ALOG(temp27)*expppb
          aparbb = apare*aexpb + apard*temp28b1
          aparab = aexpb - ALOG(aconcr)*expppb
          aconcrb = -(apara*expppb/aconcr)
          CALL POPREAL8(aconcr)
          temp27b = EXP(0.1335*atempe-10.5462*rh01+1958.4*(rh01/atempe)-
     +      14.5125)*aconcrb
          temp27b0 = 1958.4*temp27b/atempe
          CALL POPREAL8(apard)
          anwb = -(0.0415*apardb/anw)
          temp27b1 = -(1.9712*aparbb/rh01)
          adeltab = temp27b1 - 2.2479*rh01*aparab
          CALL POPREAL8(anw)
          temp26 = akb*atempe
          temp25 = rh01/temp26
          temp24 = 5.7113e-03*atempe - 8.2*LOG(atempe) - 7235.42451/
     +      atempe + 77.34491296
          temp24b1 = temp25*1.e-06*EXP(temp24)*anwb
          temp25b = EXP(temp24)*1.e-06*anwb/temp26
          atempeb = 0.0016*apardb - 7643.4*aparbb/atempe**2 + adeltab/
     +      273.15 - temp25*akb*temp25b + (7235.42451/atempe**2-8.2/
     +      atempe+5.7113e-03)*temp24b1 + 4890.8*aparab/atempe**2 + 
     +      1743.3*aparcb/atempe**2 - rh01*temp27b0/atempe + 0.1335*
     +      temp27b
          rh01b = ara*0.0154*apardb/(ara+rh01)**2 - 2.2479*adelta*aparab
     +      + temp25b - adelta*temp27b1/rh01 + temp27b0 - 10.5462*
     +      temp27b
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPREAL8(atempe)
            x2b = 0.0
          ELSE
            CALL POPREAL8(atempe)
            x2b = atempeb
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) tb(i, l+1) = tb(i, l+1) + x2b
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPREAL8(rh01)
            x1b = 0.0
          ELSE
            CALL POPREAL8(rh01)
            x1b = rh01b
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) rhb(i, l+1) = rhb(i, l+1) + x1b
          CALL POPCONTROL2B(branch)
          IF (branch .NE. 0) THEN
            IF (branch .EQ. 1) THEN
              CALL POPREAL8(xrow(i, l+1, iso2))
              xrowb(i, l+1, iso2) = 0.0
              so2prob = 0.0
            ELSE
              so2pro = -(64.6*(rth2s(i, l)/34.06+rtdms(i, l)/62.13)*tclr
     +          )
              CALL POPREAL8(xrow(i, l+1, iso2))
              so2prob = adt2*xrowb(i, l+1, iso2)
              adt2b = adt2b + so2pro*xrowb(i, l+1, iso2)
            END IF
            temp24b0 = -(64.6*tclr*so2prob)
            rth2sb(i, l) = rth2sb(i, l) + temp24b0/34.06
            rtdmsb(i, l) = rtdmsb(i, l) + temp24b0/62.13
            tclrb = -(64.6*(rth2s(i, l)/34.06+rtdms(i, l)/62.13)*so2prob
     +        )
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(xrow(i, l+1, ih2s))
              y3b = xrowb(i, l+1, ih2s)
              xrowb(i, l+1, ih2s) = 0.0
            ELSE
              CALL POPREAL8(xrow(i, l+1, ih2s))
              xrowb(i, l+1, ih2s) = 0.0
              y3b = 0.0
            END IF
            rth2sb(i, l) = rth2sb(i, l) + adt2*tclr*y3b
            dich = max1/tcszrow(i)*daylnt/delt
            rocon = avo*273.15/t(i, l+1)*pressg(i)*shj(i, l)/1.0133e5*
     +        1.e-3/22.4136
            qoh = ohrow(i, l)*dich*rocon
            temp23 = -(rk4*qoh*adt2)
            temp22b = (EXP(temp23)-1.0)*rth2sb(i, l)/adt2
            temp22 = xrow(i, l+1, ih2s)/adt2
            temp23b = temp22*EXP(temp23)*rth2sb(i, l)
            temp24b = rth2s(i, l)*y3b
            xrowb(i, l+1, ih2s) = xrowb(i, l+1, ih2s) + temp22b + y3b
            adt2b = adt2b + tclr*temp24b - rk4*qoh*temp23b - temp22*
     +        temp22b
            tclrb = tclrb + adt2*temp24b
            rk4b = -(adt2*qoh*temp23b)
            qohb = -(adt2*rk4*temp23b)
            rth2sb(i, l) = 0.0
            CALL POPREAL8(rk4)
            temp21 = t(i, l+1)
            temp20 = 80./temp21
            tb(i, l+1) = tb(i, l+1) + EXP(-temp20)*6.3e-12*temp20*rk4b/
     +        temp21
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(xrow(i, l+1, idms))
              y2b = xrowb(i, l+1, idms)
              xrowb(i, l+1, idms) = 0.0
            ELSE
              CALL POPREAL8(xrow(i, l+1, idms))
              xrowb(i, l+1, idms) = 0.0
              y2b = 0.0
            END IF
            temp1 = t(i, l+1)
            temp0 = 300.0/temp1
            rtdmsb(i, l) = rtdmsb(i, l) + adt2*tclr*y2b
            rtob = xrow(i, l+1, idms)*rtdmsb(i, l)
            adich = (1.0-max2)/(daylnt/delt-tcszrow(i))*daylnt/delt
            qno3 = no3row(i, l)*adich*rocon
            temp19 = (rk1+rk2)*qoh + rk3*qno3
            temp19b = EXP(-(temp19*adt2))*rtob/adt2
            temp20b = rtdms(i, l)*y2b
            xrowb(i, l+1, idms) = xrowb(i, l+1, idms) + rto*rtdmsb(i, l)
     +        + y2b
            adt2b = adt2b + tclr*temp20b - (EXP(-(temp19*adt2))-1.)*rtob
     +        /adt2**2 - temp19*temp19b
            tclrb = tclrb + adt2*temp20b
            rtdmsb(i, l) = 0.0
            CALL POPREAL8(rto)
            temp19b0 = -(adt2*temp19b)
            rk1b = qoh*temp19b0
            rk2b = qoh*temp19b0
            qohb = qohb + rk*rtso2b(i, l, 1) + (rk1+rk2)*temp19b0
            rk3b = qno3*temp19b0
            qno3b = rk3*temp19b0
            temp19b1 = no3row(i, l)*qno3b
            no3rowb(i, l) = no3rowb(i, l) + adich*rocon*qno3b
            adichb = rocon*temp19b1
            CALL POPREAL8(rk3)
            temp18 = t(i, l+1)
            temp17 = 500./temp18
            o2 = roarow(i, l)*avo/airmw*1.0e-3*0.21
            CALL POPREAL8(rk2)
            temp16 = t(i, l+1)
            temp15 = 7460./temp16
            temp14 = EXP(temp15)
            temp13 = 5.5e-31*temp14*o2 + 1.
            temp12 = t(i, l+1)
            temp11 = 7810./temp12
            temp10 = EXP(temp11)
            temp10b = 1.7e-42*rk2b/temp13
            temp10b0 = -(temp10*o2*5.5e-31*temp10b/temp13)
            o2b = temp14*temp10b0 + temp10*temp10b
            CALL POPREAL8(rk1)
            temp9 = t(i, l+1)
            temp8 = 234./temp9
            rkb = qoh*rtso2b(i, l, 1)
            rtso2b(i, l, 1) = 0.0
            temp8b = ohrow(i, l)*qohb
            roconb = dich*temp8b + adich*temp19b1
            ohrowb(i, l) = ohrowb(i, l) + dich*rocon*qohb
            dichb = rocon*temp8b
            temp7 = 1.0133e5*22.4136*t(i, l+1)
            temp7b = avo*1.e-3*273.15*roconb/temp7
            pressgb(i) = pressgb(i) + shj(i, l)*temp7b
            shjb(i, l) = shjb(i, l) + pressg(i)*temp7b
            rkinf = 1.5e-12
            CALL POPREAL8(rk)
            temp6 = rk0/rkinf + 1.0
            temp5 = LOG10(rk0/rkinf)
            temp4 = temp5**2 + 1.0
            temp3 = 1.0/temp4
            temp2 = 0.6**temp3
            temp2b = temp2*rkb/temp6
            rk0b = (1.0-rk0/(temp6*rkinf))*temp2b - 2*temp5*temp3*temp2*
     +        LOG(0.6)*rkb/(LOG(10.0)*temp4*temp6)
            rocon = avo/airmw*1.0e-3
            CALL POPREAL8(rk0)
            roarowb(i, l) = roarowb(i, l) + rocon*rk0*rk0b + avo*0.21*
     +        1.0e-3*o2b/airmw
            rk0b = rocon*roarow(i, l)*rk0b
            tb(i, l+1) = tb(i, l+1) + EXP(-temp8)*9.6e-12*temp8*rk1b/
     +        temp9 - EXP(temp15)*o2*temp15*temp10b0/temp16 - pressg(i)*
     +        shj(i, l)*1.0133e5*22.4136*temp7b/temp7 - 3.3*temp0**2.3*
     +        3.0e-31*temp0*rk0b/temp1 - EXP(temp11)*o2*temp11*temp10b/
     +        temp12 - EXP(temp17)*1.9e-13*temp17*rk3b/temp18
            CALL POPREAL8(rk0)
            temp = daylnt/delt - tcszrow(i)
            tempb1 = daylnt*adichb/(temp*delt)
            tempb2 = -((1.0-max2)*tempb1/(temp*delt))
            max2b = -tempb1
            deltb = deltb + (temp-daylnt/delt)*tempb2
            tcszrowb(i) = tcszrowb(i) - delt*tempb2
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(max2)
            ELSE
              CALL POPREAL8(max2)
              cszrowb(i) = cszrowb(i) + max2b
            END IF
            tempb = daylnt*dichb/(tcszrow(i)*delt)
            tempb0 = -(max1*tempb/(tcszrow(i)*delt))
            max1b = tempb
            tcszrowb(i) = tcszrowb(i) + delt*tempb0
            deltb = deltb + tcszrow(i)*tempb0
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(max1)
            ELSE
              CALL POPREAL8(max1)
              cszrowb(i) = cszrowb(i) + max1b
            END IF
            CALL POPREAL8(tclr)
            amin10b = -tclrb
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              y1b = amin10b
            ELSE
              y1b = 0.0
            END IF
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              cldcvb(i, l, 2) = cldcvb(i, l, 2) + y1b
            ELSE
              cldcvb(i, l, 1) = cldcvb(i, l, 1) + y1b
            END IF
          END IF
        ENDDO
      ENDDO
      CALL POPREAL8ARRAY(rtcond, ilg*ilev*isize)
      CALL POPINTEGER4(arg1)
      CALL PUTZERO_B(rtcond, rtcondb, arg1)
      CALL POPINTEGER4(arg1)
      CALL PUTZERO_B(pcond, pcondb, arg1)
      CALL POPINTEGER4(arg1)
      CALL PUTZERO_B(rtnucl, rtnuclb, arg1)
      CALL POPREAL8ARRAY(totcdn, ilg*ilev)
      CALL POPINTEGER4(arg1)
      CALL PUTZERO_B(totcdn, totcdnb, arg1)
      CALL POPREAL8ARRAY(totcd, ilg*ilev)
      CALL POPINTEGER4(arg1)
      CALL PUTZERO_B(totcd, totcdb, arg1)
      deltb = deltb + 2.*adt2b
      END

