
      SUBROUTINE SUBVVEL_B(modv, modvb, epsi, epsib, t, tb, q, wcc, wj, 
     +                     wjb, lev, ilg, delt, deltb, roarow, f1, f1b, 
     +                     f2, f2b, f, fb, shj, shjb, shtj, thlev, 
     +                     thlevb, ts, tsb, psfc, psfcb, il1, il2, ilev
     +                     , n, mae, sums, sumsb, wav, wavb, au, aub, bv
     +                     , bvb, a, ab, tmp1, tmp1b, tmp2, tmp2b, tmp3
     +                     , tmp3b, tmp4, tmp4b)
      IMPLICIT NONE
C
C
C-----------------------------------------------------------------------
C
      REAL tw, ti, htvocp, esw, esi, esteff, es
      REAL e, dp, dzlcl, td, ptomb, g, cp, epslon, dtdzd, ao, bvd, bvw
      REAL aob, bvdb, bvwb
      INTEGER l, j, k, m, i, mae, n, ilg, lev, ilev, il1, il2
      REAL factor, d, tlcl, rs, qs, tsp, plcl, zlcl, dtdzs, rd, t2s, t1s
      REAL rsb, qsb, dtdzsb, t2sb, t1sb
      REAL aw, ai, bi, delt, eps1, eps2, b1, rp, ma, rog, a1, aice, slp
      REAL awb, aib, bib, deltb, b1b, a1b, aiceb, slpb
      REAL bw, qmin, tice, bice, ttt
      REAL bwb, biceb
      INTEGER kbreak
      REAL q(ilg, lev), t(ilg, lev), wcc(ilg, ilev, 2), ts(ilg), psfc(
     +     ilg)
      REAL tb(ilg, lev), tsb(ilg), psfcb(ilg)
      REAL shj(ilg, ilev), shtj(ilg, lev)
      REAL shjb(ilg, ilev)
      REAL f1(ilg, ilev, n), f2(ilg, ilev, n), au(ilg, ilev), a(ilg, 
     +     ilev)
      REAL f1b(ilg, ilev, n), f2b(ilg, ilev, n), aub(ilg, ilev), ab(ilg
     +     , ilev)
      REAL sums(ilg, ilev), modv(ilg, ilev), wj(ilg, ilev, n)
      REAL sumsb(ilg, ilev), modvb(ilg, ilev), wjb(ilg, ilev, n)
      REAL wav(ilg, ilev), roarow(ilg, ilev), thlev(ilg, ilev)
      REAL wavb(ilg, ilev), thlevb(ilg, ilev)
      REAL epsi(ilg, ilev), bv(ilg, ilev)
      REAL epsib(ilg, ilev), bvb(ilg, ilev)
      REAL pr, prp1, tr, trp1, qr, wcr, dzp, gamav, gamd, gamw, dz
      REAL prb, trb, trp1b, gamavb, gamwb, dzb
      REAL kslope
      REAL tmp1(ilg, ilev), tmp2(ilg, ilev), tmp3(ilg, ilev), tmp4(ilg, 
     +     ilev)
      REAL tmp1b(ilg, ilev), tmp2b(ilg, ilev), tmp3b(ilg, ilev), tmp4b(
     +     ilg, ilev)
C
      COMPLEX f(ilg, ilev, 2*n)
      COMPLEX fb(ilg, ilev, 2*n)
C
      COMMON /htcp/ t1s, t2s, ai, bi, aw, bw, slp
      COMMON /epsice/ aice, bice, tice, qmin
      COMMON /eps/ a1, b1, eps1, eps2
      EXTERNAL CVMGT
      EXTERNAL CVMGT_B
      REAL CVMGT
c      EXTERNAL CABS
c      EXTERNAL CABS_B
      REAL arg1
      REAL arg1b
      REAL arg2
      REAL arg2b
      REAL arg3
      REAL arg3b
      LOGICAL arg4
      REAL result1
      REAL result1b
      LOGICAL arg5
      REAL result2
      REAL result2b
      REAL arg6
      REAL arg6b
      REAL arg7
      REAL arg7b
      REAL arg8
      REAL arg8b
      LOGICAL arg9
      REAL result3
      REAL result3b
      LOGICAL arg10
      REAL result4
      REAL result4b
      REAL arg11
      REAL arg11b
      REAL arg20
      REAL arg20b
      REAL arg30
      REAL arg30b
      REAL arg60
      REAL arg60b
      REAL arg70
      REAL arg70b
      REAL arg80
      REAL arg80b
      COMPLEX tmp
      INTEGER branch
      REAL temp3
      INTRINSIC CMPLX
      REAL temp2
      REAL temp1
      REAL temp0
      INTRINSIC EXP
      REAL temp4b0
c      INTRINSIC CONJG
c      REAL CABS
      REAL temp0b
      INTRINSIC MAX
      COMPLEX tmpb
      INTEGER x1
      COMPLEX temp12b
      INTRINSIC FLOAT
      REAL temp6b
      REAL temp14
      REAL temp13
      REAL temp12
      REAL temp11
      INTRINSIC ALOG
      REAL temp10
      INTRINSIC REAL
      REAL temp5b3
      REAL temp5b2
      REAL temp5b1
      REAL temp5b0
      REAL tempb
c      EXTERNAL CONJG_B
      INTRINSIC NINT
      REAL temp2b
      REAL temp5b
      REAL temp12b0
      INTRINSIC MIN
      INTRINSIC SQRT
      REAL temp
      REAL temp9
      REAL temp8
      REAL temp7
      REAL temp10b
      REAL temp6
      REAL temp4b
      COMPLEX temp10b1
      REAL temp5
      REAL temp10b0
      REAL temp4
      COMMON /eps_b/ a1b, b1b
      COMMON /epsice_b/ aiceb, biceb
      COMMON /htcp_b/ t1sb, t2sb, aib, bib, awb, bwb, slpb
      DATA rog /29.29/
C
C . . . . Sets constants, units are CGS:
C
C [g/mole]  Molecular weight of air
      ma = 28.964
C [erg/mole.K] Universal gas constant
      rp = 8.314e7
C [J/kg.K]   Gas constant for dry air
      rd = rp/ma
C [erg/g.K] Specific heat of air
      cp = 1.006e7
C [cm/s2]   Gravitational acceleration
      g = 980.665
C [mb.cm2/dyne] Conversion to mb
C [K/cm]    dry adiabatic lapse rate, enleve le moins
      dtdzd = g/cp
C constant Rd / Rv
      epslon = 0.622
C
      m = n/2 + 1
      CALL FILZRO(sums, ilg, ilev, 1)
      CALL PUSHREAL8ARRAY(tmp4, ilg*ilev)
      CALL PUSHREAL8ARRAY(tmp3, ilg*ilev)
      CALL PUSHREAL8ARRAY(tmp2, ilg*ilev)
      CALL PUSHREAL8ARRAY(tmp1, ilg*ilev)
      CALL PUSHREAL8ARRAY(f2, ilg*ilev*n)
      CALL PUSHREAL8ARRAY(f1, ilg*ilev*n)
      CALL RNOISE(f1, f2, ilg, ilev, il1, il2, m, n, tmp1, tmp2, tmp3, 
     +            tmp4, mae)
      DO k=2,m
        DO l=1+mae,ilev
          DO j=il1,il2
            CALL PUSHREAL8(dz)
C [m]
            dz = thlev(j, l)
            CALL PUSHREAL8(tr)
            tr = t(j, l+1)
            pr = shj(j, l)*psfc(j)/100.
            IF (l .LT. ilev) THEN
              CALL PUSHREAL8(trp1)
              trp1 = t(j, l+2)
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(trp1)
              trp1 = ts(j)
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(gamav)
            gamav = (trp1-tr)/dz
            wcr = wcc(j, l, 1) + wcc(j, l, 2)
            CALL PUSHREAL8(gamd)
            gamd = dtdzd
            IF (tr .GE. t1s) THEN
              arg1 = EXP(a1 - b1/tr)
              arg2 = EXP(aice - bice/tr)
              arg3 = slp*((tr-t2s)*EXP(a1-b1/tr)+(t1s-tr)*EXP(aice-bice/
     +          tr))
              arg4 = tr .LE. t2s
              CALL PUSHREAL8(result1)
              result1 = CVMGT(arg2, arg3, arg4)
              arg5 = tr .GE. t1s
              CALL PUSHREAL8(result2)
              result2 = CVMGT(arg1, result1, arg5)
              td = b1/(a1-ALOG(result2))
              CALL PUSHCONTROL2B(2)
            ELSE IF (tr .LE. t2s) THEN
              arg1 = EXP(a1 - b1/tr)
              arg2 = EXP(aice - bice/tr)
              arg3 = slp*((tr-t2s)*EXP(a1-b1/tr)+(t1s-tr)*EXP(aice-bice/
     +          tr))
              arg4 = tr .LE. t2s
              CALL PUSHREAL8(result1)
              result1 = CVMGT(arg2, arg3, arg4)
              arg5 = tr .GE. t1s
              CALL PUSHREAL8(result2)
              result2 = CVMGT(arg1, result1, arg5)
              td = bice/(aice-ALOG(result2))
              CALL PUSHCONTROL2B(1)
            ELSE
              arg1 = EXP(a1 - b1/tr)
              arg2 = EXP(aice - bice/tr)
              arg3 = slp*((tr-t2s)*EXP(a1-b1/tr)+(t1s-tr)*EXP(aice-bice/
     +          tr))
              arg4 = tr .LE. t2s
              CALL PUSHREAL8(result1)
              result1 = CVMGT(arg2, arg3, arg4)
              arg5 = tr .GE. t1s
              CALL PUSHREAL8(result2)
              result2 = CVMGT(arg1, result1, arg5)
              arg6 = EXP(a1 - b1/tr)
              arg7 = EXP(aice - bice/tr)
              arg8 = slp*((tr-t2s)*EXP(a1-b1/tr)+(t1s-tr)*EXP(aice-bice/
     +          tr))
              arg9 = tr .LE. t2s
              result3 = CVMGT(arg7, arg8, arg9)
              arg10 = tr .GE. t1s
              CALL PUSHREAL8(result4)
              result4 = CVMGT(arg6, result3, arg10)
              td = slp*((tr-t2s)*b1/(a1-ALOG(result2))+(t1s-tr)*bice/(
     +          aice-ALOG(result4)))
              CALL PUSHCONTROL2B(0)
            END IF
C [m]
            dzlcl = 120.*(tr-td)
C [mb]
C [K]
C [g/g]
            arg1 = EXP(a1 - b1/tr)
            arg2 = EXP(aice - bice/tr)
            arg3 = slp*((tr-t2s)*EXP(a1-b1/tr)+(t1s-tr)*EXP(aice-bice/tr
     +        ))
            arg4 = tr .LE. t2s
            CALL PUSHBOOLEAN(arg4)
            CALL PUSHREAL8(arg3)
            CALL PUSHREAL8(arg2)
            result1 = CVMGT(arg2, arg3, arg4)
            arg5 = tr .GE. t1s
            CALL PUSHBOOLEAN(arg5)
            CALL PUSHREAL8(result1)
            CALL PUSHREAL8(arg1)
            result2 = CVMGT(arg1, result1, arg5)
            arg6 = EXP(a1 - b1/tr)
            arg7 = EXP(aice - bice/tr)
            arg8 = slp*((tr-t2s)*EXP(a1-b1/tr)+(t1s-tr)*EXP(aice-bice/tr
     +        ))
            arg9 = tr .LE. t2s
            CALL PUSHBOOLEAN(arg9)
            CALL PUSHREAL8(arg8)
            CALL PUSHREAL8(arg7)
            result3 = CVMGT(arg7, arg8, arg9)
            arg10 = tr .GE. t1s
            CALL PUSHBOOLEAN(arg10)
            CALL PUSHREAL8(result3)
            CALL PUSHREAL8(arg6)
            result4 = CVMGT(arg6, result3, arg10)
            CALL PUSHREAL8(qs)
            qs = epslon*result2/(pr-(1.-epslon)*result4)
            rs = qs/(1.-qs)
            arg11 = (aw-bw*tr)*1004.5
            arg20 = (ai-bi*tr)*1004.5
            arg30 = slp*((tr-t2s)*((aw-bw*tr)*1004.5)+(t1s-tr)*((ai-bi*
     +        tr)*1004.5))
            arg4 = tr .LE. t2s
            CALL PUSHBOOLEAN(arg4)
            CALL PUSHREAL8(arg30)
            CALL PUSHREAL8(arg20)
            result1 = CVMGT(arg20, arg30, arg4)
            arg5 = tr .GE. t1s
            CALL PUSHBOOLEAN(arg5)
            CALL PUSHREAL8(result1)
            CALL PUSHREAL8(arg11)
            result2 = CVMGT(arg11, result1, arg5)
            arg60 = (aw-bw*tr)*1004.5
            arg70 = (ai-bi*tr)*1004.5
            arg80 = slp*((tr-t2s)*((aw-bw*tr)*1004.5)+(t1s-tr)*((ai-bi*
     +        tr)*1004.5))
            arg9 = tr .LE. t2s
            CALL PUSHBOOLEAN(arg9)
            CALL PUSHREAL8(arg80)
            CALL PUSHREAL8(arg70)
            result3 = CVMGT(arg70, arg80, arg9)
            arg10 = tr .GE. t1s
            CALL PUSHBOOLEAN(arg10)
            CALL PUSHREAL8(result3)
            CALL PUSHREAL8(arg60)
            result4 = CVMGT(arg60, result3, arg10)
            dtdzs = dtdzd*(1.+result2*rs/(rd*tr))/(1.+result4**2.*epslon
     +        *rs/(rd*cp*tr**2.))
C===========================================================
C Taking the temperature gradient of the lower layer
C
            IF (dzlcl .GT. 5000.) THEN
              zlcl = 5000.
            ELSE
              zlcl = dzlcl
            END IF
            IF (zlcl .LE. 0.) THEN
              CALL PUSHREAL8(gamw)
              gamw = dtdzs
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(gamw)
              gamw = dtdzs
              CALL PUSHCONTROL1B(1)
            END IF
            bvw = g*(gamw-gamav)/tr
            bvd = g*(gamd-gamav)/tr
            IF (wcr .GT. 0.) THEN
              bv(j, l) = bvw
              CALL PUSHCONTROL1B(0)
            ELSE
              bv(j, l) = bvd
              CALL PUSHCONTROL1B(1)
            END IF
            IF (epsi(j, l) .GT. 1.e-9) THEN
              bv(j, l) = 0.
              CALL PUSHCONTROL2B(0)
            ELSE IF (bv(j, l) .EQ. 0. .AND. bvd .GT. 0.) THEN
              bv(j, l) = bvd
              CALL PUSHCONTROL2B(1)
            ELSE IF (bv(j, l) .EQ. 0. .AND. bvd .EQ. 0.) THEN
              bv(j, l) = 1./delt
              CALL PUSHCONTROL2B(2)
            ELSE
              CALL PUSHCONTROL2B(3)
            END IF
C
C=======================================================================
C     In turbulence case, set BV = 0.  A zero slope is prescribed and
C     turbulence intensity is calculeted asssuming a Kolmogorov relation
C     for scale leser than 1 km
C========================================================================
            IF (bv(j, l) .EQ. 0.) THEN
              CALL PUSHREAL8(kslope)
              kslope = 1.
              CALL PUSHREAL8(ao)
              ao = 1./350000.*FLOAT(n*n)*0.2*epsi(j, l)**(2./3.)*(128./
     +          350000.)**(-(5./3.))
              CALL PUSHREAL8(a(j, l))
              a(j, l) = SQRT(ao/2.)
              CALL PUSHCONTROL2B(0)
            ELSE
              x1 = NINT(350000.*bv(j, l)/modv(j, l))
              IF (x1 .GT. n/2 + 1) THEN
                kbreak = n/2 + 1
              ELSE
                kbreak = x1
              END IF
              IF (kbreak .LT. 1) THEN
                kbreak = 1
              ELSE
                kbreak = kbreak
              END IF
              CALL PUSHREAL8(au(j, l))
              au(j, l) = 10.**(0.02213*modv(j, l))*47.64277e-4
              CALL PUSHREAL8(a(j, l))
              a(j, l) = SQRT(au(j, l))
              d = 3.
              IF (k .GT. kbreak .AND. kbreak .GT. 2) THEN
                CALL PUSHREAL8(kslope)
                kslope = REAL(k-1)**(-(d/2.))
                factor = REAL(kbreak-2)**(d/2.)
                kslope = kslope*factor
                CALL PUSHCONTROL2B(1)
              ELSE
                CALL PUSHREAL8(kslope)
                kslope = 1.
                CALL PUSHCONTROL2B(2)
              END IF
            END IF
            CALL PUSHREAL8(f(j, l, k))
C=======================================================================
C     Construction Fourier transform function for the first part of the
C     Fourier domain.
C=======================================================================
            f(j, l, k) = a(j, l)*CMPLX(f1(j, l, k), f2(j, l, k))*kslope
C======================================================================
C     Assign the conjugue complex of F of the first part of the domain
C     to the second part.
C======================================================================
            i = n - k + 2
            IF (i .GT. m) THEN
              CALL PUSHREAL8(tmp)
              tmp = CONJG(f(j, l, k))
              CALL PUSHREAL8(f(j, l, i))
              f(j, l, i) = tmp
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(f(j, l, k))
C==============================================================
C     Calcul of the power spectrum and the variance [m^2/s^2]
C==============================================================
            result1 = CABS(f(j, l, k))
            sums(j, l) = sums(j, l) + REAL(result1**2.)
          ENDDO
        ENDDO
      ENDDO
C--------------------------------------------------------------
      DO k=1,n
        DO l=1+mae,ilev
          DO j=il1,il2
C               Write (*,*) ' SUMS =', F1(J,L,k),F2(J,L,k),
C     1                                      SUMS(J,L), J, L, K
            IF (bv(j, l) .GT. 0. .AND. sums(j, l) .GT. 0.0) THEN
              CALL PUSHREAL8(f(j, l, k))
C
C                 gravity wave case
              f(j, l, k) = REAL(n)*f(j, l, k)*SQRT(au(j, l)/(2.*sums(j, 
     +          l)))
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
          ENDDO
        ENDDO
      ENDDO
      CALL PUSHREAL8ARRAY(f, ilg*ilev*2*n)
C
      CALL FOUR1(f, n, -1, ilg, ilev, il1, il2, mae)
C
      DO k=n,1,-1
        DO l=ilev,1+mae,-1
          DO j=il2,il1,-1
            wjb(j, l, k) = 2.*wjb(j, l, k)
            wavb(j, l) = wavb(j, l) - wjb(j, l, k)
          ENDDO
        ENDDO
      ENDDO
      DO k=n,1,-1
        DO l=ilev,1+mae,-1
          DO j=il2,il1,-1
            wjb(j, l, k) = wjb(j, l, k) + wavb(j, l)/REAL(n)
            fb(j, l, k) = fb(j, l, k) + wjb(j, l, k)/2.
            wjb(j, l, k) = 0.0
          ENDDO
        ENDDO
      ENDDO
      CALL FILZRO_B(wav, wavb, ilg, ilev, 1)
      CALL POPREAL8ARRAY(f, ilg*ilev*2*n)
      CALL FOUR1_B(f, fb, n, -1, ilg, ilev, il1, il2, mae)
      DO k=n,1,-1
        DO l=ilev,1+mae,-1
          DO j=il2,il1,-1
            CALL POPCONTROL1B(branch)
            IF (branch .NE. 0) THEN
              CALL POPREAL8(f(j, l, k))
              temp14 = 2.*sums(j, l)
              temp12 = au(j, l)/temp14
              temp13 = SQRT(temp12)
              temp12b = REAL(n)*fb(j, l, k)
              IF (temp12 .EQ. 0.0) THEN
                temp12b0 = 0.0
              ELSE
                temp12b0 = f(j, l, k)*temp12b/(2.0*temp13*temp14)
              END IF
              aub(j, l) = aub(j, l) + temp12b0
              sumsb(j, l) = sumsb(j, l) - temp12*2.*temp12b0
              fb(j, l, k) = temp13*temp12b
            END IF
          ENDDO
        ENDDO
      ENDDO
      DO k=m,2,-1
        DO l=ilev,1+mae,-1
          DO j=il2,il1,-1
            result1b = 2.*result1*sumsb(j, l)
            CALL LOOKREAL8(f(j, l, k))
c            CALL CABS_B(f(j, l, k), fb(j, l, k), result1b)
            result1=CABS(f(j, l, k))
            result1b=CABS(fb(j, l, k))
            CALL POPREAL8(f(j, l, k))
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              i = n - k + 2
              CALL POPREAL8(f(j, l, i))
              tmpb = fb(j, l, i)
              fb(j, l, i) = (0.0,0.0)
              CALL POPREAL8(tmp)
c              CALL CONJG_B(f(j, l, k), fb(j, l, k), tmpb)
               tmp=CONJG(f(j, l, k))
               tmpb=CONJG(fb(j, l, k))
            END IF
            CALL POPREAL8(f(j, l, k))
            temp11 = f2(j, l, k)
            temp10 = f1(j, l, k)
            temp10b1 = kslope*a(j, l)*fb(j, l, k)
            ab(j, l) = ab(j, l) + kslope*CMPLX(temp10, temp11)*fb(j, l, 
     +        k)
            f1b(j, l, k) = f1b(j, l, k) + CMPLX(1.0, 0.0)*temp10b1
            f2b(j, l, k) = f2b(j, l, k) + CMPLX(0.0, 1.0)*temp10b1
            fb(j, l, k) = (0.0,0.0)
            CALL POPCONTROL2B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(a(j, l))
              IF (ao/2. .EQ. 0.0) THEN
                aob = 0.0
              ELSE
                aob = ab(j, l)/(2.0*SQRT(ao/2.)*2.)
              END IF
              ab(j, l) = 0.0
              CALL POPREAL8(ao)
              IF (.NOT.(epsi(j, l) .LE. 0.0 .AND. (2./3. .EQ. 0.0 .OR. 
     +            2./3. .NE. INT(2./3.)))) epsib(j, l) = epsib(j, l) + 
     +            FLOAT(n**2)*0.2*(128./350000.)**(-(5./3.))*2.*epsi(j, 
     +            l)**(2./3.-1)*aob/(350000.*3.)
              CALL POPREAL8(kslope)
            ELSE
              IF (branch .EQ. 1) THEN
                CALL POPREAL8(kslope)
              ELSE
                CALL POPREAL8(kslope)
              END IF
              CALL POPREAL8(a(j, l))
              IF (.NOT.au(j, l) .EQ. 0.0) aub(j, l) = aub(j, l) + ab(j, 
     +            l)/(2.0*SQRT(au(j, l)))
              ab(j, l) = 0.0
              CALL POPREAL8(au(j, l))
              modvb(j, l) = modvb(j, l) + 10.**(0.02213*modv(j, l))*LOG(
     +          10.)*47.64277e-4*0.02213*aub(j, l)
              aub(j, l) = 0.0
            END IF
            CALL POPCONTROL2B(branch)
            IF (branch .LT. 2) THEN
              IF (branch .EQ. 0) THEN
                bvb(j, l) = 0.0
                bvdb = 0.0
              ELSE
                bvdb = bvb(j, l)
                bvb(j, l) = 0.0
              END IF
            ELSE
              IF (branch .EQ. 2) THEN
                deltb = deltb - bvb(j, l)/delt**2
                bvb(j, l) = 0.0
              END IF
              bvdb = 0.0
            END IF
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              bvwb = bvb(j, l)
              bvb(j, l) = 0.0
            ELSE
              bvdb = bvdb + bvb(j, l)
              bvb(j, l) = 0.0
              bvwb = 0.0
            END IF
            temp10b0 = g*bvwb/tr
            temp10b = g*bvdb/tr
            gamavb = -temp10b0 - temp10b
            trb = -((gamw-gamav)*temp10b0/tr) - (gamd-gamav)*temp10b/tr
            gamwb = temp10b0
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(gamw)
              dtdzsb = gamwb
            ELSE
              CALL POPREAL8(gamw)
              dtdzsb = gamwb
            END IF
            rs = qs/(1.-qs)
            temp9 = rd*cp*tr**2.
            temp8 = result4**2.
            temp6 = temp8*rs/temp9
            temp7 = rd*tr
            temp5 = result2*rs/temp7
            temp5b = dtdzd*dtdzsb/(epslon*temp6+1.)
            temp5b0 = temp5b/temp7
            temp6b = -(epslon*(temp5+1.)*temp5b/((epslon*temp6+1.)*temp9
     +        ))
            result2b = rs*temp5b0
            rsb = temp8*temp6b + result2*temp5b0
            result4b = rs*2.*result4*temp6b
            CALL POPREAL8(arg60)
            CALL POPREAL8(result3)
            CALL POPBOOLEAN(arg10)
            arg60b = 0.0
            result3b = 0.0
            CALL CVMGT_B(arg60, arg60b, result3, result3b, arg10, 
     +                   result4b)
            CALL POPREAL8(arg70)
            CALL POPREAL8(arg80)
            CALL POPBOOLEAN(arg9)
            arg70b = 0.0
            arg80b = 0.0
            CALL CVMGT_B(arg70, arg70b, arg80, arg80b, arg9, result3b)
            temp5b1 = slp*arg80b
            pr = shj(j, l)*psfc(j)/100.
            CALL POPREAL8(arg11)
            CALL POPREAL8(result1)
            CALL POPBOOLEAN(arg5)
            arg11b = 0.0
            result1b = 0.0
            CALL CVMGT_B(arg11, arg11b, result1, result1b, arg5, 
     +                   result2b)
            CALL POPREAL8(arg20)
            CALL POPREAL8(arg30)
            CALL POPBOOLEAN(arg4)
            arg20b = 0.0
            arg30b = 0.0
            CALL CVMGT_B(arg20, arg20b, arg30, arg30b, arg4, result1b)
            temp5b2 = slp*arg30b
            temp5b3 = rsb/(1.-qs)
            qsb = (qs/(1.-qs)+1.0)*temp5b3
            CALL POPREAL8(qs)
            temp4 = pr - (-epslon+1.)*result4
            temp4b = epslon*qsb/temp4
            temp4b0 = -(result2*temp4b/temp4)
            result2b = temp4b
            prb = temp4b0
            result4b = -((1.-epslon)*temp4b0)
            CALL POPREAL8(arg6)
            CALL POPREAL8(result3)
            CALL POPBOOLEAN(arg10)
            arg6b = 0.0
            result3b = 0.0
            CALL CVMGT_B(arg6, arg6b, result3, result3b, arg10, result4b
     +                  )
            CALL POPREAL8(arg7)
            CALL POPREAL8(arg8)
            CALL POPBOOLEAN(arg9)
            arg7b = 0.0
            arg8b = 0.0
            CALL CVMGT_B(arg7, arg7b, arg8, arg8b, arg9, result3b)
            temp3 = bice/tr
            temp2 = b1/tr
            temp2b = slp*arg8b
            CALL POPREAL8(arg1)
            CALL POPREAL8(result1)
            CALL POPBOOLEAN(arg5)
            arg1b = 0.0
            result1b = 0.0
            CALL CVMGT_B(arg1, arg1b, result1, result1b, arg5, result2b)
            CALL POPREAL8(arg2)
            CALL POPREAL8(arg3)
            CALL POPBOOLEAN(arg4)
            arg2b = 0.0
            arg3b = 0.0
            CALL CVMGT_B(arg2, arg2b, arg3, arg3b, arg4, result1b)
            temp1 = bice/tr
            temp0 = b1/tr
            temp0b = slp*arg3b
            trb = trb + (1004.5*(aw-bw*tr)-(ai-bi*tr)*1004.5-(tr-t2s)*
     +        1004.5*bw-(t1s-tr)*1004.5*bi)*temp5b1 - 1004.5*bw*arg60b -
     +        1004.5*bi*arg20b + (EXP(aice-temp3)*(t1s-tr)*temp3/tr-EXP(
     +        aice-temp3)+EXP(a1-temp2)*(tr-t2s)*temp2/tr+EXP(a1-temp2))
     +        *temp2b + EXP(a1-b1/tr)*b1*arg6b/tr**2 + EXP(aice-bice/tr)
     +        *bice*arg2b/tr**2 + EXP(a1-b1/tr)*b1*arg1b/tr**2 + (EXP(
     +        aice-temp1)*(t1s-tr)*temp1/tr-EXP(aice-temp1)+EXP(a1-temp0
     +        )*(tr-t2s)*temp0/tr+EXP(a1-temp0))*temp0b + EXP(aice-bice/
     +        tr)*bice*arg7b/tr**2 - 1004.5*bw*arg11b + (1004.5*(aw-bw*
     +        tr)-(ai-bi*tr)*1004.5-(tr-t2s)*1004.5*bw-(t1s-tr)*1004.5*
     +        bi)*temp5b2 - 1004.5*bi*arg70b - rd*cp*temp6*2.*tr*temp6b 
     +        - temp5*rd*temp5b0
            temp = 3.5*ALOG(tr) - ALOG(pr*qr/(qr+6.222)) - 7.108
            CALL POPCONTROL2B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(result4)
              CALL POPREAL8(result2)
              CALL POPREAL8(result1)
            ELSE IF (branch .EQ. 1) THEN
              CALL POPREAL8(result2)
              CALL POPREAL8(result1)
            ELSE
              CALL POPREAL8(result2)
              CALL POPREAL8(result1)
            END IF
            CALL POPREAL8(gamd)
            CALL POPREAL8(gamav)
            tempb = gamavb/dz
            trp1b = tempb
            trb = trb - tempb
            dzb = -((trp1-tr)*tempb/dz)
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(trp1)
              tb(j, l+2) = tb(j, l+2) + trp1b
            ELSE
              CALL POPREAL8(trp1)
              tsb(j) = tsb(j) + trp1b
            END IF
            shjb(j, l) = shjb(j, l) + psfc(j)*prb/100.
            psfcb(j) = psfcb(j) + shj(j, l)*prb/100.
            CALL POPREAL8(tr)
            tb(j, l+1) = tb(j, l+1) + trb
            CALL POPREAL8(dz)
            thlevb(j, l) = thlevb(j, l) + dzb
          ENDDO
        ENDDO
      ENDDO
      CALL POPREAL8ARRAY(f1, ilg*ilev*n)
      CALL POPREAL8ARRAY(f2, ilg*ilev*n)
      CALL POPREAL8ARRAY(tmp1, ilg*ilev)
      CALL POPREAL8ARRAY(tmp2, ilg*ilev)
      CALL POPREAL8ARRAY(tmp3, ilg*ilev)
      CALL POPREAL8ARRAY(tmp4, ilg*ilev)
      CALL RNOISE_B(f1, f1b, f2, f2b, ilg, ilev, il1, il2, m, n, tmp1, 
     +              tmp1b, tmp2, tmp2b, tmp3, tmp3b, tmp4, tmp4b, mae)
      CALL FILZRO_B(sums, sumsb, ilg, ilev, 1)
      t1sb = 0.0
      t2sb = 0.0
      aib = 0.0
      bib = 0.0
      awb = 0.0
      bwb = 0.0
      slpb = 0.0
      aiceb = 0.0
      biceb = 0.0
      a1b = 0.0
      b1b = 0.0
      END

C  Differentiation of four1 in reverse (adjoint) mode:
C   gradient     of useful results: datum
C   with respect to varying inputs: datum
C
C==================================================================
C
      SUBROUTINE FOUR1_B(datum, datumb, nn, isign, ilg, ilev, il1, il2, 
     +                   mae)
      IMPLICIT NONE
C-------------------------------------------------------------
C     From FOUR1 "Numerical Recipes" Press et al., 1992, P501
C-------------------------------------------------------------
C
C     FEB. 12 /1998    S.L. GONG    3-D VECTORIZED VERSION
C                      J.  JIANG
C
      INTEGER i, istep, j, m, mmax, n
      REAL tempi, tempr
      REAL tempib, temprb
      DOUBLE PRECISION wr, wi, wpr, wpi, wtemp, theta
      INTEGER nn
      INTEGER ilg
      INTEGER ilev
C      COMPLEX DATUM(ILG,ILEV,2*NN)
      COMPLEX datum(ilg, ilev, 4*nn+1)
      COMPLEX datumb(ilg, ilev, 4*nn+1)
      INTEGER jm
      INTEGER im
      COMPLEX tmp
      COMPLEX tmp0
      COMPLEX tmp1
      COMPLEX tmp2
      INTEGER ad_count
      INTEGER i0
      INTEGER branch
      INTEGER ad_from
      INTEGER ad_stride
      INTEGER ad_to
      INTEGER ad_count0
      INTEGER i1
      INTEGER il1
      INTEGER il2
      INTEGER mae
      INTEGER isign
      INTRINSIC DSIN
      INTRINSIC SNGL
      COMPLEX tmpb
      COMPLEX tmp0b
      INTRINSIC REAL
      COMPLEX tmp2b
      COMPLEX tmp1b
C-----------------------------------------------------------------
      n = 2*nn
      j = 1
      DO i=1,n,2
        IF (j .GT. i) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHCONTROL1B(1)
        END IF
        m = n/2
        ad_count = 1
 1      IF (m .GE. 2 .AND. j .GT. m) THEN
          CALL PUSHINTEGER4(j)
          j = j - m
          m = m/2
          ad_count = ad_count + 1
          GOTO 1
        END IF
        CALL PUSHINTEGER4(ad_count)
        CALL PUSHINTEGER4(j)
        j = j + m
      ENDDO
      mmax = 2
      ad_count0 = 1
 2    IF (n .GT. mmax) THEN
        istep = 2*mmax
        theta = 6.28318530717959d0/(isign*mmax)
        wpr = -(2.d0*DSIN(0.5d0*theta)**2)
        wpi = DSIN(theta)
        wr = 1.d0
        wi = 0.d0
        DO m=1,mmax,2
          ad_from = m
          ad_stride = istep
          CALL PUSHINTEGER4(ad_from)
          CALL PUSHINTEGER4(ad_stride)
          wtemp = wr
          CALL PUSHREAL8(wr)
          wr = wr*wpr - wi*wpi + wr
          CALL PUSHREAL8(wi)
          wi = wi*wpr + wtemp*wpi + wi
        ENDDO
        CALL PUSHINTEGER4(m - 2)
        CALL PUSHINTEGER4(mmax)
        mmax = istep
        ad_count0 = ad_count0 + 1
        GOTO 2
      END IF
      CALL PUSHINTEGER4(ad_count0)
C
      IF (isign .EQ. -1) THEN
        DO i=n,1,-1
          DO jm=ilev,1+mae,-1
            DO im=il2,il1,-1
              datumb(im, jm, i) = datumb(im, jm, i)/REAL(nn)
            ENDDO
          ENDDO
        ENDDO
      END IF
      CALL POPINTEGER4(ad_count0)
      DO i1=1,ad_count0
        IF (i1 .NE. 1) THEN
          CALL POPINTEGER4(mmax)
          CALL POPINTEGER4(ad_to)
          DO m=ad_to,1,-2
            CALL POPREAL8(wi)
            CALL POPREAL8(wr)
            CALL POPINTEGER4(ad_stride)
            CALL POPINTEGER4(ad_from)
            DO i=n-MOD(n-ad_from, ad_stride),ad_from,-ad_stride
              j = i + mmax
              DO jm=ilev,1+mae,-1
                DO im=il2,il1,-1
                  tmp2b = datumb(im, jm, j+1)
                  tempib = datumb(im, jm, i+1) - tmp2b
                  temprb = datumb(im, jm, i)
                  datumb(im, jm, j+1) = (0.0,0.0)
                  datumb(im, jm, i+1) = datumb(im, jm, i+1) + tmp2b
                  tmp1b = datumb(im, jm, j)
                  datumb(im, jm, j) = (0.0,0.0)
                  datumb(im, jm, i) = datumb(im, jm, i) + tmp1b
                  temprb = temprb - tmp1b
                  datumb(im, jm, j+1) = datumb(im, jm, j+1) + SNGL(wr)*
     +              tempib
                  datumb(im, jm, j) = datumb(im, jm, j) + SNGL(wr)*
     +              temprb + SNGL(wi)*tempib
                  datumb(im, jm, j+1) = datumb(im, jm, j+1) - SNGL(wi)*
     +              temprb
                ENDDO
              ENDDO
            ENDDO
          ENDDO
        END IF
      ENDDO
      DO i=n-MOD(n-1, 2),1,-2
        CALL POPINTEGER4(j)
        CALL POPINTEGER4(ad_count)
        DO i0=1,ad_count
          IF (i0 .NE. 1) CALL POPINTEGER4(j)
        ENDDO
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          DO jm=ilev,1+mae,-1
            DO im=il2,il1,-1
              tempib = datumb(im, jm, i+1)
              datumb(im, jm, i+1) = (0.0,0.0)
              temprb = datumb(im, jm, i)
              datumb(im, jm, i) = (0.0,0.0)
              tmp0b = datumb(im, jm, j+1)
              datumb(im, jm, j+1) = (0.0,0.0)
              datumb(im, jm, i+1) = datumb(im, jm, i+1) + tmp0b
              tmpb = datumb(im, jm, j)
              datumb(im, jm, j) = (0.0,0.0)
              datumb(im, jm, i) = datumb(im, jm, i) + tmpb
              datumb(im, jm, j+1) = datumb(im, jm, j+1) + tempib
              datumb(im, jm, j) = datumb(im, jm, j) + temprb
            ENDDO
          ENDDO
        END IF
      ENDDO
      END

C  Differentiation of rnoise in reverse (adjoint) mode:
C   gradient     of useful results: f1 f2 sumf11 sumf12 sumf21
C                sumf22
C   with respect to varying inputs: f1 f2 sumf11 sumf12 sumf21
C                sumf22
C
      SUBROUTINE RNOISE_B(f1, f1b, f2, f2b, ilg, ilev, il1, il2, m, n, 
     +                    sumf11, sumf11b, sumf12, sumf12b, sumf21, 
     +                    sumf21b, sumf22, sumf22b, mae)
      IMPLICIT NONE
      INTEGER n
      INTEGER ilg
      INTEGER ilev
C
C     OCT. 30/1997    J.  JIANG     COLLUMN VERSION
C     FEB. 12/1998    S.L. GONG     3-D VECTORIZED VERSION FOR CAM
C                   (W/J. JIANG)
C
      REAL f1(ilg, ilev, n), f2(ilg, ilev, n)
      REAL f1b(ilg, ilev, n), f2b(ilg, ilev, n)
      REAL sumf11(ilg, ilev), sumf12(ilg, ilev)
      REAL sumf11b(ilg, ilev), sumf12b(ilg, ilev)
      REAL sumf21(ilg, ilev), sumf22(ilg, ilev)
      REAL sumf21b(ilg, ilev), sumf22b(ilg, ilev)
      INTEGER k
      INTEGER l
      INTEGER j
      EXTERNAL RANDOM
      REAL RANDOM
      INTEGER il1
      INTEGER il2
      INTEGER m
      INTEGER mae
      REAL temp2
      REAL temp1
      REAL temp0
      INTRINSIC REAL
      INTRINSIC SQRT
      REAL temp
C
C=====================================================
C  Building random white noises with zero mean signal
C=====================================================
C
      CALL FILZRO(sumf11, ilg, ilev, 1)
      CALL FILZRO(sumf12, ilg, ilev, 1)
      CALL FILZRO(sumf21, ilg, ilev, 1)
      CALL FILZRO(sumf22, ilg, ilev, 1)
C
      DO k=2,m
        DO l=1+mae,ilev
          DO j=il1,il2
            f1(j, l, k) = RANDOM(0)
Cinitial random white no
            f2(j, l, k) = RANDOM(0)
            sumf11(j, l) = sumf11(j, l) + f1(j, l, k)/REAL(n/2)
            sumf12(j, l) = sumf12(j, l) + f2(j, l, k)/REAL(n/2)
            sumf21(j, l) = sumf21(j, l) + f1(j, l, k)*f1(j, l, k)/REAL(n
     +        /2)
            sumf22(j, l) = sumf22(j, l) + f2(j, l, k)*f2(j, l, k)/REAL(n
     +        /2)
          ENDDO
        ENDDO
      ENDDO
C
      DO k=2,m
        DO l=1+mae,ilev
          DO j=il1,il2
            CALL PUSHREAL8(f1(j, l, k))
C
C       NORMALIZE
C
            f1(j, l, k) = f1(j, l, k) - sumf11(j, l)
            CALL PUSHREAL8(f2(j, l, k))
Cwhite noises with zero
            f2(j, l, k) = f2(j, l, k) - sumf12(j, l)
C
Cnormalized white noise
          ENDDO
        ENDDO
      ENDDO
      DO k=m,2,-1
        DO l=ilev,1+mae,-1
          DO j=il2,il1,-1
            temp2 = 2.*sumf22(j, l)
            temp1 = SQRT(temp2)
            IF (.NOT.temp2 .EQ. 0.0) sumf22b(j, l) = sumf22b(j, l) - f2(
     +          j, l, k)*2.*f2b(j, l, k)/(2.0*temp1**3)
            f2b(j, l, k) = f2b(j, l, k)/temp1
            temp0 = 2.*sumf21(j, l)
            temp = SQRT(temp0)
            IF (.NOT.temp0 .EQ. 0.0) sumf21b(j, l) = sumf21b(j, l) - f1(
     +          j, l, k)*2.*f1b(j, l, k)/(2.0*temp**3)
            f1b(j, l, k) = f1b(j, l, k)/temp
            CALL POPREAL8(f2(j, l, k))
            sumf12b(j, l) = sumf12b(j, l) - f2b(j, l, k)
            CALL POPREAL8(f1(j, l, k))
            sumf11b(j, l) = sumf11b(j, l) - f1b(j, l, k)
          ENDDO
        ENDDO
      ENDDO
      DO k=m,2,-1
        DO l=ilev,1+mae,-1
          DO j=il2,il1,-1
            f2b(j, l, k) = 0.0
            f1b(j, l, k) = 0.0
          ENDDO
        ENDDO
      ENDDO
      CALL FILZRO_B(sumf22, sumf22b, ilg, ilev, 1)
      CALL FILZRO_B(sumf21, sumf21b, ilg, ilev, 1)
      CALL FILZRO_B(sumf12, sumf12b, ilg, ilev, 1)
      CALL FILZRO_B(sumf11, sumf11b, ilg, ilev, 1)
      END
