C        Generated by TAPENADE     (INRIA, Tropics team)
C  Tapenade 3.5 (r3931) - 24 May 2011 16:28
C
C  Differentiation of scaveng in reverse (adjoint) mode:
C   gradient     of useful results: colef pdepv throw qr pdiff
C                delt pxnew xrow dshj shj rhsize gdrem rtbcld rhop
C                adt2 pressg roarow wetdep cldcv qrow
C   with respect to varying inputs: colef pdepv throw qr pdiff
C                delt pxnew xrow dshj shj rhsize gdrem rtbcld rhop
C                adt2 pressg roarow wetdep cldcv qrow
C   RW status of diff variables: colef:in-out pdepv:incr throw:incr
C                qr:incr pdiff:incr delt:incr pxnew:in-out xrow:in-out
C                dshj:incr shj:incr rhsize:incr gdrem:in-out rtbcld:in-out
C                rhop:incr adt2:incr pressg:incr roarow:incr wetdep:in-out
C                cldcv:incr qrow:incr
      SUBROUTINE SCAVENG_B(throw,   cldcv,   xrow,    mae,    lev,
     +                      ilev,     ilg,    il1,    il2,    shj,
     +                    pressg,   pdepv,  rcoex,  rcrit, radcld,
     +                        qr,  rtbcld, rticld,  pxnew, rhsize,
     +                      rhop,    qrow,   dshj,   iae1,  pdiff,
     +                      tmin,    iso2,    ntr,    ntp,  isize,
     +                     thlev,    adt2,  gdrem, roarow,  colef,
     +                    wetdep,    delt,                 
ccccccccccccc   for ad model   cccccccccccc
     +                    throwb,  cldcvb,  xrowb,   shjb,pressgb,
     +                    pdepvb,     qrb,rtbcldb, pxnewb,rhsizeb,
     +                     rhopb,   qrowb,  dshjb, pdiffb,  adt2b,
     +                    gdremb, roarowb, colefb,wetdepb,  deltb)

      IMPLICIT NONE
C
      REAL ww, tw, rayon, asq, g, rgas, rgocp, rgoasq, cpres
      REAL rgasv, cpresv, delt, tmin, zcons1, zcolleff, pcons2, vtmpc1
      REAL deltb, pcons2b
      REAL zzeff, afact, zftom, zrho0, zbcscav, adt2, oldso2
      REAL afactb, zftomb, zrho0b, zbcscavb, adt2b, oldso2b
C
      INTEGER ilg, ilev, ntr, lev, isize, l, mae, i, il1, il2, nt, ntp, 
     +        n, np
      INTEGER iae1, jk, il, iso2
      COMMON /params/ ww, tw, rayon, asq, g, rgas, rgocp, rgoasq, cpres
     +, rgasv, cpresv
C      COMMON /TIMES/DELT
C
      REAL pxnew(ilg, ilev, ntr), xrow(ilg, lev, ntr)
      REAL pxnewb(ilg, ilev, ntr), xrowb(ilg, lev, ntr)
      REAL pdepv(ilg, ilev, isize), thlev(ilg, ilev), gdrem(ilg, ntr, 3)
      REAL pdepvb(ilg, ilev, isize), gdremb(ilg, ntr, 3)
      REAL throw(ilg, lev), pdiff(ilg, ilev, isize)
      REAL throwb(ilg, lev), pdiffb(ilg, ilev, isize)
      REAL cldcv(ilg, ilev, 2)
      REAL cldcvb(ilg, ilev, 2)
      REAL pressg(ilg), shj(ilg, ilev), dshj(ilg, ilev)
      REAL pressgb(ilg), shjb(ilg, ilev), dshjb(ilg, ilev)
      REAL roarow(ilg, ilev), qrow(ilg, lev)
      REAL roarowb(ilg, ilev), qrowb(ilg, lev)
      REAL colef(ilg, ilev, isize), wetdep(ilg, ilev, isize)
      REAL colefb(ilg, ilev, isize), wetdepb(ilg, ilev, isize)
      REAL rcrit(ilg, ilev), rcoex(ilg, ilev)
      REAL radcld(ilg, ilev), qr(ilg, ilev, 2)
      REAL qrb(ilg, ilev, 2)
      REAL rtbcld(ilg, ilev, ntr), rticld(ilg, ilev, ntr)
      REAL rtbcldb(ilg, ilev, ntr)
C
      REAL rhsize(ilg, ilev, isize), rhop(ilg, ilev, isize)
      REAL rhsizeb(ilg, ilev, isize), rhopb(ilg, ilev, isize)
      EXTERNAL PUTZERO
      EXTERNAL PUTZERO_B
      INTEGER arg1
      INTEGER branch
      REAL temp3
      REAL temp2
      REAL temp1
      REAL temp0
      INTRINSIC MAX
      REAL temp2b1
      REAL temp2b0
      REAL temp5b3
      REAL temp5b2
      REAL temp5b1
      REAL temp5b0
      REAL tempb
      INTRINSIC AMAX1
      REAL temp2b
      REAL temp5b
      INTRINSIC MIN
      REAL temp1b
      REAL temp
      REAL temp4
      real inner
C
C
C . . . . SUM UP PRECIPITATION [STRATIFORM ONLY]
C
      arg1 = ilg*ilev*ntr
      CALL PUSHINTEGER4(arg1)
      CALL PUSHREAL8ARRAY(pxnew, ilg*ilev*ntr)
      CALL PUTZERO(pxnew, arg1)
      DO l=1+mae,ilev
        DO i=il1,il2
          IF (qr(i, l, 1) + qr(i, l, 2) .LT. 0.0) THEN
            pxnew(i, l, 1) = 0.0
            CALL PUSHCONTROL1B(0)
          ELSE
            pxnew(i, l, 1) = qr(i, l, 1) + qr(i, l, 2)
            CALL PUSHCONTROL1B(1)
          END IF
        ENDDO
      ENDDO
C
C     * BELOW-CLOUD REMOVAL OF PARTICLES
C
      arg1 = ilg*ilev*isize
      CALL PUSHINTEGER4(arg1)
      CALL PUSHREAL8ARRAY(colef, ilg*ilev*isize)
      CALL PUTZERO(colef, arg1)
      CALL PUSHREAL8ARRAY(xrow, ilg*lev*ntr)
      CALL PUSHREAL8ARRAY(wetdep, ilg*ilev*isize)
      CALL PUSHREAL8ARRAY(colef, ilg*ilev*isize)
      CALL PUSHREAL8ARRAY(pxnew, ilg*ilev*ntr)
      CALL BLCLD(throw, pxnew, rhsize, colef, rcoex, rcrit, pdepv, 
     +           pressg, shj, roarow, wetdep, pdiff, xrow, rtbcld, rhop
     +           , radcld, cldcv, mae, ntr, ntp, isize, lev, iae1, tmin
     +           , ilev, ilg, il1, il2, adt2)
C
C      ADD GROUND REMOVAL
C
      DO nt=1,ntp
        DO n=1,isize
          CALL PUSHINTEGER4(np)
          np = isize*(nt-1) + n + (iae1-1)
          DO l=1+mae,ilev
            DO i=il1,il2
              IF (xrow(i, l+1, np) .GT. tmin) THEN
                CALL PUSHCONTROL1B(1)
              ELSE
                CALL PUSHCONTROL1B(0)
              END IF
            ENDDO
          ENDDO
        ENDDO
      ENDDO
C
C     BELOW-CLOUD SCAVENGING OF SO2
C     THIS PROTION OF THE CODE WAS ADAPTED
C     FROM THE GCM ROUTINE WETDEP.
C
!jinmin
      g=9.80616000000000021
      rgas=287.050000
      rgasv=461.50999999
      
      zcons1 = 5.2
      zcolleff = 0.1
      pcons2 = 1./(2.*delt*g)
      vtmpc1 = rgasv/rgas - 1.
      zzeff = zcolleff*3.
CCONVERT QR FROM M TO KG/KG/S
      afact = 1./(2.*delt*0.001)
C
      DO jk=1+mae,ilev
        DO il=il1,il2
          zftom = 1./(dshj(il, jk)*pressg(il)*pcons2)
          CALL PUSHREAL8(zrho0)
          zrho0 = pressg(il)*shj(il, jk)/(rgas*throw(il, jk+1)*(1.+
     +      vtmpc1*qrow(il, jk+1)))
          CALL PUSHREAL8(zbcscav)
          zbcscav = zcons1*zzeff*qr(il, jk, 1)*zftom*zrho0*afact
          IF (1. .GT. zbcscav) THEN
            zbcscav = zbcscav
            CALL PUSHCONTROL1B(0)
          ELSE
            zbcscav = 1.
            CALL PUSHCONTROL1B(1)
          END IF
          IF (0. .LT. zbcscav) THEN
            CALL PUSHCONTROL1B(0)
            zbcscav = zbcscav
          ELSE
            zbcscav = 0.
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHREAL8(oldso2)
          oldso2 = xrow(il, jk+1, iso2)
          CALL PUSHREAL8(xrow(il, jk+1, iso2))
          xrow(il, jk+1, iso2) = xrow(il, jk+1, iso2)*(1.-zbcscav)
          CALL PUSHREAL8(rtbcld(il, jk, iso2))
          rtbcld(il, jk, iso2) = rtbcld(il, jk, iso2) + (xrow(il, jk+1, 
     +      iso2)-oldso2)/adt2
        ENDDO
      ENDDO
      afactb = 0.0
      pcons2b = 0.0
      DO jk=ilev,1+mae,-1
        DO il=il2,il1,-1
          temp5b2 = pressg(il)*gdremb(il, iso2, 2)/g
          rtbcldb(il, jk, iso2) = rtbcldb(il, jk, iso2) + dshj(il, jk)*
     +      temp5b2
          dshjb(il, jk) = dshjb(il, jk) + rtbcld(il, jk, iso2)*temp5b2
          pressgb(il) = pressgb(il) + rtbcld(il, jk, iso2)*dshj(il, jk)*
     +      gdremb(il, iso2, 2)/g
          CALL POPREAL8(rtbcld(il, jk, iso2))
          temp5b3 = rtbcldb(il, jk, iso2)/adt2
          xrowb(il, jk+1, iso2) = xrowb(il, jk+1, iso2) + temp5b3
          oldso2b = -temp5b3
          adt2b = adt2b - (xrow(il, jk+1, iso2)-oldso2)*temp5b3/adt2
          CALL POPREAL8(xrow(il, jk+1, iso2))
          zbcscavb = -(xrow(il, jk+1, iso2)*xrowb(il, jk+1, iso2))
          xrowb(il, jk+1, iso2) = oldso2b + (1.-zbcscav)*xrowb(il, jk+1
     +      , iso2)
          CALL POPREAL8(oldso2)
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) zbcscavb = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            zftom = 1./(dshj(il, jk)*pressg(il)*pcons2)
          ELSE
            zftom = 1./(dshj(il, jk)*pressg(il)*pcons2)
            zbcscavb = 0.0
          END IF
          CALL POPREAL8(zbcscav)
          temp5b = zcons1*zzeff*zbcscavb
          temp5b0 = zftom*zrho0*temp5b
          temp5b1 = qr(il, jk, 1)*afact*temp5b
          qrb(il, jk, 1) = qrb(il, jk, 1) + afact*temp5b0
          afactb = afactb + qr(il, jk, 1)*temp5b0
          zftomb = zrho0*temp5b1
          zrho0b = zftom*temp5b1
          CALL POPREAL8(zrho0)
          temp4 = vtmpc1*qrow(il, jk+1) + 1.
          temp3 = rgas*throw(il, jk+1)
          temp2 = temp3*temp4
          temp2b = zrho0b/temp2
          temp2b0 = -(pressg(il)*shj(il, jk)*temp2b/temp2)
          shjb(il, jk) = shjb(il, jk) + pressg(il)*temp2b
          throwb(il, jk+1) = throwb(il, jk+1) + temp4*rgas*temp2b0
          qrowb(il, jk+1) = qrowb(il, jk+1) + temp3*vtmpc1*temp2b0
          temp1 = dshj(il, jk)*pressg(il)*pcons2
          temp1b = -(zftomb/temp1**2)
          temp2b1 = dshj(il, jk)*temp1b
          pressgb(il) = pressgb(il) + pcons2*temp2b1 + shj(il, jk)*
     +      temp2b
          dshjb(il, jk) = dshjb(il, jk) + pressg(il)*pcons2*temp1b
          pcons2b = pcons2b + pressg(il)*temp2b1
        ENDDO
      ENDDO
      temp = 2.*g*delt
      temp0 = 2.*0.001*delt
      deltb = deltb - 2.*g*pcons2b/temp**2 - 2.*0.001*afactb/temp0**2
      DO nt=ntp,1,-1
        DO n=isize,1,-1
          DO l=ilev,1+mae,-1
            DO i=il2,il1,-1
              CALL POPCONTROL1B(branch)
              IF (branch .NE. 0) THEN
                tempb = pressg(i)*gdremb(i, np, 2)/g
                rtbcldb(i, l, np) = rtbcldb(i, l, np) + dshj(i, l)*tempb
                dshjb(i, l) = dshjb(i, l) + rtbcld(i, l, np)*tempb
                pressgb(i) = pressgb(i) + rtbcld(i, l, np)*dshj(i, l)*
     +            gdremb(i, np, 2)/g
              END IF
            ENDDO
          ENDDO
          CALL POPINTEGER4(np)
        ENDDO
      ENDDO
      CALL POPREAL8ARRAY(pxnew, ilg*ilev*ntr)
      CALL POPREAL8ARRAY(colef, ilg*ilev*isize)
      CALL POPREAL8ARRAY(wetdep, ilg*ilev*isize)
      CALL POPREAL8ARRAY(xrow, ilg*lev*ntr)
      CALL BLCLD_B(throw, throwb, pxnew, pxnewb, rhsize, rhsizeb, colef
     +             , colefb, rcoex, rcrit, pdepv, pdepvb, pressg, 
     +             pressgb, shj, shjb, roarow, roarowb, wetdep, wetdepb
     +             , pdiff, pdiffb, xrow, xrowb, rtbcld, rtbcldb, rhop, 
     +             rhopb, radcld, cldcv, cldcvb, mae, ntr, ntp, isize, 
     +             lev, iae1, tmin, ilev, ilg, il1, il2, adt2, adt2b)
      CALL POPREAL8ARRAY(colef, ilg*ilev*isize)
      CALL POPINTEGER4(arg1)
      CALL PUTZERO_B(colef, colefb, arg1)
      DO l=ilev,1+mae,-1
        DO i=il2,il1,-1
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            pxnewb(i, l, 1) = 0.0
          ELSE
            qrb(i, l, 1) = qrb(i, l, 1) + pxnewb(i, l, 1)
            qrb(i, l, 2) = qrb(i, l, 2) + pxnewb(i, l, 1)
            pxnewb(i, l, 1) = 0.0
          END IF
        ENDDO
      ENDDO
      CALL POPREAL8ARRAY(pxnew, ilg*ilev*ntr)
      CALL POPINTEGER4(arg1)
      CALL PUTZERO_B(pxnew, pxnewb, arg1)
      END

C  Differentiation of blcld in reverse (adjoint) mode:
C   gradient     of useful results: colef pdepv t qr pdiff xrow
C                shj rhsize rtbcld rhop adt2 pressg roarow wetdep
C                cldcv
C   with respect to varying inputs: colef pdepv t qr pdiff xrow
C                shj rhsize rtbcld rhop adt2 pressg roarow wetdep
C                cldcv
      SUBROUTINE BLCLD_B(t, tb, qr, qrb, rhsize, rhsizeb, colef, colefb
     +                   , rcoex, rcrit, pdepv, pdepvb, pressg, pressgb
     +                   , shj, shjb, roarow, roarowb, wetdep, wetdepb, 
     +                   pdiff, pdiffb, xrow, xrowb, rtbcld, rtbcldb, 
     +                   rhop, rhopb, radcld, cldcv, cldcvb, mae, ntr, 
     +                   ntp, isize, lev, iae1, tmin, ilev, ilg, il1, 
     +                   il2, adt2, adt2b)
      IMPLICIT NONE
C
      INTEGER ilg, ilev, ntr, isize, lev, mae
      INTEGER l, il1, il2, i, ntp, n, nn, np, iae1
C
      REAL cpres, rgoasq, rgocp, rgas, g, asq, rayon, tw, ww
      REAL avno, rgasi, am, boltzk, pi, a, tl
      REAL t1s, t2s, ai, bi, aw, bw, slp
      REAL rrm, bcrain, bcsnow, xold, xnew, adt2, rgasv, cpresv
      REAL rrmb, xoldb, xnewb, adt2b
      REAL tmin, dm, tend
      REAL tendb
C
      REAL qr(ilg, ilev, ntr), xrow(ilg, lev, ntr)
      REAL qrb(ilg, ilev, ntr), xrowb(ilg, lev, ntr)
      REAL t(ilg, lev), radcld(ilg, ilev)
      REAL tb(ilg, lev)
      REAL pressg(ilg), shj(ilg, ilev), roarow(ilg, ilev)
      REAL pressgb(ilg), shjb(ilg, ilev), roarowb(ilg, ilev)
      REAL pdepv(ilg, ilev, isize), pdiff(ilg, ilev, isize)
      REAL pdepvb(ilg, ilev, isize), pdiffb(ilg, ilev, isize)
      REAL rtbcld(ilg, ilev, ntr)
      REAL rtbcldb(ilg, ilev, ntr)
      REAL rhsize(ilg, ilev, isize), rhop(ilg, ilev, isize)
      REAL rhsizeb(ilg, ilev, isize), rhopb(ilg, ilev, isize)
      REAL cldcv(ilg, ilev, 2)
      REAL cldcvb(ilg, ilev, 2)
      REAL colef(ilg, ilev, isize), wetdep(ilg, ilev, isize)
      REAL colefb(ilg, ilev, isize), wetdepb(ilg, ilev, isize)
      REAL rcrit(ilg, ilev), rcoex(ilg, ilev)
      REAL a0, rsn0, rcut0, rcg0, p
      COMMON /params/ ww, tw, rayon, asq, g, rgas, rgocp, rgoasq, cpres
     +, rgasv, cpresv
      COMMON /narcm/ avno, rgasi, am, boltzk, pi, a, a0, rsn0, rcut0, 
     +rcg0, p
      COMMON /htcp/ t1s, t2s, ai, bi, aw, bw, slp
      EXTERNAL PUTZERO
      EXTERNAL PUTZERO_B
      INTEGER arg1
      INTEGER branch
      REAL temp0
      INTRINSIC EXP
      REAL amin10b
      REAL tempb0
      REAL temp0b
      REAL amin10
      REAL tempb
      REAL temp0b2
      REAL temp0b1
      INTRINSIC AMAX1
      REAL temp0b0
      INTRINSIC AMIN1
      INTEGER ii1
      REAL temp1b
      REAL temp
      real inner
C
      DATA bcrain /0.5/
      DATA bcsnow /0.8/
      DO ii1=1,ilg
        CALL PUSHREAL8(qr(ii1, 1, 3))
      ENDDO
      CALL PUSHREAL8ARRAY(wetdep, ilg*ilev*isize)
C
C  *********** BELOW CLOUD SCAVENGING *************
C
C     * CALL TO COMPUTE COLLECTION EFFICIENTCY COEFFICIENTS
C
      CALL CAS(t, colef, rhop, roarow, rhsize, pressg, qr(1, 1, 1), mae
     +         , ilg, ilev, lev, isize, il1, il2, qr(1, 1, 2), pdiff, 
     +         pdepv, shj, wetdep, qr(1, 1, 3))
      arg1 = ilg*ilev*isize
      CALL PUSHINTEGER4(arg1)
      CALL PUSHREAL8ARRAY(wetdep, ilg*ilev*isize)
      CALL PUTZERO(wetdep, arg1)
      DO n=1,isize
        DO l=1+mae,ilev
          DO i=il1,il2
            IF (qr(i, l, 1) .GT. 1.e-20) THEN
              tl = t(i, l+1) - t1s
              IF (tl .GT. 0.) THEN
C
C     * RAIN SCAVENGING RATE
C     THE UNIT OF QR IS MM S-1
C     THE 1.0E-3 CONVERTS IT INTO M S-1
C
                rrm = 0.35*(qr(i, l, 1)*3600.)**0.25*1.e-3
                wetdep(i, l, n) = bcrain*qr(i, l, 1)*1.0e-3*colef(i, l, 
     +            n)/rrm
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHCONTROL1B(1)
              END IF
              IF (tl .LE. 0.0 .AND. tl .GE. -8.) THEN
C
C     FOR SNOW SCAVENGING, THE DNESITY OF SNOW IS SET AS
C       1/10 OF LIQUID WATER. THE FACTOR 1.0E-2 IN THE WETDEP
C     CALCULATION TAKES THIS INTO ACCOUNT PLUS THE UNIT CHANGE
C     INTO M S-1
C
CCHARACTERISTIC LEHGTH! SCALE [M]
                dm = 3.8e-5
                wetdep(i, l, n) = bcsnow*qr(i, l, 1)*1.0e-3*colef(i, l, 
     +            n)/dm
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHCONTROL1B(1)
              END IF
              IF (tl .LT. -8. .AND. tl .GE. -25.) THEN
C
C     * STELLER SNOW SCAVENGING
C
C
                dm = 2.7e-5
                wetdep(i, l, n) = bcsnow*qr(i, l, 1)*1.0e-3*colef(i, l, 
     +            n)/dm
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHCONTROL1B(1)
              END IF
              IF (tl .LT. -25.) THEN
C
C     * GRAUPEL SCAVENGING
C
                dm = 1.4e-4
                wetdep(i, l, n) = bcsnow*qr(i, l, 1)*1.0e-3*colef(i, l, 
     +            n)/dm
                CALL PUSHCONTROL2B(2)
              ELSE
                CALL PUSHCONTROL2B(1)
              END IF
            ELSE
              CALL PUSHCONTROL2B(0)
            END IF
          ENDDO
        ENDDO
      ENDDO
C
C     * ADD THE BELOW-CLOUD SCAVENGING TEDENCY
C
      DO nn=1,ntp
        DO n=1,isize
          CALL PUSHINTEGER4(np)
          np = isize*(nn-1) + n + (iae1-1)
          DO l=ilev,1+mae,-1
            DO i=il1,il2
              CALL PUSHREAL8(xold)
              xold = xrow(i, l+1, np)
              CALL PUSHREAL8(xnew)
              xnew = xold*EXP(-(adt2*wetdep(i, l, n)))
              IF ((xnew-xold)/adt2 .GT. 0.0) THEN
                CALL PUSHREAL8(amin10)
                amin10 = 0.0
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHREAL8(amin10)
                amin10 = (xnew-xold)/adt2
                CALL PUSHCONTROL1B(1)
              END IF
              tend = amin10*cldcv(i, l, 1)
              IF (xrow(i, l+1, np) + tend*adt2 .LT. tmin) THEN
                xrow(i, l+1, np) = tmin
                CALL PUSHCONTROL1B(0)
              ELSE
                xrow(i, l+1, np) = xrow(i, l+1, np) + tend*adt2
                CALL PUSHCONTROL1B(1)
              END IF
            ENDDO
          ENDDO
        ENDDO
      ENDDO
      DO nn=ntp,1,-1
        DO n=isize,1,-1
          DO l=mae+1,ilev,1
            DO i=il2,il1,-1
              tendb = rtbcldb(i, l, np)
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                xrowb(i, l+1, np) = 0.0
              ELSE
                tend = amin10*cldcv(i, l, 1)
                tendb = tendb + adt2*xrowb(i, l+1, np)
                adt2b = adt2b + tend*xrowb(i, l+1, np)
              END IF
              amin10b = cldcv(i, l, 1)*tendb
              cldcvb(i, l, 1) = cldcvb(i, l, 1) + amin10*tendb
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                CALL POPREAL8(amin10)
                xoldb = 0.0
                xnewb = 0.0
              ELSE
                CALL POPREAL8(amin10)
                temp1b = amin10b/adt2
                xnewb = temp1b
                xoldb = -temp1b
                adt2b = adt2b - (xnew-xold)*temp1b/adt2
              END IF
              CALL POPREAL8(xnew)
              temp0 = wetdep(i, l, n)
              temp0b2 = xold*EXP(-(adt2*temp0))*xnewb
              xoldb = xoldb + EXP(-(adt2*temp0))*xnewb
              adt2b = adt2b - temp0*temp0b2
              wetdepb(i, l, n) = wetdepb(i, l, n) - adt2*temp0b2
              CALL POPREAL8(xold)
              xrowb(i, l+1, np) = xrowb(i, l+1, np) + xoldb
            ENDDO
          ENDDO
          CALL POPINTEGER4(np)
        ENDDO
      ENDDO
      DO n=isize,1,-1
        DO l=ilev,1+mae,-1
          DO i=il2,il1,-1
            CALL POPCONTROL2B(branch)
            IF (branch .NE. 0) THEN
              IF (branch .NE. 1) THEN
                dm = 1.4e-4
                temp0b1 = bcsnow*1.0e-3*wetdepb(i, l, n)
                qrb(i, l, 1) = qrb(i, l, 1) + colef(i, l, n)*temp0b1/dm
                colefb(i, l, n) = colefb(i, l, n) + qr(i, l, 1)*temp0b1/
     +            dm
                wetdepb(i, l, n) = 0.0
              END IF
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                dm = 2.7e-5
                temp0b0 = bcsnow*1.0e-3*wetdepb(i, l, n)
                qrb(i, l, 1) = qrb(i, l, 1) + colef(i, l, n)*temp0b0/dm
                colefb(i, l, n) = colefb(i, l, n) + qr(i, l, 1)*temp0b0/
     +            dm
                wetdepb(i, l, n) = 0.0
              END IF
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                dm = 3.8e-5
                temp0b = bcsnow*1.0e-3*wetdepb(i, l, n)
                qrb(i, l, 1) = qrb(i, l, 1) + colef(i, l, n)*temp0b/dm
                colefb(i, l, n) = colefb(i, l, n) + qr(i, l, 1)*temp0b/
     +            dm
                wetdepb(i, l, n) = 0.0
              END IF
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                rrm = 0.35*(qr(i, l, 1)*3600.)**0.25*1.e-3
                temp = qr(i, l, 1)/rrm
                tempb = bcrain*1.0e-3*wetdepb(i, l, n)
                tempb0 = colef(i, l, n)*tempb/rrm
                rrmb = -(temp*tempb0)
                qrb(i, l, 1) = qrb(i, l, 1) + 0.25*(3600.*qr(i, l, 1))**
     +            (-0.75)*1.e-3*0.35*3600.*rrmb + tempb0
                colefb(i, l, n) = colefb(i, l, n) + temp*tempb
                wetdepb(i, l, n) = 0.0
              END IF
            END IF
          ENDDO
        ENDDO
      ENDDO
      CALL POPREAL8ARRAY(wetdep, ilg*ilev*isize)
      CALL POPINTEGER4(arg1)
      CALL PUTZERO_B(wetdep, wetdepb, arg1)
      CALL POPREAL8ARRAY(wetdep, ilg*ilev*isize)
      DO ii1=ilg,1,-1
        CALL POPREAL8(qr(ii1, 1, 3))
      ENDDO
      CALL CAS_B(t, tb, colef, colefb, rhop, rhopb, roarow, roarowb, 
     +           rhsize, rhsizeb, pressg, pressgb, qr(1, 1, 1), qrb(1, 1
     +           , 1), mae, ilg, ilev, lev, isize, il1, il2, qr(1, 1, 2)
     +           , qrb(1, 1, 2), pdiff, pdiffb, pdepv, pdepvb, shj, shjb
     +           , wetdep, wetdepb, qr(1, 1, 3), qrb(1, 1, 3))
      END
