      subroutine readinput(ABCOEF,SCCOEF,aerosize,aerochem_np,isize)
C--------------------------------------------------------------------------          
      integer aerochem_np, ISIZE,aero_nsize
      REAL ABCOEF(isize,13,aerochem_np,14)
      REAL SCCOEF(isize,13,aerochem_np,14)
      REAL AEROSIZE(2,ISIZE+1), PVOL(ISIZE)
      INTEGER I,J,N,L
      INTEGER NPAB,NPSC
C------------------------------------------------------------------------------
C
C    BIN VOLUME OF DRY AEROSOL
C
      DO I=1,ISIZE
         RI=(AEROSIZE(1,I)+AEROSIZE(2,I))/2.0
         PVOL(I)=4.189*RI*RI*RI
      END DO
C
C    Read in scattering cross section
C
      NPAB=48
      NPSC=49
      OPEN(NPAB,FILE='ABSORPTION')
      OPEN(NPSC,FILE='SCATTERING')
      DO J = 1,14
        DO N=1,aerochem_np-1
           READ (NPAB,*) ((ABCOEF(I,L,N,J), I=1,ISIZE), L=1,13)
           READ (NPSC,*) ((SCCOEF(I,L,N,J), I=1,ISIZE), L=1,13)
        ENDDO
      ENDDO
      CLOSE (NPAB)
      CLOSE (NPSC)
C     
C    Compute the Extinction cross section [m^2]
C
        DO J=1,14
         DO N = 1,aerochem_np-1
          DO L=1,13
           DO  I=1,ISIZE
              ABCOEF(I,L,N,J) = ABCOEF(I,L,N,J)*1.E-12/PVOL(I)
              SCCOEF(I,L,N,J) = SCCOEF(I,L,N,J)*1.E-12/PVOL(I)
           ENDDO
          ENDDO
         ENDDO
        ENDDO
      RETURN
      END
