
      SUBROUTINE OXISTR_B(il1, il2, ilev, ilg, isize, ntr, iso2, ihpo, 
     +                    nn, iae1, roarow, roarowb, agamma, agammab, 
     +                    aspeci, aspecib, agtso2, agtso2b, agtso4, 
     +                    agtso4b, agto3, agto3b, agtco2, agtco2b, 
     +                    agtnh3, agtnh3b, agthno3, agthno3b, agtna, 
     +                    agtnab, agtho2, agtho2b, aeqca, aeqcab, aeqcb
     +                    , aeqcbb, aeqcc, aeqccb, aeqcbi, aeqcbib, 
     +                    aeqchp, aeqchpb, aeqcho, aeqchob, aeqhno, 
     +                    aeqhnob, aeqnh3, aeqnh3b, aeqhcl, aeqhclb, 
     +                    aorhp1, aorhp1b, aorhp2, aorhp2b, aorho, 
     +                    aorhob, antso2, antso2b, antho2, antho2b, 
     +                    antso4, antso4b, xrow, xrowb, aoh2o2, aoh2o2b
     +                    , aresid, aresidb, zmlwc, zmlwcb, cldcv, 
     +                    cldcvb, afrac, afracb, amh, amhb, kcalc, rtso4
     +                    , rtso4b, rthpo, rthpob, rcrit, rcritb, amaspe
     +                    , asprva, asprvab, asrso2, asrso2b, asrhpo, 
     +                    asrhpob, mae, delt, deltb)
      IMPLICIT NONE
      REAL afnh4, afno3, atvo3, afoh, aparb, adelms, afcl, afhso, afco3
      REAL afnh4b, afno3b, atvo3b, aparbb, adelmsb, afclb, afhsob, 
     +     afco3b
      INTEGER indx, l, i, k, ilg, isize, ntr, il1, il2, ilev, iae1, mae
     +        , iso2
      REAL delt
      REAL deltb
      INTEGER ihpo, nn
C      COMMON /TIMES/ DELT
C
      LOGICAL kcalc(ilg, ilev)
      INTEGER indti, ind, il, jk, n, nf
C
      INTEGER ysub, yindmx, iterp
      PARAMETER (ysub=2)
      PARAMETER (yindmx=3)
      PARAMETER (iterp=3)
      REAL ycom3l, yrhow
      PARAMETER (ycom3l=1.e+03, yrhow=1.e+03)
C
      REAL amso4, atval, adelti, afo3, afh2o2, atimst, amso3, amnh4, 
     +     amno3, amna, amcl, amo3, agthcl, adelta, afrah, afras, apard
     +     , apara, aparc, atvalx, amaspe(3)
      REAL amso4b, atvalb, adeltib, afo3b, afh2o2b, atimstb, amso3b, 
     +     amnh4b, amno3b, amnab, amclb, amo3b, agthclb, adeltab, afrahb
     +     , afrasb, apardb, aparab, aparcb, atvalxb
      REAL agamma(ilg, ilev), cldcv(ilg, ilev), aresid(ilg, ilev), 
     +     aspeci(ilg, ilev), agtso2(ilg, ilev), agtso4(ilg, ilev), 
     +     agto3(ilg, ilev), agtco2(ilg, ilev), agtnh3(ilg, ilev), 
     +     agthno3(ilg, ilev), agtna(ilg, ilev), agtho2(ilg, ilev), 
     +     aeqca(ilg, ilev), aeqcb(ilg, ilev), aeqcc(ilg, ilev), amh(ilg
     +     , ilev), aeqcbi(ilg, ilev), aeqchp(ilg, ilev), aeqcho(ilg, 
     +     ilev), aeqhno(ilg, ilev), aeqnh3(ilg, ilev), aeqhcl(ilg, ilev
     +     ), aorhp1(ilg, ilev), aorhp2(ilg, ilev), aorho(ilg, ilev), 
     +     antso2(ilg, ilev), antho2(ilg, ilev), antso4(ilg, ilev)
      REAL agammab(ilg, ilev), cldcvb(ilg, ilev), aresidb(ilg, ilev), 
     +     aspecib(ilg, ilev), agtso2b(ilg, ilev), agtso4b(ilg, ilev), 
     +     agto3b(ilg, ilev), agtco2b(ilg, ilev), agtnh3b(ilg, ilev), 
     +     agthno3b(ilg, ilev), agtnab(ilg, ilev), agtho2b(ilg, ilev), 
     +     aeqcab(ilg, ilev), aeqcbb(ilg, ilev), aeqccb(ilg, ilev), amhb
     +     (ilg, ilev), aeqcbib(ilg, ilev), aeqchpb(ilg, ilev), aeqchob(
     +     ilg, ilev), aeqhnob(ilg, ilev), aeqnh3b(ilg, ilev), aeqhclb(
     +     ilg, ilev), aorhp1b(ilg, ilev), aorhp2b(ilg, ilev), aorhob(
     +     ilg, ilev), antso2b(ilg, ilev), antho2b(ilg, ilev), antso4b(
     +     ilg, ilev)
      REAL zmlwc(ilg, ilev), rcrit(ilg, ilev), roarow(ilg, ilev), aoh2o2
     +     (ilg, ilev), afrac(ilg, ilev, isize), rtso4(ilg, ilev, isize)
     +     , rthpo(ilg, ilev), asprva(ilg, ilev), asrso2(ilg, ilev), 
     +     asrhpo(ilg, ilev)
      REAL zmlwcb(ilg, ilev), rcritb(ilg, ilev), roarowb(ilg, ilev), 
     +     aoh2o2b(ilg, ilev), afracb(ilg, ilev, isize), rtso4b(ilg, 
     +     ilev, isize), rthpob(ilg, ilev), asprvab(ilg, ilev), asrso2b(
     +     ilg, ilev), asrhpob(ilg, ilev)
      REAL xrow(ilg, ilev+1, ntr)
      REAL xrowb(ilg, ilev+1, ntr)
c      EXTERNAL AMOD
c      EXTERNAL AMOD_B
      REAL result1
      REAL result1b
      INTEGER branch
      REAL temp3
      REAL temp29
      REAL temp2
      REAL temp28
      REAL temp1
      REAL temp27
      REAL temp0
      REAL temp26
      REAL temp25
      REAL temp21b
      REAL temp24
      REAL temp23
      REAL temp22
      REAL temp21
      REAL temp18b1
      REAL temp20
      REAL temp18b0
      REAL temp16b
      REAL temp32b
      REAL temp40b
      REAL temp30b0
      REAL tempb4
      REAL temp19b
      REAL tempb3
      REAL tempb2
      REAL tempb1
      REAL tempb0
      REAL temp0b
      INTRINSIC MAX
      REAL temp40b1
      REAL temp40b0
      REAL temp38b
      REAL temp38b2
      REAL temp38b1
      REAL temp3b
      REAL temp38b0
      REAL x2
      REAL x1
      REAL x2b
      REAL temp19
      REAL temp18
      REAL temp16b0
      REAL temp17
      REAL temp16
      REAL temp6b
      REAL temp15
      REAL temp20b
      REAL temp14
      REAL temp13
      REAL temp12
      REAL temp11
      REAL temp10
      REAL temp42
      REAL temp36b4
      REAL max1b
      REAL temp41
      REAL temp36b3
      REAL temp40
      REAL temp18b
      REAL temp36b2
      INTRINSIC REAL
      REAL temp36b1
      REAL temp36b0
      REAL temp34b
      REAL tempb
      REAL temp0b2
      REAL temp0b1
      REAL temp0b0
      REAL temp37b
      REAL temp2b
      REAL x1b
      REAL temp11b
      INTRINSIC INT
      REAL temp39
      REAL temp38
      REAL temp37
      REAL temp36
      REAL temp22b
      REAL temp35
      REAL temp34
      REAL temp30b
      REAL temp33
      REAL temp32
      REAL temp31
      REAL temp30
      REAL temp25b
      REAL temp33b
c      REAL AMOD
      INTRINSIC MIN
      REAL temp37b2
      REAL temp37b1
      REAL temp36b
      REAL temp37b0
      REAL temp1b
      INTRINSIC SQRT
      REAL temp
      REAL max1
      REAL temp9
      REAL temp8
      REAL temp7
      REAL temp6
      REAL temp5
      REAL temp4
C
C-----------------------------------------------------------------------
C
C     initial values and constants
C
C-----------------------------------------------------------------------
C
      atimst = 2.*delt/REAL(ysub)
      DO k=1+mae,ilev
        DO il=il1,il2
          kcalc(il, k) = .false.
          agamma(il, k) = 0.
C         AMH(IL,K) = 0.1
        ENDDO
      ENDDO
C
      DO jk=1+mae,ilev
        DO il=il1,il2
C
C---     check for activation
          IF (INT(rcrit(il, jk)) .GE. 1 .AND. INT(rcrit(il, jk)) .LE. 
     +        isize .AND. zmlwc(il, jk) .GT. 1.e-06 .AND. cldcv(il, jk) 
     +        .GT. 1.e-03) THEN
C     3        .AND. (CLDCV(IL,JK) .GT. 1.E-04)         ) THEN
            kcalc(il, jk) = .true.
            agamma(il, jk) = zmlwc(il, jk)*roarow(il, jk)/yrhow
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
          END IF
        ENDDO
      ENDDO
C
      DO jk=1+mae,ilev
        DO il=il1,il2
C
C---     sulphur dioxide. Conversion kg/kg -> mol/l
          atval = xrow(il, jk+1, iso2)*roarow(il, jk)/amaspe(2)
          agtso2(il, jk) = atval/ycom3l
C
C---     initial values EBI-method
          aoh2o2(il, jk) = agtho2(il, jk)
          aresid(il, jk) = 0.
          aspeci(il, jk) = 0.
        ENDDO
      ENDDO
C
      DO n=1,isize
        nf = isize*(nn-1) + n + (iae1-1)
        DO l=1+mae,ilev
          DO i=il1,il2
            IF (kcalc(i, l)) THEN
              IF (n .EQ. INT(rcrit(i, l))) THEN
                CALL PUSHREAL8(rcrit(i, l))
                result1 = AMOD(rcrit(i, l), 1.)
                agtso4(i, l) = xrow(i, l+1, nf)*(1.-result1)*roarow(i, l
     +            )/amaspe(1)/ycom3l
                CALL PUSHCONTROL2B(0)
              ELSE IF (n .GT. INT(rcrit(i, l))) THEN
                agtso4(i, l) = agtso4(i, l) + xrow(i, l+1, nf)*roarow(i
     +            , l)/amaspe(1)/ycom3l
                CALL PUSHCONTROL2B(1)
              ELSE
                CALL PUSHCONTROL2B(2)
              END IF
            ELSE
              CALL PUSHCONTROL2B(3)
            END IF
          ENDDO
        ENDDO
      ENDDO
C
C-----------------------------------------------------------------------
C
C     Euler Backward Iterations
C
C-----------------------------------------------------------------------
C
C time
      DO indti=1,ysub
C
C---     initialization
        DO jk=1+mae,ilev
          DO il=il1,il2
            IF (kcalc(il, jk)) THEN
              CALL PUSHREAL8(antso2(il, jk))
              antso2(il, jk) = agtso2(il, jk)
              CALL PUSHREAL8(antho2(il, jk))
              antho2(il, jk) = agtho2(il, jk)
              antso4(il, jk) = agtso4(il, jk)
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
          ENDDO
        ENDDO
C
C---     EBI-iteration
C
C parameter update
        DO ind=1,yindmx
          DO jk=1+mae,ilev
            DO il=il1,il2
              IF (kcalc(il, jk)) THEN
                CALL PUSHREAL8(amso3)
C
C---           approach for pH from Tremblay with additional iteration
C SO3(2-)
                amso3 = 0.
C NH4(+)
                amnh4 = agtnh3(il, jk)/agamma(il, jk)
C NO3(-)
                amno3 = agthno3(il, jk)/agamma(il, jk)
C SO4(2-)
                amso4 = agtso4(il, jk)/agamma(il, jk)
C Na(+)
                amna = agtna(il, jk)/agamma(il, jk)
                IF (amna - 2.e-06 .LT. 0.) THEN
                  CALL PUSHREAL8(amcl)
                  amcl = 0.
                  CALL PUSHCONTROL1B(0)
                ELSE
                  CALL PUSHREAL8(amcl)
                  amcl = amna - 2.e-06
                  CALL PUSHCONTROL1B(1)
                END IF
                agthcl = amcl*agamma(il, jk)
C
C---           O3-concentrations
                atvo3 = 1./(1.+agamma(il, jk)*aeqcho(il, jk))
                amo3 = agto3(il, jk)*atvo3*aeqcho(il, jk)
                CALL PUSHREAL8(adelta)
C
C---           initial guess
                adelta = amno3 + 2.*(amso4+amso3) + amcl - amnh4 - amna
                CALL PUSHREAL8(amh(il, jk))
                amh(il, jk) = 0.5*(adelta+SQRT(adelta**2+4.*(1.e-14+
     +            aeqcb(il, jk)*agtso2(il, jk)+aeqcbi(il, jk)*agtco2(il
     +            , jk))))
                IF (amh(il, jk) .GT. 1.e-01) THEN
                  CALL PUSHCONTROL1B(0)
                  x1 = 1.e-01
                ELSE
                  x1 = amh(il, jk)
                  CALL PUSHCONTROL1B(1)
                END IF
                IF (x1 .LT. 1.e-10) THEN
                  amh(il, jk) = 1.e-10
                  CALL PUSHCONTROL1B(0)
                ELSE
                  amh(il, jk) = x1
                  CALL PUSHCONTROL1B(1)
                END IF
C
C---           SO2-, NH3-, and NO3-equilibrium parameters
                atval = aeqca(il, jk) + aeqcb(il, jk)/amh(il, jk) + 
     +            aeqcc(il, jk)/amh(il, jk)**2
                CALL PUSHREAL8(afras)
                afras = 1./(1.+agamma(il, jk)*atval)
                afnh4 = (1.+agtnh3(il, jk)/(1./aeqnh3(il, jk)+agamma(il
     +            , jk)*amh(il, jk)))**(-1)
                afno3 = agthno3(il, jk)/(1./aeqhno(il, jk)+agamma(il, jk
     +            )/amh(il, jk))
C
C---           subsequent iterations for pH-calculation
                DO indx=1,iterp
                  CALL PUSHREAL8(afcl)
                  afcl = agthcl/(1./aeqhcl(il, jk)+agamma(il, jk)/amh(il
     +              , jk))
                  afhso = agtso2(il, jk)*afras*aeqcb(il, jk)
                  afco3 = agtco2(il, jk)*aeqcbi(il, jk)
                  afoh = 1.e-14
                  CALL PUSHREAL8(amso3)
                  amso3 = agtso2(il, jk)*afras*aeqcc(il, jk)/amh(il, jk)
     +              **2
                  adelta = afnh4*(2.*(amso4+amso3)-amna)
                  CALL PUSHREAL8(amh(il, jk))
                  amh(il, jk) = 0.5*(adelta+SQRT(adelta**2+4.*afnh4*(
     +              afoh+afco3+afhso+afno3+afcl)))
                  IF (amh(il, jk) .GT. 1.e-01) THEN
                    CALL PUSHCONTROL1B(0)
                    x2 = 1.e-01
                  ELSE
                    x2 = amh(il, jk)
                    CALL PUSHCONTROL1B(1)
                  END IF
                  IF (x2 .LT. 1.e-10) THEN
                    amh(il, jk) = 1.e-10
                    CALL PUSHCONTROL1B(0)
                  ELSE
                    amh(il, jk) = x2
                    CALL PUSHCONTROL1B(1)
                  END IF
                  CALL PUSHREAL8(atval)
C
C---              SO2-, NH3-, and NO3-equilibrium parameters
                  atval = aeqca(il, jk) + aeqcb(il, jk)/amh(il, jk) + 
     +              aeqcc(il, jk)/amh(il, jk)**2
                  CALL PUSHREAL8(afras)
                  afras = 1./(1.+agamma(il, jk)*atval)
                  CALL PUSHREAL8(afnh4)
                  afnh4 = (1.+agtnh3(il, jk)/(1./aeqnh3(il, jk)+agamma(
     +              il, jk)*amh(il, jk)))**(-1)
                  CALL PUSHREAL8(afno3)
                  afno3 = agthno3(il, jk)/(1./aeqhno(il, jk)+agamma(il, 
     +              jk)/amh(il, jk))
                ENDDO
                CALL PUSHREAL8(afo3)
C
C---           O3-oxidation rate parameter AFO3
                afo3 = (aorhp1(il, jk)+aorhp2(il, jk)/amh(il, jk))*amo3*
     +            afras*atval
C
C---           H2O2-oxidation rate parameter AFH2O2
                afrah = 1./(1.+agamma(il, jk)*aeqchp(il, jk))
                CALL PUSHREAL8(afh2o2)
                afh2o2 = aorho(il, jk)/(0.1+amh(il, jk))*afras*aeqca(il
     +            , jk)*afrah*aeqchp(il, jk)
                CALL PUSHREAL8(atval)
C
C              scavenging ratios
C
C---           new concentrations
                atval = atimst*agamma(il, jk)
                CALL PUSHREAL8(apard)
                apard = agtho2(il, jk)
                apara = (1.+atval*afo3)*atval*afh2o2
                aparc = -agtso2(il, jk)
                aparb = 1. + atval*(afo3+afh2o2*(apard+aparc))
                atvalx = -(aparb/(2.*apara))
                CALL PUSHREAL8(antso2(il, jk))
                antso2(il, jk) = atvalx + SQRT(atvalx**2 - aparc/apara)
                CALL PUSHREAL8(antho2(il, jk))
                antho2(il, jk) = apard/(1.+atval*afh2o2*antso2(il, jk))
                adelta = agtso2(il, jk) - antso2(il, jk)
                antso4(il, jk) = agtso4(il, jk) + adelta
C
C---           diagnostic parameters
                adelti = afh2o2*antho2(il, jk)/(afh2o2*antho2(il, jk)+
     +            afo3)*adelta
                IF (ind .EQ. yindmx) THEN
                  aspeci(il, jk) = aspeci(il, jk) + adelti
                  CALL PUSHCONTROL2B(0)
                ELSE
                  CALL PUSHCONTROL2B(1)
                END IF
              ELSE
                CALL PUSHCONTROL2B(2)
              END IF
            ENDDO
          ENDDO
        ENDDO
C
        DO jk=1+mae,ilev
          DO il=il1,il2
            IF (kcalc(il, jk)) THEN
              CALL PUSHREAL8(adelta)
              adelta = agtso2(il, jk) - antso2(il, jk)
              aresid(il, jk) = aresid(il, jk) + adelta
              CALL PUSHREAL8(agtso2(il, jk))
C
C---           final concentrations after ATIMST
              agtso2(il, jk) = antso2(il, jk)
              agtho2(il, jk) = antho2(il, jk)
              CALL PUSHREAL8(agtso4(il, jk))
              agtso4(il, jk) = antso4(il, jk)
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
          ENDDO
        ENDDO
      ENDDO
C
C-----------------------------------------------------------------------
C
C     results
C
C-----------------------------------------------------------------------
C
      DO jk=1+mae,ilev
        DO il=il1,il2
          IF (kcalc(il, jk)) THEN
            IF (aresid(il, jk) .LT. 1.e-33) THEN
              CALL PUSHREAL8(max1)
              max1 = 1.e-33
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(max1)
              max1 = aresid(il, jk)
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(aspeci(il, jk))
C
C---        sulphate fraction produced by hydrogen peroxide
            aspeci(il, jk) = aspeci(il, jk)/max1
            IF (aspeci(il, jk) .LT. 0.) THEN
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
C
C---        limitation of oxidation due to too low hydrogen peroxide
C---        concentrations
            IF (agtho2(il, jk) .LT. 0.) THEN
              aresid(il, jk) = aresid(il, jk) + agtho2(il, jk)
              agtho2(il, jk) = 0.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
C
C---        limitation of oxidation due to too low sulphur dioxide
C---        concentrations
            adelms = xrow(il, jk+1, iso2)*roarow(il, jk)/(amaspe(2)*
     +        ycom3l) - aresid(il, jk)
            IF (adelms .LT. 0.) THEN
              aresid(il, jk) = adelms + aresid(il, jk)
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(adelta)
C
C---        additional sulphate in mol/kg
C
C---        sulphur dioxide in kg/kg/s
C
C---        hydrogen peroxide
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
          END IF
        ENDDO
      ENDDO
C
      DO n=1,isize
        DO l=1+mae,ilev
          DO i=il1,il2
            IF (kcalc(i, l) .AND. n .GE. INT(rcrit(i, l)) .AND. xrow(i, 
     +          l+1, iso2) .GT. 0.0) THEN
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
          ENDDO
        ENDDO
      ENDDO
      DO n=isize,1,-1
        DO l=ilev,1+mae,-1
          DO i=il2,il1,-1
            CALL POPCONTROL1B(branch)
            IF (branch .NE. 0) THEN
              temp40 = 2.*roarow(i, l)*delt
              temp42 = cldcv(i, l)*aresid(i, l)
              temp41 = afrac(i, l, n)
              temp40b0 = ycom3l*amaspe(1)*rtso4b(i, l, n)/temp40
              temp40b1 = -(temp41*temp42*temp40b0/temp40)
              afracb(i, l, n) = afracb(i, l, n) + temp42*temp40b0
              cldcvb(i, l) = cldcvb(i, l) + temp41*aresid(i, l)*temp40b0
              aresidb(i, l) = aresidb(i, l) + temp41*cldcv(i, l)*
     +          temp40b0
              roarowb(i, l) = roarowb(i, l) + 2.*delt*temp40b1
              deltb = deltb + roarow(i, l)*2.*temp40b1
            END IF
          ENDDO
        ENDDO
      ENDDO
      DO jk=ilev,1+mae,-1
        DO il=il2,il1,-1
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            adelta = cldcv(il, jk)*(agtho2(il, jk)-aoh2o2(il, jk))*
     +        ycom3l/roarow(il, jk)
            temp40b = amaspe(3)*rthpob(il, jk)/(2.*delt)
            adeltab = temp40b
            deltb = deltb - adelta*temp40b/delt
            temp39 = roarow(il, jk)
            temp38 = cldcv(il, jk)/temp39
            temp38b = ycom3l*adeltab
            temp38b0 = (agtho2(il, jk)-aoh2o2(il, jk))*temp38b/temp39
            agtho2b(il, jk) = agtho2b(il, jk) + temp38*temp38b
            aoh2o2b(il, jk) = aoh2o2b(il, jk) - temp38*temp38b
            adelta = cldcv(il, jk)*aresid(il, jk)*ycom3l/roarow(il, jk)
            temp38b2 = -(amaspe(2)*asprvab(il, jk)/(2.*delt))
            adeltab = temp38b2
            deltb = deltb - adelta*temp38b2/delt
            asprvab(il, jk) = 0.0
            CALL POPREAL8(adelta)
            temp38b1 = ycom3l*adeltab/roarow(il, jk)
            cldcvb(il, jk) = cldcvb(il, jk) + aresid(il, jk)*temp38b1 + 
     +        temp38b0
            roarowb(il, jk) = roarowb(il, jk) - cldcv(il, jk)*aresid(il
     +        , jk)*temp38b1/roarow(il, jk) - temp38*temp38b0
            aresidb(il, jk) = aresidb(il, jk) + cldcv(il, jk)*temp38b1
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              adelmsb = aresidb(il, jk)
            ELSE
              adelmsb = 0.0
            END IF
            xrowb(il, jk+1, iso2) = xrowb(il, jk+1, iso2) + roarow(il, 
     +        jk)*adelmsb/(amaspe(2)*ycom3l)
            roarowb(il, jk) = roarowb(il, jk) + xrow(il, jk+1, iso2)*
     +        adelmsb/(amaspe(2)*ycom3l)
            aresidb(il, jk) = aresidb(il, jk) - adelmsb
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) agtho2b(il, jk) = aresidb(il, jk)
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) aspecib(il, jk) = 0.0
            CALL POPREAL8(aspeci(il, jk))
            max1b = -(aspeci(il, jk)*aspecib(il, jk)/max1**2)
            aspecib(il, jk) = aspecib(il, jk)/max1
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(max1)
            ELSE
              CALL POPREAL8(max1)
              aresidb(il, jk) = aresidb(il, jk) + max1b
            END IF
          END IF
        ENDDO
      ENDDO
      atimstb = 0.0
      DO indti=ysub,1,-1
        DO jk=ilev,1+mae,-1
          DO il=il2,il1,-1
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              adeltab = aresidb(il, jk)
              CALL POPREAL8(agtso4(il, jk))
              antso4b(il, jk) = antso4b(il, jk) + agtso4b(il, jk)
              agtso4b(il, jk) = 0.0
              antho2b(il, jk) = antho2b(il, jk) + agtho2b(il, jk)
              agtho2b(il, jk) = 0.0
              CALL POPREAL8(agtso2(il, jk))
              antso2b(il, jk) = antso2b(il, jk) + agtso2b(il, jk) - 
     +          adeltab
              agtso2b(il, jk) = adeltab
              CALL POPREAL8(adelta)
            END IF
          ENDDO
        ENDDO
        DO ind=yindmx,1,-1
          DO jk=ilev,1+mae,-1
            DO il=il2,il1,-1
              CALL POPCONTROL2B(branch)
              IF (branch .EQ. 0) THEN
                adeltib = aspecib(il, jk)
              ELSE IF (branch .EQ. 1) THEN
                adeltib = 0.0
              ELSE
                GOTO 100
              END IF
              temp31 = amh(il, jk)
              temp30 = aorhp2(il, jk)/temp31
              temp37 = afh2o2*antho2(il, jk) + afo3
              temp37b = adeltib/temp37
              temp37b0 = antho2(il, jk)*temp37b
              temp37b1 = -(antho2(il, jk)*afh2o2*adelta*temp37b/temp37)
              antho2b(il, jk) = antho2b(il, jk) + afh2o2*temp37b1 + 
     +          afh2o2*adelta*temp37b
              adeltab = antso4b(il, jk) + afh2o2*temp37b0
              agtso4b(il, jk) = agtso4b(il, jk) + antso4b(il, jk)
              antso4b(il, jk) = 0.0
              atval = atimst*agamma(il, jk)
              temp36 = atval*afh2o2*antso2(il, jk) + 1.
              temp36b2 = -(apard*antho2b(il, jk)/temp36**2)
              antso2b(il, jk) = antso2b(il, jk) + atval*afh2o2*temp36b2 
     +          - adeltab
              temp37b2 = antso2(il, jk)*temp36b2
              apara = (1.+atval*afo3)*atval*afh2o2
              aparc = -agtso2(il, jk)
              aparb = 1. + atval*(afo3+afh2o2*(apard+aparc))
              atvalx = -(aparb/(2.*apara))
              IF (atvalx**2 - aparc/apara .EQ. 0.0) THEN
                temp36b3 = 0.0
              ELSE
                temp36b3 = antso2b(il, jk)/(2.0*SQRT(atvalx**2-aparc/
     +            apara))
              END IF
              atvalxb = 2*atvalx*temp36b3 + antso2b(il, jk)
              antso2b(il, jk) = 0.0
              temp36b4 = -(atvalxb/(2.*apara))
              aparab = aparc*temp36b3/apara**2 - aparb*temp36b4/apara
              aparbb = temp36b4
              temp36b0 = atval*aparbb
              apardb = afh2o2*temp36b0 + antho2b(il, jk)/temp36
              antho2b(il, jk) = 0.0
              aparcb = afh2o2*temp36b0 - temp36b3/apara
              agtso2b(il, jk) = agtso2b(il, jk) + adeltab - aparcb
              temp36b1 = atval*afh2o2*aparab
              afo3b = temp36b0 + atval*temp36b1 + temp37b1
              temp36b = (atval*afo3+1.)*aparab
              afh2o2b = atval*temp37b2 + atval*temp36b + (apard+aparc)*
     +          temp36b0 + antho2(il, jk)*temp37b1 + adelta*temp37b0
              CALL POPREAL8(antho2(il, jk))
              atvalb = (afo3+afh2o2*(apard+aparc))*aparbb + afh2o2*
     +          temp36b + afo3*temp36b1 + afh2o2*temp37b2
              CALL POPREAL8(antso2(il, jk))
              CALL POPREAL8(apard)
              agtho2b(il, jk) = agtho2b(il, jk) + apardb
              atvo3 = 1./(1.+agamma(il, jk)*aeqcho(il, jk))
              amo3 = agto3(il, jk)*atvo3*aeqcho(il, jk)
              CALL POPREAL8(atval)
              atimstb = atimstb + agamma(il, jk)*atvalb
              afrah = 1./(1.+agamma(il, jk)*aeqchp(il, jk))
              CALL POPREAL8(afh2o2)
              temp35 = amh(il, jk) + 0.1
              temp33b = afras*afrah*aeqchp(il, jk)*afh2o2b/temp35
              temp34 = aorho(il, jk)*aeqca(il, jk)
              temp33 = temp34/temp35
              temp34b = temp33*aeqchp(il, jk)*afh2o2b
              afrahb = afras*temp34b - asrhpob(il, jk)
              asrhpob(il, jk) = 0.0
              aorhob(il, jk) = aorhob(il, jk) + aeqca(il, jk)*temp33b
              aeqcab(il, jk) = aeqcab(il, jk) + aorho(il, jk)*temp33b
              temp32 = agamma(il, jk)*aeqchp(il, jk) + 1.
              temp32b = -(afrahb/temp32**2)
              agammab(il, jk) = agammab(il, jk) + aeqchp(il, jk)*temp32b
     +          + atimst*atvalb
              aeqchpb(il, jk) = aeqchpb(il, jk) + agamma(il, jk)*temp32b
     +          + temp33*afras*afrah*afh2o2b
              CALL POPREAL8(afo3)
              temp30b0 = amo3*afras*atval*afo3b
              amhb(il, jk) = amhb(il, jk) - temp30*temp30b0/temp31 - 
     +          temp33*temp33b
              temp30b = (aorhp1(il, jk)+temp30)*afo3b
              afrasb = afrah*temp34b + atval*amo3*temp30b - asrso2b(il, 
     +          jk)
              asrso2b(il, jk) = 0.0
              aorhp1b(il, jk) = aorhp1b(il, jk) + temp30b0
              aorhp2b(il, jk) = aorhp2b(il, jk) + temp30b0/temp31
              amo3b = atval*afras*temp30b
              atvalb = amo3*afras*temp30b
              amso4 = agtso4(il, jk)/agamma(il, jk)
              amna = agtna(il, jk)/agamma(il, jk)
              agthcl = amcl*agamma(il, jk)
              afnh4b = 0.0
              afno3b = 0.0
              amso4b = 0.0
              amnab = 0.0
              agthclb = 0.0
              DO indx=iterp,1,-1
                temp19 = amh(il, jk)**2
                temp20 = agamma(il, jk)*atval + 1.
                temp20b = -(afrasb/temp20**2)
                atvalb = atvalb + agamma(il, jk)*temp20b
                temp19b = atvalb/amh(il, jk)
                temp24 = aeqnh3(il, jk)
                temp23 = 1.0/temp24
                temp22 = temp23 + agamma(il, jk)*amh(il, jk)
                temp21 = agtnh3(il, jk)/temp22
                temp21b = -(afnh4b/((temp21+1.)**2*temp22))
                temp22b = -(temp21*temp21b)
                CALL POPREAL8(afno3)
                temp29 = amh(il, jk)
                temp28 = agamma(il, jk)/temp29
                temp27 = aeqhno(il, jk)
                temp26 = 1.0/temp27
                temp25 = temp26 + temp28
                temp25b = -(agthno3(il, jk)*afno3b/temp25**2)
                agthno3b(il, jk) = agthno3b(il, jk) + afno3b/temp25
                aeqhnob(il, jk) = aeqhnob(il, jk) - temp26*temp25b/
     +            temp27
                agammab(il, jk) = agammab(il, jk) + amh(il, jk)*temp22b 
     +            + atval*temp20b + temp25b/temp29
                amhb(il, jk) = amhb(il, jk) + agamma(il, jk)*temp22b - 
     +            aeqcc(il, jk)*2*amh(il, jk)*atvalb/temp19**2 - aeqcb(
     +            il, jk)*temp19b/amh(il, jk) - temp28*temp25b/temp29
                CALL POPREAL8(afnh4)
                agtnh3b(il, jk) = agtnh3b(il, jk) + temp21b
                aeqnh3b(il, jk) = aeqnh3b(il, jk) - temp23*temp22b/
     +            temp24
                CALL POPREAL8(afras)
                CALL POPREAL8(atval)
                aeqcab(il, jk) = aeqcab(il, jk) + atvalb
                aeqcbb(il, jk) = aeqcbb(il, jk) + temp19b
                aeqccb(il, jk) = aeqccb(il, jk) + atvalb/temp19
                CALL POPCONTROL1B(branch)
                IF (branch .EQ. 0) THEN
                  amhb(il, jk) = 0.0
                  x2b = 0.0
                ELSE
                  x2b = amhb(il, jk)
                  amhb(il, jk) = 0.0
                END IF
                CALL POPCONTROL1B(branch)
                IF (branch .NE. 0) amhb(il, jk) = amhb(il, jk) + x2b
                adelta = afnh4*(2.*(amso4+amso3)-amna)
                afhso = agtso2(il, jk)*afras*aeqcb(il, jk)
                afco3 = agtco2(il, jk)*aeqcbi(il, jk)
                afoh = 1.e-14
                CALL POPREAL8(amh(il, jk))
                temp18 = afoh + afco3 + afhso + afno3 + afcl
                IF (adelta**2 + 4.*(afnh4*temp18) .EQ. 0.0) THEN
                  temp18b = 0.0
                ELSE
                  temp18b = 0.5*amhb(il, jk)/(2.0*SQRT(adelta**2+4.*(
     +              afnh4*temp18)))
                END IF
                temp18b0 = 4.*afnh4*temp18b
                adeltab = 2*adelta*temp18b + 0.5*amhb(il, jk)
                afnh4b = (2.*(amso4+amso3)-amna)*adeltab + 4.*temp18*
     +            temp18b
                afco3b = temp18b0
                afhsob = temp18b0
                afno3b = temp18b0
                afclb = temp18b0
                temp18b1 = afnh4*adeltab
                amso4b = amso4b + 2.*temp18b1
                amso3b = 2.*temp18b1
                amnab = amnab - temp18b1
                CALL POPREAL8(amso3)
                temp17 = amh(il, jk)**2
                temp16 = aeqcc(il, jk)/temp17
                temp16b = agtso2(il, jk)*afras*amso3b/temp17
                aeqccb(il, jk) = aeqccb(il, jk) + temp16b
                agtco2b(il, jk) = agtco2b(il, jk) + aeqcbi(il, jk)*
     +            afco3b
                aeqcbib(il, jk) = aeqcbib(il, jk) + agtco2(il, jk)*
     +            afco3b
                temp16b0 = aeqcb(il, jk)*afhsob
                agtso2b(il, jk) = agtso2b(il, jk) + afras*temp16b0 + 
     +            temp16*afras*amso3b
                afrasb = agtso2(il, jk)*temp16b0 + temp16*agtso2(il, jk)
     +            *amso3b
                aeqcbb(il, jk) = aeqcbb(il, jk) + agtso2(il, jk)*afras*
     +            afhsob
                CALL POPREAL8(afcl)
                temp15 = amh(il, jk)
                temp14 = agamma(il, jk)/temp15
                temp13 = aeqhcl(il, jk)
                temp12 = 1.0/temp13
                temp11 = temp12 + temp14
                temp11b = -(agthcl*afclb/temp11**2)
                amhb(il, jk) = -(temp16*2*amh(il, jk)*temp16b) - temp14*
     +            temp11b/temp15
                agthclb = agthclb + afclb/temp11
                aeqhclb(il, jk) = aeqhclb(il, jk) - temp12*temp11b/
     +            temp13
                agammab(il, jk) = agammab(il, jk) + temp11b/temp15
                atvalb = 0.0
              ENDDO
              temp0 = amh(il, jk)**2
              temp1 = agamma(il, jk)*atval + 1.
              temp1b = -(afrasb/temp1**2)
              atvalb = atvalb + agamma(il, jk)*temp1b
              temp0b2 = atvalb/amh(il, jk)
              temp5 = aeqnh3(il, jk)
              temp4 = 1.0/temp5
              temp3 = temp4 + agamma(il, jk)*amh(il, jk)
              temp2 = agtnh3(il, jk)/temp3
              temp2b = -(afnh4b/((temp2+1.)**2*temp3))
              temp3b = -(temp2*temp2b)
              temp10 = amh(il, jk)
              temp9 = agamma(il, jk)/temp10
              temp8 = aeqhno(il, jk)
              temp7 = 1.0/temp8
              temp6 = temp7 + temp9
              temp6b = -(agthno3(il, jk)*afno3b/temp6**2)
              agthno3b(il, jk) = agthno3b(il, jk) + afno3b/temp6
              aeqhnob(il, jk) = aeqhnob(il, jk) - temp7*temp6b/temp8
              agammab(il, jk) = agammab(il, jk) + amh(il, jk)*temp3b + 
     +          atval*temp1b + temp6b/temp10
              amhb(il, jk) = amhb(il, jk) + agamma(il, jk)*temp3b - 
     +          aeqcc(il, jk)*2*amh(il, jk)*atvalb/temp0**2 - aeqcb(il, 
     +          jk)*temp0b2/amh(il, jk) - temp9*temp6b/temp10
              agtnh3b(il, jk) = agtnh3b(il, jk) + temp2b
              aeqnh3b(il, jk) = aeqnh3b(il, jk) - temp4*temp3b/temp5
              CALL POPREAL8(afras)
              aeqcab(il, jk) = aeqcab(il, jk) + atvalb
              aeqcbb(il, jk) = aeqcbb(il, jk) + temp0b2
              aeqccb(il, jk) = aeqccb(il, jk) + atvalb/temp0
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                amhb(il, jk) = 0.0
                x1b = 0.0
              ELSE
                x1b = amhb(il, jk)
                amhb(il, jk) = 0.0
              END IF
              CALL POPCONTROL1B(branch)
              IF (branch .NE. 0) amhb(il, jk) = amhb(il, jk) + x1b
              amnh4 = agtnh3(il, jk)/agamma(il, jk)
              amno3 = agthno3(il, jk)/agamma(il, jk)
              amso3 = 0.
              adelta = amno3 + 2.*(amso4+amso3) + amcl - amnh4 - amna
              CALL POPREAL8(amh(il, jk))
              IF (adelta**2 + 4.*(aeqcb(il, jk)*agtso2(il, jk)+aeqcbi(il
     +            , jk)*agtco2(il, jk)+1.e-14) .EQ. 0.0) THEN
                temp0b = 0.0
              ELSE
                temp0b = 0.5*amhb(il, jk)/(2.0*SQRT(adelta**2+4.*(aeqcb(
     +            il, jk)*agtso2(il, jk)+aeqcbi(il, jk)*agtco2(il, jk)+
     +            1.e-14)))
              END IF
              temp0b0 = 4.*temp0b
              adeltab = 2*adelta*temp0b + 0.5*amhb(il, jk)
              aeqcbb(il, jk) = aeqcbb(il, jk) + agtso2(il, jk)*temp0b0
              agtso2b(il, jk) = agtso2b(il, jk) + aeqcb(il, jk)*temp0b0
              aeqcbib(il, jk) = aeqcbib(il, jk) + agtco2(il, jk)*temp0b0
              agtco2b(il, jk) = agtco2b(il, jk) + aeqcbi(il, jk)*temp0b0
              amhb(il, jk) = 0.0
              CALL POPREAL8(adelta)
              amno3b = adeltab
              amso4b = amso4b + 2.*adeltab
              amclb = agamma(il, jk)*agthclb + adeltab
              amnh4b = -adeltab
              amnab = amnab - adeltab
              temp0b1 = aeqcho(il, jk)*amo3b
              agto3b(il, jk) = agto3b(il, jk) + atvo3*temp0b1
              atvo3b = agto3(il, jk)*temp0b1
              temp = agamma(il, jk)*aeqcho(il, jk) + 1.
              tempb4 = -(atvo3b/temp**2)
              aeqchob(il, jk) = aeqchob(il, jk) + agamma(il, jk)*tempb4 
     +          + agto3(il, jk)*atvo3*amo3b
              agammab(il, jk) = agammab(il, jk) + amcl*agthclb + aeqcho(
     +          il, jk)*tempb4
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                CALL POPREAL8(amcl)
              ELSE
                CALL POPREAL8(amcl)
                amnab = amnab + amclb
              END IF
              tempb2 = amnh4b/agamma(il, jk)
              tempb3 = amno3b/agamma(il, jk)
              tempb1 = amso4b/agamma(il, jk)
              tempb0 = amnab/agamma(il, jk)
              agtnab(il, jk) = agtnab(il, jk) + tempb0
              agammab(il, jk) = agammab(il, jk) - agtso4(il, jk)*tempb1/
     +          agamma(il, jk) - agtnh3(il, jk)*tempb2/agamma(il, jk) - 
     +          agthno3(il, jk)*tempb3/agamma(il, jk) - agtna(il, jk)*
     +          tempb0/agamma(il, jk)
              agtso4b(il, jk) = agtso4b(il, jk) + tempb1
              agthno3b(il, jk) = agthno3b(il, jk) + tempb3
              agtnh3b(il, jk) = agtnh3b(il, jk) + tempb2
              CALL POPREAL8(amso3)
 100          CONTINUE
            ENDDO
          ENDDO
        ENDDO
        DO jk=ilev,1+mae,-1
          DO il=il2,il1,-1
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              agtso4b(il, jk) = agtso4b(il, jk) + antso4b(il, jk)
              antso4b(il, jk) = 0.0
              CALL POPREAL8(antho2(il, jk))
              agtho2b(il, jk) = agtho2b(il, jk) + antho2b(il, jk)
              antho2b(il, jk) = 0.0
              CALL POPREAL8(antso2(il, jk))
              agtso2b(il, jk) = agtso2b(il, jk) + antso2b(il, jk)
              antso2b(il, jk) = 0.0
            END IF
          ENDDO
        ENDDO
      ENDDO
      DO n=isize,1,-1
        nf = isize*(nn-1) + n + (iae1-1)
        DO l=ilev,1+mae,-1
          DO i=il2,il1,-1
            CALL POPCONTROL2B(branch)
            IF (branch .LT. 2) THEN
              IF (branch .EQ. 0) THEN
                tempb = xrow(i, l+1, nf)*agtso4b(i, l)/(amaspe(1)*ycom3l
     +            )
                xrowb(i, l+1, nf) = xrowb(i, l+1, nf) + (1.-result1)*
     +            roarow(i, l)*agtso4b(i, l)/(amaspe(1)*ycom3l)
                result1b = -(roarow(i, l)*tempb)
                roarowb(i, l) = roarowb(i, l) + (1.-result1)*tempb
                agtso4b(i, l) = 0.0
                CALL POPREAL8(rcrit(i, l))
c                CALL AMOD_B(rcrit(i, l), rcritb(i, l), 1., result1b)
                 result1=AMOD(rcrit(i, l),1.)
                 result1b=AMOD(rcritb(i, l), 1.)
              ELSE
                xrowb(i, l+1, nf) = xrowb(i, l+1, nf) + roarow(i, l)*
     +            agtso4b(i, l)/(amaspe(1)*ycom3l)
                roarowb(i, l) = roarowb(i, l) + xrow(i, l+1, nf)*agtso4b
     +            (i, l)/(amaspe(1)*ycom3l)
              END IF
            END IF
          ENDDO
        ENDDO
      ENDDO
      DO jk=ilev,1+mae,-1
        DO il=il2,il1,-1
          aspecib(il, jk) = 0.0
          aresidb(il, jk) = 0.0
          agtho2b(il, jk) = agtho2b(il, jk) + aoh2o2b(il, jk)
          aoh2o2b(il, jk) = 0.0
          atvalb = agtso2b(il, jk)/ycom3l
          agtso2b(il, jk) = 0.0
          xrowb(il, jk+1, iso2) = xrowb(il, jk+1, iso2) + roarow(il, jk)
     +      *atvalb/amaspe(2)
          roarowb(il, jk) = roarowb(il, jk) + xrow(il, jk+1, iso2)*
     +      atvalb/amaspe(2)
        ENDDO
      ENDDO
      DO jk=ilev,1+mae,-1
        DO il=il2,il1,-1
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            zmlwcb(il, jk) = zmlwcb(il, jk) + roarow(il, jk)*agammab(il
     +        , jk)/yrhow
            roarowb(il, jk) = roarowb(il, jk) + zmlwc(il, jk)*agammab(il
     +        , jk)/yrhow
            agammab(il, jk) = 0.0
          END IF
        ENDDO
      ENDDO
      DO k=ilev,1+mae,-1
        DO il=il2,il1,-1
          asprvab(il, k) = 0.0
          asrhpob(il, k) = 0.0
          asrso2b(il, k) = 0.0
          amhb(il, k) = 0.0
          agammab(il, k) = 0.0
        ENDDO
      ENDDO
      deltb = deltb + 2.*atimstb/REAL(ysub)
      END
