      SUBROUTINE OXICON (     IL1,    IL2,  NTRAC,    ILEV,      ID
     1                   ,    ILG,   ISO2,   IHPO,      NN,   ISIZE
     2                   ,   IAE1,  RCRIT,  AGTO3,  AGTCO2,  AGTNH3
     3                   ,AGTHNO3,  AGTNA,  AEQCB,  AEQCBI,  AEQNH3
     4                   , AEQHNO, AEQHCL,  AEQCC,   AEQCA,  AEQCHO
     5                   , AEQCHP, AORHP1, AORHP2,   AORHO,  ROAROW
     6                   ,  AFRAC,  CLDCV,  ZMLWC,    GRAV,    DSHJ
     7                   ,  IDEEP,   EPS0,     JT,    MAXG,      JD
     8                   ,     DZ,     DP,     DU,      EU,      ED
     9                   ,     MU,     MD,     MC,      MB,     MSG
     *                   ,LENGATH,DSUBCLD,      X,      XU,      XD
     1                   ,     XG,   XHAT,   DXDT,    DXDX,    FACX
     2                   ,  SUMDX,     OU,    XGA,     XUA,  NTRACA
     3                   , AGTSO4, AGTSO2,  AGTHP,  AGAMMA,    XROW
     4                   ,    AMH,  KCALC,  RTSO4,   RTSO2,   RTHPO
     5                   , AMASPE,    MUR,    MDR,     DUR,     EUR
     6                   ,    EDR,    ZFG,   TMP1,    TMP2,    TMP3
     7                   ,     RU,    RUA,      T,     DZT,  RTBCLD,MAE)
C***********************************************************************
C     Calculates transport and oxidation in convective clouds
C***********************************************************************
C
C---  History
C     APRIL 16, 1999    S.L. GONG      VECTORIZED THE NEW DIAGNOSE
C                                      PORTION OF THE ROUTINE AND TAKE
C                                      THE CONVECTIVE SCARVENGING 
C                                      AMMOUNT INTO TOTAL REMOVAL ARRAY
C                                      GDREM FOR TOTAL BUDGET.
C     MARCH 10, 1999    KNUT VON SALZEN     NEW DIAGNOSTICS
C     FEBRUARY 16, 1998 KNUT VON SALZEN     NEW SUBROUTINE
C     MARCH 12, 1998    KNUT VON SALZEN     ZHANG & MCFARLANE SCHEME
C
C-----------------------------------------------------------------------
C     I/O-parameters
C
C     AEQCA     REAL     INPUT
C     AEQCB     REAL     INPUT
C     AEQCC     REAL     INPUT
C     AEQCBI    REAL     INPUT
C     AEQCHO    REAL     INPUT
C     AEQCHP    REAL     INPUT
C     AEQHCL    REAL     INPUT
C     AEQHNO    REAL     INPUT
C     AEQNH3    REAL     INPUT
C     AFRAC     REAL     INPUT
C     AGAMMA    REAL     WORK ARRAY
C     AGTCO2    REAL     INPUT
C     AGTHNO3   REAL     INPUT
C     AGTHP     REAL     WORK ARRAY (UNITS: MOL HYDROGEN PEROXIDE
C                                          /CUBIC LITRE AIR)
C     AGTNA     REAL     INPUT
C     AGTNH3    REAL     INPUT
C     AGTO3     REAL     INPUT
C     AGTSO2    REAL     WORK ARRAY (UNITS: MOL SULPHUR SULPHUR DIOXIDE
C                                          /CUBIC LITRE AIR)
C     AGTSO4    REAL     WORK ARRAY (UNITS: MOL SULPHATE
C                                          /CUBIC LITRE AIR)
C     AORHO     REAL     INPUT
C     AORHP1    REAL     INPUT
C     AORHP2    REAL     INPUT
C     CLDCV     REAL     INPUT
C     DSHJ      REAL     INPUT-FROM->PHYMRCB
C     DXDT      REAL     WORK ARRAY
C     DXDX      REAL     WORK ARRAY
C     DP        REAL     INPUT-FROM->CONV4
C     DSUBCLD   REAL     INPUT-FROM->CONV4
C     DU        REAL     INPUT-FROM->CLDPRP4
C     DUR       REAL     WORK ARRAY
C     DZ        REAL     INPUT-FROM->CLDPRP4
C     EPS0      REAL     INPUT-FROM->CLDPRP4
C     ED        REAL     INPUT-FROM->CLDPRP4
C     EDR       REAL     WORK ARRAY
C     EU        REAL     INPUT-FROM->CLDPRP4
C     EUR       REAL     WORK ARRAY
C     FACX      REAL     WORK ARRAY
C     GRAV      REAL     INPUT
C     IAE1      INTEGER  INPUT
C     IDEEP     INTEGER  INPUT-FROM->CONV4
C     IL1       INTEGER  INPUT
C     IL2       INTEGER  INPUT
C     ILEV      INTEGER  INPUT
C     ILG       INTEGER  INPUT
C     IHPO      INTEGER  INPUT
C     ISO2      INTEGER  INPUT
C     ISIZE     INTEGER  INPUT
C     JD        INTEGER  INPUT-FROM->CLDPRP4
C     JT        INTEGER  INPUT-FROM->CLDPRP4
C     KCALC     LOGICAL  WORK ARRAY
C     LENGATH   INTEGER  INPUT-FROM->CONV4
C     MAXG      INTEGER  INPUT-FROM->CONV4
C     MB        REAL     INPUT-FROM->CONV4
C     MC        REAL     INPUT-FROM->CLDPRP4
C     MD        REAL     INPUT-FROM->CLDPRP4
C     MDR       REAL     WORK ARRAY
C     MU        REAL     INPUT-FROM->CLDPRP4
C     MUR       REAL     WORK ARRAY
C     MSG       INTEGER  INPUT-FROM->PHYMRCC
C     NN        INTEGER  INPUT
C     NTRAC     INTEGER  INPUT
C     RU        REAL     WORK ARRAY
C     RUA       REAL     WORK ARRAY
C     OU        REAL     WORK ARRAY
C     T         REAL     INPUT
C     RCRIT     REAL     INPUT
C     ROAROW    REAL     INPUT
C     SUMDX     REAL     WORK ARRAY
C     ZFG       REAL     INPUT-FROM->CONV4
C     ZMLWC     REAL     INPUT
C     X         REAL     WORK ARRAY
C     XG        REAL     WORK ARRAY
C     XGA       REAL     WORK ARRAY
C     XHAT      REAL     WORK ARRAY
C     XU        REAL     WORK ARRAY
C     XUA       REAL     WORK ARRAY
C     XD        REAL     WORK ARRAY
C     XROW      REAL     INPUT/OUTPUT-FROM->COMMON ICOM
C
C-----------------------------------------------------------------------
C
      COMMON /TIMES/ DELT
      COMMON /AEROSWTH/ IDEBUG,   IMM,    IMA,   INU,  ICOB,IDRYDEP,           
     1                 ITUBMIX, ICOAG,ICONVEC,IINCLD,IBLCLD     
      LOGICAL KCALC(ILG,ILEV)
C
      INTEGER IDEEP(ILG),JT(ILG),MAXG(ILG),JD(ILG)
      INTEGER ITERP,INH3,IHNO3,IO3,ICO2,ISO4
      PARAMETER (ITERP = 3)
      PARAMETER (INH3  = 1)
      PARAMETER (IHNO3 = INH3+1)
      PARAMETER (IO3   = IHNO3+1)
      PARAMETER (ICO2  = IO3+1)
      PARAMETER (ISO4  = ICO2+1)
C
      REAL XROW(ILG,ILEV+1,NTRAC),XG(ILG,ILEV,NTRAC)                    !
     1    ,X(ILG,ILEV,NTRAC),XU(ILG,ILEV,NTRAC),XD(ILG,ILEV,NTRAC)
     2    ,DXDT(ILG,ILEV,NTRAC), XHAT(ILG,ILEV,NTRAC)
     3    ,DXDX(ILG,ILEV,NTRAC), FACX(ILG,ILEV,NTRAC)
     4    ,SUMDX(ILG),MB(ILG),DSUBCLD(ILG),EPS0(ILG)
     5    ,MU(ILG,ILEV),EU(ILG,ILEV),DU(ILG,ILEV),MD(ILG,ILEV)
     6    ,MC(ILG,ILEV),ED(ILG,ILEV),DP(ILG,ILEV),DZ(ILG,ILEV)
     7    ,DSHJ(ILG,ILEV),OU(ILG,ILEV,NTRAC),MUR(ILG,ILEV)
     8    ,MDR(ILG,ILEV),DUR(ILG,ILEV),EUR(ILG,ILEV)
     9    ,EDR(ILG,ILEV),ZFG(ILG,ILEV),RTBCLD(ILG,ILEV,NTRAC) 
      REAL CLDCV(ILG,ILEV),AGTO3(ILG,ILEV),AMASPE(3)
     1    ,AGTCO2(ILG,ILEV),AGTNH3(ILG,ILEV),AGTHNO3(ILG,ILEV)
     2    ,ZMLWC(ILG,ILEV),RCRIT(ILG,ILEV),AGTSO4(ILG,ILEV)
     3    ,AGTSO2(ILG,ILEV),AGTHP(ILG,ILEV),ROAROW(ILG,ILEV)
     4    ,AGAMMA(ILG,ILEV),AGTNA(ILG,ILEV),AEQCB(ILG,ILEV)
     5    ,AEQCBI(ILG,ILEV),AEQNH3(ILG,ILEV),AEQHNO(ILG,ILEV)
     6    ,AEQHCL(ILG,ILEV),AEQCC(ILG,ILEV),AEQCA(ILG,ILEV)
     7    ,AEQCHO(ILG,ILEV),AEQCHP(ILG,ILEV),AORHP1(ILG,ILEV)
     8    ,AORHP2(ILG,ILEV),AORHO(ILG,ILEV),AFRAC(ILG,ILEV,ISIZE)
     9    ,RTSO4(ILG,ILEV,ISIZE),RTSO2(ILG,ILEV),RTHPO(ILG,ILEV)
      REAL RU(ILG,ILEV,NTRAC),RUA(ILG,ILEV,NTRACA),T(ILG,ILEV)
      REAL AMH(ILG,ILEV),XUA(ILG,ILEV,NTRACA),XGA(ILG,ILEV,NTRACA)
      REAL TMP1(ILG), TMP2(ILG),TMP3(ILG), DZT(ILG,ILEV)

      REAL AMSO3,AMNH4,AMNO3,AMSO4,AMNA,AMCL,AGTHCL,ADELTA,ATVAL
     1    ,AMO3,AFRAS,AFRAH,AFO3,AFH2O2,GRAV
      REAL YCOM3L,YEPS,YSMALL,YRHOW,RNU,BETA
      PARAMETER (YCOM3L = 1.E+03)
      PARAMETER (YEPS   = 1.E-33)
      PARAMETER (YSMALL = 1.E-03)
      PARAMETER (YRHOW  = 1.E+03)
      PARAMETER (RNU    = 1.)
      PARAMETER (BETA   = 1.)
      COMMON/HTCP  / TFREEZ,T2S,AI,BI,AW,BW,SLP
C
C-----------------------------------------------------------------------
C
C     initial values and constants
C
C-----------------------------------------------------------------------
C
C---  minimum and maximum tracer index of sulphate aerosol
      NFMIN=ISIZE*(NN-1)+1+(IAE1-1)
      NFMAX=ISIZE*(NN-1)+ISIZE+(IAE1-1)
C
C---  scavenging ratios sulphate and carbon dioxide
      ASRSO4 = 1.
      ASRCO2 = 0.
C
C---  control parameter
      CALL PUTZERO (SUMDX,  ILG)

      CALL PUTZERO  (AGTSO2, ILG*ILEV)
      CALL PUTZERO  (AGTSO4, ILG*ILEV)
      CALL PUTZERO  (AGTHP , ILG*ILEV)
C
C---  assume no chemical sinks/sources
      CALL PUTZERO  (OU    , ILG*ILEV*NTRAC)
      CALL PUTZERO  (RU    , ILG*ILEV*NTRAC)
      CALL PUTZERO  (RUA   , ILG*ILEV*NTRACA)
      
      CALL PUTZERO  (MUR   , ILG*ILEV)
      CALL PUTZERO  (MDR   , ILG*ILEV)
      CALL PUTZERO  (EDR   , ILG*ILEV)
      CALL PUTZERO  (EUR   , ILG*ILEV)
      CALL PUTZERO  (DUR   , ILG*ILEV)
      MASG=MAX (MAE,MSG) 
C
C---  assume 10**(-pH) = 1
      DO 40 L=1+MASG,ILEV
      DO 40 IL=IL1,IL2
         AMH(IL,L) = 1.
 40   CONTINUE

      DO 60 L=MASG+1,ILEV
      DO 60 K=1,LENGATH
         MUR(K,L) = MU(K,L) / MAX(MB(K),YEPS)
         MDR(K,L) = MD(K,L) / MAX(MB(K),YEPS)
         EDR(K,L) = ED(K,L) / MAX(MB(K),YEPS)
         EUR(K,L) = EU(K,L) / MAX(MB(K),YEPS)
 60   CONTINUE
      DO 62 L=MASG+1,ILEV-1
      DO 62 K=1,LENGATH
         DUR(K,L) = DU(K,L) * DP(K,L)
     1           / (MAX(MB(K),YEPS)*(ZFG(K,L)-ZFG(K,L+1)))
!       print *, MU(K,L),MD(K,L),MB(K),EU(K,L),
!     +      DU(K,L),K,L,'IN OXICOV 1'
 62   CONTINUE
      DO 63 K=1,LENGATH
         DUR(K,ILEV) = DU(K,ILEV) * DP(K,ILEV)
     1              / (MAX(MB(K),YEPS)*ZFG(K,ILEV))
!       print *, DU(K,ILEV), DP(K,ILEV),MB(K),
!     +        ZFG(K,ILEV),DUR(K,ILEV),'IN OXICOV 2'
 63   CONTINUE
C
C---  copy XROW into the work array and change units from kg/kg
C---  to mol/kg
         DO 70 N=1,NTRAC
         DO 70 L=1+MASG,ILEV
         DO 70 K=IL1,IL2
            IF ( N .EQ. ISO2 ) THEN
               AFAKT = 1. / AMASPE(2)
            ELSE IF ( N .EQ. IHPO) THEN
               AFAKT = 1. / AMASPE(3)
            ELSE IF ( (N .GE. NFMIN) .OR. (N .LE. NFMAX) ) THEN
               AFAKT = 1. / AMASPE(1)
            ELSE
               AFAKT = 1.
            END IF
            X(K,L,N) = AFAKT * XROW(K,L+1,N)
 70      CONTINUE
C
C---     IDEEP(K) contains indices where convection occurs
C---     XG is "gathered" here
         DO 90 N=1,NTRAC
         DO 90 L=1+MASG,ILEV
         DO 90 K=1,LENGATH
            XG(K,L,N) = X(IDEEP(K),L,N)
 90      CONTINUE
C
C---     all chemical species which are not subject to
C---     other processes than cloud-chemical processes
C---     units: mol/kg
         DO 95 L=1+MASG,ILEV
         DO 95 K=1,LENGATH
            AFAKT = YCOM3L / ROAROW(IDEEP(K),L)
            XGA(K,L,INH3)  = AGTNH3(IDEEP(K),L)  * AFAKT
            XGA(K,L,IHNO3) = AGTHNO3(IDEEP(K),L) * AFAKT
            XGA(K,L,IO3)   = AGTO3(IDEEP(K),L)   * AFAKT
            XGA(K,L,ICO2)  = AGTCO2(IDEEP(K),L)  * AFAKT
            XGA(K,L,ISO4)  = 0.
 95      CONTINUE
C
C---     total activated sulphate
         DO 96 N=1,ISIZE
            NF=NFMIN+N-1
            DO 97 L=1+MASG,ILEV
            DO 97 K=1,LENGATH
               IF (N .EQ. INT(RCRIT(IDEEP(K),L)))  THEN
                  XGA(K,L,ISO4) = XG(K,L,NF)
     1                          *(1.-AMOD(RCRIT(IDEEP(K),L),1.))
               ELSE IF (N .GT. INT(RCRIT(IDEEP(K),L))) THEN
                  XGA(K,L,ISO4) = XGA(K,L,ISO4) + XG(K,L,NF)
               END IF
 97         CONTINUE
 96      CONTINUE
C
C---     compute XHAT from two different interpolation approaches
         DO 110 N=1,NTRAC
            IF (     (N .EQ. ISO2) .OR. (N .EQ. IHPO)
     1         .OR. ((N .GE. NFMIN) .AND. (N .LE. NFMAX)) ) THEN
               DO 115 L=MASG+2,ILEV
               DO 115 K=1,LENGATH
                  AXDIF = 0.
                  IF(XG(K,L-1,N) .GT. 0. .OR. XG(K,L,N) .GT. 0.)
     1               AXDIF = ABS((XG(K,L-1,N)-XG(K,L,N))
     2                     / MAX(XG(K,L-1,N),XG(K,L,N)))
                  IF (AXDIF .GT. YSMALL) THEN
                     AXGM1 = XG(K,L-1,N)
                     AXG   = XG(K,L,N)
                     IF ( AXGM1 .LE. 0. ) THEN
                        AXGM1 = YSMALL * AXG
                     ELSE IF ( AXG .LE. 0. ) THEN
                        AXG   = YSMALL * AXGM1
                     END IF
                     ABSA = ABS(AXGM1)
                     ABSB = ABS(AXG-AXGM1)
                     IF ( (ABSA.GT.YEPS) .AND. (ABSB.GT.YEPS) ) THEN
                        XHAT(K,L,N)= AXG * AXGM1 * LOG( AXG / AXGM1 )
     1                            / ( AXG - AXGM1 )
                     ELSE 
                        XHAT(K,L,N) = 0.
                     END IF
                  ELSE
                     XHAT(K,L,N)=0.5*(XG(K,L,N)+XG(K,L-1,N))
                  END IF
 115           CONTINUE
            END IF
 110     CONTINUE
C
C---     initial guess for updraft and downdraft concentrations
         DO 130 N=1,NTRAC
         DO 130 K=MASG+1,ILEV
         DO 130 IL=1,LENGATH
            XU(IL,K,N)=XG(IL,K,N)
            XD(IL,K,N)=XG(IL,K,N)
 130     CONTINUE
         DO 135 N=1,NTRACA
         DO 135 K=MASG+1,ILEV
         DO 135 IL=1,LENGATH
            XUA(IL,K,N)=XGA(IL,K,N)
 135     CONTINUE
C
C---     check for cumulus transport and activation
C---     restrict chemical reactions to grid cells with
C---     activation, sufficient cloud water and cloud cover
         DO 137 K=MASG+1,ILEV
         DO 137 IL=1,LENGATH
            KCALC(IL,K) = .FALSE.
            AGAMMA(IL,K) = 0.
 137     CONTINUE
         DO 140 J=ILEV,MASG+2,-1
         DO 140 IL=1,LENGATH
            IF(EPS0(IL).GT.0. .AND. (J.GE.JT(IL)
     1         .AND. J.LT.MAXG(IL)) .AND. MUR(IL,J).GT.0.
     2         .AND. MB(IL).GT.0.) THEN
               KCALC(IL,J) = .TRUE.
               IF (      (INT(RCRIT(IDEEP(IL),J)) .GE. 1)
     1             .AND. (INT(RCRIT(IDEEP(IL),J)) .LE. ISIZE)
C     2             .AND. (ZMLWC(IDEEP(IL),J) .GT. 1.E-04)
C     3             .AND. (CLDCV(IDEEP(IL),J) .GT. 1.E-04) ) THEN
     2             .AND. (ZMLWC(IDEEP(IL),J) .GT. 1.E-09) ) THEN
                  AGAMMA(IL,J) = ZMLWC(IDEEP(IL),J)
     1                         *.5*(ROAROW(IDEEP(IL),J-1)
     2                             +ROAROW(IDEEP(IL),J)) / YRHOW
                  AGAMMA(IL,J) = MAX (AGAMMA(IL,J),0.)
               END IF
            END IF
 140     CONTINUE
C
         DO 1000 J=ILEV,MASG+2,-1
C
C-----------------------------------------------------------------------
C
C     calculate updraft concentrations XU of reactive tracers
C     total sulphate, sulphur dioxide and hydrogen peroxide
C
C-----------------------------------------------------------------------
C
C---        sulphur dioxide
            DO 1150 IL=1,LENGATH
               IF ( KCALC(IL,J) ) THEN
                  AMEAM  = .5 * ( MUR(IL,J) + MUR(IL,J+1) )
                  ADMUD  = ( MUR(IL,J) - MUR(IL,J+1) ) / DZ(IL,J)
                  ATERM1 = EUR(IL,J) * XG(IL,J,ISO2)
                  ATERM2 = DUR(IL,J) + OU(IL,J+1,ISO2)
     1                   + RU(IL,J+1,ISO2) + ADMUD
                  IF (     (ABS(ATERM2) .GT. YEPS)
     1               .AND. (ABS(AMEAM)  .GT. YEPS)            ) THEN
                     XU(IL,J,ISO2) = XU(IL,J+1,ISO2) + ( ATERM1/ATERM2
     1                 - XU(IL,J+1,ISO2) ) * ( 1. - EXP(-DZ(IL,J)
     2                 * ATERM2 / AMEAM) )
                     AGTSO2(IL,J) = XU(IL,J+1,ISO2) + ( ATERM1/ATERM2
     1                 - XU(IL,J+1,ISO2) ) * ( 1. + AMEAM
     2                / (ATERM2 * DZ(IL,J)) * ( EXP(-DZ(IL,J)
     3                 * ATERM2 / AMEAM) - 1.) )
                  END IF
                  IF (      ABS(AMEAM)  .GT. YEPS
     1                .AND. ABS(ATERM2) .LE. YEPS              ) THEN
                     XU(IL,J,ISO2) = XU(IL,J+1,ISO2)
     1                             + ATERM1 * DZ(IL,J) / AMEAM
                     AGTSO2(IL,J) = XU(IL,J+1,ISO2)
     1                            + .5 * ATERM1 * DZ(IL,J) / AMEAM
                  END IF
                  IF (        ABS(ATERM2) .GT. YEPS
     1                .AND.   ABS(AMEAM)  .LE. YEPS            ) THEN
                     XU(IL,J,ISO2) = ATERM1 / ATERM2
                     AGTSO2(IL,J)  = .5 * ( XU(IL,J+1,ISO2)
     1                                    + XU(IL,J,ISO2)   )
                  END IF
                  XU(IL,J,ISO2) = MAX (XU(IL,J,ISO2), 0.)
               END IF
 1150       CONTINUE
C
C---        total sulphate
            DO 1120 IL=1,LENGATH
               IF ( KCALC(IL,J) ) THEN
                  AMEAM  = .5 * ( MUR(IL,J) + MUR(IL,J+1) )
                  ADMUD  = ( MUR(IL,J) - MUR(IL,J+1) ) / DZ(IL,J)
                  ATERM1 = EUR(IL,J) * XGA(IL,J,ISO4)
     1                   + OU(IL,J+1,ISO2)
     2                   * AGTSO2(IL,J)
                  ATERM2 = DUR(IL,J) + RUA(IL,J+1,ISO4) + ADMUD
                  IF (     (ABS(ATERM2) .GT. YEPS)
     1               .AND. (ABS(AMEAM)  .GT. YEPS)            ) THEN
                     XUA(IL,J,ISO4) = XUA(IL,J+1,ISO4)
     1                     + ( ATERM1/ATERM2 - XUA(IL,J+1,ISO4) )
     2                     * ( 1. - EXP(-DZ(IL,J) * ATERM2/AMEAM) )
                     AGTSO4(IL,J) = XUA(IL,J+1,ISO4) + ( ATERM1/ATERM2
     1                 - XUA(IL,J+1,ISO4) ) * ( 1. + AMEAM
     2                / (ATERM2 * DZ(IL,J)) * ( EXP(-DZ(IL,J)
     3                 * ATERM2 / AMEAM) - 1.) )
                  END IF
                  IF (      ABS(AMEAM)  .GT. YEPS
     1                .AND. ABS(ATERM2) .LE. YEPS              ) THEN
                     XUA(IL,J,ISO4) = XUA(IL,J+1,ISO4)
     1                              + ATERM1 * DZ(IL,J) / AMEAM
                     AGTSO4(IL,J) = XUA(IL,J+1,ISO4)
     1                            + .5 * ATERM1 * DZ(IL,J) / AMEAM
                  END IF
                  IF (        ABS(ATERM2) .GT. YEPS
     1                .AND.   ABS(AMEAM)  .LE. YEPS            ) THEN
                     XUA(IL,J,ISO4) = ATERM1 / ATERM2
                     AGTSO4(IL,J)  = .5 * ( XUA(IL,J+1,ISO4)
     1                                    + XUA(IL,J,ISO4)   )
                  END IF
                  XUA(IL,J,ISO4) = MAX (XUA(IL,J,ISO4), 0.)
               END IF
 1120       CONTINUE
C
C---        hydrogen peroxide
            DO 1160 IL=1,LENGATH
               IF ( KCALC(IL,J) ) THEN
                  AMEAM  = .5 * ( MUR(IL,J) + MUR(IL,J+1) )
                  ADMUD  = ( MUR(IL,J) - MUR(IL,J+1) ) / DZ(IL,J)
                  ATERM1 = EUR(IL,J) * XG(IL,J,IHPO)
     1                   - OU(IL,J+1,IHPO)
     2                   * AGTSO2(IL,J)
                  ATERM2 = DUR(IL,J) + RU(IL,J+1,IHPO) + ADMUD
                  IF (     (ABS(ATERM2) .GT. YEPS)
     1               .AND. (ABS(AMEAM)  .GT. YEPS)            ) THEN
                     XU(IL,J,IHPO) = XU(IL,J+1,IHPO) + ( ATERM1/ATERM2
     1                 - XU(IL,J+1,IHPO) ) * ( 1. - EXP(-DZ(IL,J)
     2                 * ATERM2 / AMEAM) )
                     AGTHP(IL,J) = XU(IL,J+1,IHPO) + ( ATERM1/ATERM2
     1                 - XU(IL,J+1,IHPO) ) * ( 1. + AMEAM
     2                / (ATERM2 * DZ(IL,J)) * ( EXP(-DZ(IL,J)
     3                 * ATERM2 / AMEAM) - 1.) )
                  END IF
                  IF (      ABS(AMEAM)  .GT. YEPS
     1                .AND. ABS(ATERM2) .LE. YEPS              ) THEN
                     XU(IL,J,IHPO) = XU(IL,J+1,IHPO)
     1                             + ATERM1 * DZ(IL,J) / AMEAM
                     AGTHP(IL,J) = XU(IL,J+1,IHPO)
     1                            + .5 * ATERM1 * DZ(IL,J) / AMEAM
                  END IF
                  IF (        ABS(ATERM2) .GT. YEPS
     1                .AND.   ABS(AMEAM)  .LE. YEPS            ) THEN
                     XU(IL,J,IHPO) = ATERM1 / ATERM2
                     AGTHP(IL,J)  = .5 * ( XU(IL,J+1,IHPO)
     1                                   + XU(IL,J,IHPO)   )
                  END IF
                  XU(IL,J,IHPO) = MAX (XU(IL,J,IHPO), 0.)
               END IF
 1160       CONTINUE
C
C-----------------------------------------------------------------------
C
C     compute updraft concentrations for additional tracers
C
C-----------------------------------------------------------------------
C
            DO 160 N=1,NTRACA-1
            DO 160 IL=1,LENGATH
               IF(KCALC(IL,J)) THEN
                  AMEAM  = .5 * ( MUR(IL,J) + MUR(IL,J+1) )
                  ADMUD  = ( MUR(IL,J) - MUR(IL,J+1) ) / DZ(IL,J)
                  ATERM1 = EUR(IL,J) * XGA(IL,J,N)
                  ATERM2 = DUR(IL,J) + RUA(IL,J+1,N) + ADMUD
                  IF (     (ABS(ATERM2) .GT. YEPS)
     1               .AND. (ABS(AMEAM)  .GT. YEPS)            ) THEN
                     XUA(IL,J,N) = XUA(IL,J+1,N) + ( ATERM1/ATERM2
     1                 - XUA(IL,J+1,N) ) * ( 1. - EXP(-DZ(IL,J)
     2                 * ATERM2 / AMEAM) )
                  END IF
                  IF (      ABS(AMEAM)  .GT. YEPS
     1                .AND. ABS(ATERM2) .LE. YEPS              ) THEN
                     XUA(IL,J,N) = XUA(IL,J+1,N)
     1                           + ATERM1 * DZ(IL,J) / AMEAM
                  END IF
                  IF (        ABS(ATERM2) .GT. YEPS
     1                .AND.   ABS(AMEAM)  .LE. YEPS            ) THEN
                     XUA(IL,J,N) = ATERM1 / ATERM2
                  END IF
               END IF
 160        CONTINUE
C
C-----------------------------------------------------------------------
C
C        determine chemical source/sink terms OU
C
C-----------------------------------------------------------------------
C
            DO 1170 IL=1,LENGATH
               IF ( KCALC(IL,J) .AND. AGAMMA(IL,J) .GT. 0. ) THEN
C
C---              concentrations of relevant species
                  AFAKT = .5*(ROAROW(IDEEP(IL),J-1)+ROAROW(IDEEP(IL),J))
     1                  / YCOM3L
                  ACSO4 = XUA(IL,J,ISO4) * AFAKT
                  ACSO2 = XU(IL,J,ISO2) * AFAKT
                  ACHPO = XU(IL,J,IHPO) * AFAKT
                  ACNH4 = MAX(XUA(IL,J,INH3), 0.) * AFAKT
                  ACNO3 = MAX(XUA(IL,J,IHNO3), 0.)* AFAKT
                  ACCO2 = MAX(XUA(IL,J,ICO2), 0.) * AFAKT
                  ACO3  = MAX(XUA(IL,J,IO3), 0.)  * AFAKT
C
                  AMNH4 = ACNH4 / AGAMMA(IL,J)
                  AMNO3 = ACNO3 / AGAMMA(IL,J)
                  AMSO4 = ACSO4 / AGAMMA(IL,J)
                  AMSO3 = 0.
C
C---              ozone
                  ATVO3 = 1. / (1. + AGAMMA(IL,J)
     1                  *.5*(AEQCHO(IDEEP(IL),J-1)+AEQCHO(IDEEP(IL),J)))
                  ASRO3 = 1. - ATVO3
                  AMO3 = ACO3 * .5*(AEQCHO(IDEEP(IL),J-1)
     1                 + AEQCHO(IDEEP(IL),J)) * ATVO3
C
C---              for later applications...
                  AMNA  = AGTNA(IDEEP(IL),J) / AGAMMA(IL,J)
                  AMCL  = MAX(AMNA - 2.E-06,0.)
                  AGTHCL = AMCL * AGAMMA(IL,J)
C
C---              approach for pH from Tremblay with additional iteratio
                  ADELTA = AMNO3 + 2. * (AMSO4 + AMSO3) + AMCL
     1                   - AMNH4 - AMNA
                  AMH(IL,J) = 0.5*(ADELTA + SQRT (ADELTA**2
     1                      + 4.*(1.E-14 + .5*(AEQCB(IDEEP(IL),J-1)
     2                      + AEQCB(IDEEP(IL),J)) * ACSO2
     3                      + .5*(AEQCBI(IDEEP(IL),J-1)
     4                      + AEQCBI(IDEEP(IL),J)) * ACCO2)))
C
C---              restrict pH to avoid numerical problems
                  AMH(IL,J) = MAX (MIN(AMH(IL,J),1.E-01), 1.E-10)
C
C---              SO2-, NH3-, and NO3-equilibrium parameters
                  ATVAL=.5*(AEQCA(IDEEP(IL),J-1)+AEQCA(IDEEP(IL),J))
     1                 +.5*(AEQCB(IDEEP(IL),J-1)+AEQCB(IDEEP(IL),J))
     2                 / AMH(IL,J)
     3                 +.5*(AEQCC(IDEEP(IL),J-1)+AEQCC(IDEEP(IL),J))
     4                 / AMH(IL,J)**2
                  AFRAS = 1. / (1. + AGAMMA(IL,J) * ATVAL)
                  AFNH4 = (1.+ACNH4/(1./(.5*(AEQNH3(IDEEP(IL),J-1)
     1                  + AEQNH3(IDEEP(IL),J))) + AGAMMA(IL,J)
     2                  * AMH(IL,J)))**(-1)
                  AFNO3 = ACNO3 / ( 1./(.5*(AEQHNO(IDEEP(IL),J-1)
     1                  + AEQHNO(IDEEP(IL),J))) + AGAMMA(IL,J)
     2                  / AMH(IL,J) )
C
C---              subsequent iterations for pH-calculation
                  DO 1200 INDX = 1, ITERP
                     AFCL  = AGTHCL / ( 1./(.5*(AEQHCL(IDEEP(IL),J-1)
     1                     + AEQHCL(IDEEP(IL),J))) + AGAMMA(IL,J)
     2                     / AMH(IL,J) )
                     AFHSO = ACSO2 * AFRAS
     1                     *.5*(AEQCB(IDEEP(IL),J-1)+AEQCB(IDEEP(IL),J))
                     AFCO3 = ACCO2
     1                   *.5*(AEQCBI(IDEEP(IL),J-1)+AEQCBI(IDEEP(IL),J))
                     AFOH  = 1.E-14
                     AMSO3 = ( ACSO2 * AFRAS * .5
     1                     * (AEQCC(IDEEP(IL),J-1)+AEQCC(IDEEP(IL),J)) )
     2                     / AMH(IL,J)**2
                     ADELTA = AFNH4 * ( 2. * (AMSO4 + AMSO3) - AMNA )
                     AMH(IL,J) = 0.5*(ADELTA + SQRT (ADELTA**2
     1                         + 4. * AFNH4 * (AFOH + AFCO3 + AFHSO
     2                         + AFNO3 + AFCL)))
C
C---                 restrict pH to avoid numerical problems
                     AMH(IL,J) = MAX (MIN(AMH(IL,J),1.E-01), 1.E-10)
C
C---                 SO2- and H2O2-equilibrium parameters
                     ATVAL=.5*(AEQCA(IDEEP(IL),J-1)+AEQCA(IDEEP(IL),J))
     1                    +.5*(AEQCB(IDEEP(IL),J-1)+AEQCB(IDEEP(IL),J))
     2                    / AMH(IL,J)
     3                    +.5*(AEQCC(IDEEP(IL),J-1)+AEQCC(IDEEP(IL),J))
     4                    / AMH(IL,J)**2
                     AFRAS = 1. / (1. + AGAMMA(IL,J) * ATVAL)
                     AFNH4 = (1.+ACNH4/(1./(.5*(AEQNH3(IDEEP(IL),J-1)
     1                     + AEQNH3(IDEEP(IL),J))) + AGAMMA(IL,J)
     2                     * AMH(IL,J)))**(-1)
                     AFNO3 = ACNO3 / ( 1./(.5*(AEQHNO(IDEEP(IL),J-1)
     1                     + AEQHNO(IDEEP(IL),J))) + AGAMMA(IL,J)
     2                     / AMH(IL,J) )
 1200             CONTINUE
C
C---              scavenging ratios
                  ASRNH3 = AGAMMA(IL,J) * AMH(IL,J) * (1./AFNH4 - 1.)
     1                   / MAX (ACNH4,1.E-33)
                  ASRHNO = AGAMMA(IL,J) * AFNO3 / ( MAX (ACNO3,1.E-33)
     1                   * AMH(IL,J))
C
                  ASRSO2 = 1. - AFRAS
                  ATAEQ = .5*(AEQCHP(IDEEP(IL),J-1)+AEQCHP(IDEEP(IL),J))
                  AFRAH = 1. / (1. + AGAMMA(IL,J) * ATAEQ )
                  ASRHPO = 1. - AFRAH
C
C---              O3-oxidation rate parameter AFO3
                  AFO3 = (.5*(AORHP1(IDEEP(IL),J-1)+AORHP1(IDEEP(IL),J))
     1                  + .5*(AORHP2(IDEEP(IL),J-1)+AORHP2(IDEEP(IL),J))
     2                  / AMH(IL,J)) * AMO3 * AFRAS * ATVAL
C
C---              H2O2-oxidation rate parameter AFH2O2
                  AFH2O2 =(.5*(AORHO(IDEEP(IL),J-1)+AORHO(IDEEP(IL),J))
     1                   / (0.1+AMH(IL,J))) * AFRAS * AFRAH
     2                   *.5*(AEQCA(IDEEP(IL),J-1)+AEQCA(IDEEP(IL),J))
     3                   *.5*(AEQCHP(IDEEP(IL),J-1)+AEQCHP(IDEEP(IL),J))
C
C---              rate constants in 1/s
                  ATENO3 = AGAMMA(IL,J) * AFO3
                  ATENHP = AGAMMA(IL,J) * AFH2O2 * ACHPO
C
C---              chemical tendency parameters for sulphur dioxide
C---              and hydrogen peroxide in mbar/(s*m*MB)
                  AFAKT = CLDCV(IDEEP(IL),J)
     1                  * DP(IL,J)/(ZFG(IL,J)-ZFG(IL,J+1))/MB(IL)
                  print *, ATENO3,ATENHP,AFAKT,ATENHP,'for ou'
                  OU(IL,J,ISO2) = ( ATENO3 + ATENHP ) * AFAKT
                  OU(IL,J,IHPO) = ATENHP * AFAKT
C
C-----------------------------------------------------------------------
C
C        determine scavenging term RU
C
C-----------------------------------------------------------------------
C                SHOULD T(IDEEP(IL)) be USED?
C
                  FAC=MAX(T(IL,MAXG(IL))-.5*(T(IL,J-1)+T(IL,J)),0.)
     1               /MAX(T(IL,MAXG(IL))-TFREEZ, 1.)
                  C0= 2.E-03 * MIN(FAC**2, 1.) * MUR(IL,J)
                  ASRHPO = 0.
                  RU(IL,J,ISO2) = ASRSO2 * C0
                  RU(IL,J,IHPO) = ASRHPO * C0
                  RUA(IL,J,ISO4)  = ASRSO4 * C0
                  RUA(IL,J,INH3)  = ASRNH3 * C0
                  RUA(IL,J,IHNO3) = ASRHNO * C0
                  RUA(IL,J,ICO2)  = ASRCO2 * C0
                  RUA(IL,J,IO3)   = ASRO3  * C0
               END IF
 1170       CONTINUE
 1000    CONTINUE
C
C-----------------------------------------------------------------------
C
C     compute updraft concentrations XU of sulphate for each bin
C
C-----------------------------------------------------------------------
C
C---     the updraft concentrations are calculated from the
C---     precalculated source/sink terms of total sulphate
C---     to avoid numerical instabilities
         DO 156 N=1,ISIZE
            NF=NFMIN+N-1
            DO 158 J=ILEV,MASG+2,-1
            DO 158 IL=1,LENGATH
               IF ( KCALC(IL,J) ) THEN
                  AMEAM  = .5 * ( MUR(IL,J) + MUR(IL,J+1) )
                  ADMUD  = ( MUR(IL,J) - MUR(IL,J+1) ) / DZ(IL,J)
                  ATERM1 = EUR(IL,J) * XG(IL,J,NF) + OU(IL,J+1,ISO2)
     1                   * AGTSO2(IL,J) * AFRAC(IDEEP(IL),J,N)
                  IF (N .EQ. INT(RCRIT(IDEEP(IL),J)))  THEN
                     ATERM2 = DUR(IL,J) + ADMUD
                  END IF
                  IF (N .GT. INT(RCRIT(IDEEP(IL),J))) THEN
                     ATERM2 = DUR(IL,J) + RUA(IL,J+1,ISO4) + ADMUD
                  ELSE
                     ATERM2 = DUR(IL,J) + ADMUD
                  END IF
                  IF (     (ABS(ATERM2) .GT. YEPS)
     1               .AND. (ABS(AMEAM)  .GT. YEPS)            ) THEN
                     XU(IL,J,NF) = XU(IL,J+1,NF) + ( ATERM1/ATERM2
     1                    - XU(IL,J+1,NF) ) * ( 1. - EXP(-DZ(IL,J)
     2                    * ATERM2 / AMEAM) )
                  END IF
                  IF (      ABS(AMEAM)  .GT. YEPS
     1                .AND. ABS(ATERM2) .LE. YEPS              ) THEN
                     XU(IL,J,NF) = XU(IL,J+1,NF)
     1                           + ATERM1 * DZ(IL,J) / AMEAM
                  END IF
                  IF (        ABS(ATERM2) .GT. YEPS
     1                .AND.   ABS(AMEAM)  .LE. YEPS            ) THEN
                     XU(IL,J,NF) = ATERM1 / ATERM2
                  END IF
               END IF
 158        CONTINUE
 156     CONTINUE
C
C-----------------------------------------------------------------------
C
C     compute downdraft concentrations XD of all prognostic tracers
C
C-----------------------------------------------------------------------
         DO 220 N=1,NTRAC
         IF ( (N .EQ. ISO2) .OR. (N .EQ. IHPO)
     1       .OR. ((N .GE. NFMIN) .AND. (N .LE. NFMAX)) ) THEN
            DO 222 IL=1,LENGATH
               XD(IL,JD(IL),N)=XG(IL,JD(IL)-1,N)
  222       CONTINUE
            DO 225 J=MASG+2,ILEV
            DO 225 IL=1,LENGATH
               IF((J.GT.JD(IL) .AND. J.LE.MAXG(IL))
     1           .AND. EPS0(IL).GT.0. .AND. JD(IL).LT.MAXG(IL)) THEN
                 AMEAM  = .5 * ( MDR(IL,J-1) + MDR(IL,J) )
                 ADMUD  = ( MDR(IL,J-1) - MDR(IL,J) ) / DZ(IL,J-1)
                 ATERM1 = EDR(IL,J-1) * XG(IL,J-1,N)
                 ATERM2 = ADMUD
                 IF (     (ABS(ATERM2) .GT. YEPS)
     1              .AND. (ABS(AMEAM)  .GT. YEPS)            ) THEN
                    XD(IL,J,N) = XD(IL,J-1,N) - ( XD(IL,J-1,N)
     1                   - ATERM1/ATERM2 ) * ( 1. - EXP( DZ(IL,J-1)
     2                   * ATERM2/AMEAM) )
                 END IF
                 IF (      ABS(AMEAM)  .GT. YEPS
     1                .AND. ABS(ATERM2) .LE. YEPS              ) THEN
                    XD(IL,J,N) = XD(IL,J-1,N)
     1                      - ATERM1 * DZ(IL,J-1) / AMEAM
                 END IF
                 IF (        ABS(ATERM2) .GT. YEPS
     1                .AND.   ABS(AMEAM)  .LE. YEPS            ) THEN
                    XD(IL,J,N) = ATERM1 / ATERM2
                 END IF
                 XD(IL,J,N) = MAX(XD(IL,J,N), 0.)
               ENDIF
 225        CONTINUE
            END IF
 220     CONTINUE
C
C-----------------------------------------------------------------------
C
C     compute tracer tendecies
C
C-----------------------------------------------------------------------
C
C---  prepare arrays for the implicit time stepping/solver
C---  initialize the tendecy to zero on ALL levels
      CALL PUTZERO  (DXDT  , ILG*ILEV*NTRAC)
C
C---  calculate factor FACX for semi-implicit solver
         DO 260 N=1,NTRAC
            IF (     (N .EQ. ISO2) .OR. (N .EQ. IHPO)
     1         .OR. ((N .GE. NFMIN) .AND. (N .LE. NFMAX)) ) THEN
               DO 265 K=MASG+1,ILEV
               DO 265 IL=1,LENGATH
                  IF (K.GE.JT(IL) .AND. K.LT.ILEV) THEN
                     AXDIF = 0.
                     IF(XG(IL,K,N) .GT. 0. .AND. XG(IL,K+1,N) .GT. 0.)
     1                  AXDIF = ABS((XG(IL,K,N)-XG(IL,K+1,N))
     2                         / MAX(XG(IL,K,N),XG(IL,K+1,N)))
                     IF (AXDIF .GT. YSMALL) THEN
                        AXG   = XG(IL,K,N)
                        AXGP1 = XG(IL,K+1,N)
                        IF ( AXG .LE. 0. ) THEN
                           AXG   = YSMALL * AXGP1
                        END IF
                        IF ( AXGP1 .LE. 0. .AND. AXG .GT. 0.) THEN
                           AXGP1 = YSMALL * AXG
                        END IF
                        DXDX(IL,K,N) = AXGP1 / (AXG-AXGP1)
     1                                -LOG( AXG / AXGP1 )
     2                       * ( AXGP1 / (AXG-AXGP1) )**2
                     ELSE
                        DXDX(IL,K,N)=0.5
                     ENDIF
                     FACX(IL,K,N)=1./( 1. + MC(IL,K+1)
     1                           *2.*DELT/DP(IL,K)*RNU*DXDX(IL,K,N) )
                  ENDIF
 265           CONTINUE
            END IF
 260     CONTINUE
C
C---  compute tendency for the tracers (DXDT)
C---  do this for top of the updraft; MB is the mass flux at cloud base
         DO 280 N=1,NTRAC
         IF ( (N .EQ. ISO2) .OR. (N .EQ. IHPO)
     1       .OR. ((N .GE. NFMIN) .AND. (N .LE. NFMAX)) ) THEN
            DO 285 J=MASG+1,ILEV-1
            DO 285 IL=1,LENGATH
               IF(J.EQ.JT(IL) .AND. MB(IL).GT.0.)       THEN
                  DXDT(IL,J,N)=FACX(IL,J,N)/DP(IL,J)
     1            * (MU(IL,J+1)*( XU(IL,J+1,N)-XHAT(IL,J+1,N) ) +
     3               MD(IL,J+1)*( XD(IL,J+1,N)-XHAT(IL,J+1,N) ))
               ENDIF
  285       CONTINUE
            END IF
  280    CONTINUE
C
C---  continue to compute the tendencies for the other layers
C---  between JT and MAXG (the launching level of the cloud base)
         DO 300 N=1,NTRAC
         IF ( (N .EQ. ISO2) .OR. (N .EQ. IHPO)
     1       .OR. ((N .GE. NFMIN) .AND. (N .LE. NFMAX)) ) THEN
            DO 305 J=MASG+1,ILEV
            DO 305 IL=1,LENGATH
               IF(J.GT.JT(IL) .AND. J.LT.MAXG(IL)
     1           .AND. MB(IL).GT.0.) THEN
                  XHAT(IL,J,N)=XHAT(IL,J,N)
     1              +DXDT(IL,J-1,N)*2.*DELT*RNU*DXDX(IL,J-1,N)
                  DXDT(IL,J,N)=FACX(IL,J,N)
     1           *((MC(IL,J)*(XHAT(IL,J,N)-XG(IL,J,N))
     2           +MC(IL,J+1)*(XG(IL,J,N)-XHAT(IL,J+1,N)))/DP(IL,J)
     3           +DU(IL,J)*(0.5*(XU(IL,J,N)+XU(IL,J+1,N))-XG(IL,J,N)) )
               ENDIF
  305       CONTINUE
            END IF
  300    CONTINUE
C
C---  now compute the detrainment at cloud base
         DO 320 N=1,NTRAC
            IF ( (N .EQ. ISO2) .OR. (N .EQ. IHPO)
     1         .OR. ((N .GE. NFMIN) .AND. (N .LE. NFMAX)) ) THEN
            DO 325 J=MASG+1,ILEV
            DO 325 IL=1,LENGATH
               IF(J.EQ.MAXG(IL) .AND. MB(IL).GT.0.)           THEN
                  XHAT(IL,J,N)=XHAT(IL,J,N)
     1               +DXDT(IL,J-1,N)*2.*DELT*RNU*DXDX(IL,J-1,N)
                  DXDT(IL,J,N)=(1./DSUBCLD(IL))
     1               *( MU(IL,J)*( XHAT(IL,J,N)-XU(IL,J,N))
     2                 +MD(IL,J)*( XHAT(IL,J,N)-XD(IL,J,N)) )
               ENDIF
 325        CONTINUE
            END IF
 320     CONTINUE
C
C-----------------------------------------------------------------------
C
C     calculate resulting large scale tendencies
C
C-----------------------------------------------------------------------
C
C---     hydrogen peroxide
         DO 345 L=MASG+1,ILEV
            DO K=1,LENGATH
               TMP2(K)=RTHPO(IDEEP(K),L)
     1                      +DXDT(K,L,IHPO)*AMASPE(3)
            END DO
            DO 345 K=1,LENGATH
C
C---           hydrogen peroxide tendency
               RTHPO(IDEEP(K),L) = TMP2(K)
 345     CONTINUE
C
C-----------------------------------------------------------------------
C
C     calculate in-cloud oxidation (OU) and washout rates (RU)
C     for diagnostics purposes
C
C-----------------------------------------------------------------------
C
C---  safe old tendencies for in-cloud production (in mol/m^3/s) 
C---  at lower thermodynamic layers
C
      DO 350 J=MASG+2,ILEV
      DO 350 IL=1,LENGATH
         IF (J .LT. ILEV) THEN
            AFAKT = MB(IL)*ROAROW(IDEEP(IL),J)/DP(IL,J)
     1                                      *(ZFG(IL,J)-ZFG(IL,J+1))
!        print *, MB(IL),ROAROW(IDEEP(IL),J),DP(IL,J),ZFG(IL,J),
!     +           ZFG(IL,J+1),AFAKT
!       print *, OU(IL,J+1,ISO2),AGTSO2(IL,J),OU(IL,J+1,IHPO),
!     +          AGTHP (IL,J),AFAKT
            OU(IL,J,ISO2) = - AFAKT * OU(IL,J+1,ISO2) * AGTSO2(IL,J) 
            OU(IL,J,IHPO) = - AFAKT * OU(IL,J+1,IHPO) * AGTHP (IL,J)
            RU(IL,J,ISO2) = - AFAKT * RU(IL,J+1,ISO2) * AGTSO2(IL,J) 
            RU(IL,J,IHPO) = - AFAKT * RU(IL,J+1,IHPO) * AGTHP (IL,J)
         ELSE
            OU(IL,J,ISO2) = 0.
            OU(IL,J,IHPO) = 0.
            RU(IL,J,ISO2) = 0.
            RU(IL,J,IHPO) = 0.
         END IF
 350  CONTINUE
C
C---  safe old tendencies for in-cloud washout (in mol/m^3/s) 
C---  at lower thermodynamic layers
C
      DO 365 N=1,ISIZE
         NF=NFMIN+N-1
         DO 360 J=MASG+2,ILEV
         DO 360 IL=1,LENGATH
            IF (J .LT. ILEV) THEN
               AFAKT = MB(IL)*ROAROW(IDEEP(IL),J)/DP(IL,J)
     1                            *(ZFG(IL,J)-ZFG(IL,J+1))
               RU(IL,J,NF) = - AFAKT * RUA(IL,J+1,ISO4)
     1                * AGTSO4(IL,J) * AFRAC(IDEEP(IL),J,N)
            ELSE
               RU(IL,J,NF) = 0.
            END IF
 360     CONTINUE
 365  CONTINUE
C
C---  correct diagnostics parameters
C
      CALL PUTZERO(TMP1, ILG)
      CALL PUTZERO(TMP2, ILG)
      CALL PUTZERO(TMP3, ILG)
      DO 385 J=MASG+1,ILEV
         DO 380 IL=1,LENGATH
!            print *, DZT(IDEEP(IL),J),DXDT(IL,J,ISO2),
!     +              RU(IL,J,ISO2),OU(IL,J,ISO2)
            TMP1(IL) = TMP1(IL)+DZT(IDEEP(IL),J)*DXDT(IL,J,ISO2)
     1                      *ROAROW(IDEEP(IL),J)
            TMP2(IL) = TMP2(IL)+DZT(IDEEP(IL),J)*RU(IL,J,ISO2)
            TMP3(IL) = TMP3(IL)+DZT(IDEEP(IL),J)*OU(IL,J,ISO2)
 380     CONTINUE
 385  CONTINUE
      DO IL=1,LENGATH
!         print *, TMP1(IL),TMP2(IL),TMP3(IL),YEPS,'for ou 2'
         SUMDX(IL) = TMP1(IL) / MIN(TMP2(IL)+TMP3(IL),-YEPS) 
      END DO
      DO 390 J=MASG+2,ILEV-1
      DO 390 IL=1,LENGATH
!          print *, OU(IL,J,ISO2),OU(IL,J,IHPO),SUMDX(IL),
!     +      'for ou 3'
         RU(IL,J,ISO2) = RU(IL,J,ISO2) * SUMDX(IL)
         OU(IL,J,ISO2) = OU(IL,J,ISO2) * SUMDX(IL)
         OU(IL,J,IHPO) = OU(IL,J,IHPO) * SUMDX(IL)
 390  CONTINUE

      CALL PUTZERO(TMP1, ILG)
      CALL PUTZERO(TMP2, ILG)
      CALL PUTZERO(TMP3, ILG)
      DO 400 J=MASG+1,ILEV
        DO 400 IL=1,LENGATH
!         print *, TMP1(IL),DZT(IDEEP(IL),J),DXDT(IL,J,IHPO),
!     +       'for ou 4'
            TMP1(IL) = TMP1(IL)+DZT(IDEEP(IL),J)*DXDT(IL,J,IHPO)
     1             *ROAROW(IDEEP(IL),J)
            TMP2(IL) = TMP2(IL)+DZT(IDEEP(IL),J)*RU(IL,J,IHPO)
            TMP3(IL) = TMP3(IL)+DZT(IDEEP(IL),J)*OU(IL,J,IHPO)
  400 CONTINUE

      DO 405 IL=1,LENGATH
          SUMDX(IL) = (TMP1(IL)-TMP3(IL)) / MIN(TMP2(IL),-YEPS) 
  405 CONTINUE
      DO 410 J=MASG+2,ILEV-1
      DO 410 IL=1,LENGATH
         RU(IL,J,IHPO) = RU(IL,J,IHPO) * SUMDX(IL)
 410  CONTINUE
      DO 450 N=1,ISIZE
         NF=NFMIN+N-1
         DO 455 J=MASG+2,ILEV-1
         DO 455 IL=1,LENGATH
            OU(IL,J,NF) = -OU(IL,J,ISO2) * AFRAC(IDEEP(IL),J,N)
  455    CONTINUE
  450 CONTINUE
      
      CALL PUTZERO(TMP1, ILG)
      CALL PUTZERO(TMP2, ILG)
      CALL PUTZERO(TMP3, ILG)
      DO 465 N=1,ISIZE
         NF=NFMIN+N-1
         DO 460 J=MASG+1,ILEV
            DO 460 IL=1,LENGATH
               TMP1(IL) = TMP1(IL)+DZT(IDEEP(IL),J)*DXDT(IL,J,NF)
     1                     *ROAROW(IDEEP(IL),J)
               TMP2(IL) = TMP2(IL)+DZT(IDEEP(IL),J)*RU(IL,J,NF)
               TMP3(IL) = TMP3(IL)+DZT(IDEEP(IL),J)*OU(IL,J,NF)
  460    CONTINUE
  465 CONTINUE
      DO IL=1,LENGATH
         SUMDX(IL) = (TMP1(IL)-TMP3(IL))/MIN(TMP2(IL),-YEPS) 
      END DO
      DO N=1,ISIZE
         NF=NFMIN+N-1
         DO J=MASG+2,ILEV-1
            DO IL=1,LENGATH
               RU(IL,J,NF) = RU(IL,J,NF) * SUMDX(IL)
            END DO
         END DO
      END DO
C
C---  calculate final production and loss rates (in kg/kg/s)
      DO 500 J=MASG+1,ILEV
         DO IL=IL1,IL2
            TMP1(IL)=0.0
            TMP2(IL)=0.0
            TMP3(IL)=0.0
         END DO
         DO 510 IL=1,LENGATH
            TMP1(IDEEP(IL)) = RU(IL,J,ISO2) * AMASPE(2) 
     1                      / ROAROW(IDEEP(IL),J)
            TMP2(IDEEP(IL)) = OU(IL,J,ISO2) * AMASPE(2)
     1                      / ROAROW(IDEEP(IL),J)
 510     CONTINUE
         DO 515 IL=IL1,IL2
            RU(IL,J,ISO2) = TMP1(IL)
            OU(IL,J,ISO2) = TMP2(IL)
 515     CONTINUE
         DO 517 IL=1,LENGATH
            TMP3(IDEEP(IL)) = DXDT(IL,J,ISO2) * AMASPE(2) 
     1                      - TMP1(IDEEP(IL)) - TMP2(IDEEP(IL))
 517     CONTINUE
         DO 518 IL=IL1,IL2
            DXDT(IL,J,ISO2) = TMP3(IL)
 518     CONTINUE
C
C     UPDATE THE SO2 TENDENCY
C
          DO 519 IL=IL1,IL2
C
C---           sulphur dioxide removal rate
              RTSO2(IL,J)=OU(IL,J,ISO2)+DXDT(IL,J,ISO2)
       if(RTSO2(IL,J).LE.0.) then
       else
!       print *, RTSO2(IL,J),OU(IL,J,ISO2),DXDT(IL,J,ISO2)
!     +      , IL, J, 'ISO2'
       endif
              RTBCLD(IL,J,ISO2)=RTBCLD(IL,J,ISO2)+
     1                                AMIN1(0.0,RU(IL,J,ISO2))
 519      CONTINUE
 500  CONTINUE
      DO 520 J=1+MASG,ILEV
         DO 525 IL=IL1,IL2
            TMP1(IL) = 0.
            TMP2(IL) = 0.
            TMP3(IL) = 0.
 525     CONTINUE
         DO 530 IL=1,LENGATH
            TMP1(IDEEP(IL)) = RU(IL,J,IHPO) * AMASPE(3)
     1                      / ROAROW(IDEEP(IL),J)
            TMP2(IDEEP(IL)) = OU(IL,J,IHPO) * AMASPE(3)
     1                      / ROAROW(IDEEP(IL),J)
 530     CONTINUE
         DO 535 IL=IL1,IL2
            RU(IL,J,IHPO) = TMP1(IL)
            OU(IL,J,IHPO) = TMP2(IL)
 535     CONTINUE
         DO 537 IL=1,LENGATH
            TMP3(IDEEP(IL)) = DXDT(IL,J,IHPO) * AMASPE(3) 
     1                      - TMP1(IDEEP(IL)) - TMP2(IDEEP(IL))
 537     CONTINUE
         DO 538 IL=IL1,IL2
            DXDT(IL,J,IHPO) = TMP3(IL)
 538     CONTINUE
 520  CONTINUE
      DO 540 N=1,ISIZE
         NF=NFMIN+N-1
         DO 550 J=1+MASG,ILEV
            DO 555 IL=IL1,IL2
               TMP1(IL) = 0.
               TMP2(IL) = 0.
               TMP3(IL) = 0.
 555        CONTINUE
            DO 560 IL=1,LENGATH
               TMP1(IDEEP(IL)) = RU(IL,J,NF) * AMASPE(1) 
     1                         / ROAROW(IDEEP(IL),J)
               TMP2(IDEEP(IL)) = OU(IL,J,NF) * AMASPE(1)
     1                         / ROAROW(IDEEP(IL),J)
 560        CONTINUE
            DO 565 IL=IL1,IL2
               RU(IL,J,NF) = TMP1(IL)
               OU(IL,J,NF) = TMP2(IL)
 565        CONTINUE
            DO 567 IL=1,LENGATH
               TMP3(IDEEP(IL)) = DXDT(IL,J,NF) * AMASPE(1) 
     1                         - TMP1(IDEEP(IL)) - TMP2(IDEEP(IL))
 567        CONTINUE
            DO 568 IL=IL1,IL2
               DXDT(IL,J,NF) = TMP3(IL)
 568        CONTINUE
 550     CONTINUE
 540  CONTINUE
C
C      UNDATE THE SULPHATE TENDENCY
C
      DO N=1,ISIZE
         NF=NFMIN+N-1
         DO L=MASG+1,ILEV
           DO IL=IL1,IL2
               RTSO4(IL,L,N)=OU(IL,L,NF)+DXDT(IL,L,NF)
          if(RTSO4(IL,L,N).GE.0.) then
          else
!          print *, RTSO4(IL,L,N),OU(IL,L,NF),DXDT(IL,L,NF),
!     +             IL, L, N,'SO4'
          endif
               RTBCLD(IL,L,NF)=RTBCLD(IL,L,NF)+
     1                                AMIN1(0.0,RU(IL,L,NF))
           END DO
         END DO
      END DO
C
C       DIAGNOSTIC WRITEOUTS
C
      IF (IDEBUG .GT. 1) THEN
         TTSO4=0.0
         TTRU=0.0
         TTSO2=0.0
         TTOV=0.0
         SORU=0.0
         DDDT=0.0
         DDDV=0.0
         TTOU=0.0
         DO N=1,ISIZE
         NF=NFMIN+N-1
            DO L=1+MASG,ILEV
              GO=DZT(ID,L)*ROAROW(ID,L)
              TTSO4=TTSO4+RTSO4(ID,L,N)*GO
              TTRU=TTRU+RU(ID,L,NF)*GO
              DDDV=DDDV+DXDT(ID,L,NF)*GO
              TTOV=TTOV+OU(ID,L,NF)*GO
             IF(N.EQ.1) THEN
                TTSO2 = TTSO2 + RTSO2(ID,L)*GO
                TTOU = TTOU + OU(ID,L,ISO2)*GO
                SORU = SORU + RU(ID,L,ISO2)*GO
                DDDT = DDDT+DXDT(ID,L,ISO2)*GO
             END IF
            END DO
         END DO
         SO22=TTOU+SORU
         SO44=TTRU-AMASPE(1)/AMASPE(2)*TTOU
                 WRITE (*,*) ' SO2 SO4 ++ ', TTSO2,TTSO4
                 WRITE (*,*) ' SO2 SO4    ', SO22,SO44
                 WRITE (*,*) ' DXDT       ', DDDT, DDDV
      END IF
      RETURN
      END
