        MODULE module_model_constants
        IMPLICIT NONE
        
        real                        :: dc0
        real                        :: dc025
        real                        :: dc05
        real                        :: dc1 
        real                        :: dc15
        real                        :: dc2
        real                        :: dc4
        
        real                        :: cp
        real                        :: grav
        real                        :: r_d
        real                        :: gamma
        real                        :: arc
        real                        :: re
        real                        :: owgma
        REAL                        :: ep
        REAL                        :: eq
        REAL                        :: alfa_e
        
        CONTAINS
        
        SUBROUTINE init_module_model_constants()
        
        dc0     =0.0d0
        dc025   =0.25d0
        dc05    =0.5d0
        dc1     =1.0d0
        dc15    =1.5d0
        dc2     =2.0d0
        dc4     =4.0d0
        
        cp      =1004.5d0
        grav    =9.81d0
        r_d     =287.d0
        gamma   =cp/r_d
        arc     =3.14159265d0/180.d0
        re      =6371000.d0
        owgma   =7.293d-5
        ep      =1.d-14
        eq      =0.608d0
        alfa_e  =0.7d0
        
        END SUBROUTINE init_module_model_constants
        
        END MODULE module_model_constants
