      SUBROUTINE INTRSEC_b (lev, ilev, ilg, il1, il2, xrow, Adj_xrow,
     +        rgrid, Adj_rgrid, ntr, ntp, iae1, aerosize, rth, Adj_rth
     +            , nn, adt2, Adj_adt2, rhop0, Adj_rhop0, xiao, isize
     +            , rtcond, Adj_rtcond, aeronum, Adj_aeronum, roarow
     +            , v, Adj_v, mae)
C------------------------------------------------------------------------
C     PURPOSE
C     -------
C     - THIS MODULE COMPUTES INTERSECTIONAL TRANSPORT OF AEROSOLS DUE TO
C       CONDENSATION OR CLOUD PROCESSES
C                                                                                   
C     HISTORY:
C     --------
C     *
C     * AUG 11/97 - S.L. GONG   FIRST VERSION
C    
C    INPUT:  
C    ------
C
C    RTCOND - MASS TRANSFER RATE ONTO EACH PARTICLE SIZE BIN
C      XROW - TRACER CONCENTRATION IN EACH BIN BEFORE INTERSECTION TRANPORT
C    TOTMAS - TOTAL MASS OF AEROSOL IN EACH BIN
C     RGRID - INITIAL CONCENTRATION OF TRACERS IN EACH BIN
C
C    OUTPUT:
C    -------
C    
C      XROW - TRACER CONCENTRATION IN EACH BIN AFTER INTERSECTION TRANPORT 
C
C------------------------------------------------------------------------

C PART I: VARIABLES DECLARATION
      implicit none
      real hv,hs,tfrez,daylnt,pi,boltzk,airmw,rvord,pai
      real a,vokm1,vokp1,vok,voij,rcond,rgasi
      integer np,k,ik,nk,no,nt,n,il,l,i,nn,iae1,ntp,isize
      real xiao,adt2,Adj_adt2,cpres,rgoasq,rgocp,avo,cpresv,rgasv
      integer ilg,ilev,lev,ntr,il1,il2,mae
      real rayon,tw,ww,rgas,g,asq
      real A0,RSN0,RCUT0,RCG0,P
      COMMON /PARAMS/ WW,TW,RAYON,ASQ,G,RGAS,RGOCP,RGOASQ,CPRES
     +       ,RGASV,CPRESV
      COMMON /NARCM/  AVO, RGASi, AIRMW, BOLTZK,  PI,  A
     +          ,A0,RSN0,RCUT0,RCG0,P
      COMMON /PARAM1/ PAI, RVORD, TFREZ,     HS,  HV, DAYLNT

      REAL AERONUM (ILG, ILEV,ISIZE), Adj_AERONUM (ILG, ILEV,ISIZE),
     +          ROAROW(ILG,ILEV)
      REAL RTCOND(ILG, ILEV,ISIZE), Adj_RTCOND(ILG, ILEV,ISIZE)
      REAL XROW (ILG, LEV, NTR), Adj_XROW (ILG, LEV, NTR),
     +      RGRID(ILG, ILEV, NTR), 
     +     Adj_RGRID(ILG, ILEV, NTR)
      REAL AEROSIZE(2,ISIZE), V(ISIZE), Adj_V(ISIZE)
      REAL RTH(ILG,ILEV,ISIZE), Adj_RTH(ILG,ILEV,ISIZE), RHOP0(NTP),
     +      Adj_RHOP0(NTP)

      REAL,EXTERNAL:: CVMGT
      REAL Keep_RTH(ILG,ILEV,ISIZE,ISIZE)
      REAL Keep_XRG(ILG, ILEV, NTP,ISIZE,ISIZE)
      LOGICAL Keep(ILG, ILEV, ISIZE,ISIZE)
      LOGICAL Keep_VOKP1(ILG, ILEV, ISIZE,ISIZE)

      REAL Adj_RCOND
      REAL Adj_VOIJ
      REAL Adj_VOK
      REAL Adj_VOKP1
      REAL Adj_VOKM1
      EXTERNAL putzero

C PART II: CALCULATION OF BASIC STATE

C LPB[0]
      DO K=1,ISIZE
        DO NP=1,NTP
           IK=(NP-1)*ISIZE+K+(IAE1-1)
           DO L=1+MAE,ILEV
              DO IL=IL1,IL2
                 RGRID(IL,L,IK)=XROW(IL,L+1,IK)
              END DO
           END DO
        END DO
      END DO

C
C     CONDENSATION RATE
C
C LPB[1]
      DO N=1,ISIZE
        CALL PUTZERO(RTH, ILG*ILEV*ISIZE)
        DO K=N,ISIZE
          DO L=1+MAE,ILEV
            DO I=IL1,IL2
              IF(AERONUM(I,L,N)*ROAROW(I,L) .GT. XIAO .AND.
     1                                 RTCOND(I,L,N) .GT. 0.0 ) THEN
                 RCOND=RTCOND(I,L,N)
C
C     NEW DRY VOLUME OF SIZE BIN N
C
                 VOIJ=V(N)+RCOND*ADT2/(AERONUM(I,L,N)*RHOP0(NN))
                 VOK=V(K)
                 IF (K .EQ. ISIZE .AND. VOIJ .GE. VOK) THEN
                    RTH(I,L,K)=1.0
                 END IF
                 IF (K .LT. ISIZE) THEN
                    VOKP1=V(K+1)
                    Keep_VOKP1(I,L,K,N)=VOIJ.GE.VOK.AND.VOIJ.LT.VOKP1
                    RTH(I,L,K)=CVMGT(VOK/VOIJ*(VOKP1-VOIJ)/(VOKP1-VOK),
     1                RTH(I,L,K), Keep_VOKP1(I,L,K,N))
                 END IF
                 IF (K .GT. 1 ) THEN
                    VOKM1=V(K-1)
                    Keep(I,L,K,N)=VOIJ .GT. VOKM1 .AND. VOIJ .LT. VOK
                    RTH(I,L,K)=CVMGT(1.-RTH(I,L,K-1), RTH(I,L,K),
     +                          Keep(I,L,K,N))
                 END IF
               END IF
            END DO
          END DO

          DO L=1+MAE,ILEV
          DO I=IL1,IL2
            Keep_RTH(I,L,K,N) =RTH(I,L,K)
          END DO
          END DO

          DO NT=1,NTP
            NO= N+ISIZE*(NT-1)+(IAE1-1)
            NK= K+ISIZE*(NT-1)+(IAE1-1)
            DO L=1+MAE,ILEV
              DO I=IL1,IL2
                IF (RTH(I,L,K) .GT. 0.0) THEN
C
C     ZERO BIN N FOR RE-DISTRIBUTION
C
                  IF (N.EQ.K) then
                Keep_XRG(I,L,Nt,K,N) =XROW(I,L+1,NO)-RGRID(I,L,NO)
                    XROW(I,L+1,NO)=AMAX1(0.0,
     1                                     XROW(I,L+1,NO)-RGRID(I,L,NO))
                  end if
C
C     DISTRIBUTED INTO BIN K ....
C
                  XROW(I,L+1,NK)=XROW(I,L+1,NK)+RGRID(I,L,NO)*RTH(I,L,K)
                  IF(NT .EQ. NN) XROW(I,L+1,NK)=XROW(I,L+1,NK)+
     1                                     RTH(I,L,K)*RTCOND(I,L,N)*ADT2
                END IF
              END DO
            END DO
          END DO
        END DO
      END DO


C PART III: INITIALIZATION OF LOCAL ADJOINT VARIABLES


      Adj_RCOND =0.0
      Adj_VOIJ =0.0
      Adj_VOK =0.0
      Adj_VOKP1 =0.0
      Adj_VOKM1 =0.0

C PART IV: ADJOINT ACCUMULATIONS

C LPB[1]

      DO N=ISIZE,1,-1
      DO K=ISIZE,N,-1

      DO NT=NTP,1,-1
         NO= N+ISIZE*(NT-1)+(IAE1-1)
         NK= K+ISIZE*(NT-1)+(IAE1-1)

      DO L=ILEV,1+MAE,-1
      DO I=IL2,IL1,-1

      IF (Keep_RTH(I,L,K,N) .GT. 0.0) THEN

      IF(NT .EQ. NN) THEN
        Adj_RTH(I,L,K) =Adj_RTH(I,L,K)+RTCOND(I,L,N)*ADT2*
     +                                     Adj_XROW(I,L+1,NK)
        Adj_RTCOND(I,L,N)=Adj_RTCOND(I,L,N)+Keep_RTH(I,L,K,N)
     +                     *ADT2*Adj_XROW(I,L+1,NK)
        Adj_ADT2 =Adj_ADT2+Keep_RTH(I,L,K,N)*RTCOND(I,L,N)
     +            *Adj_XROW(I,L+1,NK)
      END IF

      Adj_RGRID(I,L,NO) =Adj_RGRID(I,L,NO) +Keep_RTH(I,L,K,N)
     +       *Adj_XROW(I,L+1,NK)
      Adj_RTH(I,L,K) =Adj_RTH(I,L,K) 
     +       +RGRID(I,L,NO)*Adj_XROW(I,L+1,NK)

      IF (N.EQ.K) THEN
        IF (Keep_XRG(I,L,Nt,K,N).GT.0.0) THEN
        Adj_RGRID(I,L,NO) =Adj_RGRID(I,L,NO)-Adj_XROW(I,L+1,NO)
        ELSE
        Adj_XROW(I,L+1,NO) =0.0
        END IF
      END IF

      END IF
      END DO
      END DO

      END DO


      DO L=ILEV,1+MAE,-1
      DO I=IL2,IL1,-1

      IF(AERONUM(I,L,N)*ROAROW(I,L) .GT. XIAO .AND.
     +RTCOND(I,L,N) .GT. 0.0 ) THEN

      RCOND=RTCOND(I,L,N)
      VOK=V(K)
      VOIJ=V(N)+RCOND*ADT2/(AERONUM(I,L,N)*RHOP0(NN))

      IF (K .GT. 1 ) THEN
         IF (Keep(I,L,K,N)) THEN
         Adj_RTH(I,L,K-1) =Adj_RTH(I,L,K-1)-Adj_RTH(I,L,K)
         Adj_RTH(I,L,K) =0.0
         END IF
      END IF

      IF (K .LT. ISIZE) THEN
         VOKP1=V(K+1)

C        RTH(I,L,K)=VOK/VOIJ*(VOKP1-VOIJ)/(VOKP1-VOK)

         IF (Keep_VOKP1(I,L,K,N)) THEN
         Adj_VOK =Adj_VOK +((VOKP1-VOIJ)/(VOKP1-VOK)/VOIJ+VOK
     +   /VOIJ*(VOKP1-VOIJ)/
     +   ((VOKP1-VOK)*(VOKP1-VOK)))*Adj_RTH(I,L,K)
         Adj_VOIJ =Adj_VOIJ +(-VOK/VOIJ/VOIJ*(VOKP1-VOIJ)/(VOKP1-VOK)
     +   -VOK/VOIJ/(VOKP1-VOK))*Adj_RTH(I,L,K)
         Adj_VOKP1 =Adj_VOKP1 +VOK/VOIJ*(1.0/(VOKP1-VOK)
     +   -(VOKP1-VOIJ)/(VOKP1-VOK)/(VOKP1-VOK))*Adj_RTH(I,L,K)
         Adj_RTH(I,L,K) =0.0
         END IF


         Adj_V(K+1) =Adj_V(K+1)+Adj_VOKP1
         Adj_VOKP1 =0.0
      END IF

      IF (K .EQ. ISIZE .AND. VOIJ .GE. VOK) THEN
        Adj_RTH(I,L,K)=0.0
      END IF

      Adj_V(K) =Adj_V(K) +Adj_VOK
      Adj_VOK =0.0

      Adj_V(N) =Adj_V(N) +Adj_VOIJ
      Adj_RCOND =Adj_RCOND +ADT2/(AERONUM(I,L,N)*RHOP0(NN))*Adj_VOIJ
      Adj_ADT2 =Adj_ADT2 +RCOND/(AERONUM(I,L,N)*RHOP0(NN))*Adj_VOIJ
      Adj_AERONUM(I,L,N) =Adj_AERONUM(I,L,N) -RCOND*ADT2/AERONUM(I,L,N)
     +                   /(AERONUM(I,L,N)*RHOP0(NN))*Adj_VOIJ
      Adj_RHOP0(NN) =Adj_RHOP0(NN) -RCOND*ADT2/RHOP0(NN)/(AERONUM(I,L,N)
     $                   *RHOP0(NN))*Adj_VOIJ
      Adj_VOIJ =0.0

      Adj_RTCOND(I,L,N) =Adj_RTCOND(I,L,N) +Adj_RCOND
      Adj_RCOND  =0.0
      END IF
      END DO
      END DO

      END DO

      CALL PUTZERO(Adj_RTH, ILG*ILEV*ISIZE)
      END DO


C LPB[0]

      DO K=ISIZE,1,-1
        DO NP=NTP,1,-1
           IK=(NP-1)*ISIZE+K+(IAE1-1)
           DO L=ILEV,1+MAE,-1
              DO IL=IL2,IL1,-1
                 Adj_XROW(IL,L+1,IK) =Adj_XROW(IL,L+1,IK) +
     +                                Adj_RGRID(IL,L,IK)
                 Adj_RGRID(IL,L,IK) =0.0
              END DO
           END DO
        END DO
      END DO

      RETURN
      END
