      SUBROUTINE INCLD (   ILG,   ILEV,    LEV,    NTR,     IAE1,   
     1                   ISIZE,    MAE,    CAM,    IL1,      IL2,
     2                  PRECTR, RCRITS,   XROW, WRSCAV,     DELT,
     3                  WPEVPA, RTICLD,  GDREM, PRESSG,     DSHJ,
     4                    ISO2,   IHPO,     NN,      G,      NTP,
     5                  ZFPREC,  CLDCV, ASRSO2, ASRHPO )
C-----------------------------------------------------------------------
C
C     HISTORY:
C     --------
C     * DEC 20/1998 - S.L. GONG   INCLOUD PROCESSES
C     *                           RAIN-OUT OF AEROSOLS
C     *                           AND SO2.
C     * WRSCAV - WATER CONDENSATION RATE (KG/M3 S)
C     * ZFPREC - PRECIPITATION PRODUCTION RATE (KG/KG S)
C     * WPEVPA - PRECIPITATION EVAPOURATION RATE (KG/KG S)

      REAL PRESSG(ILG),  RTICLD(ILG,ILEV,NTR) , DSHJ(ILG,ILEV)
      REAL RCRITS(ILG,ILEV,2),PRECTR(ILG,NTR)
      REAL WPEVPA(ILG,ILEV), WRSCAV(ILG,ILEV),ZFPREC(ILG,ILEV)
      REAL TONE(12),CLDCV(ILG,ILEV,2)
      REAL GDREM(ILG,NTR,3), XROW(ILG,LEV,NTR)
      REAL ASRSO2(ILG,ILEV), ASRHPO(ILG,ILEV) 
C      DATA TONE /1.0,0.7,0.4,0.2,0.1,0.2,0.4,0.7,0.8,0.9,1.0,1.0/

      DO N=1,12
         TONE(N)=1.0
      END DO

      CALL PUTZERO(PRECTR, ILG*NTR)
      DO NN=1,NTP
         DO N=1, ISIZE
            NP=ISIZE*(NN-1)+N+(IAE1-1)
            DO L=1+MAE,ILEV
               DO I=IL1,IL2
                  NA=INT(RCRITS(I,L,1))
                  IF (N .GE. NA ) THEN
C
C     AEROSOL RAIN-OUT
C     FROM GIORGI AND CHAMEIDES [1986]
C
                      IF (WRSCAV(I,L) .GT. 1.E-18) THEN
                        ARATIO=0.5E-3/WRSCAV(I,L)
                        BETA=1.E-4 + 1./(0.8*ARATIO)
                        FF=0.8/(1.0+0.8E-4*ARATIO)
                        FRAC1=FF*(EXP(-BETA*2.*DELT)-1.0)
                        XOLD = XROW(I,L+1,NP)

                        SCAV=AMIN1(XOLD*FRAC1/(2.*DELT), 0.)*TONE(N)
                        FRACT=1.- (RCRITS(I,L,1)-REAL(NA))
                        RTICLD(I,L,NP)=CVMGT(SCAV*FRACT,
     1                                     SCAV, N .EQ. NA)
C
C     ACCUMULATIVE TRACER FLUX TO PRECIPITATION [KG M-2 S-1]
C
                        PRECTR(I,NP)=PRECTR(I,NP)-RTICLD(I,L,NP)*
     1                                         (DSHJ(I,L)*PRESSG(I)/G)
                      END IF
                  END IF
C
C     AEROSOL PRODUCTION DUE TO EVAPORATION OF CLOUDS
C
                  IF (ZFPREC(I,L) .GT. 1.E-18)  THEN
                     FRAC2=AMAX1(AMIN1(WPEVPA(I,L)/ZFPREC(I,L),1.0),0.0)
                     ZEVP=FRAC2*PRECTR(I,NP)/(DSHJ(I,L)*PRESSG(I)/G)
                     RTICLD(I,L,NP)=RTICLD(I,L,NP)+ZEVP
                     PRECTR(I,NP)=(1.-FRAC2)*PRECTR(I,NP)
                  END IF
                  XROW(I,L+1,NP)=XROW(I,L+1,NP)+2.*DELT*RTICLD(I,L,NP)
                  IF (L .EQ. ILEV) GDREM(I,NP,3)=-PRECTR(I,NP)         
               END DO
             END DO
          END DO
      END DO

      IF (CAM .GE. 10.0) RETURN
C
C    SECTION 5 IN-CLOUD REMOVAL OF SO2 AND H2O2 DUE TO EVOLUTION BY
C              STRATIFORM PRECIPITATION  (MM S-1 = KG M-2 S-1).
C
      DO L=1+MAE,ILEV                                                    
        DO I=IL1,IL2                                                   
           IF (WRSCAV(I,L) .GT. 1.E-18) THEN                               
             ARATIO=0.5E-3/WRSCAV(I,L)
             BETA=1.E-4 + 1./(0.8*ARATIO)
             FF=0.8/(1.0+0.8E-4*ARATIO)
             FRAC1=FF*(EXP(-BETA*2.*DELT)-1.0)
C            
             XOLD = XROW(I,L+1,ISO2)                                              

             RTICLD(I,L,ISO2)=AMIN1(XOLD*FRAC1/(2.*DELT), 0.)
C
C     ACCUMULATIVE TRACER FLUX TO PRECIPITATION [KG M-2 S-1]
C
             PRECTR(I,ISO2)=PRECTR(I,ISO2)-RTICLD(I,L,ISO2)*
     1                                         (DSHJ(I,L)*PRESSG(I)/G)

             XOLD = XROW(I,L+1,IHPO)                                              

             RTICLD(I,L,IHPO)=AMIN1(XOLD*FRAC1/(2.*DELT), 0.)
             PRECTR(I,IHPO)=PRECTR(I,IHPO)-RTICLD(I,L,IHPO)*
     1                                         (DSHJ(I,L)*PRESSG(I)/G)
           END IF                                                      
C
C     GAS PRODUCTION DUE TO EVAPORATION OF CLOUDS
C
           IF (ZFPREC(I,L) .GT. 1.E-18)  THEN


             FRAC2=AMAX1(AMIN1(WPEVPA(I,L)/ZFPREC(I,L),1.0),0.0)
             ZEVP=FRAC2*PRECTR(I,ISO2)/(DSHJ(I,L)*PRESSG(I)/G)
             RTICLD(I,L,ISO2)=RTICLD(I,L,ISO2)+ZEVP
             PRECTR(I,ISO2)=(1.-FRAC2)*PRECTR(I,ISO2)


             ZEVP=FRAC2*PRECTR(I,IHPO)/(DSHJ(I,L)*PRESSG(I)/G)
             RTICLD(I,L,IHPO)=RTICLD(I,L,IHPO)+ZEVP
             PRECTR(I,IHPO)=(1.-FRAC2)*PRECTR(I,IHPO)

           END IF
           IF (L .EQ. ILEV) THEN
             GDREM(I,ISO2,3)=-PRECTR(I,ISO2)
             GDREM(I,IHPO,3)=-PRECTR(I,IHPO)
           END IF
           XROW(I,L+1,ISO2)=XROW(I,L+1,ISO2)+2.*DELT*RTICLD(I,L,ISO2)
           XROW(I,L+1,IHPO)=XROW(I,L+1,IHPO)+2.*DELT*RTICLD(I,L,IHPO)
        END DO                                                         
      END DO                                                         


      RETURN
      END