C        Generated by TAPENADE     (INRIA, Tropics team)
C  Tapenade 3.6 (r4159) - 21 Sep 2011 10:11
C
C  Differentiation of difvchem in reverse (adjoint) mode:
C   gradient     of useful results: d tu u a b c
C   with respect to varying inputs: d tu u a b c
C   RW status of diff variables: d:in-out tu:in-out u:in-out a:in-out
C                b:in-out c:in-out
      SUBROUTINE DIFVCHEM_B(u, ub, tu, tub, ku, s, sk, a, ab, b, bb, c, 
     +                      cb, d, db, tau, n, nk)
      IMPLICIT NONE
      INTEGER n, nk
      REAL tau
      REAL u(n, nk)
      REAL ub(n, nk)
      REAL tu(n, nk), ku(n, nk), s(n, nk), sk(n, nk)
      REAL tub(n, nk)
      REAL a(n, nk), b(n, nk), c(n, nk), d(n, nk)
      REAL ab(n, nk), bb(n, nk), cb(n, nk), db(n, nk)
      REAL d_jm(n, nk),d_jmb(n, nk),d_jm2(n, nk),d_jm2b(n, nk)
C     REAL  D1(N, NK),D2(N,NK)
C---------------------------------------------------------------------
CAuthor
C          R. Benoit (Mar 89)
C
CRevisions
C 001      R. Benoit (Aug 93) -Local sigma: s and sk become 2D
C 002      B. Bilodeau (Dec 94) - "IF" tests on integer 
C          instead of character.
C 003      D. Plummer (June 98) - stripped down version of difuvdfj
C          used for vertical diffusion of chemical tracers
CObject
C          to solve a vertical diffusion equation by finite
C          differences
C
CArguments
C
C          - Output -
C TU       tendancy due to vertical diffusion
C
C          - Input -
C U        variable to diffuse (U,V,T,Q,E)
C KU       diffusion coefficient
C S        sigma coordinates of full levels
C SK       sigma coordinates of diffusion coefficient levels
C TAU      length of timestep
C A        work space (N,NK)
C B        work space (N,NK)
C C        work space (N,NK)
C D        work space (N,NK)
C N        horizontal dimension
C NK       vertical dimension
C
CNotes
C          D/DT U = D(U) + R
C          D(U) = D/DS J(U)
C          J(U) = KU*(D/DS U + GU)
C          Limiting Conditions where S=ST: J=0(for 'U'), D=0(for 'UT'
C          and ST=1)
C          U=0(for 'E')
C          Limiting Conditions where S=SB: J=ALFA+BETA*U(S(NK))(for
C          'U'/'UT'), J=0(for 'E')
C          ST = S(1)-1/2 (S(2)-S(1)) (except for 'TU')
C          SB = SK(NK)
C
C*
C---------------------------------------------------------------------
C
C
      INTEGER i, k, nkx
      REAL sc, hm, hp, hd, sck1, f
C     Added by WH. 050128
      REAL st(n), sb(n)
      EXTERNAL DIFUVD1, DIFUVD2
      EXTERNAL DIFUVD1_B, DIFUVD2_B
      INTEGER ad_count
      INTEGER i0
      INTEGER branch
      INTEGER ii2
      INTEGER ii1
C
C
C=========
C
      DO i=1,n
        st(i) = s(i, 1)
        sb(i) = sk(i, nk)
      ENDDO
C
C     These definitions hereunder for st, sb are always true.
C     so use as statement functions in code directly
C     to handle local sigma.
C     ST=S(1)
C     SB=SK(NK)
C
      sc = 1
      nkx = nk
      sck1 = 1
      f = 1.0
C
C      call flush (6)
C      call abort
C----------
C
C (1) CONSTRUIRE L'OPERATEUR TRIDIAGONAL DE DIFFUSION N=(A,B,C)
C                ET LE TERME CONTRE-GRADIENT (DANS D)
C
C     K=1
C
C
      CALL PUSHINTEGER4(i)
      ad_count = 1
      DO i=1,n
        hp = s(i, 2) - s(i, 1)
        hd = 0.5*(s(i, 1)+s(i, 2)) - st(i)
        a(i, 1) = 0
        IF (hp .NE. 0.0 .AND. hd .NE. 0.0) THEN
          b(i, 1) = -(sck1*ku(i, 1)/(hp*hd))
          c(i, 1) = -(sck1*b(i, 1))
          d(i, 1) = 0.0
          CALL PUSHINTEGER4(i)
          ad_count = ad_count + 1
        ELSE
          GOTO 100
        END IF
      ENDDO
      GOTO 110
 100  CALL PUSHCONTROL1B(1)
      CALL PUSHINTEGER4(ad_count)
C
C
      STOP
 110  CALL PUSHCONTROL1B(0)
      CALL PUSHINTEGER4(ad_count)
C
C     K=2...NK-1
C
      DO k=2,nk-1,1
        DO i=1,n
          hm = s(i, k) - s(i, k-1)
          hp = s(i, k+1) - s(i, k)
          hd = 0.5*(hm+hp)
          IF (hp .NE. 0.0 .AND. hd .NE. 0.0 .AND. hm .NE. 0.0) THEN
            a(i, k) = ku(i, k-1)/(hm*hd)
            b(i, k) = -((ku(i, k-1)/hm+ku(i, k)/hp)/hd)
            c(i, k) = ku(i, k)/(hp*hd)
            CALL PUSHCONTROL1B(0)
          ELSE
            a(i, k) = 0.0
            b(i, k) = 0.0
            c(i, k) = 0.0
            CALL PUSHCONTROL1B(1)
          END IF
          d(i, k) = 0.0
        ENDDO
      ENDDO
      DO i=1,n
        hm = s(i, nk) - s(i, nk-1)
        hd = sb(i) - 0.5*(s(i, nk-1)+s(i, nk))
        IF (hm .NE. 0.0 .AND. hd .NE. 0.0) THEN
          a(i, nk) = ku(i, nk-1)/(hm*hd)
          b(i, nk) = -((ku(i, nk-1)/hm+0)/hd)
          CALL PUSHCONTROL1B(0)
        ELSE
          a(i, nk) = 0.0
          b(i, nk) = 0.0
          CALL PUSHCONTROL1B(1)
        END IF
        c(i, nk) = 0.0
        d(i, nk) = 0.0
      ENDDO
C
C
C
C (2) CALCULER LE COTE DROIT D=TAU*(SC*N(U)+R+D/DS(KU*GU))
C
C
      d_jm=d
      CALL DIFUVD1(d, sc, a, b, c, u, d_jm, n, n, nkx)
C
C
      DO k=1,nkx
        DO i=1,n
          d(i, k) = tau*d(i, k)
        ENDDO
      ENDDO
C
C (3) CALCULER OPERATEUR DU COTE GAUCHE
C
      DO k=1,nkx
        DO i=1,n
          CALL PUSHREAL8(a(i, k))
          a(i, k) = -(f*tau*a(i, k))
          CALL PUSHREAL8(b(i, k))
          b(i, k) = 1 - f*tau*b(i, k)
          CALL PUSHREAL8(c(i, k))
C
          c(i, k) = -(f*tau*c(i, k))
        ENDDO
      ENDDO
      DO k=nkx,1,-1
        DO i=n,1,-1
          tub(i, k) = tub(i, k) + ub(i, k)
        ENDDO
      ENDDO
      d_jm2=d
      d_jm2b=0.0
      CALL DIFUVD2_B(tu, tub, a, ab, b, bb, c, cb, d_jm2, d_jm2b,
     +               d,db, n, n, nkx)
      db=db+d_jm2b
      d_jm2b=0.0
      DO k=nkx,1,-1
        DO i=n,1,-1
          CALL POPREAL8(c(i, k))
          cb(i, k) = -(f*tau*cb(i, k))
          CALL POPREAL8(b(i, k))
          bb(i, k) = -(f*tau*bb(i, k))
          CALL POPREAL8(a(i, k))
          ab(i, k) = -(f*tau*ab(i, k))
        ENDDO
      ENDDO
      DO k=nkx,1,-1
        DO i=n,1,-1
          db(i, k) = tau*db(i, k)
        ENDDO
      ENDDO
      d_jm=d
      d_jmb=0.0
      CALL DIFUVD1_B(d, db, sc, a, ab, b, bb,c,cb,u,ub,d_jm,d_jmb,n,n
     +               , nkx)
      db=db+d_jmb
      d_jmb=0.0
      DO i=n,1,-1
        db(i, nk) = 0.0
        cb(i, nk) = 0.0
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          bb(i, nk) = 0.0
          ab(i, nk) = 0.0
        ELSE
          bb(i, nk) = 0.0
          ab(i, nk) = 0.0
        END IF
      ENDDO
      DO k=nk-1,2,-1
        DO i=n,1,-1
          db(i, k) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            cb(i, k) = 0.0
            bb(i, k) = 0.0
            ab(i, k) = 0.0
          ELSE
            cb(i, k) = 0.0
            bb(i, k) = 0.0
            ab(i, k) = 0.0
          END IF
        ENDDO
      ENDDO
      CALL POPINTEGER4(ad_count)
      DO i0=1,ad_count
        IF (i0 .EQ. 1) THEN
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) GOTO 120
        ELSE
          bb(i, 1) = 0.0
          db(i, 1) = 0.0
          cb(i, 1) = 0.0
        END IF
        ab(i, 1) = 0.0
 120    CALL POPINTEGER4(i)
      ENDDO
      END
