!copyright (C) 2001  MSC-RPN COMM  %%%RPNPHY%%%
***S/P DIFUVD2
*
      SUBROUTINE DIFUVD2(P, A, B, C, D, DELTA, NP, N, NK)
*
      include "impnone.cdk"
      INTEGER NP, N, NK
      REAL P(NP,NK), A(N,NK), B(N,NK), C(N,NK), D(N,NK), DELTA(N,NK)
      REAL AP,AB,BX
*
*Author
*          R. Benoit(Mar 89)
*
*Object
*          this is the transverse vectorization of the subroutine
*          ROSSR1
*
*Arguments
*
*          - Output -
* P        result
*
*          - Input -
* A        lower-diagonal
* B        diagonal
* C        upper-diagonal
* D        right side
* DELTA    work space
* NP       1st dimension of P
* N        1st dimension of all other vectors
* NK       2nd dimension (order)
*
*Notes
*          This subroutine solves the tri-diagonal matrix problem
*          below using ROSSR:
*
*  *****                                      ****  ****     ***    ****
*  *****                                      ****  ****     ***    ****
*  ** B(1),C(1), 0  , 0  , 0  , - - - -  ,  0   **  **  P(1)  **    **D(
*  ** A(2),B(2),C(2), 0  , 0  , - - - -  ,  0   **  **  P(2)  **    **D(
*  **  0  ,A(3),B(3),C(3), 0  , - - - -  ,  0   **  **  P(3)  **    **
*  **  0  , 0  ,A(4),B(4),C(4), - - - -  ,  0   **  **  P(4)  **    **
*  **  0  , 0  , 0  ,A(5),B(5), - - - -  ,  0   **  **  P(5)  ** -- **
*  **  -                                    -   **  **    -   ** -- **
*  **  -                                    -   **  **    -   **    **
*  **  0  ,  , 0 ,A(NK-2),B(NK-2),C(NK-2),  0   **  ** P(NK-2)**    **
*  **  0  ,  , 0 ,  0   ,A(NK-1),B(NK-1),C(NK-1)**  ** P(NK-1)**    **
*  **  0  ,  , 0 ,  0   ,   0   , A(NK) , B(NK) **  **  P(NK) **    **D(
*  ****                                       ****  ****    ****    ****
*  ****                                       ****  ****    ****    ****
*
*          Delta is a working array of dimension NK.  If the array D
*          is not required subsequently then the call CALL ROSSR1(P.A,
*          B,C,D,D,NK) will reduce storage requirements.  If further
*          the array C is not required subsequently, then the call
*          will further reduce storage requirements.
*
**
*
*-----------------------------------------------------------------------
*
      REAL X
      INTEGER I, K
*
c      print*,'------before 10 --------------'

      DO 10 I=1,N
      C(I,NK)=0.
      X=1./B(I,1)
      P(I,1)=-C(I,1)*X
      DELTA(I,1)=D(I,1)*X
   10 CONTINUE
*

c      print*,'------before 20 --------------'
c       DO K=1,NK
c         DO I=1,N
c         PRINT*,'K=       ',K
c         PRINT*,'I=        ',I
c         print*, A(I,K),B(I,K),C(I,K),D(I,K)
c        ENDDO
c       ENDDO

      DO 20 K=2,NK
      DO 20 I=1,N
c      PRINT*,'K=',K
c      print*,'I=',I
c      PRINT*,'B',B(I,K)
c      PRINT*,'P',P(I,K-1)

c      PRINT*,'A',A(I,K)
c      PRINT*,'A*P',A(I,K)*P(I,K-1)
c      print*,'C',C(I,K)
      BX=B(I,K)  
      AP=A(I,K)*P(I,K-1)
      AB=BX+AP
      IF (AB.NE.0.0)THEN
       X=1./AB
      ELSE
       X=0.0
      ENDIF
c      print*,'X',X

       P(I,K)=-C(I,K)*X
c       print*,'P',P(I,K)
       DELTA(I,K)=(D(I,K)-A(I,K)*DELTA(I,K-1))*X
c      print*,'delta=',DELTA(I,K)
   20 CONTINUE
*

c      print*,'------before 30 --------------'

      DO 30 I=1,N
      P(I,NK)=DELTA(I,NK)
   30 CONTINUE
      DO 40 K=NK-1,1,-1
      DO 40 I=1,N
      P(I,K)=P(I,K)*P(I,K+1)+DELTA(I,K)
   40 CONTINUE
    
      RETURN
		
      END
