!copyright (C) 2001  MSC-RPN COMM  %%%RPNPHY%%%
***S/P DIFUVD1
*
      SUBROUTINE DIFUVD1 (E, SC, A, B, C, U, D, N, NU, NK)
*
      include "impnone.cdk"
      INTEGER N, NU, NK
      REAL E(N, NK), A(N, NK), B(N, NK), C(N, NK), U(NU, NK), D(N, NK)
      REAL SC
*
*Author
*          R. Benoit(Mar 89)
*
*Object
*          to produce the tri-diagonal: E=SC*(A,B,C)*U + D
*
*Arguments
*
*          - Output -
* E        result of (product +D)
*
*          - Input -
* SC       factor of the operator
* A        lower-diagonal
* B        diagonal
* C        upper-diagonal
* U        vector to multiply on matrix(A,B,C)
* D        inhomogeneous term to add
* N        1st dimension (for all except for U)
* NU       1st dimension of U
* NK       second dimension
*
*
*LANGAGE CFT
**
*
      INTEGER K, I
*
      DO 10 K=1,NK
*     FAIRE D'ABORD TERME DIAGONAL ET AJOUT DU TERME D DANS ACCUMULATEUR
         DO 1 I=1,N
1           E(I,K)=D(I,K)+SC*B(I,K)*U(I,K)          !zhjh: SC=1 .
         IF (K.GT.1) THEN
            DO 2 I=1,N
2              E(I,K)=E(I,K)+SC*A(I,K)*U(I,K-1)
         ENDIF
         IF (K.LT.NK) THEN
            DO 3 I=1,N
3              E(I,K)=E(I,K)+SC*C(I,K)*U(I,K+1)
         ENDIF
10       CONTINUE
 
      RETURN
      END
          
