C        Generated by TAPENADE     (INRIA, Tropics team)
C  Tapenade 3.6 (r4159) - 21 Sep 2011 10:11
C
C  Differentiation of coagd in reverse (adjoint) mode:
C   gradient     of useful results: rhopd f pdepv gx throw aerosize
C                v pdiff vkp rtcoa aeronum xrow aerop1 sgsum rhsize
C                cbar12 binloss dbsum rhop beta adt2 totmas roarow
C   with respect to varying inputs: rhopd f pdepv gx throw aerosize
C                v pdiff vkp rtcoa aeronum xrow aerop1 sgsum rhsize
C                cbar12 binloss dbsum rhop beta adt2 totmas roarow
C   RW status of diff variables: rhopd:incr f:incr pdepv:incr gx:in-out
C                throw:incr aerosize:incr v:incr pdiff:incr vkp:in-out
C                rtcoa:in-out aeronum:in-out xrow:in-out aerop1:in-out
C                sgsum:in-out rhsize:incr cbar12:in-out binloss:in-out
C                dbsum:in-out rhop:incr beta:in-out adt2:incr totmas:in-out
C                roarow:incr
      SUBROUTINE COAGD_B(ilg,      il1,     il2,     ilev,    throw,
     +                 isize,   roarow,   rtcoa,   rhsize,   totmas,
     +               aeronum,      ntr,     ntp,        f,     iae1, 
     +                 dbsum,    sgsum, binloss,   aerop1,    kount,
     +                  beta,     adt2,   icoag,    irest,     xrow, 
     +                     v,      vkp,    jlat,     icob,     tmin,
     +                 pdepv,    pdiff,  cbar12,       gx,      mae, 
     +                   igf,    igfij,    rhop, aerosize,    rhopd,
CCCCCCCCCCCCCCCC   for AD model
     +                throwb,  roarowb,  rtcoab,  rhsizeb,  totmasb,
     +              aeronumb,       fb,  dbsumb,   sgsumb, binlossb, 
     +               aerop1b,    betab,   adt2b,    xrowb,       vb,
     +                  vkpb,   pdepvb,  pdiffb,  cbar12b,      gxb,
     +                 rhopb,aerosizeb,  rhopdb) 
      IMPLICIT NONE
      INTEGER ilg, ilev, ntr, isize, mae, irest, jlat, kount, n
      INTEGER icob, l, il, il1, il2, i, j, k, nn, ntp, ij
      INTEGER ik, iae1, ip, icoag, nt, no
C
      REAL dx, v1, dl3, gx0, diffx, diffy, dsum, cbar, gmean, amu
      REAL dxb, v1b, dl3b, gx0b, diffxb, diffyb, dsumb, cbarb, gmeanb
      REAL stick, xiao, adt2, oldnum, rtloss, cpresv, rgasv, turb1
      REAL adt2b, oldnumb, rtlossb
      REAL cpres, rgoasq, rgocp, rgas, g, asq, rayon, tw, ww
      REAL avno, rgasi, am, boltzk, pi, a, turbds
C
      REAL l1, tmin, rwi
      REAL l1b, rwib
      REAL a0, rsn0, rcut0, rcg0, pnon
      COMMON /params/ ww, tw, rayon, asq, g, rgas, rgocp, rgoasq, cpres
     +, rgasv, cpresv
      COMMON /narcm/ avno, rgasi, am, boltzk, pi, a, a0, rsn0, rcut0, 
     +rcg0, pnon
      REAL throw(ilg, ilev+1), roarow(ilg, ilev), aerosize(2, isize)
      REAL throwb(ilg, ilev+1), roarowb(ilg, ilev), aerosizeb(2, isize)
      REAL rtcoa(ilg, ilev, ntr), rhsize(ilg, ilev, isize)
      REAL rtcoab(ilg, ilev, ntr), rhsizeb(ilg, ilev, isize)
      REAL v(isize), binloss(ilg, ilev, isize), rhop(ilg, ilev, isize)
      REAL vb(isize), binlossb(ilg, ilev, isize), rhopb(ilg, ilev, isize
     +     )
      REAL vkp(ilg, ilev), beta(ilg, ilev, isize, isize)
      REAL vkpb(ilg, ilev), betab(ilg, ilev, isize, isize)
      REAL f(isize, isize, isize), sgsum(ilg, ilev), dbsum(ilg, ilev)
      REAL fb(isize, isize, isize), sgsumb(ilg, ilev), dbsumb(ilg, ilev)
      REAL totmas(ilg, ilev, isize), aeronum(ilg, ilev, isize)
      REAL totmasb(ilg, ilev, isize), aeronumb(ilg, ilev, isize)
      REAL rhopd(ilg, ilev, isize)
      REAL rhopdb(ilg, ilev, isize)
      REAL aerop1(ilg, ilev, isize), xrow(ilg, ilev+1, ntr)
      REAL aerop1b(ilg, ilev, isize), xrowb(ilg, ilev+1, ntr)
      REAL pdiff(ilg, ilev, isize), pdepv(ilg, ilev, isize)
      REAL pdiffb(ilg, ilev, isize), pdepvb(ilg, ilev, isize)
      REAL cbar12(ilg, ilev, isize), gx(ilg, ilev, isize)
      REAL cbar12b(ilg, ilev, isize), gxb(ilg, ilev, isize)
C
      INTEGER igf(isize), igfij(isize, isize*isize, 2)
      EXTERNAL PUTZERO
      EXTERNAL PUTZERO_B
      INTEGER arg1
      REAL tmp
      INTEGER branch
      INTEGER ad_from
      INTEGER ad_to
      INTEGER ad_from0
      REAL temp3
      REAL temp2
      REAL y1b
      REAL temp1
      REAL temp0
      REAL temp13b
      REAL temp7b
      REAL temp9b1
      REAL temp9b0
      INTRINSIC MOD
      INTRINSIC MAX
      REAL tmpb
      REAL temp3b
      INTRINSIC ABS
      REAL temp12b
      REAL temp2b0
      REAL temp6b
      REAL temp14
      REAL temp13
      REAL temp12
      REAL temp11
      REAL temp10
      REAL temp15b
      REAL temp9b
      REAL abs0b
      REAL temp5b2
      REAL temp5b1
      REAL temp5b0
      REAL tempb
      INTRINSIC AMAX1
      REAL temp2b
      REAL temp5b
      REAL temp14b
      REAL temp3b1
      REAL temp8b
      REAL temp3b0
      REAL temp12b0
      REAL abs0
      INTRINSIC SQRT
      REAL temp
      INTEGER max1
      REAL temp9
      REAL temp8
      REAL temp7
      REAL temp4b
      REAL temp6
      REAL temp5
      REAL y1
      REAL temp4
C
      DATA stick /1.0/
      DATA turbds /0.002/
      DATA xiao /1.e6/
C
C     NON START-RUN BEGINS 
C
      arg1 = ilg*ilev*ntr
      CALL PUSHINTEGER4(arg1)
      CALL PUSHREAL8ARRAY(rtcoa, ilg*ilev*ntr)
      CALL PUTZERO(rtcoa, arg1)
      arg1 = ilg*ilev*isize
      CALL PUSHINTEGER4(arg1)
      CALL PUSHREAL8ARRAY(totmas, ilg*ilev*isize)
      CALL PUTZERO(totmas, arg1)
C
C     UPDATE THE CURRENT AEROSOL NUMBER
C
      DO nt=1,ntp
        DO n=1,isize
          CALL PUSHINTEGER4(no)
          no = n + isize*(nt-1) + (iae1-1)
          DO l=1+mae,ilev
            DO i=il1,il2
              totmas(i, l, n) = totmas(i, l, n) + xrow(i, l+1, no)
            ENDDO
          ENDDO
        ENDDO
      ENDDO
      DO n=1,isize
        CALL PUSHREAL8(rwi)
        rwi = (aerosize(1, n)+aerosize(2, n))/2.0
        DO l=1+mae,ilev
          DO i=il1,il2
            aeronum(i, l, n) = totmas(i, l, n)/(4.189*rwi*rwi*rwi*rhopd(
     +        i, l, n))
          ENDDO
        ENDDO
      ENDDO
      IF (MOD(kount, icoag) .EQ. 0 .OR. irest .EQ. 1) THEN
CEND IF 888
C
C      IF (JLAT .EQ. 1) WRITE (*,555) KOUNT
C
        arg1 = ilg*ilev*isize*isize
        CALL PUSHINTEGER4(arg1)
        CALL PUSHREAL8ARRAY(beta, ilg*ilev*isize**2)
        CALL PUTZERO(beta, arg1)
        DO n=1,icob
          CALL PUSHREAL8(rwi)
          rwi = (aerosize(1, n)+aerosize(2, n))/2.0
          DO l=1+mae,ilev
            DO il=il1,il2
              dx = 2.*rhsize(il, l, n)
              v1 = 4.189*rwi*rwi*rwi*rhop(il, l, n)
              cbar12(il, l, n) = 3.51568e-23*throw(il, l+1)/v1
              CALL PUSHREAL8(l1)
              l1 = 2.5465*pdiff(il, l, n)/SQRT(cbar12(il, l, n))
              dl3 = (dx+l1)*(dx+l1)*(dx+l1)
              CALL PUSHREAL8(gx0)
              gx0 = (dl3-(dx*dx+l1*l1)**1.5)/(3.*dx*l1) - dx
              gx(il, l, n) = gx0*gx0
            ENDDO
          ENDDO
        ENDDO
        DO i=1,icob
          ad_from = i
          DO j=ad_from,icob
            DO l=1+mae,ilev
              DO il=il1,il2
C
C     * DIFFUSION COEFFICIENTS
C
                diffx = pdiff(il, l, i)
                diffy = pdiff(il, l, j)
C
C     * AIR'S DYNAMIC VISCOSITY
C
                dsum = 2.*(rhsize(il, l, i)+rhsize(il, l, j))
                CALL PUSHREAL8(cbar)
C
C       BROWNIAN COAGULATION COEFFICIENT        [V1, V2, VR - PARTICLE MASS, KG] 
C
                cbar = SQRT(cbar12(il, l, i) + cbar12(il, l, j))
                CALL PUSHREAL8(gmean)
                gmean = SQRT(gx(il, l, i) + gx(il, l, j))
C
                beta(il, l, i, j) = 6.2832*(diffx+diffy)*dsum/(dsum/(
     +            dsum+2.*gmean)+8.*(diffx+diffy)/(cbar*dsum*stick))
                IF (pdepv(il, l, i) - pdepv(il, l, j) .GE. 0.) THEN
                  CALL PUSHREAL8(abs0)
                  abs0 = pdepv(il, l, i) - pdepv(il, l, j)
                  CALL PUSHCONTROL1B(0)
                ELSE
                  CALL PUSHREAL8(abs0)
                  abs0 = -(pdepv(il, l, i)-pdepv(il, l, j))
                  CALL PUSHCONTROL1B(1)
                END IF
C
C       ADD GRAVITATIONAL COAGULATION
C
                beta(il, l, i, j) = beta(il, l, i, j) + 0.7854*dsum**2*
     +            abs0
                tmp = beta(il, l, i, j)
                beta(il, l, j, i) = tmp
              ENDDO
            ENDDO
          ENDDO
          CALL PUSHINTEGER4(ad_from)
        ENDDO
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHCONTROL1B(1)
      END IF
C
      arg1 = ilg*ilev*isize
      CALL PUSHINTEGER4(arg1)
      CALL PUSHREAL8ARRAY(aerop1, ilg*ilev*isize)
      CALL PUTZERO(aerop1, arg1)
      DO k=1,icob
        arg1 = ilg*ilev
        CALL PUSHREAL8ARRAY(dbsum, ilg*ilev)
        CALL PUSHINTEGER4(arg1)
        CALL PUTZERO(dbsum, arg1)
        arg1 = ilg*ilev
        CALL PUSHREAL8ARRAY(sgsum, ilg*ilev)
        CALL PUSHINTEGER4(arg1)
        CALL PUTZERO(sgsum, arg1)
        arg1 = ilg*ilev*isize
        CALL PUSHREAL8ARRAY(binloss, ilg*ilev*isize)
        CALL PUSHINTEGER4(arg1)
        CALL PUTZERO(binloss, arg1)
        CALL PUSHINTEGER4(j)
C
        DO j=1,icob
          DO l=1+mae,ilev
            DO il=il1,il2
C
C       NUMBER LOSS OF K DUE TO COLLISION WITH J [1-ISIZE]
C              
              oldnum = aeronum(il, l, j)*roarow(il, l)
              IF (oldnum .GT. xiao) THEN
                binloss(il, l, j) = (1.-f(k, j, k))*beta(il, l, k, j)*
     +            oldnum
                sgsum(il, l) = sgsum(il, l) + binloss(il, l, j)
                CALL PUSHCONTROL1B(1)
              ELSE
                CALL PUSHCONTROL1B(0)
              END IF
            ENDDO
          ENDDO
        ENDDO
C
CGETHERED POINTS FOR COAGFR
        DO ij=1,igf(k)
          CALL PUSHINTEGER4(i)
          i = igfij(k, ij, 1)
          CALL PUSHINTEGER4(j)
          j = igfij(k, ij, 2)
          DO l=1+mae,ilev
            DO il=il1,il2
C
C       VOLUME GAIN OF K DUE TO COLLISION OF I AND J [=<K]-- [M3 S-1]
C
              dbsum(il, l) = dbsum(il, l) + f(i, j, k)*beta(il, l, i, j)
     +          *v(i)*aerop1(il, l, i)*aeronum(il, l, j)*roarow(il, l)
            ENDDO
          ENDDO
        ENDDO
        CALL PUSHINTEGER4(ij - 1)
C
C      TOTAL NUMBER OF K AFTER COAGULATION [# M-3]
C
        DO l=1+mae,ilev
          DO il=il1,il2
            CALL PUSHREAL8(aerop1(il, l, k))
            aerop1(il, l, k) = (roarow(il, l)*aeronum(il, l, k)+adt2/v(k
     +        )*dbsum(il, l))/(1.+adt2*sgsum(il, l))
          ENDDO
        ENDDO
C
C     MASS BALANCE FOR EACH SPECIES OF K
C       LOSS OF K IS THE SUM OF MASS GAINED BY ALL J
C       SGSUM  - DIMESIONLESS
C       AEROP1 - # M-3
C
        DO nn=1,ntp
          CALL PUSHINTEGER4(ik)
          ik = (nn-1)*isize + k + (iae1-1)
          arg1 = ilg*ilev
          CALL PUSHREAL8ARRAY(vkp, ilg*ilev)
          CALL PUSHINTEGER4(arg1)
          CALL PUTZERO(vkp, arg1)
          DO l=1+mae,ilev
            DO il=il1,il2
C
C        LOST TENDENCY OF K
C        AEROP1(IL,L,K) * SGSUM(IL,L) * V(K) IS THE VOLUME LOSS RATE OF
C        BIN K DUE TO THE COAGULATION. BY /(OLDNUM*V(K)) *XROW(IL,L+1,IK)
C        THE LOSS TENDENCY OF IK IS OBTAINED.
C         
C
              oldnum = aeronum(il, l, k)*roarow(il, l)
              IF (oldnum .GT. xiao) THEN
                vkp(il, l) = aerop1(il, l, k)/oldnum*xrow(il, l+1, ik)
                rtcoa(il, l, ik) = rtcoa(il, l, ik) - vkp(il, l)*sgsum(
     +            il, l)
                CALL PUSHCONTROL1B(1)
              ELSE
                CALL PUSHCONTROL1B(0)
              END IF
            ENDDO
          ENDDO
          CALL PUSHINTEGER4(j)
C
C        GAIN TENDENCY OF I DUE TO LOSS OF [K,J]
C
          DO j=1,icob
            IF (j .LT. k) THEN
              max1 = k
            ELSE
              max1 = j
            END IF
            ad_from0 = max1
            CALL PUSHINTEGER4(i)
            DO i=ad_from0,icob
              IF (f(k, j, i) .GT. 0.) THEN
                CALL PUSHINTEGER4(ip)
                ip = (nn-1)*isize + i + (iae1-1)
                DO l=1+mae,ilev
                  DO il=il1,il2
                    rtloss = vkp(il, l)*binloss(il, l, j)*f(k, j, i)
                    rtcoa(il, l, ip) = rtcoa(il, l, ip) + rtloss
                  ENDDO
                ENDDO
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHCONTROL1B(1)
              END IF
            ENDDO
            CALL PUSHINTEGER4(ad_from0)
          ENDDO
        ENDDO
      ENDDO
CEND OF NN LOOP
CEND OF K  LOOP
C
C      UPDATE TRACER DUE TO COAGULATIONS
C
CTHE TENDENCY FOR K=ISIZE IS ADDED
CDRY DEPOSITION
      DO k=1,isize
        DO nn=1,ntp
          CALL PUSHINTEGER4(ik)
          ik = (nn-1)*isize + k + (iae1-1)
          DO l=1+mae,ilev
            DO il=il1,il2
              y1 = xrow(il, l+1, ik) + rtcoa(il, l, ik)*adt2
              IF (tmin .LT. y1) THEN
                CALL PUSHREAL8(xrow(il, l+1, ik))
                xrow(il, l+1, ik) = y1
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHREAL8(xrow(il, l+1, ik))
                xrow(il, l+1, ik) = tmin
                CALL PUSHCONTROL1B(1)
              END IF
            ENDDO
          ENDDO
        ENDDO
      ENDDO
      DO k=isize,1,-1
        DO nn=ntp,1,-1
          DO l=ilev,1+mae,-1
            DO il=il2,il1,-1
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                CALL POPREAL8(xrow(il, l+1, ik))
                y1b = xrowb(il, l+1, ik)
                xrowb(il, l+1, ik) = 0.0
              ELSE
                CALL POPREAL8(xrow(il, l+1, ik))
                xrowb(il, l+1, ik) = 0.0
                y1b = 0.0
              END IF
              xrowb(il, l+1, ik) = xrowb(il, l+1, ik) + y1b
              rtcoab(il, l, ik) = rtcoab(il, l, ik) + adt2*y1b
              adt2b = adt2b + rtcoa(il, l, ik)*y1b
            ENDDO
          ENDDO
          CALL POPINTEGER4(ik)
        ENDDO
      ENDDO
      DO k=icob,1,-1
        DO nn=ntp,1,-1
          DO j=icob,1,-1
            CALL POPINTEGER4(ad_from0)
            DO i=icob,ad_from0,-1
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                DO l=ilev,1+mae,-1
                  DO il=il2,il1,-1
                    rtlossb = rtcoab(il, l, ip)
                    temp15b = f(k, j, i)*rtlossb
                    vkpb(il, l) = vkpb(il, l) + binloss(il, l, j)*
     +                temp15b
                    binlossb(il, l, j) = binlossb(il, l, j) + vkp(il, l)
     +                *temp15b
                    fb(k, j, i) = fb(k, j, i) + vkp(il, l)*binloss(il, l
     +                , j)*rtlossb
                  ENDDO
                ENDDO
                CALL POPINTEGER4(ip)
              END IF
            ENDDO
            CALL POPINTEGER4(i)
          ENDDO
          CALL POPINTEGER4(j)
          DO l=ilev,1+mae,-1
            DO il=il2,il1,-1
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                oldnumb = 0.0
              ELSE
                vkpb(il, l) = vkpb(il, l) - sgsum(il, l)*rtcoab(il, l, 
     +            ik)
                sgsumb(il, l) = sgsumb(il, l) - vkp(il, l)*rtcoab(il, l
     +            , ik)
                oldnum = aeronum(il, l, k)*roarow(il, l)
                temp14b = xrow(il, l+1, ik)*vkpb(il, l)/oldnum
                temp14 = aerop1(il, l, k)/oldnum
                aerop1b(il, l, k) = aerop1b(il, l, k) + temp14b
                oldnumb = -(temp14*temp14b)
                xrowb(il, l+1, ik) = xrowb(il, l+1, ik) + temp14*vkpb(il
     +            , l)
                vkpb(il, l) = 0.0
              END IF
              aeronumb(il, l, k) = aeronumb(il, l, k) + roarow(il, l)*
     +          oldnumb
              roarowb(il, l) = roarowb(il, l) + aeronum(il, l, k)*
     +          oldnumb
            ENDDO
          ENDDO
          CALL POPINTEGER4(arg1)
          CALL LOOKREAL8ARRAY(vkp, ilg*ilev)
          CALL PUTZERO_B(vkp, vkpb, arg1)
          CALL POPREAL8ARRAY(vkp, ilg*ilev)
          CALL POPINTEGER4(ik)
        ENDDO
        DO l=ilev,1+mae,-1
          DO il=il2,il1,-1
            CALL POPREAL8(aerop1(il, l, k))
            temp13 = adt2*sgsum(il, l) + 1.
            temp12b = aerop1b(il, l, k)/temp13
            temp12 = adt2/v(k)
            temp12b0 = dbsum(il, l)*temp12b/v(k)
            temp13b = -((roarow(il, l)*aeronum(il, l, k)+dbsum(il, l)*
     +        temp12)*temp12b/temp13)
            roarowb(il, l) = roarowb(il, l) + aeronum(il, l, k)*temp12b
            aeronumb(il, l, k) = aeronumb(il, l, k) + roarow(il, l)*
     +        temp12b
            dbsumb(il, l) = dbsumb(il, l) + temp12*temp12b
            adt2b = adt2b + sgsum(il, l)*temp13b + temp12b0
            vb(k) = vb(k) - temp12*temp12b0
            sgsumb(il, l) = sgsumb(il, l) + adt2*temp13b
            aerop1b(il, l, k) = 0.0
          ENDDO
        ENDDO
        CALL POPINTEGER4(ad_to)
        DO ij=ad_to,1,-1
          DO l=ilev,1+mae,-1
            DO il=il2,il1,-1
              temp11 = v(i)*roarow(il, l)
              temp10 = f(i, j, k)*aerop1(il, l, i)
              temp9b0 = temp10*temp11*dbsumb(il, l)
              temp9 = beta(il, l, i, j)
              temp9b1 = temp9*aeronum(il, l, j)*dbsumb(il, l)
              betab(il, l, i, j) = betab(il, l, i, j) + aeronum(il, l, j
     +          )*temp9b0
              aeronumb(il, l, j) = aeronumb(il, l, j) + temp9*temp9b0
              fb(i, j, k) = fb(i, j, k) + temp11*aerop1(il, l, i)*
     +          temp9b1
              aerop1b(il, l, i) = aerop1b(il, l, i) + temp11*f(i, j, k)*
     +          temp9b1
              vb(i) = vb(i) + temp10*roarow(il, l)*temp9b1
              roarowb(il, l) = roarowb(il, l) + temp10*v(i)*temp9b1
            ENDDO
          ENDDO
          CALL POPINTEGER4(j)
          CALL POPINTEGER4(i)
        ENDDO
        DO j=icob,1,-1
          DO l=ilev,1+mae,-1
            DO il=il2,il1,-1
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                oldnumb = 0.0
              ELSE
                binlossb(il, l, j) = binlossb(il, l, j) + sgsumb(il, l)
                oldnum = aeronum(il, l, j)*roarow(il, l)
                temp9b = beta(il, l, k, j)*binlossb(il, l, j)
                fb(k, j, k) = fb(k, j, k) - oldnum*temp9b
                oldnumb = (1.-f(k, j, k))*temp9b
                betab(il, l, k, j) = betab(il, l, k, j) + (1.-f(k, j, k)
     +            )*oldnum*binlossb(il, l, j)
                binlossb(il, l, j) = 0.0
              END IF
              aeronumb(il, l, j) = aeronumb(il, l, j) + roarow(il, l)*
     +          oldnumb
              roarowb(il, l) = roarowb(il, l) + aeronum(il, l, j)*
     +          oldnumb
            ENDDO
          ENDDO
        ENDDO
        CALL POPINTEGER4(j)
        CALL POPINTEGER4(arg1)
        CALL LOOKREAL8ARRAY(binloss, ilg*ilev*isize)
        CALL PUTZERO_B(binloss, binlossb, arg1)
        CALL POPREAL8ARRAY(binloss, ilg*ilev*isize)
        CALL POPINTEGER4(arg1)
        CALL LOOKREAL8ARRAY(sgsum, ilg*ilev)
        CALL PUTZERO_B(sgsum, sgsumb, arg1)
        CALL POPREAL8ARRAY(sgsum, ilg*ilev)
        CALL POPINTEGER4(arg1)
        CALL LOOKREAL8ARRAY(dbsum, ilg*ilev)
        CALL PUTZERO_B(dbsum, dbsumb, arg1)
        CALL POPREAL8ARRAY(dbsum, ilg*ilev)
      ENDDO
      CALL POPREAL8ARRAY(aerop1, ilg*ilev*isize)
      CALL POPINTEGER4(arg1)
      CALL PUTZERO_B(aerop1, aerop1b, arg1)
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) THEN
        DO i=icob,1,-1
          CALL POPINTEGER4(ad_from)
          DO j=icob,ad_from,-1
            DO l=ilev,1+mae,-1
              DO il=il2,il1,-1
                tmpb = betab(il, l, j, i)
                betab(il, l, j, i) = 0.0
                betab(il, l, i, j) = betab(il, l, i, j) + tmpb
                dsum = 2.*(rhsize(il, l, i)+rhsize(il, l, j))
                dsumb = abs0*0.7854*2*dsum*betab(il, l, i, j)
                abs0b = 0.7854*dsum**2*betab(il, l, i, j)
                CALL POPCONTROL1B(branch)
                IF (branch .EQ. 0) THEN
                  CALL POPREAL8(abs0)
                  pdepvb(il, l, i) = pdepvb(il, l, i) + abs0b
                  pdepvb(il, l, j) = pdepvb(il, l, j) - abs0b
                ELSE
                  CALL POPREAL8(abs0)
                  pdepvb(il, l, j) = pdepvb(il, l, j) + abs0b
                  pdepvb(il, l, i) = pdepvb(il, l, i) - abs0b
                END IF
                diffx = pdiff(il, l, i)
                diffy = pdiff(il, l, j)
                temp8 = stick*cbar*dsum
                temp7 = (diffx+diffy)/temp8
                temp6 = dsum + 2.*gmean
                temp5 = dsum/temp6 + 8.*temp7
                temp5b = 6.2832*betab(il, l, i, j)/temp5
                temp5b0 = -((diffx+diffy)*dsum*temp5b/temp5)
                temp6b = -(dsum*temp5b0/temp6**2)
                temp7b = 8.*temp5b0/temp8
                temp8b = -(temp7*temp7b)
                diffxb = temp7b + dsum*temp5b
                diffyb = temp7b + dsum*temp5b
                dsumb = dsumb + stick*cbar*temp8b + temp6b + temp5b0/
     +            temp6 + (diffx+diffy)*temp5b
                gmeanb = 2.*temp6b
                cbarb = dsum*stick*temp8b
                betab(il, l, i, j) = 0.0
                CALL POPREAL8(gmean)
                IF (gx(il, l, i) + gx(il, l, j) .EQ. 0.0) THEN
                  temp5b1 = 0.0
                ELSE
                  temp5b1 = gmeanb/(2.0*SQRT(gx(il, l, i)+gx(il, l, j)))
                END IF
                gxb(il, l, i) = gxb(il, l, i) + temp5b1
                gxb(il, l, j) = gxb(il, l, j) + temp5b1
                CALL POPREAL8(cbar)
                IF (cbar12(il, l, i) + cbar12(il, l, j) .EQ. 0.0) THEN
                  temp5b2 = 0.0
                ELSE
                  temp5b2 = cbarb/(2.0*SQRT(cbar12(il, l, i)+cbar12(il, 
     +              l, j)))
                END IF
                cbar12b(il, l, i) = cbar12b(il, l, i) + temp5b2
                cbar12b(il, l, j) = cbar12b(il, l, j) + temp5b2
                rhsizeb(il, l, i) = rhsizeb(il, l, i) + 2.*dsumb
                rhsizeb(il, l, j) = rhsizeb(il, l, j) + 2.*dsumb
                pdiffb(il, l, j) = pdiffb(il, l, j) + diffyb
                pdiffb(il, l, i) = pdiffb(il, l, i) + diffxb
              ENDDO
            ENDDO
          ENDDO
        ENDDO
        DO n=icob,1,-1
          rwib = 0.0
          DO l=ilev,1+mae,-1
            DO il=il2,il1,-1
              gx0b = 2*gx0*gxb(il, l, n)
              gxb(il, l, n) = 0.0
              dx = 2.*rhsize(il, l, n)
              dl3 = (dx+l1)*(dx+l1)*(dx+l1)
              CALL POPREAL8(gx0)
              temp4 = 3.*dx*l1
              temp3b = gx0b/temp4
              temp3 = dx**2 + l1**2
              temp3b0 = -(1.5*temp3**0.5*temp3b)
              temp4b = -((dl3-temp3**1.5)*temp3b/temp4)
              dl3b = temp3b
              temp3b1 = 3*(dx+l1)**2*dl3b
              dxb = temp3b1 - gx0b + l1*3.*temp4b + 2*dx*temp3b0
              l1b = temp3b1 + 3.*dx*temp4b + 2*l1*temp3b0
              CALL POPREAL8(l1)
              temp2 = SQRT(cbar12(il, l, n))
              temp2b = 2.5465*l1b/temp2
              pdiffb(il, l, n) = pdiffb(il, l, n) + temp2b
              IF (.NOT.cbar12(il, l, n) .EQ. 0.0) cbar12b(il, l, n) = 
     +            cbar12b(il, l, n) - pdiff(il, l, n)*temp2b/(temp2**2*
     +            2.0)
              v1 = 4.189*rwi*rwi*rwi*rhop(il, l, n)
              temp2b0 = 3.51568e-23*cbar12b(il, l, n)/v1
              throwb(il, l+1) = throwb(il, l+1) + temp2b0
              v1b = -(throw(il, l+1)*temp2b0/v1)
              cbar12b(il, l, n) = 0.0
              rwib = rwib + rhop(il, l, n)*4.189*3*rwi**2*v1b
              rhopb(il, l, n) = rhopb(il, l, n) + 4.189*rwi**3*v1b
              rhsizeb(il, l, n) = rhsizeb(il, l, n) + 2.*dxb
            ENDDO
          ENDDO
          CALL POPREAL8(rwi)
          aerosizeb(1, n) = aerosizeb(1, n) + rwib/2.0
          aerosizeb(2, n) = aerosizeb(2, n) + rwib/2.0
        ENDDO
        CALL POPREAL8ARRAY(beta, ilg*ilev*isize**2)
        CALL POPINTEGER4(arg1)
        CALL PUTZERO_B(beta, betab, arg1)
      END IF
      DO n=isize,1,-1
        rwib = 0.0
        DO l=ilev,1+mae,-1
          DO i=il2,il1,-1
            temp1 = 4.189*rhopd(i, l, n)
            temp0 = rwi**3
            temp = temp0*temp1
            tempb = -(totmas(i, l, n)*aeronumb(i, l, n)/temp**2)
            totmasb(i, l, n) = totmasb(i, l, n) + aeronumb(i, l, n)/temp
            rwib = rwib + temp1*3*rwi**2*tempb
            rhopdb(i, l, n) = rhopdb(i, l, n) + temp0*4.189*tempb
            aeronumb(i, l, n) = 0.0
          ENDDO
        ENDDO
        CALL POPREAL8(rwi)
        aerosizeb(1, n) = aerosizeb(1, n) + rwib/2.0
        aerosizeb(2, n) = aerosizeb(2, n) + rwib/2.0
      ENDDO
      DO nt=ntp,1,-1
        DO n=isize,1,-1
          DO l=ilev,1+mae,-1
            DO i=il2,il1,-1
              xrowb(i, l+1, no) = xrowb(i, l+1, no) + totmasb(i, l, n)
            ENDDO
          ENDDO
          CALL POPINTEGER4(no)
        ENDDO
      ENDDO
      CALL POPREAL8ARRAY(totmas, ilg*ilev*isize)
      CALL POPINTEGER4(arg1)
      CALL PUTZERO_B(totmas, totmasb, arg1)
      CALL POPREAL8ARRAY(rtcoa, ilg*ilev*ntr)
      CALL POPINTEGER4(arg1)
      CALL PUTZERO_B(rtcoa, rtcoab, arg1)
 555  FORMAT(' COAGD -> BETA COMPUTED @ ',i5)
      END
