
      SUBROUTINE CLDCHEM_B(il1, il2, ilev, ilg, iso2, ihpo, nn, ntr, 
     +                     ntraca, isize, iae1, rcrit, rcritb, rcoex, 
     +                     rcoexb, clsize, clsizeb, cldcv, cldcvb, zmlwc
     +                     , zmlwcb, h2o2row, h2o2rowb, roarow, roarowb
     +                     , th, thb, hno3row, hno3rowb, nh3row, nh3rowb
     +                     , o3row, o3rowb, co2row, co2rowb, rgrid, 
     +                     rgridb, rthpo, rthpob, rtso4, rtso4b, rtso2, 
     +                     rtso2b, pressg, pressgb, shj, shjb, aeronum, 
     +                     aeronumb, grav, dshj, dshjb, ideep, jt, maxg
     +                     , jd, eps0, mu, mub, eu, eub, du, dub, md, 
     +                     mdb, mc, mcb, ed, edb, dp, dpb, dz, dzb, mb, 
     +                     mbb, msg, zfg, zfgb, lengath, dsubcld, 
     +                     dsubcldb, asprva, asprvab, agamma, agammab, 
     +                     aresid, aresidb, aspeci, aspecib, agtso2, 
     +                     agtso2b, agtso4, agtso4b, agto3, agto3b, 
     +                     agtco2, agtco2b, agtnh3, agtnh3b, agthno3, 
     +                     agthno3b, agtna, agtnab, agtho2, agtho2b, 
     +                     aoh2o2, aoh2o2b, aeqca, aeqcab, aeqcb, aeqcbb
     +                     , aeqcc, aeqccb, aeqcai, aeqcaib, aeqcbi, 
     +                     aeqcbib, aeqchp, aeqchpb, aeqcho, aeqchob, 
     +                     aeqhno, aeqhnob, aeqnh3, aeqnh3b, aeqhcl, 
     +                     aeqhclb, aorhp1, aorhp1b, aorhp2, aorhp2b, 
     +                     aorho, aorhob, antso2, antso2b, antho2, 
     +                     antho2b, antso4, antso4b, amh, amhb, hpoxrow
     +                     , hpoxrowb, mur, murb, mdr, mdrb, dur, durb, 
     +                     eur, eurb, edr, edrb, kcalc, x, xb, xd, xdb, 
     +                     xg, xgb, dxdt, dxdtb, xhat, xhatb, dxdx, 
     +                     dxdxb, xu, xub, facx, facxb, ou, oub, sumdx, 
     +                     sumdxb, xga, xgab, xua, xuab, afrac, afracb, 
     +                     afracf, afracfb, z, xrow, xrowb, kount, pxnew
     +                     , pxnewb, ru, rub, rua, ruab, asrso2, asrso2b
     +                     , asrhpo, asrhpob, aerosize, thlev, thlevb, 
     +                     rtbcld, rtbcldb, id, gdrem, gdremb, mae, delt
     +                     , deltb)
      IMPLICIT NONE
      REAL ytau, ycom3l, ygasc, y3ln10
      INTEGER jk, il, kount, id, mae, i, nf, l, nct, n, iso2, ihpo, nn
      INTEGER ilg, ilev, lev, il1, il2, msg, lengath, iae1, ntr
      INTEGER ntraca, isize
      REAL roco0, delt, aerno, rocon, grav
      REAL roco0b, deltb, roconb
C      COMMON /TIMES/ DELT
C
      LOGICAL kcalc(ilg, ilev)
C
      INTEGER ideep(ilg), jt(ilg), maxg(ilg), jd(ilg)
C
      REAL clsize(ilg, ilev, isize), rcrit(ilg, ilev, 2), xrow(ilg, ilev
     +     +1, ntr), th(ilg, ilev+1), h2o2row(ilg, ilev), xu(ilg, ilev
     +     , ntr), hpoxrow(ilg, ilev), o3row(ilg, ilev), nh3row(ilg, 
     +     ilev), hno3row(ilg, ilev), co2row(ilg, ilev), rcoex(ilg, ilev
     +     , 2), aeronum(ilg, ilev, isize), cldcv(ilg, ilev, 2), zmlwc(
     +     ilg, ilev, 2), afrac(ilg, ilev, isize, 2), afracf(ilg, ilev, 
     +     2), aerosize(2, isize), thlev(ilg, ilev), rtbcld(ilg, ilev, 
     +     ntr), gdrem(ilg, ntr, 3)
      REAL clsizeb(ilg, ilev, isize), rcritb(ilg, ilev, 2), xrowb(ilg, 
     +     ilev+1, ntr), thb(ilg, ilev+1), h2o2rowb(ilg, ilev), xub(ilg
     +     , ilev, ntr), hpoxrowb(ilg, ilev), o3rowb(ilg, ilev), 
     +     nh3rowb(ilg, ilev), hno3rowb(ilg, ilev), co2rowb(ilg, ilev), 
     +     rcoexb(ilg, ilev, 2), aeronumb(ilg, ilev, isize), cldcvb(ilg
     +     , ilev, 2), zmlwcb(ilg, ilev, 2), afracb(ilg, ilev, isize, 2)
     +     , afracfb(ilg, ilev, 2), thlevb(ilg, ilev), rtbcldb(ilg, ilev
     +     , ntr), gdremb(ilg, ntr, 3)
      REAL roarow(ilg, ilev), agamma(ilg, ilev), amaspe(3), aresid(ilg, 
     +     ilev), aspeci(ilg, ilev), agtso2(ilg, ilev), agtso4(ilg, ilev
     +     ), agto3(ilg, ilev), agtco2(ilg, ilev), agtnh3(ilg, ilev), 
     +     agthno3(ilg, ilev), agtna(ilg, ilev), agtho2(ilg, ilev), 
     +     aoh2o2(ilg, ilev), aeqca(ilg, ilev), aeqcb(ilg, ilev), aeqcc(
     +     ilg, ilev), aeqcai(ilg, ilev), aeqcbi(ilg, ilev), aeqchp(ilg
     +     , ilev), aeqcho(ilg, ilev), aeqhno(ilg, ilev), aeqnh3(ilg, 
     +     ilev), aeqhcl(ilg, ilev), aorhp1(ilg, ilev), aorhp2(ilg, ilev
     +     ), aorho(ilg, ilev), antso2(ilg, ilev), antho2(ilg, ilev), 
     +     antso4(ilg, ilev)
      REAL roarowb(ilg, ilev), agammab(ilg, ilev), aresidb(ilg, ilev), 
     +     aspecib(ilg, ilev), agtso2b(ilg, ilev), agtso4b(ilg, ilev), 
     +     agto3b(ilg, ilev), agtco2b(ilg, ilev), agtnh3b(ilg, ilev), 
     +     agthno3b(ilg, ilev), agtnab(ilg, ilev), agtho2b(ilg, ilev), 
     +     aoh2o2b(ilg, ilev), aeqcab(ilg, ilev), aeqcbb(ilg, ilev), 
     +     aeqccb(ilg, ilev), aeqcaib(ilg, ilev), aeqcbib(ilg, ilev), 
     +     aeqchpb(ilg, ilev), aeqchob(ilg, ilev), aeqhnob(ilg, ilev), 
     +     aeqnh3b(ilg, ilev), aeqhclb(ilg, ilev), aorhp1b(ilg, ilev), 
     +     aorhp2b(ilg, ilev), aorhob(ilg, ilev), antso2b(ilg, ilev), 
     +     antho2b(ilg, ilev), antso4b(ilg, ilev)
      REAL dshj(ilg, ilev), eps0(ilg), mu(ilg, ilev), eu(ilg, ilev), du(
     +     ilg, ilev), md(ilg, ilev), mc(ilg, ilev), ed(ilg, ilev), dp
     +     (ilg, ilev), dz(ilg, ilev), mb(ilg), dsubcld(ilg), x(ilg, 
     +     ilev, ntr), xd(ilg, ilev, ntr), xg(ilg, ilev, ntr), dxdt(
     +     ilg, ilev, ntr), xhat(ilg, ilev, ntr), dxdx(ilg, ilev, ntr)
     +     , facx(ilg, ilev, ntr), sumdx(ilg), ou(ilg, ilev, ntr), mur
     +     (ilg, ilev), mdr(ilg, ilev), dur(ilg, ilev), eur(ilg, ilev)
     +     , edr(ilg, ilev), zfg(ilg, ilev), pxnew(ilg, ilev, ntr)
      REAL dshjb(ilg, ilev), mub(ilg, ilev), eub(ilg, ilev), dub(ilg, 
     +     ilev), mdb(ilg, ilev), mcb(ilg, ilev), edb(ilg, ilev), dpb(
     +     ilg, ilev), dzb(ilg, ilev), mbb(ilg), dsubcldb(ilg), xb(ilg, 
     +     ilev, ntr), xdb(ilg, ilev, ntr), xgb(ilg, ilev, ntr), dxdtb
     +     (ilg, ilev, ntr), xhatb(ilg, ilev, ntr), dxdxb(ilg, ilev, 
     +     ntr), facxb(ilg, ilev, ntr), sumdxb(ilg), oub(ilg, ilev, 
     +     ntr), murb(ilg, ilev), mdrb(ilg, ilev), durb(ilg, ilev), 
     +     eurb(ilg, ilev), edrb(ilg, ilev), zfgb(ilg, ilev), pxnewb(ilg
     +     , ilev, ntr)
      REAL rgrid(ilg, ilev, ntr), rtso4(ilg, ilev, isize), rtso2(ilg, 
     +     ilev, 2), rthpo(ilg, ilev), pressg(ilg), amh(ilg, ilev), shj(
     +     ilg, ilev), xua(ilg, ilev, ntraca), xga(ilg, ilev, ntraca
     +     ), z(ilg, ilev), asprva(ilg, ilev), asrso2(ilg, ilev), asrhpo
     +     (ilg, ilev)
      REAL rgridb(ilg, ilev, ntr), rtso4b(ilg, ilev, isize), rtso2b(ilg
     +     , ilev, 2), rthpob(ilg, ilev), pressgb(ilg), amhb(ilg, ilev)
     +     , shjb(ilg, ilev), xuab(ilg, ilev, ntraca), xgab(ilg, ilev+
     +     1, ntraca), asprvab(ilg, ilev), asrso2b(ilg, ilev), asrhpob(
     +     ilg, ilev)
      REAL ru(ilg, ilev, ntr), rua(ilg, ilev, ntraca)
      REAL rub(ilg, ilev, ntr), ruab(ilg, ilev, ntraca)
      PARAMETER (ytau=129600., ycom3l=1.e+03, ygasc=8.31441, y3ln10=
     +   6.90776)
c      EXTERNAL AMOD
c      EXTERNAL AMOD_B
      INTEGER arg1
      REAL result1
      REAL result1b
      INTEGER branch
      REAL temp0b
      INTRINSIC MAX
      REAL tempb
      REAL temp0b4
      REAL temp0b3
      REAL temp0b2
      REAL temp0b1
      REAL temp0b0
      INTRINSIC INT
c      REAL AMOD
      INTEGER ii1
      REAL temp
      DATA amaspe /96.0576e-03, 64.0588e-03, 34.0146e-03/
C
C-----------------------------------------------------------------------
C
C     (1) in-cloud production of sulphate
C
C-----------------------------------------------------------------------
C
C---  dimensions and initialization
      CALL OEQUIP(ilg, ilev, il1, il2, aeqca, aeqcb, aeqcc, aeqcai, 
     +            aeqcbi, aeqchp, aeqcho, aeqhno, aeqnh3, aeqhcl, aorhp1
     +            , aorhp2, aorho, th(1, 2), mae)
C
C---  initial tendencies
      DO jk=1+mae,ilev
        DO il=il1,il2
          rthpo(il, jk) = 0.
        ENDDO
      ENDDO
C
C---  initial concentrations
      DO jk=1+mae,ilev
        DO il=il1,il2
C
C---     conversion from m**3/m**3 -> mol/l
          roco0 = pressg(il)*shj(il, jk)/(ygasc*th(il, jk+1))
          rocon = roco0/ycom3l
C nitric acid
          agthno3(il, jk) = hno3row(il, jk)*rocon
C ammonia
          agtnh3(il, jk) = nh3row(il, jk)*rocon
C ozone
          agto3(il, jk) = o3row(il, jk)*rocon
C carbon dioxide
          agtco2(il, jk) = co2row(il, jk)*rocon
C hydrogen peroxi
          agtho2(il, jk) = xrow(il, jk+1, ihpo)*roarow(il, jk)/(amaspe(3
     +      )*ycom3l)
C
C---     conversion from m**3/m**3 -> kg/kg
          rocon = roco0*amaspe(3)/roarow(il, jk)
C hydrogen peroxi
          hpoxrow(il, jk) = h2o2row(il, jk)*rocon
C
C---     sodium concentration (for later applications)
          agtna(il, jk) = 0.
        ENDDO
      ENDDO
C
C---  distribution of total produced sulphate on bins. AFRAC(I,L,N,NCT)
C---  is the volume of activated aerosol in bin N per total volume
C---  of activated aerosol for cloud type NCT
C
C     Note that only when the number density of a size bin is greater 
C       than 5 m-3, can it be serve as a activation bin to receive
C       cloud-produed sulphate.
C
      arg1 = ilg*ilev*2
      CALL PUTZERO(afracf, arg1)
      arg1 = ilg*ilev*isize*2
      CALL PUTZERO(afrac, arg1)
      DO nct=1,2
        DO n=1,isize
          DO l=1+mae,ilev
            DO i=il1,il2
              IF (INT(rcrit(i, l, nct)) .GE. 1 .AND. INT(rcrit(i, l, nct
     +            )) .LE. isize) THEN
                aerno = aeronum(i, l, n)*roarow(i, l)
                IF (n .EQ. INT(rcrit(i, l, nct)) .AND. aerno .GT. 1.e6) 
     +          THEN
                  CALL PUSHREAL8(rcrit(i, l, nct))
                  result1 = AMOD(rcrit(i, l, nct), 1.)
                  afrac(i, l, n, nct) = aeronum(i, l, n)*rcoex(i, l, nct
     +              )**3*(1.-result1)
                  afracf(i, l, nct) = afrac(i, l, n, nct)
                  CALL PUSHCONTROL2B(2)
                ELSE IF (n .GT. INT(rcrit(i, l, nct)) .AND. aerno .GT. 
     +              1.e6) THEN
                  afrac(i, l, n, nct) = aeronum(i, l, n)*clsize(i, l, n)
     +              **3
                  afracf(i, l, nct) = afracf(i, l, nct) + afrac(i, l, n
     +              , nct)
                  CALL PUSHCONTROL2B(1)
                ELSE
                  afrac(i, l, n, nct) = 0.
                  CALL PUSHCONTROL2B(0)
                END IF
                IF (afracf(i, l, nct) .LT. 1.e-33) THEN
                  afracf(i, l, nct) = 1.e-33
                  CALL PUSHCONTROL2B(2)
                ELSE
                  CALL PUSHCONTROL2B(1)
                  afracf(i, l, nct) = afracf(i, l, nct)
                END IF
              ELSE
                CALL PUSHCONTROL2B(0)
              END IF
            ENDDO
          ENDDO
        ENDDO
      ENDDO
      DO nct=1,2
        DO n=1,isize
          DO l=1+mae,ilev
            DO i=il1,il2
              IF (INT(rcrit(i, l, nct)) .GE. 1 .AND. INT(rcrit(i, l, nct
     +            )) .LE. isize) THEN
                CALL PUSHREAL8(afrac(i, l, n, nct))
                afrac(i, l, n, nct) = afrac(i, l, n, nct)/afracf(i, l, 
     +            nct)
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHCONTROL1B(1)
              END IF
            ENDDO
          ENDDO
        ENDDO
      ENDDO
      DO ii1=1,ilg
        CALL PUSHREAL8(rcrit(ii1, 1, 1))
      ENDDO
      CALL PUSHBOOLEANARRAY(kcalc, ilg*ilev)
      CALL PUSHREAL8ARRAY(aresid, ilg*ilev)
      CALL PUSHREAL8ARRAY(aoh2o2, ilg*ilev)
      CALL PUSHREAL8ARRAY(antso4, ilg*ilev)
      CALL PUSHREAL8ARRAY(antho2, ilg*ilev)
      CALL PUSHREAL8ARRAY(antso2, ilg*ilev)
      CALL PUSHREAL8ARRAY(agtho2, ilg*ilev)
      CALL PUSHREAL8ARRAY(agtso4, ilg*ilev)
      CALL PUSHREAL8ARRAY(agtso2, ilg*ilev)
      CALL PUSHREAL8ARRAY(aspeci, ilg*ilev)
      CALL PUSHREAL8ARRAY(agamma, ilg*ilev)
C
C---  call to perform stratiform cloud oxidation of sulphur dioxide
      CALL OXISTR(il1, il2, ilev, ilg, isize, ntr, iso2, ihpo, nn, iae1
     +            , roarow, agamma, aspeci, agtso2, agtso4, agto3, 
     +            agtco2, agtnh3, agthno3, agtna, agtho2, aeqca, aeqcb, 
     +            aeqcc, aeqcbi, aeqchp, aeqcho, aeqhno, aeqnh3, aeqhcl
     +            , aorhp1, aorhp2, aorho, antso2, antho2, antso4, xrow
     +            , aoh2o2, aresid, zmlwc(1, 1, 1), cldcv(1, 1, 1), 
     +            afrac(1, 1, 1, 1), amh, kcalc, rtso4, rthpo, rcrit(1, 
     +            1, 1), amaspe, asprva, asrso2, asrhpo, mae, delt)
C
C   UPDATE SO4
C
      DO n=1,isize
        CALL PUSHINTEGER4(nf)
        nf = isize*(nn-1) + n + (iae1-1)
        DO l=1+mae,ilev
          DO i=il1,il2
            CALL PUSHREAL8(xrow(i, l+1, nf))
            xrow(i, l+1, nf) = xrow(i, l+1, nf) + 2.*delt*rtso4(i, l, n)
          ENDDO
        ENDDO
      ENDDO
C
C   UPDATE SO2
C 
      DO l=1+mae,ilev
        DO i=il1,il2
          CALL PUSHREAL8(xrow(i, l+1, iso2))
          xrow(i, l+1, iso2) = xrow(i, l+1, iso2) + 2.*delt*asprva(i, l)
        ENDDO
      ENDDO
C
C---  call tp perform convective cloud oxidation of sulphur dioxide
      arg1 = ilg*ilev*isize
      CALL PUTZERO(rgrid, arg1)
      arg1 = ilg*ilev
      CALL PUSHREAL8ARRAY(asprva, ilg*ilev)
      CALL PUTZERO(asprva, arg1)
      CALL PUSHREAL8ARRAY(rua, ilg*(ilev+1)*ntraca)
      CALL PUSHREAL8ARRAY(ru, ilg*(ilev+1)*ntr)
      DO ii1=1,ilg
        CALL PUSHREAL8(pxnew(ii1, 1, 3))
      ENDDO
      DO ii1=1,ilg
        CALL PUSHREAL8(pxnew(ii1, 1, 2))
      ENDDO
      DO ii1=1,ilg
        CALL PUSHREAL8(pxnew(ii1, 1, 1))
      ENDDO
      CALL PUSHREAL8ARRAY(edr, ilg*ilev)
      CALL PUSHREAL8ARRAY(eur, ilg*ilev)
      CALL PUSHREAL8ARRAY(dur, ilg*ilev)
      CALL PUSHREAL8ARRAY(mdr, ilg*ilev)
      CALL PUSHREAL8ARRAY(mur, ilg*(ilev))
      CALL PUSHREAL8ARRAY(rthpo, ilg*ilev)
      CALL PUSHBOOLEANARRAY(kcalc, ilg*ilev)
      CALL PUSHREAL8ARRAY(agamma, ilg*ilev)
      CALL PUSHREAL8ARRAY(agtho2, ilg*ilev)
      CALL PUSHREAL8ARRAY(agtso2, ilg*ilev)
      CALL PUSHREAL8ARRAY(agtso4, ilg*ilev)
      CALL PUSHREAL8ARRAY(xua, ilg*(ilev)*ntraca)
      CALL PUSHREAL8ARRAY(xga, ilg*(ilev)*ntraca)
      CALL PUSHREAL8ARRAY(ou, ilg*(ilev)*ntr)
      CALL PUSHREAL8ARRAY(sumdx, ilg)
      CALL PUSHREAL8ARRAY(facx, ilg*ilev*ntr)
      CALL PUSHREAL8ARRAY(dxdx, ilg*ilev*ntr)
      CALL PUSHREAL8ARRAY(dxdt, ilg*ilev*ntr)
      CALL PUSHREAL8ARRAY(xhat, ilg*(ilev)*ntr)
      CALL PUSHREAL8ARRAY(xg, ilg*ilev*ntr)
      CALL PUSHREAL8ARRAY(xd, ilg*(ilev)*ntr)
      CALL PUSHREAL8ARRAY(xu, ilg*(ilev)*ntr)
      CALL PUSHREAL8ARRAY(x, ilg*ilev*ntr)
      DO ii1=1,ilg
        CALL PUSHREAL8(rcrit(ii1, 1, 2))
      ENDDO
C
C
      CALL OXICON(il1, il2, ntr, ilev, id, ilg, iso2, ihpo, nn, isize, 
     +            iae1, rcrit(1, 1, 2), agto3, agtco2, agtnh3, agthno3, 
     +            agtna, aeqcb, aeqcbi, aeqnh3, aeqhno, aeqhcl, aeqcc, 
     +            aeqca, aeqcho, aeqchp, aorhp1, aorhp2, aorho, roarow, 
     +            afrac(1, 1, 1, 2), cldcv(1, 1, 2), zmlwc(1, 1, 2), 
     +            grav, dshj, ideep, eps0, jt, maxg, jd, dz, dp, du, eu
     +            , ed, mu, md, mc, mb, msg, lengath, dsubcld, x, xu, xd
     +            , xg, xhat, dxdt, dxdx, facx, sumdx, ou, xga, xua, 
     +            ntraca, agtso4, agtso2, agtho2, agamma, xrow, amh, 
     +            kcalc, rgrid, asprva, rthpo, amaspe, mur, mdr, dur, 
     +            eur, edr, zfg, pxnew(1, 1, 1), pxnew(1, 1, 2), pxnew(1
     +            , 1, 3), ru, rua, th(1, 2), thlev, rtbcld, mae, delt)
C
C   UPDATE SO4
C
      DO n=1,isize
        CALL PUSHINTEGER4(nf)
        nf = isize*(nn-1) + n + (iae1-1)
        DO l=1+mae,ilev
          DO i=il1,il2
            CALL PUSHREAL8(xrow(i, l+1, nf))
            xrow(i, l+1, nf) = xrow(i, l+1, nf) + 2.*delt*(rgrid(i, l, n
     +        )+rtbcld(i, l, nf))
          ENDDO
        ENDDO
      ENDDO
C
C   UPDATE SO2
C 
      DO l=1+mae,ilev
        DO i=il1,il2
          CALL PUSHREAL8(xrow(i, l+1, iso2))
          xrow(i, l+1, iso2) = xrow(i, l+1, iso2) + 2.*delt*(asprva(i, l
     +      )+rtbcld(i, l, iso2))
        ENDDO
      ENDDO
C
C
C-----------------------------------------------------------------------
C
C     (2) hydrogen peroxide production
C
C-----------------------------------------------------------------------
C
      DO l=1+mae,ilev
        DO i=il1,il2
          rthpo(i, l) = rthpo(i, l) - 1./ytau*(xrow(i, l+1, ihpo)-
     +      hpoxrow(i, l))
        ENDDO
      ENDDO
      DO l=ilev,1+mae,-1
        DO i=il2,il1,-1
          rthpob(i, l) = rthpob(i, l) + 2.*delt*xrowb(i, l+1, ihpo)
          deltb = deltb + 2.*rthpo(i, l)*xrowb(i, l+1, ihpo)
          xrowb(i, l+1, ihpo) = xrowb(i, l+1, ihpo) - rthpob(i, l)/ytau
          hpoxrowb(i, l) = hpoxrowb(i, l) + rthpob(i, l)/ytau
        ENDDO
      ENDDO
      DO l=ilev,1+mae,-1
        DO i=il2,il1,-1
          temp0b3 = 2.*delt*xrowb(i, l+1, iso2)
          asprvab(i, l) = asprvab(i, l) + temp0b3 + rtso2b(i, l, 2)
          temp0b4 = pressg(i)*gdremb(i, iso2, 2)/grav
          rtbcldb(i, l, iso2) = rtbcldb(i, l, iso2) + temp0b3 + dshj(i, 
     +      l)*temp0b4
          dshjb(i, l) = dshjb(i, l) + rtbcld(i, l, iso2)*temp0b4
          pressgb(i) = pressgb(i) + rtbcld(i, l, iso2)*dshj(i, l)*gdremb
     +      (i, iso2, 2)/grav
          CALL POPREAL8(xrow(i, l+1, iso2))
          deltb = deltb + 2.*(asprva(i, l)+rtbcld(i, l, iso2))*xrowb(i, 
     +      l+1, iso2)
        ENDDO
      ENDDO
      DO n=isize,1,-1
        DO l=ilev,1+mae,-1
          DO i=il2,il1,-1
            temp0b2 = 2.*delt*xrowb(i, l+1, nf)
            rgridb(i, l, n) = rgridb(i, l, n) + temp0b2 + rtso4b(i, l, n
     +        )
            CALL POPREAL8(xrow(i, l+1, nf))
            deltb = deltb + 2.*(rgrid(i, l, n)+rtbcld(i, l, nf))*xrowb(i
     +        , l+1, nf)
            rtbcldb(i, l, nf) = rtbcldb(i, l, nf) + temp0b2
          ENDDO
        ENDDO
        CALL POPINTEGER4(nf)
      ENDDO
      DO ii1=ilg,1,-1
        CALL POPREAL8(rcrit(ii1, 1, 2))
      ENDDO
      CALL POPREAL8ARRAY(x, ilg*ilev*ntr)
      CALL POPREAL8ARRAY(xu, ilg*(ilev)*ntr)
      CALL POPREAL8ARRAY(xd, ilg*(ilev)*ntr)
      CALL POPREAL8ARRAY(xg, ilg*ilev*ntr)
      CALL POPREAL8ARRAY(xhat, ilg*(ilev)*ntr)
      CALL POPREAL8ARRAY(dxdt, ilg*ilev*ntr)
      CALL POPREAL8ARRAY(dxdx, ilg*ilev*ntr)
      CALL POPREAL8ARRAY(facx, ilg*ilev*ntr)
      CALL POPREAL8ARRAY(sumdx, ilg)
      CALL POPREAL8ARRAY(ou, ilg*(ilev)*ntr)
      CALL POPREAL8ARRAY(xga, ilg*(ilev)*ntraca)
      CALL POPREAL8ARRAY(xua, ilg*(ilev)*ntraca)
      CALL POPREAL8ARRAY(agtso4, ilg*ilev)
      CALL POPREAL8ARRAY(agtso2, ilg*ilev)
      CALL POPREAL8ARRAY(agtho2, ilg*ilev)
      CALL POPREAL8ARRAY(agamma, ilg*ilev)
      CALL POPBOOLEANARRAY(kcalc, ilg*ilev)
      CALL POPREAL8ARRAY(rthpo, ilg*ilev)
      CALL POPREAL8ARRAY(mur, ilg*(ilev))
      CALL POPREAL8ARRAY(mdr, ilg*ilev)
      CALL POPREAL8ARRAY(dur, ilg*ilev)
      CALL POPREAL8ARRAY(eur, ilg*ilev)
      CALL POPREAL8ARRAY(edr, ilg*ilev)
      DO ii1=ilg,1,-1
        CALL POPREAL8(pxnew(ii1, 1, 1))
      ENDDO
      DO ii1=ilg,1,-1
        CALL POPREAL8(pxnew(ii1, 1, 2))
      ENDDO
      DO ii1=ilg,1,-1
        CALL POPREAL8(pxnew(ii1, 1, 3))
      ENDDO
      CALL POPREAL8ARRAY(ru, ilg*(ilev)*ntr)
      CALL POPREAL8ARRAY(rua, ilg*(ilev)*ntraca)
      CALL OXICON_B(il1, il2, ntr, ilev, id, ilg, iso2, ihpo, nn, isize
     +              , iae1, rcrit(1, 1, 2), rcritb(1, 1, 2), agto3, 
     +              agto3b, agtco2, agtco2b, agtnh3, agtnh3b, agthno3, 
     +              agthno3b, agtna, agtnab, aeqcb, aeqcbb, aeqcbi, 
     +              aeqcbib, aeqnh3, aeqnh3b, aeqhno, aeqhnob, aeqhcl, 
     +              aeqhclb, aeqcc, aeqccb, aeqca, aeqcab, aeqcho, 
     +              aeqchob, aeqchp, aeqchpb, aorhp1, aorhp1b, aorhp2, 
     +              aorhp2b, aorho, aorhob, roarow, roarowb, afrac(1, 1
     +              , 1, 2), afracb(1, 1, 1, 2), cldcv(1, 1, 2), cldcvb(
     +              1, 1, 2), zmlwc(1, 1, 2), zmlwcb(1, 1, 2), grav, 
     +              dshj, ideep, eps0, jt, maxg, jd, dz, dzb, dp, dpb, 
     +              du, dub, eu, eub, ed, edb, mu, mub, md, mdb, mc, mcb
     +              , mb, mbb, msg, lengath, dsubcld, dsubcldb, x, xb, 
     +              xu, xub, xd, xdb, xg, xgb, xhat, xhatb, dxdt, dxdtb
     +              , dxdx, dxdxb, facx, facxb, sumdx, sumdxb, ou, oub, 
     +              xga, xgab, xua, xuab, ntraca, agtso4, agtso4b, 
     +              agtso2, agtso2b, agtho2, agtho2b, agamma, agammab, 
     +              xrow, xrowb, amh, amhb, kcalc, rgrid, rgridb, asprva
     +              , asprvab, rthpo, rthpob, amaspe, mur, murb, mdr, 
     +              mdrb, dur, durb, eur, eurb, edr, edrb, zfg, zfgb, 
     +              pxnew(1, 1, 1), pxnewb(1, 1, 1), pxnew(1, 1, 2), 
     +              pxnewb(1, 1, 2), pxnew(1, 1, 3), pxnewb(1, 1, 3), ru
     +              , rub, rua, ruab, th(1, 2), thb(1, 2), thlev, thlevb
     +              , rtbcld, rtbcldb, mae, delt, deltb)
      CALL POPREAL8ARRAY(asprva, ilg*ilev)
      CALL PUTZERO_B(asprva, asprvab, arg1)
      arg1 = ilg*ilev*isize
      CALL PUTZERO_B(rgrid, rgridb, arg1)
      DO l=ilev,1+mae,-1
        DO i=il2,il1,-1
          asprvab(i, l) = asprvab(i, l) + 2.*delt*xrowb(i, l+1, iso2) + 
     +      rtso2b(i, l, 2)
          rtso2b(i, l, 2) = 0.0
          CALL POPREAL8(xrow(i, l+1, iso2))
          deltb = deltb + 2.*asprva(i, l)*xrowb(i, l+1, iso2)
        ENDDO
      ENDDO
      DO n=isize,1,-1
        DO l=ilev,1+mae,-1
          DO i=il2,il1,-1
            CALL POPREAL8(xrow(i, l+1, nf))
            deltb = deltb + 2.*rtso4(i, l, n)*xrowb(i, l+1, nf)
            rtso4b(i, l, n) = rtso4b(i, l, n) + 2.*delt*xrowb(i, l+1, nf
     +        )
          ENDDO
        ENDDO
        CALL POPINTEGER4(nf)
      ENDDO
      CALL POPREAL8ARRAY(agamma, ilg*ilev)
      CALL POPREAL8ARRAY(aspeci, ilg*ilev)
      CALL POPREAL8ARRAY(agtso2, ilg*ilev)
      CALL POPREAL8ARRAY(agtso4, ilg*ilev)
      CALL POPREAL8ARRAY(agtho2, ilg*ilev)
      CALL POPREAL8ARRAY(antso2, ilg*ilev)
      CALL POPREAL8ARRAY(antho2, ilg*ilev)
      CALL POPREAL8ARRAY(antso4, ilg*ilev)
      CALL POPREAL8ARRAY(aoh2o2, ilg*ilev)
      CALL POPREAL8ARRAY(aresid, ilg*ilev)
      CALL POPBOOLEANARRAY(kcalc, ilg*ilev)
      DO ii1=ilg,1,-1
        CALL POPREAL8(rcrit(ii1, 1, 1))
      ENDDO
      CALL OXISTR_B(il1, il2, ilev, ilg, isize, ntr, iso2, ihpo, nn, 
     +              iae1, roarow, roarowb, agamma, agammab, aspeci, 
     +              aspecib, agtso2, agtso2b, agtso4, agtso4b, agto3, 
     +              agto3b, agtco2, agtco2b, agtnh3, agtnh3b, agthno3, 
     +              agthno3b, agtna, agtnab, agtho2, agtho2b, aeqca, 
     +              aeqcab, aeqcb, aeqcbb, aeqcc, aeqccb, aeqcbi, 
     +              aeqcbib, aeqchp, aeqchpb, aeqcho, aeqchob, aeqhno, 
     +              aeqhnob, aeqnh3, aeqnh3b, aeqhcl, aeqhclb, aorhp1, 
     +              aorhp1b, aorhp2, aorhp2b, aorho, aorhob, antso2, 
     +              antso2b, antho2, antho2b, antso4, antso4b, xrow, 
     +              xrowb, aoh2o2, aoh2o2b, aresid, aresidb, zmlwc(1, 1
     +              , 1), zmlwcb(1, 1, 1), cldcv(1, 1, 1), cldcvb(1, 1, 
     +              1), afrac(1, 1, 1, 1), afracb(1, 1, 1, 1), amh, amhb
     +              , kcalc, rtso4, rtso4b, rthpo, rthpob, rcrit(1, 1, 1
     +              ), rcritb(1, 1, 1), amaspe, asprva, asprvab, asrso2
     +              , asrso2b, asrhpo, asrhpob, mae, delt, deltb)
      DO nct=2,1,-1
        DO n=isize,1,-1
          DO l=ilev,1+mae,-1
            DO i=il2,il1,-1
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                CALL POPREAL8(afrac(i, l, n, nct))
                temp0b1 = afracb(i, l, n, nct)/afracf(i, l, nct)
                afracfb(i, l, nct) = afracfb(i, l, nct) - afrac(i, l, n
     +            , nct)*temp0b1/afracf(i, l, nct)
                afracb(i, l, n, nct) = temp0b1
              END IF
            ENDDO
          ENDDO
        ENDDO
      ENDDO
      DO nct=2,1,-1
        DO n=isize,1,-1
          DO l=ilev,1+mae,-1
            DO i=il2,il1,-1
              CALL POPCONTROL2B(branch)
              IF (branch .NE. 0) THEN
                IF (branch .NE. 1) afracfb(i, l, nct) = 0.0
                CALL POPCONTROL2B(branch)
                IF (branch .EQ. 0) THEN
                  afracb(i, l, n, nct) = 0.0
                ELSE IF (branch .EQ. 1) THEN
                  afracb(i, l, n, nct) = afracb(i, l, n, nct) + afracfb(
     +              i, l, nct)
                  aeronumb(i, l, n) = aeronumb(i, l, n) + clsize(i, l, n
     +              )**3*afracb(i, l, n, nct)
                  clsizeb(i, l, n) = clsizeb(i, l, n) + aeronum(i, l, n)
     +              *3*clsize(i, l, n)**2*afracb(i, l, n, nct)
                  afracb(i, l, n, nct) = 0.0
                ELSE
                  afracb(i, l, n, nct) = afracb(i, l, n, nct) + afracfb(
     +              i, l, nct)
                  afracfb(i, l, nct) = 0.0
                  temp0b0 = rcoex(i, l, nct)**3*afracb(i, l, n, nct)
                  aeronumb(i, l, n) = aeronumb(i, l, n) + (1.-result1)*
     +              temp0b0
                  result1b = -(aeronum(i, l, n)*temp0b0)
                  rcoexb(i, l, nct) = rcoexb(i, l, nct) + aeronum(i, l, 
     +              n)*(1.-result1)*3*rcoex(i, l, nct)**2*afracb(i, l, n
     +              , nct)
                  afracb(i, l, n, nct) = 0.0
                  CALL POPREAL8(rcrit(i, l, nct))
c                  CALL AMOD_B(rcrit(i, l, nct), rcritb(i, l, nct), 1., 
c     +                        result1b)
                  result1=AMOD(rcrit(i, l, nct),1.)
                  result1b=AMOD(rcritb(i, l, nct), 1.)
                END IF
              END IF
            ENDDO
          ENDDO
        ENDDO
      ENDDO
      arg1 = ilg*ilev*isize*2
      CALL PUTZERO_B(afrac, afracb, arg1)
      arg1 = ilg*ilev*2
      CALL PUTZERO_B(afracf, afracfb, arg1)
      DO jk=ilev,1+mae,-1
        DO il=il2,il1,-1
          agtnab(il, jk) = 0.0
          roco0 = pressg(il)*shj(il, jk)/(ygasc*th(il, jk+1))
          rocon = roco0*amaspe(3)/roarow(il, jk)
          h2o2rowb(il, jk) = h2o2rowb(il, jk) + rocon*hpoxrowb(il, jk)
          roconb = h2o2row(il, jk)*hpoxrowb(il, jk)
          hpoxrowb(il, jk) = 0.0
          temp0b = amaspe(3)*roconb/roarow(il, jk)
          roarowb(il, jk) = roarowb(il, jk) + xrow(il, jk+1, ihpo)*
     +      agtho2b(il, jk)/(amaspe(3)*ycom3l) - roco0*temp0b/roarow(il
     +      , jk)
          xrowb(il, jk+1, ihpo) = xrowb(il, jk+1, ihpo) + roarow(il, jk)
     +      *agtho2b(il, jk)/(amaspe(3)*ycom3l)
          agtho2b(il, jk) = 0.0
          rocon = roco0/ycom3l
          co2rowb(il, jk) = co2rowb(il, jk) + rocon*agtco2b(il, jk)
          roconb = o3row(il, jk)*agto3b(il, jk) + hno3row(il, jk)*
     +      agthno3b(il, jk) + nh3row(il, jk)*agtnh3b(il, jk) + co2row(
     +      il, jk)*agtco2b(il, jk)
          roco0b = roconb/ycom3l + temp0b
          agtco2b(il, jk) = 0.0
          o3rowb(il, jk) = o3rowb(il, jk) + rocon*agto3b(il, jk)
          agto3b(il, jk) = 0.0
          nh3rowb(il, jk) = nh3rowb(il, jk) + rocon*agtnh3b(il, jk)
          agtnh3b(il, jk) = 0.0
          hno3rowb(il, jk) = hno3rowb(il, jk) + rocon*agthno3b(il, jk)
          agthno3b(il, jk) = 0.0
          temp = ygasc*th(il, jk+1)
          tempb = roco0b/temp
          pressgb(il) = pressgb(il) + shj(il, jk)*tempb
          shjb(il, jk) = shjb(il, jk) + pressg(il)*tempb
          thb(il, jk+1) = thb(il, jk+1) - pressg(il)*shj(il, jk)*ygasc*
     +      tempb/temp
        ENDDO
      ENDDO
      DO jk=ilev,1+mae,-1
        DO il=il2,il1,-1
          rthpob(il, jk) = 0.0
        ENDDO
      ENDDO
      CALL OEQUIP_B(ilg, ilev, il1, il2, aeqca, aeqcab, aeqcb, aeqcbb, 
     +              aeqcc, aeqccb, aeqcai, aeqcaib, aeqcbi, aeqcbib, 
     +              aeqchp, aeqchpb, aeqcho, aeqchob, aeqhno, aeqhnob, 
     +              aeqnh3, aeqnh3b, aeqhcl, aeqhclb, aorhp1, aorhp1b, 
     +              aorhp2, aorhp2b, aorho, aorhob, th(1, 2), thb(1, 2)
     +              , mae)
      END
